/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.compiler;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.openjdk.btrace.compiler.VerifierVisitor;
import org.openjdk.btrace.core.Messages;
import org.openjdk.btrace.core.annotations.BTrace;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class Verifier
extends AbstractProcessor
implements TaskListener {
    private final List<String> classNames = new ArrayList<String>();
    private final List<CompilationUnitTree> compUnits = new ArrayList<CompilationUnitTree>();
    private final AttributionTaskListener listener = new AttributionTaskListener();
    private Trees treeUtils;
    private ClassTree currentClass;

    @Override
    public synchronized void init(ProcessingEnvironment pe) {
        super.init(pe);
        this.treeUtils = Trees.instance(pe);
        JavacTask task = JavacTask.instance(this.processingEnv);
        task.addTaskListener(this.listener);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return true;
    }

    @Override
    public void started(TaskEvent e) {
        CompilationUnitTree ct;
        if (e.getKind() == TaskEvent.Kind.ENTER && (ct = e.getCompilationUnit()) != null) {
            this.compUnits.add(ct);
        }
    }

    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.ANALYZE) {
            return;
        }
        if (this.processingEnv == null) {
            return;
        }
        TypeElement elem = e.getTypeElement();
        for (Tree tree : e.getCompilationUnit().getTypeDecls()) {
            TreePath topLevel = new TreePath(e.getCompilationUnit());
            if (tree.getKind() != Tree.Kind.CLASS || !elem.equals(this.getTreeUtils().getElement(new TreePath(topLevel, tree)))) continue;
            this.currentClass = (ClassTree)tree;
            break;
        }
        if (this.currentClass != null) {
            this.verify(this.currentClass, elem);
        }
    }

    List<String> getClassNames() {
        return this.classNames;
    }

    CompilationUnitTree getCompilationUnit() {
        for (CompilationUnitTree ct : this.compUnits) {
            for (Tree tree : ct.getTypeDecls()) {
                if (!tree.equals(this.currentClass)) continue;
                return ct;
            }
        }
        return null;
    }

    Trees getTreeUtils() {
        return this.treeUtils;
    }

    SourcePositions getSourcePositions() {
        return this.treeUtils.getSourcePositions();
    }

    ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnv;
    }

    Messager getMessager() {
        return this.processingEnv.getMessager();
    }

    Elements getElementUtils() {
        return this.processingEnv.getElementUtils();
    }

    Types getTypeUtils() {
        return this.processingEnv.getTypeUtils();
    }

    Locale getLocale() {
        return this.processingEnv.getLocale();
    }

    String annotationName(AnnotationTree at) {
        TreePath tp = this.getTreeUtils().getPath(this.getCompilationUnit(), at.getAnnotationType());
        Element el = this.getTreeUtils().getElement(tp);
        if (el == null || el.getKind() != ElementKind.ANNOTATION_TYPE) {
            return null;
        }
        return ((TypeElement)el).getQualifiedName().toString();
    }

    private void verify(ClassTree ct, Element topElement) {
        this.currentClass = ct;
        CompilationUnitTree cut = this.getCompilationUnit();
        String className = ct.getSimpleName().toString();
        ExpressionTree pkgName = cut.getPackageName();
        if (pkgName != null) {
            className = pkgName + "." + className;
        }
        this.classNames.add(className);
        if (this.hasTrustedAnnotation(ct, topElement)) {
            return;
        }
        ct.accept(new VerifierVisitor(this, topElement), null);
    }

    private boolean hasTrustedAnnotation(ClassTree ct, Element topElement) {
        for (AnnotationTree annotationTree : ct.getModifiers().getAnnotations()) {
            String annFqn = this.annotationName(annotationTree);
            if (!BTrace.class.getName().equals(annFqn)) continue;
            for (ExpressionTree expressionTree : annotationTree.getArguments()) {
                AssignmentTree assign;
                String name;
                if (expressionTree.getKind() != Tree.Kind.ASSIGNMENT || !"unsafe".equals(name = ((IdentifierTree)(assign = (AssignmentTree)expressionTree).getVariable()).getName().toString()) && !"trusted".equals(name)) continue;
                String val = assign.getExpression().toString();
                if ("true".equals(val)) {
                    return true;
                }
                if ("false".equals(val)) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, Messages.get("no.complex.unsafe.value"), topElement);
            }
        }
        return false;
    }

    private final class AttributionTaskListener
    implements TaskListener {
        private AttributionTaskListener() {
        }

        @Override
        public void finished(TaskEvent e) {
            if (e.getKind() != TaskEvent.Kind.ANALYZE) {
                return;
            }
            TypeElement elem = e.getTypeElement();
            TreePath topLevel = new TreePath(e.getCompilationUnit());
            for (Tree tree : e.getCompilationUnit().getTypeDecls()) {
                if (tree.getKind() != Tree.Kind.CLASS || !elem.equals(Verifier.this.getTreeUtils().getElement(new TreePath(topLevel, tree)))) continue;
                Verifier.this.currentClass = (ClassTree)tree;
                break;
            }
            if (Verifier.this.currentClass != null) {
                Verifier.this.verify(Verifier.this.currentClass, elem);
            }
        }

        @Override
        public void started(TaskEvent e) {
        }
    }
}

