/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.compiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.openjdk.btrace.compiler.CompilerHelper;
import org.openjdk.btrace.compiler.MemoryJavaFileManager;
import org.openjdk.btrace.core.Messages;
import org.openjdk.btrace.runtime.BTraceRuntimeAccess;

public class Compiler {
    private final CompilerHelper compilerHelper;
    public List<String> includeDirs;
    private final StandardJavaFileManager stdManager;
    private final String packExtension = "class";

    public Compiler(String includePath, boolean generatePack) {
        if (includePath != null) {
            this.includeDirs = new ArrayList<String>();
            String[] paths = includePath.split(File.pathSeparator);
            this.includeDirs.addAll(Arrays.asList(paths));
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        this.stdManager = compiler.getStandardFileManager(null, null, null);
        this.compilerHelper = new CompilerHelper(compiler, generatePack);
    }

    public Compiler(String includePath) {
        this(includePath, false);
    }

    public Compiler(boolean generatePack) {
        this(null, generatePack);
    }

    public Compiler() {
        this(null);
    }

    private static void usage(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    private static void usage() {
        Compiler.usage(Messages.get("btracec.usage"));
    }

    public static void main(String[] args) throws Exception {
        block35: {
            if (args.length == 0) {
                Compiler.usage();
            }
            try {
                Field f = BTraceRuntimeAccess.class.getDeclaredField("uniqueClientClassNames");
                f.setAccessible(true);
                f.set(null, false);
            }
            catch (Exception f) {
                // empty catch block
            }
            String classPath = ".";
            String outputDir = ".";
            String includePath = null;
            boolean trusted = false;
            boolean generatePack = true;
            String packExtension = null;
            int count = 0;
            boolean classPathDefined = false;
            boolean outputDirDefined = false;
            boolean includePathDefined = false;
            boolean trustedDefined = false;
            while (args[count].charAt(0) == '-') {
                if (args.length <= count + 1) {
                    Compiler.usage();
                }
                if ((args[count].equals("-cp") || args[count].equals("-classpath")) && !classPathDefined) {
                    classPath = args[++count];
                    classPathDefined = true;
                } else if (args[count].equals("-d") && !outputDirDefined) {
                    outputDir = args[++count];
                    outputDirDefined = true;
                } else if (args[count].equals("-I") && !includePathDefined) {
                    includePath = args[++count];
                    includePathDefined = true;
                } else if ((args[count].equals("-unsafe") || args[count].equals("-trusted")) && !trustedDefined) {
                    trusted = true;
                    trustedDefined = true;
                } else if (args[count].equals("-nopack")) {
                    generatePack = false;
                } else if (args[count].equals("-packext")) {
                    packExtension = args[++count];
                } else {
                    Compiler.usage();
                }
                if (++count < args.length) continue;
            }
            if (args.length <= count) {
                Compiler.usage();
            }
            if (!generatePack && packExtension != null) {
                Compiler.usage("Can not specify pack extension if not using packs (-nopack)");
            }
            File[] files = new File[args.length - count];
            for (int i = 0; i < files.length; ++i) {
                files[i] = new File(args[i + count]);
                if (files[i].exists()) continue;
                Compiler.usage("File not found: " + files[i]);
            }
            Compiler compiler = new Compiler(includePath, generatePack);
            classPath = classPath + File.pathSeparator + System.getProperty("java.class.path");
            try {
                Map<String, byte[]> classes = compiler.compile(files, (Writer)new PrintWriter(System.err), ".", classPath);
                if (classes != null) {
                    for (Map.Entry<String, byte[]> c : classes.entrySet()) {
                        String name = c.getKey().replace(".", File.separator);
                        int index = name.lastIndexOf(File.separatorChar);
                        String dir = outputDir + File.separator;
                        if (index != -1) {
                            dir = dir + name.substring(0, index);
                        }
                        new File(dir).mkdirs();
                        String file = index != -1 ? name.substring(index + 1) : name;
                        file = file + "." + (packExtension != null ? packExtension : "class");
                        File out = new File(dir, file);
                        FileOutputStream fos = new FileOutputStream(out);
                        Throwable throwable = null;
                        try {
                            fos.write(c.getValue());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (fos == null) continue;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            fos.close();
                        }
                    }
                    break block35;
                }
                System.exit(1);
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(1);
            }
        }
    }

    public Map<String, byte[]> compile(String fileName, String source, Writer err, String sourcePath, String classPath) {
        MemoryJavaFileManager manager = new MemoryJavaFileManager(this.stdManager, this.includeDirs);
        ArrayList<JavaFileObject> compUnits = new ArrayList<JavaFileObject>(1);
        compUnits.add(MemoryJavaFileManager.makeStringSource(fileName, source, this.includeDirs));
        return this.compile(manager, compUnits, err, sourcePath, classPath);
    }

    public Map<String, byte[]> compile(File file, Writer err, String sourcePath, String classPath) {
        File[] files = new File[]{file};
        return this.compile(files, err, sourcePath, classPath);
    }

    public Map<String, byte[]> compile(File[] files, Writer err, String sourcePath, String classPath) {
        Iterable<? extends JavaFileObject> compUnits = this.stdManager.getJavaFileObjects(files);
        ArrayList<JavaFileObject> preprocessedCompUnits = new ArrayList<JavaFileObject>();
        try {
            for (JavaFileObject javaFileObject : compUnits) {
                preprocessedCompUnits.add(MemoryJavaFileManager.preprocessedFileObject(javaFileObject, this.includeDirs));
            }
        }
        catch (IOException ioExp) {
            throw new RuntimeException(ioExp);
        }
        return this.compile(preprocessedCompUnits, err, sourcePath, classPath);
    }

    public Map<String, byte[]> compile(Iterable<? extends JavaFileObject> compUnits, Writer err, String sourcePath, String classPath) {
        MemoryJavaFileManager manager = new MemoryJavaFileManager(this.stdManager, this.includeDirs);
        return this.compilerHelper.compile(manager, compUnits, err, sourcePath, classPath);
    }

    private Map<String, byte[]> compile(MemoryJavaFileManager manager, Iterable<? extends JavaFileObject> compUnits, Writer err, String sourcePath, String classPath) {
        return this.compilerHelper.compile(manager, compUnits, err, sourcePath, classPath);
    }
}

