/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class RecordsFilter
implements IFilter {
    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (!"java/lang/Record".equals(context.getSuperClassName())) {
            return;
        }
        Matcher matcher = new Matcher();
        if (matcher.isEquals(methodNode) || matcher.isHashCode(methodNode) || matcher.isToString(methodNode)) {
            output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
        }
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        boolean isToString(MethodNode m3) {
            if (!"toString".equals(m3.name) || !"()Ljava/lang/String;".equals(m3.desc)) {
                return false;
            }
            this.firstIsALoad0(m3);
            this.nextIsInvokeDynamic("toString");
            this.nextIs(176);
            return this.cursor != null;
        }

        boolean isHashCode(MethodNode m3) {
            if (!"hashCode".equals(m3.name) || !"()I".equals(m3.desc)) {
                return false;
            }
            this.firstIsALoad0(m3);
            this.nextIsInvokeDynamic("hashCode");
            this.nextIs(172);
            return this.cursor != null;
        }

        boolean isEquals(MethodNode m3) {
            if (!"equals".equals(m3.name) || !"(Ljava/lang/Object;)Z".equals(m3.desc)) {
                return false;
            }
            this.firstIsALoad0(m3);
            this.nextIs(25);
            this.nextIsInvokeDynamic("equals");
            this.nextIs(172);
            return this.cursor != null;
        }

        private void nextIsInvokeDynamic(String name) {
            this.nextIs(186);
            if (this.cursor == null) {
                return;
            }
            InvokeDynamicInsnNode i = (InvokeDynamicInsnNode)this.cursor;
            Handle bsm = i.bsm;
            if (name.equals(i.name) && "java/lang/runtime/ObjectMethods".equals(bsm.getOwner()) && "bootstrap".equals(bsm.getName())) {
                return;
            }
            this.cursor = null;
        }
    }
}

