/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Interval
implements Comparable<Interval> {
    private static final Pattern INTERVAL_PATTERN = Pattern.compile("\\((\\d+)[,;]\\s*(\\d+)\\)");
    private static final Pattern COMP_PATTERN = Pattern.compile("(<|>|=|<=|>=|GT|LT|GE|LE|EQ)?(\\d+)");
    private int a;
    private int b;

    public Interval(int a, int b) {
        this.a = a;
        this.b = b;
    }

    public static Interval eq(int value) {
        return new Interval(value, value);
    }

    public static Interval ge(int value) {
        return new Interval(value, Integer.MAX_VALUE);
    }

    public static Interval gt(int value) {
        return new Interval(value != Integer.MAX_VALUE ? value + 1 : Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static Interval le(int value) {
        return new Interval(Integer.MIN_VALUE, value);
    }

    public static Interval lt(int value) {
        return new Interval(Integer.MIN_VALUE, value != Integer.MIN_VALUE ? value - 1 : Integer.MIN_VALUE);
    }

    public static Interval all() {
        return new Interval(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static Interval none() {
        return new Interval(Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public static List<Interval> union(Collection<Interval> intervals) {
        TreeSet<Interval> itvSet = new TreeSet<Interval>(intervals);
        Iterator iter2 = itvSet.iterator();
        Interval previous = null;
        while (iter2.hasNext()) {
            if (previous == null) {
                previous = (Interval)iter2.next();
                continue;
            }
            Interval current = (Interval)iter2.next();
            if (current.a <= (previous.b != Integer.MAX_VALUE ? previous.b + 1 : Integer.MAX_VALUE)) {
                previous.b = current.b;
                iter2.remove();
                continue;
            }
            previous = current;
        }
        return new ArrayList<Interval>(itvSet);
    }

    public static List<Interval> invert(Collection<Interval> intervals) {
        Interval remainder = new Interval(Integer.MIN_VALUE, Integer.MAX_VALUE);
        TreeSet<Interval> sorted = new TreeSet<Interval>(Interval.union(intervals));
        ArrayList<Interval> result = new ArrayList<Interval>();
        for (Interval i : sorted) {
            if (i.isAll()) {
                return Collections.singletonList(Interval.none());
            }
            if (i.a <= remainder.a) {
                if (i.b <= remainder.a) continue;
                remainder.a = i.b != Integer.MAX_VALUE ? i.b + 1 : i.b;
                continue;
            }
            result.add(new Interval(remainder.a, i.a - 1));
            if (i.b < remainder.b) {
                remainder.a = i.b + 1;
                continue;
            }
            remainder = null;
            break;
        }
        if (remainder != null) {
            result.add(remainder);
        }
        return result;
    }

    public static Interval fromString(String s2) {
        Matcher m3 = INTERVAL_PATTERN.matcher(s2);
        if (m3.matches()) {
            int a = Integer.parseInt(m3.group(1));
            int b = Integer.parseInt(m3.group(2));
            return new Interval(a, b);
        }
        m3 = COMP_PATTERN.matcher(s2);
        if (m3.matches()) {
            String operator = m3.group(1) != null ? m3.group(1) : "";
            String val = m3.group(2);
            int level = Integer.parseInt(val);
            switch (operator) {
                case "EQ": 
                case "=": {
                    return Interval.eq(level);
                }
                case "LT": 
                case "<": {
                    return Interval.lt(level);
                }
                case "GT": 
                case ">": {
                    return Interval.gt(level);
                }
                case "LE": 
                case "<=": {
                    return Interval.le(level);
                }
                case "GE": 
                case ">=": 
                case "": {
                    return Interval.ge(level);
                }
            }
            throw new IllegalArgumentException("Unrecognized operator: " + operator);
        }
        throw new IllegalArgumentException("Invalid level declaration: " + s2);
    }

    public int getA() {
        return this.a;
    }

    public int getB() {
        return this.b;
    }

    public boolean isAll() {
        return this.a == Integer.MIN_VALUE && this.b == Integer.MAX_VALUE;
    }

    public boolean isNone() {
        return this.a == Integer.MAX_VALUE;
    }

    @Override
    public int compareTo(Interval o) {
        if (this.a < o.a) {
            return -1;
        }
        if (this.a > o.a) {
            return 1;
        }
        return Integer.compare(this.b, o.b);
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + this.a;
        hash = 23 * hash + this.b;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.a != other.a) {
            return false;
        }
        return this.b == other.b;
    }

    public String toString() {
        if (this.a == Integer.MIN_VALUE) {
            if (this.b != Integer.MAX_VALUE) {
                return "LE" + this.b;
            }
        } else if (this.b == Integer.MAX_VALUE) {
            return "GE" + this.a;
        }
        return "(" + this.a + ";" + this.b + ")";
    }
}

