/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.runtime;

import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import jdk.internal.perf.Perf;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import jdk.jfr.EventType;
import org.openjdk.btrace.core.ArgsMap;
import org.openjdk.btrace.core.comm.CommandListener;
import org.openjdk.btrace.core.jfr.JfrEvent;
import org.openjdk.btrace.runtime.BTraceRuntimeImplBase;
import org.openjdk.btrace.runtime.BTraceRuntimeImplFactory;
import org.openjdk.btrace.runtime.JfrEventFactoryImpl;
import org.openjdk.btrace.runtime.auxiliary.Auxiliary;

public final class BTraceRuntimeImpl_11
extends BTraceRuntimeImplBase {
    private static final int V_Variable = 3;
    private static final int V_None = 1;
    private static final int V_String = 5;
    private static final int PERF_STRING_LIMIT = 256;
    private static Perf perf;
    private final Set<JfrEventFactoryImpl> eventFactories = new CopyOnWriteArraySet<JfrEventFactoryImpl>();

    public BTraceRuntimeImpl_11() {
    }

    public BTraceRuntimeImpl_11(String className, ArgsMap args, CommandListener cmdListener, Instrumentation inst) {
        super(className, args, cmdListener, BTraceRuntimeImpl_11.fixExports(inst));
    }

    private static Instrumentation fixExports(Instrumentation instr) {
        Set<Module> myModules = Collections.singleton(BTraceRuntimeImpl_11.class.getModule());
        if (instr != null) {
            instr.redefineModule(String.class.getModule(), Collections.emptySet(), Map.of("jdk.internal.reflect", myModules, "jdk.internal.perf", myModules, "sun.security.action", myModules), Map.of("java.lang", myModules), Collections.emptySet(), Collections.emptyMap());
            instr.redefineModule(EventType.class.getModule(), Collections.emptySet(), Map.of("jdk.jfr.internal", myModules), Map.of("jdk.jfr", myModules), Collections.emptySet(), Collections.emptyMap());
        }
        return instr;
    }

    @Override
    @CallerSensitive
    public Class<?> defineClass(byte[] code, boolean mustBeBootstrap) {
        try {
            Class<?> caller = Reflection.getCallerClass();
            if (!caller.getName().startsWith("org.openjdk.btrace.")) {
                throw new SecurityException("unsafe defineClass");
            }
            Class<?> clz = MethodHandles.privateLookupIn(Auxiliary.class, MethodHandles.lookup()).defineClass(code);
            clz.getConstructor(new Class[0]).newInstance(new Object[0]);
            return clz;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    @Override
    public void newPerfCounter(Object value, String name, String desc) {
        Perf perf = BTraceRuntimeImpl_11.getPerf();
        char tc = desc.charAt(0);
        switch (tc) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                long initValue = value != null ? ((Number)value).longValue() : 0L;
                ByteBuffer b = perf.createLong(name, 3, 1, initValue);
                b.order(ByteOrder.nativeOrder());
                counters.put(name, b);
                break;
            }
            case '[': {
                break;
            }
            case 'L': {
                byte[] buf;
                if (!desc.equals("Ljava/lang/String;")) break;
                if (value != null) {
                    buf = BTraceRuntimeImpl_11.getStringBytes((String)value);
                } else {
                    buf = new byte[256];
                    buf[0] = 0;
                }
                ByteBuffer b = perf.createByteArray(name, 3, 5, buf, buf.length);
                counters.put(name, b);
            }
        }
    }

    @Override
    public ClassLoader getCallerClassLoader(int stackDec) {
        AtomicInteger cont = new AtomicInteger(stackDec);
        AtomicReference<Object> cl = new AtomicReference<Object>(null);
        StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).forEach(f -> {
            if (cont.getAndDecrement() == 0) {
                cl.compareAndSet(null, f.getDeclaringClass().getClassLoader());
            }
        });
        return cl.get();
    }

    @Override
    public Class<?> getCallerClass(int stackDec) {
        AtomicInteger cont = new AtomicInteger(stackDec);
        AtomicReference<Object> cl = new AtomicReference<Object>(null);
        StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).forEach(f -> {
            if (cont.getAndDecrement() == 0) {
                cl.compareAndSet(null, f.getDeclaringClass());
            }
        });
        return cl.get();
    }

    @Override
    public int version() {
        return Runtime.version().feature();
    }

    @Override
    public JfrEvent.Factory createEventFactory(JfrEvent.Template template) {
        JfrEventFactoryImpl factory = new JfrEventFactoryImpl(template);
        this.eventFactories.add(factory);
        return factory;
    }

    @Override
    protected void cleanupRuntime() {
        for (JfrEventFactoryImpl factory : this.eventFactories) {
            factory.unregister();
        }
        this.eventFactories.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Perf getPerf() {
        Class<BTraceRuntimeImpl_11> clazz = BTraceRuntimeImpl_11.class;
        synchronized (BTraceRuntimeImpl_11.class) {
            if (perf == null) {
                perf = AccessController.doPrivileged(new Perf.GetPerfAction());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return perf;
        }
    }

    public static final class Factory
    extends BTraceRuntimeImplFactory<BTraceRuntimeImpl_11> {
        public Factory() {
            super(new BTraceRuntimeImpl_11());
        }

        @Override
        public BTraceRuntimeImpl_11 getRuntime(String className, ArgsMap args, CommandListener cmdListener, Instrumentation inst) {
            return new BTraceRuntimeImpl_11(className, args, cmdListener, inst);
        }

        @Override
        public boolean isEnabled() {
            Runtime.Version version = Runtime.version();
            return version.version().get(0) >= 11;
        }
    }
}

