/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openjdk.btrace.core.BTraceRuntime;
import org.openjdk.btrace.core.comm.Command;
import org.openjdk.btrace.core.handlers.ErrorHandler;
import org.openjdk.btrace.core.handlers.EventHandler;
import org.openjdk.btrace.core.handlers.ExitHandler;
import org.openjdk.btrace.core.handlers.LowMemoryHandler;
import org.openjdk.btrace.core.handlers.TimerHandler;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;
import org.openjdk.btrace.runtime.BTraceRuntimeImplBase;
import org.openjdk.btrace.runtime.BTraceRuntimes;
import org.openjdk.btrace.runtime.auxiliary.Auxiliary;
import org.openjdk.btrace.services.api.RuntimeContext;

public abstract class BTraceRuntimeAccess
implements RuntimeContext {
    private static final Logger log = LoggerFactory.getLogger(BTraceRuntimeAccess.class);
    private static volatile BTraceRuntime.Impl dummy = null;
    protected static final ThreadLocal<RTWrapper> rt = ThreadLocal.withInitial(RTWrapper::new);
    private static volatile boolean uniqueClientClassNames;
    protected static final Map<String, BTraceRuntimeImplBase> runtimes;
    private static final Set<String> clients;
    private Class clazz;
    private Field level;
    private final AtomicBoolean exitting = new AtomicBoolean(false);

    static void addRuntime(String className, BTraceRuntimeImplBase rt) {
        runtimes.put(className, rt);
    }

    public static boolean enter(BTraceRuntime.Impl currentRt) {
        BTraceRuntimeImplBase current = (BTraceRuntimeImplBase)currentRt;
        if (current.isDisabled()) {
            return false;
        }
        return rt.get().set(current);
    }

    public static void leave() {
        rt.get().set(null);
    }

    public static String getClientName(String forClassName) {
        int idx = forClassName.lastIndexOf(47);
        forClassName = idx > -1 ? Auxiliary.class.getPackage().getName().replace('.', '/') + "/" + forClassName.substring(idx + 1) : Auxiliary.class.getPackage().getName().replace('.', '/') + "/" + forClassName;
        if (!uniqueClientClassNames) {
            return forClassName;
        }
        String name = forClassName;
        int suffix = 1;
        while (clients.contains(name)) {
            name = forClassName + "$" + suffix++;
        }
        clients.add(name);
        return name;
    }

    public void shutdownCmdLine() {
        this.exitting.set(true);
    }

    public static BTraceRuntimeImplBase forClass(Class cl, TimerHandler[] tHandlers, EventHandler[] evHandlers, ErrorHandler[] errHandlers, ExitHandler[] eHandlers, LowMemoryHandler[] lmHandlers) {
        BTraceRuntimeImplBase runtime = runtimes.get(cl.getName());
        runtime.init(cl, tHandlers, evHandlers, errHandlers, eHandlers, lmHandlers);
        return runtime;
    }

    public static ThreadLocal newThreadLocal(Object initValue) {
        return ThreadLocal.withInitial(() -> {
            if (initValue == null) {
                return initValue;
            }
            if (initValue instanceof Cloneable) {
                try {
                    Class<?> clz = initValue.getClass();
                    Method m3 = clz.getDeclaredMethod("clone", new Class[0]);
                    m3.setAccessible(true);
                    return m3.invoke(initValue, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return initValue;
        });
    }

    static BTraceRuntimeImplBase getCurrent() {
        RTWrapper rtw = rt.get();
        BTraceRuntime.Impl current = rtw != null ? rtw.rt : null;
        current = current != null ? current : dummy;
        return (BTraceRuntimeImplBase)current;
    }

    static <T> T doWithCurrent(Callable<T> callable) {
        RTWrapper rtw = rt.get();
        assert (rtw != null) : "BTraceRuntime access not set up";
        return rtw.escape(callable);
    }

    @Override
    public void send(String msg) {
        BTraceRuntimeImplBase rt = BTraceRuntimeAccess.getCurrent();
        if (rt != null) {
            rt.send(msg);
        }
    }

    @Override
    public void send(Command cmd) {
        BTraceRuntimeImplBase rt = BTraceRuntimeAccess.getCurrent();
        if (rt != null) {
            rt.send(cmd);
        }
    }

    static void registerRuntimeAccessor() {
        try {
            dummy = BTraceRuntimes.getDefault();
            Field fld = BTraceRuntime.class.getDeclaredField("rtAccessor");
            fld.setAccessible(true);
            fld.set(null, new Accessor());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            log.warn("Failed to register runtime accessor", e);
        }
    }

    static {
        BTraceRuntimeAccess.registerRuntimeAccessor();
        uniqueClientClassNames = true;
        runtimes = new ConcurrentHashMap<String, BTraceRuntimeImplBase>();
        clients = new HashSet<String>();
    }

    static final class Accessor
    implements BTraceRuntime.BTraceRuntimeAccessor {
        Accessor() {
        }

        @Override
        public BTraceRuntime.Impl getRt() {
            BTraceRuntimeImplBase current = BTraceRuntimeAccess.getCurrent();
            return current != null ? current : dummy;
        }
    }

    static final class RTWrapper {
        private BTraceRuntime.Impl rt = null;

        RTWrapper() {
        }

        boolean set(BTraceRuntime.Impl other) {
            if (this.rt != null && other != null) {
                return false;
            }
            this.rt = other;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> T escape(Callable<T> c) {
            BTraceRuntime.Impl oldRuntime = this.rt;
            this.rt = null;
            try {
                T t = c.call();
                return t;
            }
            catch (Exception exception) {
            }
            finally {
                if (oldRuntime != null) {
                    this.rt = oldRuntime;
                }
            }
            return null;
        }
    }
}

