/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.libs.org.jctools.queues;

import org.openjdk.btrace.libs.org.jctools.queues.MessagePassingQueue;
import org.openjdk.btrace.libs.org.jctools.queues.MpUnboundedXaddArrayQueue;
import org.openjdk.btrace.libs.org.jctools.queues.MpUnboundedXaddChunk;
import org.openjdk.btrace.libs.org.jctools.queues.MpscUnboundedXaddChunk;
import org.openjdk.btrace.libs.org.jctools.util.PortableJvmInfo;

public class MpscUnboundedXaddArrayQueue<E>
extends MpUnboundedXaddArrayQueue<MpscUnboundedXaddChunk<E>, E> {
    public MpscUnboundedXaddArrayQueue(int chunkSize, int maxPooledChunks) {
        super(chunkSize, maxPooledChunks);
    }

    public MpscUnboundedXaddArrayQueue(int chunkSize) {
        this(chunkSize, 2);
    }

    @Override
    final MpscUnboundedXaddChunk<E> newChunk(long index, MpscUnboundedXaddChunk<E> prev, int chunkSize, boolean pooled) {
        return new MpscUnboundedXaddChunk<E>(index, prev, chunkSize, pooled);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        int chunkMask = this.chunkMask;
        int chunkShift = this.chunkShift;
        long pIndex = this.getAndIncrementProducerIndex();
        int piChunkOffset = (int)(pIndex & (long)chunkMask);
        long piChunkIndex = pIndex >> chunkShift;
        MpscUnboundedXaddChunk pChunk = (MpscUnboundedXaddChunk)this.lvProducerChunk();
        if (pChunk.lvIndex() != piChunkIndex) {
            pChunk = this.producerChunkForIndex(pChunk, piChunkIndex);
        }
        pChunk.soElement(piChunkOffset, e);
        return true;
    }

    private MpscUnboundedXaddChunk<E> pollNextBuffer(MpscUnboundedXaddChunk<E> cChunk, long cIndex) {
        MpscUnboundedXaddChunk<E> next = this.spinForNextIfNotEmpty(cChunk, cIndex);
        if (next == null) {
            return null;
        }
        this.moveToNextConsumerChunk(cChunk, next);
        assert (next.lvIndex() == cIndex >> this.chunkShift);
        return next;
    }

    private MpscUnboundedXaddChunk<E> spinForNextIfNotEmpty(MpscUnboundedXaddChunk<E> cChunk, long cIndex) {
        MpscUnboundedXaddChunk<E> next = (MpscUnboundedXaddChunk<E>)cChunk.lvNext();
        if (next == null) {
            if (this.lvProducerIndex() == cIndex) {
                return null;
            }
            long ccChunkIndex = cChunk.lvIndex();
            if (this.lvProducerChunkIndex() == ccChunkIndex) {
                next = this.appendNextChunks(cChunk, ccChunkIndex, 1L);
            }
            while (next == null) {
                next = (MpscUnboundedXaddChunk)cChunk.lvNext();
            }
        }
        return next;
    }

    @Override
    public E poll() {
        int chunkMask = this.chunkMask;
        long cIndex = this.lpConsumerIndex();
        int ciChunkOffset = (int)(cIndex & (long)chunkMask);
        MpscUnboundedXaddChunk<E> cChunk = (MpscUnboundedXaddChunk<E>)this.lvConsumerChunk();
        if (ciChunkOffset == 0 && cIndex != 0L && (cChunk = this.pollNextBuffer(cChunk, cIndex)) == null) {
            return null;
        }
        Object e = cChunk.lvElement(ciChunkOffset);
        if (e == null) {
            if (this.lvProducerIndex() == cIndex) {
                return null;
            }
            e = cChunk.spinForElement(ciChunkOffset, false);
        }
        cChunk.soElement(ciChunkOffset, null);
        this.soConsumerIndex(cIndex + 1L);
        return e;
    }

    @Override
    public E peek() {
        int chunkMask = this.chunkMask;
        long cIndex = this.lpConsumerIndex();
        int ciChunkOffset = (int)(cIndex & (long)chunkMask);
        MpscUnboundedXaddChunk<E> cChunk = (MpscUnboundedXaddChunk<E>)this.lpConsumerChunk();
        if (ciChunkOffset == 0 && cIndex != 0L && (cChunk = this.spinForNextIfNotEmpty(cChunk, cIndex)) == null) {
            return null;
        }
        Object e = cChunk.lvElement(ciChunkOffset);
        if (e == null) {
            if (this.lvProducerIndex() == cIndex) {
                return null;
            }
            e = cChunk.spinForElement(ciChunkOffset, false);
        }
        return e;
    }

    @Override
    public E relaxedPoll() {
        Object e;
        int chunkMask = this.chunkMask;
        long cIndex = this.lpConsumerIndex();
        int ciChunkOffset = (int)(cIndex & (long)chunkMask);
        MpscUnboundedXaddChunk cChunk = (MpscUnboundedXaddChunk)this.lpConsumerChunk();
        if (ciChunkOffset == 0 && cIndex != 0L) {
            MpscUnboundedXaddChunk next = (MpscUnboundedXaddChunk)cChunk.lvNext();
            if (next == null) {
                return null;
            }
            e = next.lvElement(0);
            if (e == null) {
                return null;
            }
            this.moveToNextConsumerChunk(cChunk, next);
            cChunk = next;
        } else {
            e = cChunk.lvElement(ciChunkOffset);
            if (e == null) {
                return null;
            }
        }
        cChunk.soElement(ciChunkOffset, null);
        this.soConsumerIndex(cIndex + 1L);
        return e;
    }

    @Override
    public E relaxedPeek() {
        int chunkMask = this.chunkMask;
        long cIndex = this.lpConsumerIndex();
        int cChunkOffset = (int)(cIndex & (long)chunkMask);
        MpscUnboundedXaddChunk cChunk = (MpscUnboundedXaddChunk)this.lpConsumerChunk();
        if (cChunkOffset == 0 && cIndex != 0L && (cChunk = (MpscUnboundedXaddChunk)cChunk.lvNext()) == null) {
            return null;
        }
        return cChunk.lvElement(cChunkOffset);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2) {
        int filled;
        long result = 0L;
        int capacity = this.chunkMask + 1;
        int offerBatch = Math.min(PortableJvmInfo.RECOMENDED_OFFER_BATCH, capacity);
        do {
            if ((filled = this.fill(s2, offerBatch)) != 0) continue;
            return (int)result;
        } while ((result += (long)filled) <= (long)capacity);
        return (int)result;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        if (null == c) {
            throw new IllegalArgumentException("c is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative: " + limit);
        }
        if (limit == 0) {
            return 0;
        }
        int chunkMask = this.chunkMask;
        long cIndex = this.lpConsumerIndex();
        MpscUnboundedXaddChunk cChunk = (MpscUnboundedXaddChunk)this.lpConsumerChunk();
        for (int i = 0; i < limit; ++i) {
            Object e;
            int consumerOffset = (int)(cIndex & (long)chunkMask);
            if (consumerOffset == 0 && cIndex != 0L) {
                MpscUnboundedXaddChunk next = (MpscUnboundedXaddChunk)cChunk.lvNext();
                if (next == null) {
                    return i;
                }
                e = next.lvElement(0);
                if (e == null) {
                    return i;
                }
                this.moveToNextConsumerChunk(cChunk, next);
                cChunk = next;
            } else {
                e = cChunk.lvElement(consumerOffset);
                if (e == null) {
                    return i;
                }
            }
            cChunk.soElement(consumerOffset, null);
            long nextConsumerIndex = cIndex + 1L;
            this.soConsumerIndex(nextConsumerIndex);
            c.accept(e);
            cIndex = nextConsumerIndex;
        }
        return limit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2, int limit) {
        if (null == s2) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        int chunkShift = this.chunkShift;
        int chunkMask = this.chunkMask;
        long pIndex = this.getAndAddProducerIndex(limit);
        MpUnboundedXaddChunk pChunk = null;
        for (int i = 0; i < limit; ++i) {
            int pChunkOffset = (int)(pIndex & (long)chunkMask);
            long chunkIndex = pIndex >> chunkShift;
            if (pChunk == null || pChunk.lvIndex() != chunkIndex) {
                pChunk = (MpscUnboundedXaddChunk)this.producerChunkForIndex(pChunk, chunkIndex);
            }
            pChunk.soElement(pChunkOffset, s2.get());
            ++pIndex;
        }
        return limit;
    }
}

