/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.util.Arrays;

public class VariableMapper {
    private static final int UNMASK = 0x1FFFFFFF;
    private static final int DOUBLE_SLOT_FLAG = 0x20000000;
    private static final int REMAP_FLAG = 0x40000000;
    private static final int INVALID_MASK = -1;
    private final int argsSize;
    private int nextMappedVar = 0;
    private int[] mapping = new int[8];

    public VariableMapper(int argsSize) {
        this.argsSize = argsSize;
        this.nextMappedVar = argsSize;
    }

    VariableMapper(int argsSize, int nextMappedVar, int[] mapping) {
        this.argsSize = argsSize;
        this.nextMappedVar = nextMappedVar;
        this.mapping = Arrays.copyOf(mapping, mapping.length);
    }

    public static int unmask(int var) {
        return var & 0x1FFFFFFF;
    }

    public static boolean isInvalidMapping(int var) {
        return (var & 0xFFFFFFFF) != 0;
    }

    public VariableMapper mirror() {
        return new VariableMapper(this.argsSize, this.nextMappedVar, this.mapping);
    }

    public void setMapping(int from, int to, int size) {
        int padding;
        int n = padding = size == 1 ? 0 : 1;
        if (this.mapping.length <= from + padding) {
            this.mapping = Arrays.copyOf(this.mapping, Math.max(this.mapping.length * 2, from + padding + 1));
        }
        this.mapping[from] = to | 0x40000000;
        if (padding > 0) {
            this.mapping[from + padding] = Math.abs(to) + padding;
        }
    }

    public int remap(int var, int size) {
        int mappedVar;
        boolean isRemapped;
        if ((var & 0x40000000) != 0) {
            return VariableMapper.unmask(var);
        }
        int offset = var - this.argsSize;
        if (offset < 0) {
            return var;
        }
        if (offset >= this.mapping.length) {
            this.mapping = Arrays.copyOf(this.mapping, Math.max(this.mapping.length * 2, offset + 1));
        }
        boolean bl = isRemapped = ((mappedVar = this.mapping[offset]) & 0x40000000) != 0;
        if (size == 2 && (mappedVar & 0x20000000) == 0) {
            isRemapped = false;
        }
        if (!isRemapped) {
            mappedVar = this.remapVar(this.newVarIdxInternal(size), size);
            this.setMapping(offset, mappedVar, size);
        }
        int unmasked = VariableMapper.unmask(mappedVar);
        this.nextMappedVar = Math.max(unmasked + size, this.nextMappedVar);
        return unmasked;
    }

    public int map(int var) {
        if ((var & 0x40000000) != 0) {
            return VariableMapper.unmask(var);
        }
        int offset = var - this.argsSize;
        if (offset >= 0) {
            if (this.mapping.length <= offset) {
                return -1;
            }
            int newVar = this.mapping[offset];
            return (newVar & 0x40000000) != 0 ? VariableMapper.unmask(newVar) : -1;
        }
        return var;
    }

    public int[] mappings() {
        int[] cleansed = new int[this.mapping.length];
        for (int i = 0; i < this.mapping.length; ++i) {
            cleansed[i] = VariableMapper.unmask(this.mapping[i]);
        }
        return cleansed;
    }

    private int newVarIdxInternal(int size) {
        int var = this.nextMappedVar;
        this.nextMappedVar += size;
        return var == 0 ? Integer.MIN_VALUE : var;
    }

    private int remapVar(int var, int size) {
        int mappedVar = var | 0x40000000;
        if (size == 2) {
            mappedVar |= 0x20000000;
        }
        return mappedVar;
    }

    public int newVarIdx(int size) {
        int var = this.newVarIdxInternal(size);
        return this.remapVar(var, size);
    }

    public int getNextMappedVar() {
        return this.nextMappedVar;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("nextVar: ").append(this.nextMappedVar).append(", mappings: [");
        for (int j : this.mapping) {
            if ((j & 0x40000000) != 0) {
                sb.append(VariableMapper.unmask(j));
            } else {
                sb.append(j);
            }
            sb.append(",");
        }
        sb.append("],\n{").append(Arrays.toString(this.mapping)).append("}");
        return sb.toString();
    }
}

