/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import org.openjdk.btrace.instr.MethodEntryExitInstrumentor;
import org.openjdk.btrace.instr.MethodInstrumentorHelper;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;

public class SynchronizedInstrumentor
extends MethodEntryExitInstrumentor {
    protected final boolean isStatic;
    protected final boolean isSyncMethod;

    public SynchronizedInstrumentor(ClassLoader cl, MethodVisitor mv, MethodInstrumentorHelper mHelper, String parentClz, String superClz, int access, String name, String desc) {
        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
        this.isStatic = (access & 8) != 0;
        this.isSyncMethod = (access & 0x20) != 0;
    }

    @Override
    protected void onMethodEntry() {
        if (this.isSyncMethod) {
            this.onAfterSyncEntry();
        }
    }

    @Override
    protected void onMethodReturn(int opcode) {
        this.onErrorReturn();
    }

    @Override
    protected void onErrorReturn() {
        if (this.isSyncMethod) {
            this.onBeforeSyncExit();
        }
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode == 194) {
            this.onBeforeSyncEntry();
        } else if (opcode == 195) {
            this.onBeforeSyncExit();
        }
        super.visitInsn(opcode);
        if (opcode == 194) {
            this.onAfterSyncEntry();
        } else if (opcode == 195) {
            this.onAfterSyncExit();
        }
    }

    protected void onBeforeSyncEntry() {
        this.asm.println("before synchronized entry");
    }

    protected void onAfterSyncEntry() {
        this.asm.println("after synchronized entry");
    }

    protected void onBeforeSyncExit() {
        this.asm.println("before synchronized exit");
    }

    protected void onAfterSyncExit() {
        this.asm.println("after synchronized exit");
    }
}

