/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import org.openjdk.btrace.instr.Constants;
import org.openjdk.btrace.libs.org.objectweb.asm.AnnotationVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassReader;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassWriter;
import org.openjdk.btrace.libs.org.objectweb.asm.FieldVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;

final class ProbeUpgradeVisitor_1_2
extends ClassVisitor {
    private static final String ANNOTATIONS_PREFIX_OLD = "Lcom/sun/btrace/annotations/";
    private static final String ANNOTATIONS_PREFIX_NEW = "Lorg/openjdk/btrace/core/annotations/";
    private String cName = null;

    ProbeUpgradeVisitor_1_2(ClassVisitor cv) {
        super(589824, cv);
    }

    static byte[] upgrade(ClassReader cr) {
        ClassWriter cw = new ClassWriter(3);
        cr.accept(new ProbeUpgradeVisitor_1_2(cw), 8);
        return cw.toByteArray();
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.cName = name.replace('.', '/');
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (desc.startsWith(ANNOTATIONS_PREFIX_OLD)) {
            desc = ANNOTATIONS_PREFIX_NEW + desc.substring(ANNOTATIONS_PREFIX_OLD.length());
        }
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (desc.contains("BTraceRuntime")) {
            desc = "Lorg/openjdk/btrace/runtime/BTraceRuntimeAccess;";
        }
        return new FieldVisitor(589824, super.visitField(access, name, desc, signature, value)){

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (desc.startsWith(ProbeUpgradeVisitor_1_2.ANNOTATIONS_PREFIX_OLD)) {
                    desc = ProbeUpgradeVisitor_1_2.ANNOTATIONS_PREFIX_NEW + desc.substring(ProbeUpgradeVisitor_1_2.ANNOTATIONS_PREFIX_OLD.length());
                }
                return super.visitAnnotation(desc, visible);
            }
        };
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new MethodVisitor(589824, super.visitMethod(access, name, desc, signature, exceptions)){

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (desc.startsWith(ProbeUpgradeVisitor_1_2.ANNOTATIONS_PREFIX_OLD)) {
                    desc = ProbeUpgradeVisitor_1_2.ANNOTATIONS_PREFIX_NEW + desc.substring(ProbeUpgradeVisitor_1_2.ANNOTATIONS_PREFIX_OLD.length());
                }
                return super.visitAnnotation(desc, visible);
            }

            @Override
            public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                return super.visitParameterAnnotation(parameter, desc.replace("com/sun/btrace/annotations/", "org/openjdk/btrace/core/annotations/"), visible);
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (desc.equals("Lcom/sun/btrace/BTraceRuntime;")) {
                    desc = "Lorg/openjdk/btrace/runtime/BTraceRuntimeAccess;";
                }
                super.visitFieldInsn(opcode, owner, name, desc);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (owner.equals("com/sun/btrace/BTraceRuntime")) {
                    if (name.equals("enter")) {
                        if (desc.equals("(Lcom/sun/btrace/BTraceRuntime;)Z")) {
                            this.visitMethodInsn(184, "org/openjdk/btrace/runtime/BTraceRuntimeAccess", name, "(Lorg/openjdk/btrace/runtime/BTraceRuntimeAccess;)Z", itf);
                        } else {
                            this.visitFieldInsn(178, ProbeUpgradeVisitor_1_2.this.cName, "runtime", "Lorg/openjdk/btrace/runtime/BTraceRuntimeAccess;");
                            this.visitMethodInsn(182, "org/openjdk/btrace/runtime/BTraceRuntimeAccess", name, "()Z", itf);
                        }
                    } else if (name.equals("forClass")) {
                        desc = desc.replace("com/sun/btrace/shared/", "org/openjdk/btrace/core/handlers/");
                        desc = desc.replace(")Lcom/sun/btrace/BTraceRuntime;", ")Lorg/openjdk/btrace/runtime/BTraceRuntimeAccess;");
                        super.visitMethodInsn(opcode, "org/openjdk/btrace/runtime/BTraceRuntimeAccess", name, desc, itf);
                    } else {
                        super.visitMethodInsn(184, "org/openjdk/btrace/core/BTraceRuntime", name, desc, itf);
                    }
                } else if (owner.startsWith("com/sun/btrace/BTraceUtils")) {
                    super.visitMethodInsn(184, Constants.BTRACE_UTILS, name, desc, itf);
                } else if (owner.startsWith("com/sun/btrace/services/")) {
                    owner = owner.replace("com/sun/btrace/services/", "org/openjdk/btrace/services/");
                    desc = desc.replace("com/sun/btrace/BTraceRuntime", "org/openjdk/btrace/runtime/BTraceRuntimeAccess");
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                } else {
                    owner = owner.replace("com/sun/btrace/shared/", "org/openjdk/btrace/core/handlers/");
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }

            @Override
            public void visitTypeInsn(int opcode, String type) {
                type = type.replace("com/sun/btrace/shared/", "org/openjdk/btrace/core/handlers/");
                type = type.replace("com/sun/btrace/services/", "org/openjdk/btrace/services/");
                super.visitTypeInsn(opcode, type);
            }
        };
    }
}

