/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import org.openjdk.btrace.libs.org.objectweb.asm.ClassReader;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassWriter;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;

final class ProbeRenameVisitor
extends ClassVisitor {
    private String oldClassName = null;
    private final String newClassName;

    ProbeRenameVisitor(ClassVisitor classVisitor, String newClassName) {
        super(589824, classVisitor);
        this.newClassName = newClassName.replace('.', '/');
    }

    static byte[] rename(String newClassName, byte[] data) {
        ClassReader cr = new ClassReader(data);
        ClassWriter cw = new ClassWriter(3);
        cr.accept(new ProbeRenameVisitor(cw, newClassName), 2);
        return cw.toByteArray();
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.oldClassName = name;
        super.visit(version, access, this.newClassName, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        return new MethodVisitor(589824, super.visitMethod(access, name, descriptor, signature, exceptions)){

            @Override
            public void visitTypeInsn(int opcode, String type) {
                super.visitTypeInsn(opcode, type.equals(ProbeRenameVisitor.this.oldClassName) ? ProbeRenameVisitor.this.newClassName : type);
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                super.visitFieldInsn(opcode, owner.equals(ProbeRenameVisitor.this.oldClassName) ? ProbeRenameVisitor.this.newClassName : owner, name, descriptor);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                super.visitMethodInsn(opcode, owner.equals(ProbeRenameVisitor.this.oldClassName) ? ProbeRenameVisitor.this.newClassName : owner, name, descriptor, isInterface);
            }
        };
    }
}

