/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openjdk.btrace.instr.BTraceClassReader;
import org.openjdk.btrace.instr.BTraceClassWriter;
import org.openjdk.btrace.instr.ClassCache;
import org.openjdk.btrace.instr.ClassInfo;
import org.openjdk.btrace.instr.TypeUtils;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassWriter;
import org.openjdk.btrace.libs.org.objectweb.asm.Type;

public final class InstrumentUtils {
    private static final int CW_FLAGS = 0;

    public static void collectHierarchyClosure(ClassLoader cl, String type, Set<String> closure, boolean useInternal) {
        InstrumentUtils.collectHierarchyClosure(cl, type, closure, useInternal, false);
    }

    public static void collectHierarchyClosure(ClassLoader cl, String type, Set<String> closure, boolean useInternal, boolean ifcs) {
        if (type == null || type.equals("java/lang/Object")) {
            return;
        }
        ClassInfo ci = ClassCache.getInstance().get(cl, type);
        LinkedHashSet<ClassInfo> ciSet = new LinkedHashSet<ClassInfo>();
        ciSet.add(ci);
        for (ClassInfo sci : ci.getSupertypes(false)) {
            if (!ifcs && sci.isInterface() || sci.getClassName().equals("java/lang/Object")) continue;
            ciSet.add(sci);
        }
        for (ClassInfo sci : ciSet) {
            closure.add(useInternal ? sci.getClassName() : sci.getJavaClassName());
        }
    }

    public static boolean isAssignable(Type left, Type right, ClassLoader cl, boolean exactTypeCheck) {
        boolean isSame = left.equals(right);
        if (isSame) {
            return true;
        }
        if (TypeUtils.isVoid(left)) {
            return TypeUtils.isVoid(right);
        }
        if (TypeUtils.isAnyType(left)) {
            return true;
        }
        if (exactTypeCheck) {
            return false;
        }
        if (TypeUtils.isObject(left)) {
            return true;
        }
        HashSet<String> closure = new HashSet<String>();
        InstrumentUtils.collectHierarchyClosure(cl, right.getInternalName(), closure, true, true);
        return closure.contains(left.getInternalName());
    }

    public static boolean isAssignable(Type[] args1, Type[] args2, ClassLoader cl, boolean exactTypeCheck) {
        if (args1.length != args2.length) {
            return false;
        }
        for (int i = 0; i < args1.length; ++i) {
            if (args1[i].equals(args2[i])) continue;
            int sort2 = args2[i].getSort();
            if (TypeUtils.isAnyType(args1[i]) && (sort2 == 10 || sort2 == 9 || TypeUtils.isPrimitive(args2[i])) || InstrumentUtils.isAssignable(args1[i], args2[i], cl, exactTypeCheck)) continue;
            return false;
        }
        return true;
    }

    public static String arrayDescriptorFor(int typeCode) {
        switch (typeCode) {
            case 4: {
                return "[Z";
            }
            case 5: {
                return "[C";
            }
            case 6: {
                return "[F";
            }
            case 7: {
                return "[D";
            }
            case 8: {
                return "[B";
            }
            case 9: {
                return "[S";
            }
            case 10: {
                return "[I";
            }
            case 11: {
                return "[J";
            }
        }
        throw new IllegalArgumentException();
    }

    public static void accept(BTraceClassReader reader, ClassVisitor visitor) {
        InstrumentUtils.accept(reader, visitor, 0);
    }

    public static void accept(BTraceClassReader reader, ClassVisitor visitor, int flags) {
        if (reader == null || visitor == null) {
            return;
        }
        reader.accept(visitor, flags);
    }

    private static boolean isJDK16OrAbove(byte[] code) {
        return InstrumentUtils.isJDK16OrAbove(InstrumentUtils.getMajor(code));
    }

    private static boolean isJDK16OrAbove(BTraceClassReader cr) {
        return InstrumentUtils.isJDK16OrAbove(InstrumentUtils.getMajor(cr));
    }

    private static boolean isJDK16OrAbove(int major) {
        return major >= 50;
    }

    private static int getMajor(BTraceClassReader cr) {
        return cr.getClassVersion();
    }

    private static int getMajor(byte[] code) {
        int majorOffset = 6;
        return code[majorOffset] << 8 & 0xFF00 | code[majorOffset + 1] & 0xFF;
    }

    public static ClassWriter newClassWriter() {
        return InstrumentUtils.newClassWriter(false);
    }

    public static ClassWriter newClassWriter(boolean computeFrames) {
        return InstrumentUtils.newClassWriter(computeFrames, false);
    }

    public static ClassWriter newClassWriter(boolean computeFrames, boolean computeMaxs) {
        int flags = 0;
        if (computeFrames) {
            flags |= 2;
        }
        if (computeMaxs) {
            flags |= 1;
        }
        return InstrumentUtils.newClassWriter(null, flags);
    }

    static BTraceClassWriter newClassWriter(BTraceClassReader cr) {
        return InstrumentUtils.newClassWriter(cr, 0);
    }

    static BTraceClassWriter newClassWriter(BTraceClassReader reader, int flags) {
        BTraceClassWriter cw = reader != null ? new BTraceClassWriter(reader.getClassLoader(), reader, flags) : new BTraceClassWriter(null, flags);
        return cw;
    }

    static BTraceClassReader newClassReader(byte[] code) {
        return new BTraceClassReader(ClassLoader.getSystemClassLoader(), code);
    }

    static BTraceClassReader newClassReader(ClassLoader cl, byte[] code) {
        return new BTraceClassReader(cl, code);
    }

    static BTraceClassReader newClassReader(InputStream is) throws IOException {
        return new BTraceClassReader(ClassLoader.getSystemClassLoader(), is);
    }

    static BTraceClassReader newClassReader(ClassLoader cl, InputStream is) throws IOException {
        return new BTraceClassReader(cl, is);
    }

    static String getActionPrefix(String className) {
        return "$btrace$" + className.replace('/', '$') + "$";
    }
}

