/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public final class CallGraph {
    private static final Pattern MID_SPLIT_PTN = Pattern.compile("::");
    private final Set<Node> nodes = new HashSet<Node>();
    private final Set<Node> startingNodes = new HashSet<Node>();

    public static String methodId(String name, String desc) {
        return name + "::" + desc;
    }

    public static String[] method(String methodId) {
        if (methodId.contains("::")) {
            return MID_SPLIT_PTN.split(methodId);
        }
        return new String[0];
    }

    public void addEdge(String fromId, String toId) {
        Node fromNode = null;
        Node toNode = null;
        for (Node n : this.nodes) {
            if (n.id.equals(fromId)) {
                fromNode = n;
            }
            if (n.id.equals(toId)) {
                toNode = n;
            }
            if (fromNode == null || toNode == null) continue;
            break;
        }
        if (fromNode == null) {
            fromNode = new Node(fromId);
            this.nodes.add(fromNode);
        }
        if (toNode == null) {
            toNode = new Node(toId);
            this.nodes.add(toNode);
        }
        Edge e = new Edge(fromNode, toNode);
        fromNode.addOutgoing(e);
        toNode.addIncoming(e);
    }

    public void addStarting(Node n) {
        for (Node orig : this.nodes) {
            if (!orig.equals(n)) continue;
            this.startingNodes.add(orig);
            return;
        }
        this.startingNodes.add(n);
        this.nodes.add(n);
    }

    public boolean hasCycle() {
        Set<Node> looped = this.findCycles();
        if (looped.isEmpty()) {
            return false;
        }
        HashSet<Node> checkingSet = new HashSet<Node>(looped);
        checkingSet.retainAll(this.startingNodes);
        if (!checkingSet.isEmpty()) {
            return true;
        }
        ArrayDeque<Node> processingQueue = new ArrayDeque<Node>();
        for (Node n : this.startingNodes) {
            processingQueue.push(n);
            do {
                Node current;
                if (looped.contains(current = (Node)processingQueue.pop())) {
                    return true;
                }
                for (Edge e : current.outgoing) {
                    processingQueue.push(e.to);
                }
            } while (!processingQueue.isEmpty());
        }
        return false;
    }

    void callees(String name, String desc, Set<String> closure) {
        this.collectOutgoings(CallGraph.methodId(name, desc), closure);
    }

    void callers(String name, String desc, Set<String> closure) {
        this.collectIncomings(CallGraph.methodId(name, desc), closure);
    }

    private void collectOutgoings(String methodId, Set<String> closure) {
        for (Node n : this.nodes) {
            if (!n.id.equals(methodId)) continue;
            for (Edge e : n.outgoing) {
                String id = e.to.id;
                if (closure.contains(id)) continue;
                closure.add(id);
                this.collectOutgoings(id, closure);
            }
        }
    }

    private void collectIncomings(String methodId, Set<String> closure) {
        for (Node n : this.nodes) {
            if (!n.id.equals(methodId)) continue;
            for (Edge e : n.incoming) {
                String id = e.from.id;
                if (closure.contains(id)) continue;
                closure.add(id);
                this.collectIncomings(id, closure);
            }
        }
    }

    private Set<Node> findCycles() {
        if (this.nodes.size() < 2) {
            return Collections.emptySet();
        }
        HashMap<String, Object> checkingNodes = new HashMap<String, Object>();
        for (Node n : this.nodes) {
            Edge ee;
            Object newN = (Node)checkingNodes.get(n.id);
            if (newN == null) {
                newN = new Node(n.id);
                checkingNodes.put(n.id, newN);
            }
            for (Edge e : n.incoming) {
                Node fromN = (Node)checkingNodes.get(e.from.id);
                if (fromN == null) {
                    fromN = new Node(e.from.id);
                    checkingNodes.put(e.from.id, fromN);
                }
                ee = new Edge(fromN, (Node)newN);
                ((Node)newN).addIncoming(ee);
                fromN.addOutgoing(ee);
            }
            for (Edge e : n.outgoing) {
                Node toN = (Node)checkingNodes.get(e.to.id);
                if (toN == null) {
                    toN = new Node(e.to.id);
                    checkingNodes.put(e.to.id, toN);
                }
                ee = new Edge((Node)newN, toN);
                ((Node)newN).addOutgoing(ee);
                toN.addIncoming(ee);
            }
        }
        HashSet<Node> sortedNodes = new HashSet<Node>(checkingNodes.values());
        ArrayDeque<Node> terminalNodes = new ArrayDeque<Node>();
        for (Node node : sortedNodes) {
            if ((!node.incoming.isEmpty() || this.startingNodes.contains(node)) && !node.outgoing.isEmpty()) continue;
            terminalNodes.addLast(node);
        }
        while (!terminalNodes.isEmpty()) {
            Node n = (Node)terminalNodes.removeFirst();
            sortedNodes.remove(n);
            for (Edge e : new HashSet(n.incoming)) {
                e.delete();
                if (!e.from.outgoing.isEmpty()) continue;
                terminalNodes.addLast(e.from);
            }
            for (Edge e : new HashSet(n.outgoing)) {
                e.delete();
                if (!e.to.incoming.isEmpty() || this.startingNodes.contains(e.to)) continue;
                terminalNodes.addLast(e.to);
            }
        }
        return sortedNodes;
    }

    public static class Edge {
        private final Node from;
        private final Node to;

        public Edge(Node from, Node to) {
            this.from = from;
            this.to = to;
        }

        public void delete() {
            this.from.removeOutgoing(this);
            this.to.removeIncoming(this);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Edge other = (Edge)obj;
            if (!Objects.equals(this.from, other.from)) {
                return false;
            }
            return Objects.equals(this.to, other.to);
        }

        public int hashCode() {
            int hash = 5;
            hash = 37 * hash + (this.from != null ? this.from.hashCode() : 0);
            hash = 37 * hash + (this.to != null ? this.to.hashCode() : 0);
            return hash;
        }
    }

    public static class Node {
        private final String id;
        private final Set<Edge> incoming = new HashSet<Edge>();
        private final Set<Edge> outgoing = new HashSet<Edge>();

        public Node(String id) {
            this.id = id;
        }

        public void addIncoming(Edge e) {
            this.incoming.add(e);
        }

        public void addOutgoing(Edge e) {
            this.outgoing.add(e);
        }

        public void removeIncoming(Edge e) {
            this.incoming.remove(e);
        }

        public void removeOutgoing(Edge e) {
            this.outgoing.remove(e);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return Objects.equals(this.id, other.id);
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + (this.id != null ? this.id.hashCode() : 0);
            return hash;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Node{id='").append(this.id).append("'}");
            sb.append("\n");
            sb.append("incomming:\n");
            sb.append("=============================\n");
            for (Edge e : this.incoming) {
                sb.append(((Edge)e).from.id).append("\n");
            }
            sb.append("=============================\n");
            sb.append("outgoing:\n");
            for (Edge e : this.outgoing) {
                sb.append(((Edge)e).to.id).append("\n");
            }
            sb.append("=============================\n");
            return sb.toString();
        }
    }
}

