/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openjdk.btrace.core.ArgsMap;
import org.openjdk.btrace.core.BTraceRuntime;
import org.openjdk.btrace.core.DebugSupport;
import org.openjdk.btrace.core.VerifierException;
import org.openjdk.btrace.core.comm.RetransformClassNotification;
import org.openjdk.btrace.instr.BTraceBCPClassLoader;
import org.openjdk.btrace.instr.BTraceClassReader;
import org.openjdk.btrace.instr.BTraceMethodNode;
import org.openjdk.btrace.instr.BTraceProbe;
import org.openjdk.btrace.instr.BTraceProbeFactory;
import org.openjdk.btrace.instr.BTraceProbeSupport;
import org.openjdk.btrace.instr.BTraceTransformer;
import org.openjdk.btrace.instr.CallGraph;
import org.openjdk.btrace.instr.Constants;
import org.openjdk.btrace.instr.InstrumentUtils;
import org.openjdk.btrace.instr.MethodVerifier;
import org.openjdk.btrace.instr.OnMethod;
import org.openjdk.btrace.instr.OnProbe;
import org.openjdk.btrace.instr.Preprocessor;
import org.openjdk.btrace.instr.ProbeDescriptor;
import org.openjdk.btrace.instr.ProbeDescriptorLoader;
import org.openjdk.btrace.instr.Verifier;
import org.openjdk.btrace.libs.org.objectweb.asm.AnnotationVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassReader;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassWriter;
import org.openjdk.btrace.libs.org.objectweb.asm.FieldVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Type;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.ClassNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.MethodNode;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;

public final class BTraceProbeNode
extends ClassNode
implements BTraceProbe {
    private static final Logger log = LoggerFactory.getLogger(BTraceProbeNode.class);
    final BTraceProbeSupport delegate;
    final BTraceProbeFactory factory;
    final DebugSupport debug;
    private final CallGraph graph;
    private final Map<String, BTraceMethodNode> idmap;
    private final Set<String> jfrHandlers = new HashSet<String>();
    private final Preprocessor prep;
    private final BTraceBCPClassLoader bcpResourceClassLoader;
    private volatile BTraceRuntime.Impl rt = null;
    private BTraceTransformer transformer;
    private VerifierException verifierException = null;

    private BTraceProbeNode(BTraceProbeFactory factory) {
        super(589824);
        this.factory = factory;
        this.bcpResourceClassLoader = new BTraceBCPClassLoader(factory.getSettings());
        this.debug = new DebugSupport(factory.getSettings());
        this.delegate = new BTraceProbeSupport();
        this.idmap = new HashMap<String, BTraceMethodNode>();
        this.graph = new CallGraph();
        this.prep = new Preprocessor();
    }

    BTraceProbeNode(BTraceProbeFactory factory, byte[] code) {
        this(factory);
        this.initialize(code);
    }

    BTraceProbeNode(BTraceProbeFactory factory, InputStream code) throws IOException {
        this(factory);
        this.initialize(code);
    }

    @Override
    public boolean isTransforming() {
        return this.delegate.isTransforming();
    }

    @Override
    public void visit(int version, int access, String name, String sig, String superType, String[] itfcs) {
        this.delegate.setClassName(name);
        super.visit(version, access, this.delegate.getClassName(true), sig, superType, itfcs);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] exceptions) {
        super.visitMethod(access, name, desc, sig, exceptions);
        MethodNode mn = (MethodNode)this.methods.remove(this.methods.size() - 1);
        BTraceMethodNode bmn = new BTraceMethodNode(mn, this, this.jfrHandlers.contains(name));
        this.methods.add(bmn);
        this.idmap.put(CallGraph.methodId(name, desc), bmn);
        return this.isTrusted() ? bmn : new MethodVerifier(bmn, access, this.delegate.getOrigName(), name, desc, this.bcpResourceClassLoader);
    }

    @Override
    public FieldVisitor visitField(int access, final String name, final String desc, String signature, Object value) {
        return new FieldVisitor(589824, super.visitField(access, name, desc, signature, value)){

            @Override
            public AnnotationVisitor visitAnnotation(String type, boolean aVisible) {
                AnnotationVisitor av = super.visitAnnotation(type, aVisible);
                if (type.equals(Constants.INJECTED_DESC)) {
                    BTraceProbeNode.this.delegate.addServiceField(name, Type.getType(desc).getInternalName());
                }
                if (type.equals("Lorg/openjdk/btrace/core/annotations/Event;")) {
                    av = new AnnotationVisitor(524288, av){

                        @Override
                        public void visit(String name, Object value) {
                            if (name.equals("handler") && value instanceof String) {
                                BTraceProbeNode.this.jfrHandlers.add((String)value);
                            }
                            super.visit(name, value);
                        }
                    };
                }
                return av;
            }
        };
    }

    @Override
    public Collection<OnMethod> getApplicableHandlers(BTraceClassReader cr) {
        return this.delegate.getApplicableHandlers(cr);
    }

    @Override
    public Iterable<OnMethod> onmethods() {
        return this.delegate.onmethods();
    }

    public Collection<OnMethod> getOnMethods() {
        return this.delegate.getOnMethods();
    }

    @Override
    public Iterable<OnProbe> onprobes() {
        return this.delegate.onprobes();
    }

    @Override
    public String getClassName() {
        return this.getClassName(false);
    }

    @Override
    public String getClassName(boolean internal) {
        return this.delegate.getClassName(internal);
    }

    String translateOwner(String owner) {
        return this.delegate.translateOwner(owner);
    }

    @Override
    public Class<?> register(BTraceRuntime.Impl rt, BTraceTransformer t) {
        byte[] code = this.getBytecode(true);
        if (this.debug.isDumpClasses()) {
            this.debug.dumpClass(this.name + "_bcp", code);
        }
        Class<?> clz = this.delegate.defineClass(rt, code);
        t.register(this);
        this.transformer = t;
        this.rt = rt;
        return clz;
    }

    @Override
    public void unregister() {
        if (this.transformer != null && this.isTransforming()) {
            if (log.isDebugEnabled()) {
                log.debug("onExit: removing transformer for {}", (Object)this.getClassName());
            }
            this.transformer.unregister(this);
        }
        this.rt = null;
    }

    @Override
    public byte[] getFullBytecode() {
        return this.getBytecode(false);
    }

    @Override
    public byte[] getDataHolderBytecode() {
        return this.getBytecode(true);
    }

    @Override
    public BTraceRuntime.Impl getRuntime() {
        return this.rt;
    }

    private byte[] getBytecode(boolean onlyBcpMethods) {
        ClassWriter cw;
        ClassVisitor cv = cw = InstrumentUtils.newClassWriter(true);
        if (onlyBcpMethods) {
            cv = new ClassVisitor(589824, cw){

                @Override
                public MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] exceptions) {
                    if (name.startsWith("<")) {
                        return super.visitMethod(access, name, desc, sig, exceptions);
                    }
                    BTraceMethodNode bmn = (BTraceMethodNode)BTraceProbeNode.this.idmap.get(CallGraph.methodId(name, desc));
                    if (bmn != null) {
                        if (bmn.isBcpRequired()) {
                            return super.visitMethod(access, name, desc, sig, exceptions);
                        }
                        for (BTraceMethodNode c : bmn.getCallers()) {
                            if (!c.isBcpRequired()) continue;
                            return super.visitMethod(access, name, desc, sig, exceptions);
                        }
                        return null;
                    }
                    return super.visitMethod(access, name, desc, sig, exceptions);
                }
            };
        }
        this.accept(cv);
        return cw.toByteArray();
    }

    Set<BTraceMethodNode> callees(String name, String desc) {
        HashSet<String> closure = new HashSet<String>();
        this.graph.callees(name, desc, closure);
        return this.fromIdSet(closure);
    }

    Set<BTraceMethodNode> callers(String name, String desc) {
        HashSet<String> closure = new HashSet<String>();
        this.graph.callers(name, desc, closure);
        return this.fromIdSet(closure);
    }

    @Override
    public boolean willInstrument(Class<?> clz) {
        return this.delegate.willInstrument(clz);
    }

    @Override
    public boolean isClassRenamed() {
        return this.delegate.isClassRenamed();
    }

    @Override
    public boolean isVerified() {
        return this.verifierException == null;
    }

    private VerifierException getVerifierException() {
        return this.verifierException;
    }

    boolean isFieldInjected(String name) {
        return this.delegate.isFieldInjected(name);
    }

    void addOnMethod(OnMethod om) {
        this.delegate.addOnMethod(om);
    }

    void addOnProbe(OnProbe op) {
        this.delegate.addOnProbe(op);
    }

    void setTrusted() {
        this.delegate.setTrusted();
    }

    boolean isTrusted() {
        return this.delegate.isTrusted();
    }

    CallGraph getGraph() {
        return this.graph;
    }

    @Override
    public void notifyTransform(String className) {
        if (this.rt != null && this.factory.getSettings().isTrackRetransforms()) {
            this.rt.send(new RetransformClassNotification(className.replace('/', '.')));
        }
    }

    @Override
    public void checkVerified() {
        if (!this.isVerified()) {
            throw this.getVerifierException();
        }
    }

    @Override
    public void copyHandlers(ClassVisitor copyingVisitor) {
        TreeSet<MethodNode> copyNodes = new TreeSet<MethodNode>(BTraceMethodNode.COMPARATOR);
        for (OnMethod om : this.onmethods()) {
            if (!om.isCalled()) continue;
            BTraceMethodNode bmn = om.getMethodNode();
            MethodNode mn = this.copy(bmn);
            copyNodes.add(mn);
            for (BTraceMethodNode c : bmn.getCallees()) {
                copyNodes.add(this.copy(c));
            }
        }
        copyingVisitor.visit(51, 17, this.getClassName(true), null, "java/lang/Object", null);
        for (MethodNode mn : copyNodes) {
            mn.accept(copyingVisitor);
        }
        copyingVisitor.visitEnd();
    }

    @Override
    public void applyArgs(ArgsMap argsMap) {
        this.delegate.applyArgs(argsMap);
    }

    private void mapOnProbes() {
        ProbeDescriptorLoader pdl = this.getProbeDescriptorLoader();
        for (OnProbe op : this.delegate.onprobes()) {
            ProbeDescriptor probeDesc;
            String ns = op.getNamespace();
            if (log.isDebugEnabled()) {
                log.debug("about to load probe descriptor for namespace {}", (Object)ns);
            }
            if ((probeDesc = pdl.load(ns)) == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug("failed to find probe descriptor for namespace {}", (Object)ns);
                continue;
            }
            OnProbe foundProbe = probeDesc.findProbe(op.getName());
            if (foundProbe == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug("no probe mappings for {}", (Object)op.getName());
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("found probe mappings for {}", (Object)op.getName());
            }
            Collection<OnMethod> omColl = foundProbe.getOnMethods();
            for (OnMethod om : omColl) {
                OnMethod omn = new OnMethod(op.getMethodNode());
                omn.copyFrom(om);
                omn.setTargetName(op.getTargetName());
                omn.setTargetDescriptor(op.getTargetDescriptor());
                omn.setClassNameParameter(op.getClassNameParameter());
                omn.setMethodParameter(op.getMethodParameter());
                omn.setDurationParameter(op.getDurationParameter());
                omn.setMethodFqn(op.isMethodFqn());
                omn.setReturnParameter(op.getReturnParameter());
                omn.setSelfParameter(op.getSelfParameter());
                omn.setTargetInstanceParameter(op.getTargetInstanceParameter());
                omn.setTargetMethodOrFieldFqn(op.isTargetMethodOrFieldFqn());
                omn.setTargetMethodOrFieldParameter(op.getTargetMethodOrFieldParameter());
                this.addOnMethod(omn);
            }
        }
    }

    private ProbeDescriptorLoader getProbeDescriptorLoader() {
        String path = this.factory.getSettings().getProbeDescPath();
        return new ProbeDescriptorLoader(path);
    }

    private void initialize(byte[] code) {
        ClassReader cr = new ClassReader(code);
        if (this.debug.isDumpClasses()) {
            this.debug.dumpClass(cr.getClassName() + "_orig", code);
        }
        this.initialize(cr);
    }

    private void initialize(InputStream code) throws IOException {
        this.initialize(this.readFully(code));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(ClassReader cr) {
        try {
            Verifier v = new Verifier(this, this.factory.getSettings().isTrusted());
            log.debug("verifying BTrace class ...");
            cr.accept(v, 2);
            if (log.isDebugEnabled()) {
                String clzName = this.getClassName();
                log.debug("BTrace class {} verified", (Object)clzName);
                log.debug("preprocessing BTrace class {} ...", (Object)clzName);
            }
            this.prep.process(this);
            log.debug("... preprocessed");
            try {
                Class.forName("javax.xml.bind.JAXBException");
                this.mapOnProbes();
            }
            catch (ClassNotFoundException e) {
                log.debug("XML bindings are missing. @OnProbe support is disabled.");
            }
        }
        catch (VerifierException e) {
            this.verifierException = e;
        }
        finally {
            if (this.debug.isDumpClasses()) {
                this.debug.dumpClass(this.name, this.getBytecode(false));
            }
        }
    }

    private Set<BTraceMethodNode> fromIdSet(Set<String> ids) {
        HashSet<BTraceMethodNode> methods = new HashSet<BTraceMethodNode>();
        for (String id : ids) {
            BTraceMethodNode mn = this.idmap.get(id);
            if (mn == null) continue;
            methods.add(mn);
        }
        return methods;
    }

    private MethodNode copy(MethodNode n) {
        String[] exceptions = n.exceptions != null ? n.exceptions.toArray(new String[0]) : null;
        MethodNode mn = new MethodNode(589824, n.access, n.name, n.desc, n.signature, exceptions);
        n.accept(mn);
        mn.access = 10;
        mn.desc = mn.desc.replace("Lorg/openjdk/btrace/core/types/AnyType;", "Ljava/lang/Object;");
        mn.signature = mn.signature != null ? mn.signature.replace("Lorg/openjdk/btrace/core/types/AnyType;", "Ljava/lang/Object;") : null;
        mn.name = InstrumentUtils.getActionPrefix(this.getClassName(true)) + mn.name;
        return mn;
    }

    private byte[] readFully(InputStream is) throws IOException {
        int bufSize = 512;
        int pos = 0;
        byte[] finArr = new byte[1024];
        byte[] buff = new byte[bufSize];
        int read = 0;
        while ((read = is.read(buff, 0, bufSize)) > 0) {
            int newpos = pos + read;
            if (newpos >= finArr.length) {
                finArr = Arrays.copyOf(finArr, finArr.length * 2);
            }
            System.arraycopy(buff, 0, finArr, pos, read);
            pos = newpos;
        }
        return Arrays.copyOfRange(finArr, 0, pos);
    }

    public String toString() {
        return "BTraceProbe{delegate=" + this.delegate + '}';
    }
}

