/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.util.Comparator;
import java.util.Set;
import org.openjdk.btrace.core.annotations.Kind;
import org.openjdk.btrace.core.annotations.Sampled;
import org.openjdk.btrace.core.annotations.Where;
import org.openjdk.btrace.instr.BTraceProbeNode;
import org.openjdk.btrace.instr.CallGraph;
import org.openjdk.btrace.instr.Constants;
import org.openjdk.btrace.instr.Level;
import org.openjdk.btrace.instr.Location;
import org.openjdk.btrace.instr.OnMethod;
import org.openjdk.btrace.instr.OnProbe;
import org.openjdk.btrace.instr.SpecialParameterHolder;
import org.openjdk.btrace.instr.Verifier;
import org.openjdk.btrace.libs.org.objectweb.asm.AnnotationVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.MethodNode;

public class BTraceMethodNode
extends MethodNode {
    public static final Comparator<MethodNode> COMPARATOR = (o1, o2) -> (o1.name + "#" + o1.desc).compareTo(o2.name + "#" + o2.desc);
    private final BTraceProbeNode cn;
    private final CallGraph graph;
    private final String methodId;
    private OnMethod om;
    private OnProbe op;
    private Location loc;
    private boolean sampled;
    private boolean isBTraceHandler;

    BTraceMethodNode(MethodNode from, BTraceProbeNode cn) {
        this(from, cn, false);
    }

    BTraceMethodNode(MethodNode from, BTraceProbeNode cn, boolean initBTraceHandler) {
        super(589824, from.access, from.name, from.desc, from.signature, from.exceptions.toArray(new String[0]));
        this.cn = cn;
        this.graph = cn.getGraph();
        this.methodId = CallGraph.methodId(this.name, this.desc);
        this.isBTraceHandler = initBTraceHandler;
    }

    @Override
    public void visitEnd() {
        if (this.om != null) {
            this.verifySpecialParameters(this.om);
            this.cn.addOnMethod(this.om);
        }
        if (this.op != null) {
            this.cn.addOnProbe(this.op);
        }
        if (this.isBTraceHandler) {
            this.graph.addStarting(new CallGraph.Node(this.methodId));
        }
        super.visitEnd();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String type, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(type, visible);
        if (type.startsWith("Lorg/openjdk/btrace/core/annotations/")) {
            this.isBTraceHandler = true;
        }
        if (type.equals(Constants.ONMETHOD_DESC)) {
            this.om = new OnMethod(this);
            this.om.setTargetName(this.name);
            this.om.setTargetDescriptor(this.desc);
            return new AnnotationVisitor(589824, av){

                @Override
                public void visit(String name, Object value) {
                    super.visit(name, value);
                    switch (name) {
                        case "clazz": {
                            BTraceMethodNode.this.om.setClazz((String)value);
                            break;
                        }
                        case "method": {
                            BTraceMethodNode.this.om.setMethod((String)value);
                            break;
                        }
                        case "type": {
                            BTraceMethodNode.this.om.setType((String)value);
                            break;
                        }
                        case "exactTypeMatch": {
                            BTraceMethodNode.this.om.setExactTypeMatch((Boolean)value);
                            break;
                        }
                        default: {
                            System.err.println("btrace WARNING: Unsupported @OnMethod attribute: " + name);
                        }
                    }
                }

                @Override
                public AnnotationVisitor visitAnnotation(String name, String desc) {
                    AnnotationVisitor av1 = super.visitAnnotation(name, desc);
                    if (desc.equals(Constants.LOCATION_DESC)) {
                        BTraceMethodNode.this.loc = new Location();
                        return new AnnotationVisitor(589824, av1){

                            @Override
                            public void visitEnum(String name, String desc, String value) {
                                super.visitEnum(name, desc, value);
                                if (desc.equals(Constants.WHERE_DESC)) {
                                    BTraceMethodNode.this.loc.setWhere(Enum.valueOf(Where.class, value));
                                } else if (desc.equals(Constants.KIND_DESC)) {
                                    BTraceMethodNode.this.loc.setValue(Enum.valueOf(Kind.class, value));
                                }
                            }

                            @Override
                            public void visit(String name, Object value) {
                                super.visit(name, value);
                                switch (name) {
                                    case "clazz": {
                                        BTraceMethodNode.this.loc.setClazz((String)value);
                                        break;
                                    }
                                    case "method": {
                                        BTraceMethodNode.this.loc.setMethod((String)value);
                                        break;
                                    }
                                    case "type": {
                                        BTraceMethodNode.this.loc.setType((String)value);
                                        break;
                                    }
                                    case "field": {
                                        BTraceMethodNode.this.loc.setField((String)value);
                                        break;
                                    }
                                    case "line": {
                                        BTraceMethodNode.this.loc.setLine(((Number)value).intValue());
                                    }
                                }
                            }

                            @Override
                            public void visitEnd() {
                                if (BTraceMethodNode.this.loc != null) {
                                    BTraceMethodNode.this.om.setLocation(BTraceMethodNode.this.loc);
                                }
                                super.visitEnd();
                            }
                        };
                    }
                    if (desc.equals(Constants.LEVEL_DESC)) {
                        return new AnnotationVisitor(589824, av1){

                            @Override
                            public void visit(String name, Object value) {
                                super.visit(name, value);
                                if ("value".equals(name)) {
                                    BTraceMethodNode.this.om.setLevel(Level.fromString((String)value));
                                }
                            }
                        };
                    }
                    return av1;
                }
            };
        }
        if (type.equals(Constants.ONPROBE_DESC)) {
            this.op = new OnProbe(this);
            this.op.setTargetName(this.name);
            this.op.setTargetDescriptor(this.desc);
            return new AnnotationVisitor(589824, av){

                @Override
                public void visit(String name, Object value) {
                    super.visit(name, value);
                    switch (name) {
                        case "namespace": {
                            BTraceMethodNode.this.op.setNamespace((String)value);
                            break;
                        }
                        case "name": {
                            BTraceMethodNode.this.op.setName((String)value);
                        }
                    }
                }
            };
        }
        if (type.equals(Constants.SAMPLED_DESC)) {
            if (this.om != null) {
                this.om.setSamplerKind(Sampled.Sampler.Adaptive);
                return new AnnotationVisitor(589824, av){
                    private boolean meanSet;
                    {
                        this.meanSet = false;
                    }

                    @Override
                    public void visit(String name, Object value) {
                        super.visit(name, value);
                        if (name.equals("mean")) {
                            BTraceMethodNode.this.om.setSamplerMean((Integer)value);
                            this.meanSet = true;
                        }
                    }

                    @Override
                    public void visitEnum(String name, String desc, String value) {
                        super.visitEnum(name, desc, value);
                        if (name.equals("kind") && desc.equals(Constants.SAMPLER_DESC)) {
                            BTraceMethodNode.this.om.setSamplerKind(Sampled.Sampler.valueOf(value));
                        }
                    }

                    @Override
                    public void visitEnd() {
                        if (!this.meanSet) {
                            if (BTraceMethodNode.this.om.getSamplerKind() == Sampled.Sampler.Adaptive) {
                                BTraceMethodNode.this.om.setSamplerMean(500);
                            } else if (BTraceMethodNode.this.om.getSamplerKind() == Sampled.Sampler.Const) {
                                BTraceMethodNode.this.om.setSamplerMean(10);
                            }
                        }
                        if (BTraceMethodNode.this.om.getSamplerKind() == Sampled.Sampler.Adaptive && BTraceMethodNode.this.om.getSamplerMean() < 180) {
                            System.err.println("Setting the adaptive sampler time windows to the default of 180ns");
                            BTraceMethodNode.this.om.setSamplerMean(180);
                        }
                        super.visitEnd();
                    }
                };
            }
            this.sampled = true;
        }
        return av;
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        AnnotationVisitor av = super.visitParameterAnnotation(parameter, desc, visible);
        if (this.om != null) {
            av = this.setSpecialParameters(this.om, desc, parameter, av);
        } else if (this.op != null) {
            av = this.setSpecialParameters(this.op, desc, parameter, av);
        }
        return av;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        owner = this.cn.translateOwner(owner);
        if (opcode == 184) {
            this.graph.addEdge(this.methodId, CallGraph.methodId(name, desc));
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, this.cn.translateOwner(owner), name, desc);
    }

    public boolean isBcpRequired() {
        return this.isBTraceHandler && this.om == null && this.op == null;
    }

    public boolean isBTraceHandler() {
        return this.isBTraceHandler;
    }

    public OnMethod getOnMethod() {
        return this.om;
    }

    public boolean isSampled() {
        return this.sampled;
    }

    public Set<BTraceMethodNode> getCallees() {
        return this.cn.callees(this.name, this.desc);
    }

    public Set<BTraceMethodNode> getCallers() {
        return this.cn.callers(this.name, this.desc);
    }

    boolean isFieldInjected(String name) {
        return this.cn.isFieldInjected(name);
    }

    OnProbe getOnProbe() {
        return this.op;
    }

    private AnnotationVisitor setSpecialParameters(final SpecialParameterHolder ph, String desc, int parameter, AnnotationVisitor av) {
        if (desc.equals(Constants.SELF_DESC)) {
            ph.setSelfParameter(parameter);
        } else if (desc.equals(Constants.BTRACE_PROBECLASSNAME_DESC)) {
            ph.setClassNameParameter(parameter);
        } else if (desc.equals(Constants.BTRACE_PROBEMETHODNAME_DESC)) {
            ph.setMethodParameter(parameter);
            av = new AnnotationVisitor(589824, av){

                @Override
                public void visit(String name, Object val) {
                    if (name.equals("fqn")) {
                        ph.setMethodFqn((Boolean)val);
                    }
                    super.visit(name, val);
                }
            };
        } else if (desc.equals(Constants.RETURN_DESC)) {
            ph.setReturnParameter(parameter);
        } else if (desc.equals(Constants.TARGETMETHOD_DESC)) {
            ph.setTargetMethodOrFieldParameter(parameter);
            av = new AnnotationVisitor(589824, av){

                @Override
                public void visit(String name, Object val) {
                    if (name.equals("fqn")) {
                        ph.setTargetMethodOrFieldFqn((Boolean)val);
                    }
                    super.visit(name, val);
                }
            };
        } else if (desc.equals(Constants.TARGETINSTANCE_DESC)) {
            ph.setTargetInstanceParameter(parameter);
        } else if (desc.equals(Constants.DURATION_DESC)) {
            ph.setDurationParameter(parameter);
        }
        return av;
    }

    private void verifySpecialParameters(OnMethod om) {
        Location loc = om.getLocation();
        if (!(om.getReturnParameter() == -1 || loc.getValue() == Kind.RETURN || loc.getValue() == Kind.CALL && loc.getWhere() == Where.AFTER || loc.getValue() == Kind.ARRAY_GET && loc.getWhere() == Where.AFTER || loc.getValue() == Kind.FIELD_GET && loc.getWhere() == Where.AFTER || loc.getValue() == Kind.NEW && loc.getWhere() == Where.AFTER || loc.getValue() == Kind.NEWARRAY && loc.getWhere() == Where.AFTER)) {
            Verifier.reportError("return.desc.invalid", om.getTargetName() + om.getTargetDescriptor() + "(" + om.getReturnParameter() + ")");
        }
        if (om.getTargetMethodOrFieldParameter() != -1 && loc.getValue() != Kind.CALL && loc.getValue() != Kind.FIELD_GET && loc.getValue() != Kind.FIELD_SET && loc.getValue() != Kind.ARRAY_GET && loc.getValue() != Kind.ARRAY_SET) {
            Verifier.reportError("target-method.desc.invalid", om.getTargetName() + om.getTargetDescriptor() + "(" + om.getTargetMethodOrFieldParameter() + ")");
        }
        if (om.getTargetInstanceParameter() != -1 && loc.getValue() != Kind.CALL && loc.getValue() != Kind.FIELD_GET && loc.getValue() != Kind.FIELD_SET && loc.getValue() != Kind.ARRAY_GET && loc.getValue() != Kind.ARRAY_SET && loc.getValue() != Kind.INSTANCEOF && loc.getValue() != Kind.CHECKCAST && loc.getValue() != Kind.ERROR && loc.getValue() != Kind.THROW && loc.getValue() != Kind.CATCH && loc.getValue() != Kind.SYNC_ENTRY && loc.getValue() != Kind.SYNC_EXIT) {
            Verifier.reportError("target-instance.desc.invalid", om.getTargetName() + om.getTargetDescriptor() + "(" + om.getTargetInstanceParameter() + ")");
        }
        if (om.getDurationParameter() != -1 && loc.getValue() != Kind.RETURN && loc.getValue() != Kind.ERROR && (loc.getValue() != Kind.CALL || loc.getWhere() != Where.AFTER)) {
            Verifier.reportError("duration.desc.invalid", om.getTargetName() + om.getTargetDescriptor() + "(" + om.getDurationParameter() + ")");
        }
    }

    public String toString() {
        return "BTraceMethodNode{name = " + this.name + ", desc=" + this.desc + '}';
    }
}

