/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core.comm;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.openjdk.btrace.core.comm.DataCommand;

public class NumberMapDataCommand
extends DataCommand {
    private Map<String, ? extends Number> data;

    public NumberMapDataCommand() {
        this(null, null);
    }

    public NumberMapDataCommand(String name, Map<String, ? extends Number> data) {
        super((byte)7, name, false);
        this.data = data != null ? new HashMap<String, Number>(data) : null;
    }

    public Map<String, ? extends Number> getData() {
        return this.data;
    }

    @Override
    public void print(PrintWriter out) {
        if (this.name != null && !this.name.isEmpty()) {
            out.println(this.name);
        }
        if (this.data != null) {
            for (Map.Entry<String, ? extends Number> e : this.data.entrySet()) {
                out.print(e.getKey());
                out.print(" = ");
                out.println(e.getValue());
            }
        }
    }

    @Override
    protected void write(ObjectOutput out) throws IOException {
        out.writeUTF(this.name != null ? this.name : "");
        if (this.data != null) {
            out.writeInt(this.data.size());
            for (String key : this.data.keySet()) {
                out.writeUTF(key);
                out.writeObject(this.data.get(key));
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    protected void read(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        HashMap<String, ? extends Number> map = new HashMap<String, Number>();
        int sz = in.readInt();
        for (int i = 0; i < sz; ++i) {
            map.put(in.readUTF(), (Number)in.readObject());
        }
        this.data = map;
    }
}

