/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core.aggregation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class AggregationKey {
    private static final Set<Class<?>> validKeyElementTypes = new HashSet();
    private final Object[] elements;

    public AggregationKey(Object[] elements) {
        for (Object element : elements) {
            if (element == null || element.getClass() == String.class || element.getClass() == Boolean.class || element.getClass() == Byte.class || element.getClass() == Character.class || element.getClass() == Short.class || element.getClass() == Integer.class || element.getClass() == Long.class) continue;
            throw new IllegalArgumentException("Aggregation key element type '" + element.getClass().getName() + "' is not supported");
        }
        this.elements = elements;
    }

    public Object[] getElements() {
        return this.elements;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this.elements);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggregationKey other = (AggregationKey)obj;
        return Arrays.equals(this.elements, other.elements);
    }

    static {
        validKeyElementTypes.add(String.class);
        validKeyElementTypes.add(Boolean.class);
        validKeyElementTypes.add(Byte.class);
        validKeyElementTypes.add(Character.class);
        validKeyElementTypes.add(Short.class);
        validKeyElementTypes.add(Integer.class);
        validKeyElementTypes.add(Long.class);
    }
}

