/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core;

import java.io.Serializable;
import java.lang.management.MemoryUsage;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.openjdk.btrace.core.BTraceRuntime;
import org.openjdk.btrace.core.Profiler;
import org.openjdk.btrace.core.aggregation.Aggregation;
import org.openjdk.btrace.core.aggregation.AggregationFunction;
import org.openjdk.btrace.core.aggregation.AggregationKey;
import org.openjdk.btrace.core.jfr.JfrEvent;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;

public class BTraceUtils {
    private static final Logger log = LoggerFactory.getLogger(BTraceUtils.class);
    private static final int STACK_DEC = 2;

    private BTraceUtils() {
    }

    public static boolean isInteruppted() {
        return Threads.isInteruppted();
    }

    public static void jstack() {
        Threads.jstack(2, -1);
    }

    public static void jstack(int numFrames) {
        Threads.jstack(2, numFrames);
    }

    public static void jstackAll() {
        Threads.jstackAll(2, -1);
    }

    public static void jstackAll(int numFrames) {
        Threads.jstackAll(2, numFrames);
    }

    public static String jstackStr() {
        return Threads.jstackStr(2, -1);
    }

    public static String jstackStr(int numFrames) {
        return Threads.jstackStr(2, numFrames);
    }

    public static String jstackAllStr() {
        return Threads.jstackAllStr();
    }

    public static String jstackAllStr(int numFrames) {
        return Threads.jstackAllStr(numFrames);
    }

    public static void jstack(Throwable exception) {
        Threads.jstack(exception);
    }

    public static void jstack(Throwable exception, int numFrames) {
        Threads.jstack(exception, numFrames);
    }

    public static String jstackStr(Throwable exception) {
        return Threads.jstackStr(exception);
    }

    public static String jstackStr(Throwable exception, int numFrames) {
        return Threads.jstackStr(exception, numFrames);
    }

    public static Thread currentThread() {
        return Threads.currentThread();
    }

    public static long threadId(Thread thread) {
        return Threads.threadId(thread);
    }

    public static Thread.State threadState(Thread thread) {
        return Threads.threadState(thread);
    }

    public static boolean holdsLock(Object obj) {
        return Threads.holdsLock(obj);
    }

    public static void deadlocks() {
        Threads.deadlocks();
    }

    public static void deadlocks(boolean stackTrace) {
        Threads.deadlocks(stackTrace);
    }

    public static String name(Thread thread) {
        return Threads.name(thread);
    }

    public static ClassLoader loader(Class<?> clazz) {
        return clazz.getClassLoader();
    }

    public static ClassLoader parentLoader(ClassLoader loader) {
        return loader.getParent();
    }

    public static String str(Object obj) {
        return Strings.str(obj);
    }

    public static String identityStr(Object obj) {
        int hashCode = System.identityHashCode(obj);
        return obj.getClass().getName() + "@" + Integer.toHexString(hashCode);
    }

    public static int hash(Object obj) {
        if (obj.getClass().getClassLoader() == null) {
            return obj.hashCode();
        }
        return System.identityHashCode(obj);
    }

    public static int identityHashCode(Object obj) {
        return System.identityHashCode(obj);
    }

    public static boolean compare(Object obj1, Object obj2) {
        return BTraceRuntime.compare(obj1, obj2);
    }

    public static Class<?> classOf(Object obj) {
        return Reflective.classOf(obj);
    }

    public static boolean instanceOf(Object obj, String className) {
        return BTraceRuntime.instanceOf(obj, className);
    }

    public static Class<?> declaringClass(Field field) {
        return Reflective.declaringClass(field);
    }

    public static String name(Class<?> clazz) {
        return Reflective.name(clazz);
    }

    public static String name(Field field) {
        return Reflective.name(field);
    }

    public static Class<?> type(Field field) {
        return Reflective.type(field);
    }

    public static int accessFlags(Class<?> clazz) {
        return Reflective.accessFlags(clazz);
    }

    public static int accessFlags(Field field) {
        return Reflective.accessFlags(field);
    }

    public static ClassLoader contextClassLoader() {
        return Reflective.contextClassLoader();
    }

    public static Class classForName(String name) {
        return Reflective.classForName(name);
    }

    public static Class classForName(String name, ClassLoader cl) {
        return Reflective.classForName(name, cl);
    }

    public static boolean isAssignableFrom(Class<?> a, Class<?> b) {
        return Reflective.isAssignableFrom(a, b);
    }

    public static boolean isInstance(Class<?> clazz, Object obj) {
        return Reflective.isInstance(clazz, obj);
    }

    public static Class<?> getSuperclass(Class<?> clazz) {
        return Reflective.getSuperclass(clazz);
    }

    public static boolean isInterface(Class<?> clazz) {
        return Reflective.isInterface(clazz);
    }

    public static boolean isArray(Class<?> clazz) {
        return Reflective.isArray(clazz);
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return Reflective.isPrimitive(clazz);
    }

    public static Class<?> getComponentType(Class<?> clazz) {
        return Reflective.getComponentType(clazz);
    }

    public static Field field(Class<?> clazz, String name, boolean throwException) {
        return Reflective.field(clazz, name, throwException);
    }

    public static Field field(Class<?> clazz, String name) {
        return Reflective.field(clazz, name);
    }

    public static Field field(String clazz, String name, boolean throwException) {
        ClassLoader callerLoader = BTraceRuntime.getCallerClassloader(2);
        return Reflective.field(BTraceUtils.classForName(clazz, callerLoader), name, throwException);
    }

    public static Field field(String clazz, String name) {
        ClassLoader callerLoader = BTraceRuntime.getCallerClassloader(2);
        return Reflective.field(BTraceUtils.classForName(clazz, callerLoader), name);
    }

    public static byte getByte(Field field) {
        return Reflective.getByte(field);
    }

    public static byte getByte(Field field, Object obj) {
        return Reflective.getByte(field, obj);
    }

    public static short getShort(Field field) {
        return Reflective.getShort(field);
    }

    public static short getShort(Field field, Object obj) {
        return Reflective.getShort(field, obj);
    }

    public static int getInt(Field field) {
        return Reflective.getInt(field);
    }

    public static int getInt(Field field, Object obj) {
        return Reflective.getInt(field, obj);
    }

    public static long getLong(Field field) {
        return Reflective.getLong(field);
    }

    public static long getLong(Field field, Object obj) {
        return Reflective.getLong(field, obj);
    }

    public static float getFloat(Field field) {
        return Reflective.getFloat(field);
    }

    public static float getFloat(Field field, Object obj) {
        return Reflective.getFloat(field, obj);
    }

    public static double getDouble(Field field) {
        return Reflective.getDouble(field);
    }

    public static double getDouble(Field field, Object obj) {
        return Reflective.getDouble(field, obj);
    }

    public static boolean getBoolean(Field field) {
        return Reflective.getBoolean(field);
    }

    public static boolean getBoolean(Field field, Object obj) {
        return Reflective.getBoolean(field, obj);
    }

    public static char getChar(Field field) {
        return Reflective.getChar(field);
    }

    public static char getChar(Field field, Object obj) {
        return Reflective.getChar(field, obj);
    }

    public static Object get(Field field) {
        return Reflective.get(field);
    }

    public static Object get(Field field, Object obj) {
        return Reflective.get(field, obj);
    }

    public static WeakReference weakRef(Object obj) {
        return References.weakRef(obj);
    }

    public static SoftReference softRef(Object obj) {
        return References.softRef(obj);
    }

    public static Object deref(Reference ref) {
        return References.deref(ref);
    }

    @Deprecated
    public static Class<?> probeClass() {
        return BTraceRuntime.getCallerClass(2);
    }

    @Deprecated
    public static String probeMethod() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length >= 4) {
            return stack[3].getMethodName();
        }
        return null;
    }

    public static int probeLine() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length >= 4) {
            return stack[3].getLineNumber();
        }
        return -1;
    }

    public static void printMap(Map map) {
        BTraceRuntime.printMap(map);
    }

    public static void printStringMap(String name, Map<String, String> data) {
        BTraceRuntime.printStringMap(name, data);
    }

    public static void printNumberMap(String name, Map<String, ? extends Number> data) {
        BTraceRuntime.printNumberMap(name, data);
    }

    public static void printNumber(String name, Number value) {
        BTraceRuntime.printNumber(name, value);
    }

    public static void printArray(Object[] array) {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (Object obj : array) {
            buf.append(Strings.str(obj));
            buf.append(", ");
        }
        buf.append(']');
        BTraceUtils.println(buf.toString());
    }

    public static void printFields(Object obj) {
        Reflective.printFields(obj, false);
    }

    public static void printFields(Object obj, boolean classNamePrefix) {
        Reflective.printFields(obj, classNamePrefix);
    }

    public static void printStaticFields(Class<?> clazz) {
        Reflective.printStaticFields(clazz, false);
    }

    public static void printStaticFields(Class<?> clazz, boolean classNamePrefix) {
        Reflective.printStaticFields(clazz, classNamePrefix);
    }

    public static void print(Object obj) {
        BTraceRuntime.print(Strings.str(obj));
    }

    public static void print(boolean b) {
        BTraceUtils.print((Object)b);
    }

    public static void print(char c) {
        BTraceUtils.print(Character.valueOf(c));
    }

    public static void print(int i) {
        BTraceUtils.print((Object)i);
    }

    public static void print(long l) {
        BTraceUtils.print((Object)l);
    }

    public static void print(float f) {
        BTraceUtils.print(Float.valueOf(f));
    }

    public static void print(double d) {
        BTraceUtils.print((Object)d);
    }

    public static void println(Object obj) {
        BTraceRuntime.println(Strings.str(obj));
    }

    public static void println(boolean b) {
        BTraceUtils.println((Object)b);
    }

    public static void println(char c) {
        BTraceUtils.println(Character.valueOf(c));
    }

    public static void println(int i) {
        BTraceUtils.println((Object)i);
    }

    public static void println(long l) {
        BTraceUtils.println((Object)l);
    }

    public static void println(float f) {
        BTraceUtils.println(Float.valueOf(f));
    }

    public static void println(double d) {
        BTraceUtils.println((Object)d);
    }

    public static void println() {
        BTraceRuntime.println();
    }

    public static long vmStartTime() {
        return Sys.VM.vmStartTime();
    }

    public static long vmUptime() {
        return Sys.VM.vmUptime();
    }

    public static long timeMillis() {
        return Time.millis();
    }

    public static long timeNanos() {
        return Time.nanos();
    }

    public static String timestamp(String format) {
        return Time.timestamp(format);
    }

    public static String timestamp() {
        return Time.timestamp();
    }

    public static boolean startsWith(String s2, String start) {
        return Strings.startsWith(s2, start);
    }

    public static boolean endsWith(String s2, String end) {
        return Strings.endsWith(s2, end);
    }

    public static String strcat(String str1, String str2) {
        return Strings.strcat(str1, str2);
    }

    public static String concat(String str1, String str2) {
        return Strings.concat(str1, str2);
    }

    public static int compareTo(String str1, String str2) {
        return Strings.compareTo(str1, str2);
    }

    public static int strcmp(String str1, String str2) {
        return Strings.strcmp(str1, str2);
    }

    public static int compareToIgnoreCase(String str1, String str2) {
        return Strings.compareToIgnoreCase(str1, str2);
    }

    public static int stricmp(String str1, String str2) {
        return Strings.stricmp(str1, str2);
    }

    public static int strstr(String str1, String str2) {
        return Strings.strstr(str1, str2);
    }

    public static int indexOf(String str1, String str2) {
        return Strings.indexOf(str1, str2);
    }

    public static int lastIndexOf(String str1, String str2) {
        return Strings.lastIndexOf(str1, str2);
    }

    public static String substr(String str, int start, int length) {
        return Strings.substr(str, start, length);
    }

    public static String substr(String str, int start) {
        return Strings.substr(str, start);
    }

    public static int length(String str) {
        return Strings.length(str);
    }

    public static int strlen(String str) {
        return Strings.strlen(str);
    }

    public static Pattern regexp(String regex) {
        return Strings.regexp(regex);
    }

    public static Pattern pattern(String regex) {
        return Strings.pattern(regex);
    }

    public static Pattern regexp(String regex, int flags) {
        return Strings.regexp(regex, flags);
    }

    public static Pattern pattern(String regex, int flags) {
        return Strings.pattern(regex, flags);
    }

    public static boolean matches(Pattern regex, String input) {
        return Strings.matches(regex, input);
    }

    public static boolean matches(String regex, String input) {
        return Strings.matches(regex, input);
    }

    public static double random() {
        return Numbers.random();
    }

    public static strictfp double log(double a) {
        return Numbers.log(a);
    }

    public static strictfp double log10(double a) {
        return Numbers.log10(a);
    }

    public static strictfp double exp(double a) {
        return Numbers.exp(a);
    }

    public static boolean isNaN(double d) {
        return Numbers.isNaN(d);
    }

    public static boolean isNaN(float f) {
        return Numbers.isNaN(f);
    }

    public static boolean isInfinite(double d) {
        return Numbers.isInfinite(d);
    }

    public static boolean isInfinite(float f) {
        return Numbers.isInfinite(f);
    }

    public static boolean parseBoolean(String s2) {
        return Numbers.parseBoolean(s2);
    }

    public static byte parseByte(String s2) {
        return Numbers.parseByte(s2);
    }

    public static short parseShort(String s2) {
        return Numbers.parseShort(s2);
    }

    public static int parseInt(String s2) {
        return Numbers.parseInt(s2);
    }

    public static long parseLong(String s2) {
        return Numbers.parseLong(s2);
    }

    public static float parseFloat(String s2) {
        return Numbers.parseFloat(s2);
    }

    public static double parseDouble(String s2) {
        return Numbers.parseDouble(s2);
    }

    public static Boolean box(boolean b) {
        return Numbers.box(b);
    }

    public static Character box(char c) {
        return Numbers.box(c);
    }

    public static Byte box(byte b) {
        return Numbers.box(b);
    }

    public static Short box(short s2) {
        return Numbers.box(s2);
    }

    public static Integer box(int i) {
        return Numbers.box(i);
    }

    public static Long box(long l) {
        return Numbers.box(l);
    }

    public static Float box(float f) {
        return Numbers.box(f);
    }

    public static Double box(double d) {
        return Numbers.box(d);
    }

    public static boolean unbox(Boolean b) {
        return Numbers.unbox(b);
    }

    public static char unbox(Character ch) {
        return Numbers.unbox(ch);
    }

    public static byte unbox(Byte b) {
        return Numbers.unbox(b);
    }

    public static short unbox(Short s2) {
        return Numbers.unbox(s2);
    }

    public static int unbox(Integer i) {
        return Numbers.unbox(i);
    }

    public static long unbox(Long l) {
        return Numbers.unbox(l);
    }

    public static float unbox(Float f) {
        return Numbers.unbox(f);
    }

    public static double unbox(Double d) {
        return Numbers.unbox(d);
    }

    public static String str(boolean b) {
        return Strings.str(b);
    }

    public static String str(char c) {
        return Strings.str(c);
    }

    public static String str(int i) {
        return Strings.str(i);
    }

    public static String toHexString(int i) {
        return Strings.toHexString(i);
    }

    public static String str(long l) {
        return Strings.str(l);
    }

    public static String toHexString(long l) {
        return Strings.toHexString(l);
    }

    public static String str(float f) {
        return Strings.str(f);
    }

    public static String str(double d) {
        return Strings.str(d);
    }

    public static void exit(int exitCode) {
        Sys.exit(exitCode);
    }

    public static void exit() {
        Sys.exit();
    }

    public static long perfInt(String name) {
        return Counters.perfInt(name);
    }

    public static long perfLong(String name) {
        return Counters.perfLong(name);
    }

    public static String perfString(String name) {
        return Counters.perfString(name);
    }

    public static <K, V> Map<K, V> newHashMap() {
        return Collections.newHashMap();
    }

    public static <K, V> Map<K, V> newWeakMap() {
        return Collections.newWeakMap();
    }

    public static <V> Deque<V> newDeque() {
        return Collections.newDeque();
    }

    public static <K, V> V get(Map<K, V> map, K key) {
        return Collections.get(map, key);
    }

    public static <K, V> boolean containsKey(Map<K, V> map, K key) {
        return Collections.containsKey(map, key);
    }

    public static <K, V> boolean containsValue(Map<K, V> map, V value) {
        return Collections.containsValue(map, value);
    }

    public static <K, V> V put(Map<K, V> map, K key, V value) {
        return Collections.put(map, key, value);
    }

    public static <K, V> V remove(Map<K, V> map, K key) {
        return Collections.remove(map, key);
    }

    public static <K, V> void clear(Map<K, V> map) {
        Collections.clear(map);
    }

    public static <K, V> int size(Map<K, V> map) {
        return Collections.size(map);
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return Collections.isEmpty(map);
    }

    public static <E> int size(Collection<E> coll) {
        return Collections.size(coll);
    }

    public static <E> boolean isEmpty(Collection<E> coll) {
        return Collections.isEmpty(coll);
    }

    public static <E> boolean contains(Collection<E> coll, Object obj) {
        return Collections.contains(coll, obj);
    }

    public static boolean contains(Object[] array, Object value) {
        return Collections.contains(array, value);
    }

    public static <V> void push(Deque<V> queue, V value) {
        Collections.push(queue, value);
    }

    public static <V> V poll(Deque<V> queue) {
        return Collections.poll(queue);
    }

    public static <V> V peek(Deque<V> queue) {
        return Collections.peek(queue);
    }

    public static <V> void addLast(Deque<V> queue, V value) {
        Collections.addLast(queue, value);
    }

    public static <V> V peekFirst(Deque<V> queue) {
        return Collections.peekFirst(queue);
    }

    public static <V> V peekLast(Deque<V> queue) {
        return Collections.peekLast(queue);
    }

    public static <V> V removeLast(Deque<V> queue) {
        return Collections.removeLast(queue);
    }

    public static <V> V removeFirst(Deque<V> queue) {
        return Collections.removeFirst(queue);
    }

    public static int getInstrumentationLevel() {
        return BTraceRuntime.getInstrumentationLevel();
    }

    public static void setInstrumentationLevel(int level) {
        if (level >= 0) {
            BTraceRuntime.setInstrumentationLevel(level);
        }
    }

    public static String $(int n) {
        return Sys.$(n);
    }

    public static int getpid() {
        return Sys.getpid();
    }

    public static int $length() {
        return Sys.$length();
    }

    public static AtomicInteger newAtomicInteger(int initialValue) {
        return Atomic.newAtomicInteger(initialValue);
    }

    public static int get(AtomicInteger ai) {
        return Atomic.get(ai);
    }

    public static void set(AtomicInteger ai, int newValue) {
        Atomic.set(ai, newValue);
    }

    public static void lazySet(AtomicInteger ai, int newValue) {
        Atomic.lazySet(ai, newValue);
    }

    public static boolean compareAndSet(AtomicInteger ai, int expect, int update) {
        return Atomic.compareAndSet(ai, expect, update);
    }

    public static boolean weakCompareAndSet(AtomicInteger ai, int expect, int update) {
        return Atomic.weakCompareAndSet(ai, expect, update);
    }

    public static int getAndIncrement(AtomicInteger ai) {
        return Atomic.getAndIncrement(ai);
    }

    public static int getAndDecrement(AtomicInteger ai) {
        return Atomic.getAndDecrement(ai);
    }

    public static int incrementAndGet(AtomicInteger ai) {
        return Atomic.incrementAndGet(ai);
    }

    public static int decrementAndGet(AtomicInteger ai) {
        return Atomic.decrementAndGet(ai);
    }

    public static int getAndAdd(AtomicInteger ai, int delta) {
        return Atomic.getAndAdd(ai, delta);
    }

    public static int addAndGet(AtomicInteger ai, int delta) {
        return Atomic.addAndGet(ai, delta);
    }

    public static int getAndSet(AtomicInteger ai, int newValue) {
        return Atomic.getAndSet(ai, newValue);
    }

    public static AtomicLong newAtomicLong(long initialValue) {
        return Atomic.newAtomicLong(initialValue);
    }

    public static long get(AtomicLong al) {
        return Atomic.get(al);
    }

    public static void set(AtomicLong al, long newValue) {
        Atomic.set(al, newValue);
    }

    public static void lazySet(AtomicLong al, long newValue) {
        Atomic.lazySet(al, newValue);
    }

    public static boolean compareAndSet(AtomicLong al, long expect, long update) {
        return Atomic.compareAndSet(al, expect, update);
    }

    public static boolean weakCompareAndSet(AtomicLong al, long expect, long update) {
        return Atomic.weakCompareAndSet(al, expect, update);
    }

    public static long getAndIncrement(AtomicLong al) {
        return Atomic.getAndIncrement(al);
    }

    public static long getAndDecrement(AtomicLong al) {
        return Atomic.getAndDecrement(al);
    }

    public static long incrementAndGet(AtomicLong al) {
        return Atomic.incrementAndGet(al);
    }

    public static long decrementAndGet(AtomicLong al) {
        return Atomic.decrementAndGet(al);
    }

    public static long getAndAdd(AtomicLong al, long delta) {
        return Atomic.getAndAdd(al, delta);
    }

    public static long addAndGet(AtomicLong al, long delta) {
        return Atomic.addAndGet(al, delta);
    }

    public static long getAndSet(AtomicLong al, long newValue) {
        return Atomic.getAndSet(al, newValue);
    }

    public static int dtraceProbe(String str1, String str2) {
        return D.probe(str1, str2);
    }

    public static int dtraceProbe(String str1, String str2, int i1) {
        return D.probe(str1, str2, i1);
    }

    public static int dtraceProbe(String str1, String str2, int i1, int i2) {
        return D.probe(str1, str2, i1, i2);
    }

    public static String property(String key) {
        return Sys.Env.property(key);
    }

    public static Properties properties() {
        return Sys.Env.properties();
    }

    public static void printProperties() {
        Sys.Env.printProperties();
    }

    public static String getenv(String name) {
        return Sys.Env.getenv(name);
    }

    public static Map<String, String> getenv() {
        return Sys.Env.getenv();
    }

    public static void printEnv() {
        Sys.Env.printEnv();
    }

    public static long availableProcessors() {
        return Sys.Env.availableProcessors();
    }

    public static long freeMemory() {
        return Sys.Memory.freeMemory();
    }

    public static long totalMemory() {
        return Sys.Memory.totalMemory();
    }

    public static long maxMemory() {
        return Sys.Memory.maxMemory();
    }

    public static MemoryUsage heapUsage() {
        return Sys.Memory.heapUsage();
    }

    public static MemoryUsage nonHeapUsage() {
        return Sys.Memory.nonHeapUsage();
    }

    public static long init(MemoryUsage mu) {
        return Sys.Memory.init(mu);
    }

    public static long committed(MemoryUsage mu) {
        return Sys.Memory.committed(mu);
    }

    public static long max(MemoryUsage mu) {
        return Sys.Memory.max(mu);
    }

    public static long used(MemoryUsage mu) {
        return Sys.Memory.used(mu);
    }

    public static long finalizationCount() {
        return Sys.Memory.finalizationCount();
    }

    public static List<String> vmArguments() {
        return Sys.VM.vmArguments();
    }

    public static void printVmArguments() {
        Sys.VM.printVmArguments();
    }

    public static String vmVersion() {
        return Sys.VM.vmVersion();
    }

    public static boolean isBootClassPathSupported() {
        return Sys.VM.isBootClassPathSupported();
    }

    public static String bootClassPath() {
        return Sys.VM.bootClassPath();
    }

    public static String classPath() {
        return Sys.VM.classPath();
    }

    public static String libraryPath() {
        return Sys.VM.libraryPath();
    }

    public static long threadCount() {
        return Sys.VM.threadCount();
    }

    public static long peakThreadCount() {
        return Sys.VM.peakThreadCount();
    }

    public static long totalStartedThreadCount() {
        return Sys.VM.totalStartedThreadCount();
    }

    public static long daemonThreadCount() {
        return Sys.VM.daemonThreadCount();
    }

    public static long currentThreadCpuTime() {
        return Sys.VM.currentThreadCpuTime();
    }

    public static long currentThreadUserTime() {
        return Sys.VM.currentThreadUserTime();
    }

    public static long getTotalGcTime() {
        return Sys.Memory.getTotalGcTime();
    }

    public static long sizeof(Object objectToSize) {
        return BTraceRuntime.sizeof(objectToSize);
    }

    public static void dumpHeap(String fileName) {
        Sys.Memory.dumpHeap(fileName);
    }

    public static void dumpHeap(String fileName, boolean live) {
        Sys.Memory.dumpHeap(fileName, live);
    }

    public static void gc() {
        Sys.Memory.gc();
    }

    public static void runFinalization() {
        Sys.Memory.runFinalization();
    }

    public static void serialize(Serializable obj, String fileName) {
        Export.serialize(obj, fileName);
    }

    public static String toXML(Object obj) {
        return Export.toXML(obj);
    }

    public static void writeXML(Object obj, String fileName) {
        Export.writeXML(obj, fileName);
    }

    public static void writeDOT(Object obj, String fileName) {
        Export.writeDOT(obj, fileName);
    }

    public static int speculation() {
        return Speculation.speculation();
    }

    public static void speculate(int id) {
        Speculation.speculate(id);
    }

    public static void commit(int id) {
        Speculation.commit(id);
    }

    public static void discard(int id) {
        Speculation.discard(id);
    }

    public static Aggregation newAggregation(AggregationFunction type) {
        return Aggregations.newAggregation(type);
    }

    public static AggregationKey newAggregationKey(Object element1) {
        return Aggregations.newAggregationKey(element1);
    }

    public static AggregationKey newAggregationKey(Object element1, Object element2) {
        return Aggregations.newAggregationKey(element1, element2);
    }

    public static AggregationKey newAggregationKey(Object element1, Object element2, Object element3) {
        return Aggregations.newAggregationKey(element1, element2, element3);
    }

    public static AggregationKey newAggregationKey(Object element1, Object element2, Object element3, Object element4) {
        return Aggregations.newAggregationKey(element1, element2, element3, element4);
    }

    public static void addToAggregation(Aggregation aggregation, long value) {
        Aggregations.addToAggregation(aggregation, value);
    }

    public static void addToAggregation(Aggregation aggregation, AggregationKey key, long value) {
        Aggregations.addToAggregation(aggregation, key, value);
    }

    public static void clearAggregation(Aggregation aggregation) {
        Aggregations.clearAggregation(aggregation);
    }

    public static void truncateAggregation(Aggregation aggregation, int count) {
        Aggregations.truncateAggregation(aggregation, count);
    }

    public static void printAggregation(String name, Aggregation aggregation) {
        Aggregations.printAggregation(name, aggregation);
    }

    public static void printAggregation(String name, Aggregation aggregation, String format) {
        Aggregations.printAggregation(name, aggregation, format);
    }

    private static void checkStatic(Field field) {
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException(field.getName() + " is not a static field");
        }
    }

    private static Field getField(Class<?> clazz, String name, boolean throwError) {
        return AccessController.doPrivileged(() -> {
            Field field = null;
            Class cClass = clazz;
            try {
                while (Objects.isNull(field) && Objects.nonNull(cClass)) {
                    try {
                        field = cClass.getDeclaredField(name);
                    }
                    catch (NoSuchFieldException exp) {
                        cClass = cClass.getSuperclass();
                    }
                }
                if (Objects.isNull(cClass)) {
                    throw new NoSuchFieldException(name);
                }
                field.setAccessible(true);
                return field;
            }
            catch (Exception exp) {
                if (throwError) {
                    throw BTraceUtils.translate(exp);
                }
                return null;
            }
        });
    }

    private static Field[] getAllFields(Class<?> clazz) {
        return AccessController.doPrivileged(() -> {
            try {
                Field[] fields;
                for (Field f : fields = clazz.getDeclaredFields()) {
                    f.setAccessible(true);
                }
                return fields;
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        });
    }

    private static void addFieldValues(StringBuilder buf, Object obj, Class<?> clazz, boolean classNamePrefix) {
        Field[] fields;
        for (Field f : fields = BTraceUtils.getAllFields(clazz)) {
            int modifiers = f.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            if (classNamePrefix) {
                buf.append(f.getDeclaringClass().getName());
                buf.append('.');
            }
            buf.append(f.getName());
            buf.append('=');
            try {
                buf.append(Strings.str(f.get(obj)));
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
            buf.append(", ");
        }
        Class<?> sc = clazz.getSuperclass();
        if (sc != null) {
            BTraceUtils.addFieldValues(buf, obj, sc, classNamePrefix);
        }
    }

    private static void addStaticFieldValues(StringBuilder buf, Class<?> clazz, boolean classNamePrefix) {
        Field[] fields;
        for (Field f : fields = BTraceUtils.getAllFields(clazz)) {
            int modifiers = f.getModifiers();
            if (!Modifier.isStatic(modifiers)) continue;
            if (classNamePrefix) {
                buf.append(f.getDeclaringClass().getName());
                buf.append('.');
            }
            buf.append(f.getName());
            buf.append('=');
            try {
                buf.append(Strings.str(f.get(null)));
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
            buf.append(", ");
        }
        Class<?> sc = clazz.getSuperclass();
        if (sc != null) {
            BTraceUtils.addStaticFieldValues(buf, sc, classNamePrefix);
        }
    }

    private static RuntimeException translate(Exception exp) {
        if (exp instanceof RuntimeException) {
            return (RuntimeException)exp;
        }
        return new RuntimeException(exp);
    }

    static {
        BTraceRuntime.initUnsafe();
    }

    public static final class Jfr {
        public static JfrEvent prepareEvent(JfrEvent.Factory eventFactory) {
            return eventFactory.newEvent();
        }

        public static void setEventField(JfrEvent event, String fieldName, byte fieldValue) {
            event.withValue(fieldName, fieldValue);
        }

        public static void setEventField(JfrEvent event, String fieldName, char fieldValue) {
            event.withValue(fieldName, fieldValue);
        }

        public static void setEventField(JfrEvent event, String fieldName, short fieldValue) {
            event.withValue(fieldName, fieldValue);
        }

        public static void setEventField(JfrEvent event, String fieldName, int fieldValue) {
            event.withValue(fieldName, fieldValue);
        }

        public static void setEventField(JfrEvent event, String fieldName, long fieldValue) {
            event.withValue(fieldName, fieldValue);
        }

        public static void setEventField(JfrEvent event, String fieldName, float fieldValue) {
            event.withValue(fieldName, fieldValue);
        }

        public static void setEventField(JfrEvent event, String fieldName, double fieldValue) {
            event.withValue(fieldName, fieldValue);
        }

        public static void setEventField(JfrEvent event, String fieldName, boolean fieldValue) {
            event.withValue(fieldName, fieldValue);
        }

        public static void setEventField(JfrEvent event, String fieldName, String fieldValue) {
            event.withValue(fieldName, fieldValue);
        }

        public static boolean shouldCommit(JfrEvent event) {
            return event.shouldCommit();
        }

        public static void commit(JfrEvent event) {
            event.commit();
        }

        public static void begin(JfrEvent event) {
            event.begin();
        }

        public static void end(JfrEvent event) {
            event.end();
        }
    }

    public static class D {
        public static int probe(String str1, String str2) {
            return D.probe(str1, str2, -1, -1);
        }

        public static int probe(String str1, String str2, int i1) {
            return D.probe(str1, str2, i1, -1);
        }

        public static int probe(String str1, String str2, int i1, int i2) {
            return BTraceRuntime.dtraceProbe(str1, str2, i1, i2);
        }
    }

    public static class Counters {
        public static long perfInt(String name) {
            return BTraceRuntime.perfInt(name);
        }

        public static long perfLong(String name) {
            return BTraceRuntime.perfLong(name);
        }

        public static String perfString(String name) {
            return BTraceRuntime.perfString(name);
        }
    }

    public static class Sys {
        public static String $(int n) {
            return BTraceRuntime.$(n);
        }

        public static String $(String key) {
            return BTraceRuntime.$(key);
        }

        public static int getpid() {
            int pid = -1;
            try {
                pid = Integer.parseInt(Sys.$(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return pid;
        }

        public static int $length() {
            return BTraceRuntime.$length();
        }

        public static void exit(int exitCode) {
            BTraceRuntime.exit(exitCode);
        }

        public static void exit() {
            Sys.exit(0);
        }

        public static class VM {
            public static List<String> vmArguments() {
                return BTraceRuntime.getInputArguments();
            }

            public static void printVmArguments() {
                BTraceUtils.println(VM.vmArguments());
            }

            public static String vmVersion() {
                return BTraceRuntime.getVmVersion();
            }

            public static boolean isBootClassPathSupported() {
                return BTraceRuntime.isBootClassPathSupported();
            }

            public static String bootClassPath() {
                return BTraceRuntime.getBootClassPath();
            }

            public static String classPath() {
                return Env.property("java.class.path");
            }

            public static String libraryPath() {
                return Env.property("java.library.path");
            }

            public static long threadCount() {
                return BTraceRuntime.getThreadCount();
            }

            public static long peakThreadCount() {
                return BTraceRuntime.getPeakThreadCount();
            }

            public static long totalStartedThreadCount() {
                return BTraceRuntime.getTotalStartedThreadCount();
            }

            public static long daemonThreadCount() {
                return BTraceRuntime.getDaemonThreadCount();
            }

            public static double systemLoadAverage() {
                return BTraceRuntime.getSystemLoadAverage();
            }

            public static long processCPUTime() {
                return BTraceRuntime.getProcessCPUTime();
            }

            public static long vmStartTime() {
                return BTraceRuntime.vmStartTime();
            }

            public static long vmUptime() {
                return BTraceRuntime.vmUptime();
            }

            public static long currentThreadCpuTime() {
                return BTraceRuntime.getCurrentThreadCpuTime();
            }

            public static long currentThreadUserTime() {
                return BTraceRuntime.getCurrentThreadUserTime();
            }
        }

        public static class Memory {
            public static long freeMemory() {
                return Runtime.getRuntime().freeMemory();
            }

            public static long totalMemory() {
                return Runtime.getRuntime().totalMemory();
            }

            public static long maxMemory() {
                return Runtime.getRuntime().maxMemory();
            }

            public static MemoryUsage heapUsage() {
                return BTraceRuntime.heapUsage();
            }

            public static MemoryUsage nonHeapUsage() {
                return BTraceRuntime.nonHeapUsage();
            }

            public static long init(MemoryUsage mu) {
                return mu.getInit();
            }

            public static long committed(MemoryUsage mu) {
                return mu.getCommitted();
            }

            public static long max(MemoryUsage mu) {
                return mu.getMax();
            }

            public static long used(MemoryUsage mu) {
                return mu.getUsed();
            }

            public static long finalizationCount() {
                return BTraceRuntime.finalizationCount();
            }

            public static void dumpHeap(String fileName) {
                Memory.dumpHeap(fileName, true);
            }

            public static void dumpHeap(String fileName, boolean live) {
                BTraceRuntime.dumpHeap(fileName, live);
            }

            public static void gc() {
                System.gc();
            }

            public static long getTotalGcTime() {
                return BTraceRuntime.getTotalGcTime();
            }

            public static String getMemoryPoolUsage(String poolFormat) {
                return BTraceRuntime.getMemoryPoolUsage(poolFormat);
            }

            public static void runFinalization() {
                System.runFinalization();
            }
        }

        public static class Env {
            public static String property(String key) {
                return BTraceRuntime.property(key);
            }

            public static Properties properties() {
                return BTraceRuntime.properties();
            }

            public static void printProperties() {
                BTraceRuntime.printMap(Env.properties());
            }

            public static String getenv(String name) {
                return BTraceRuntime.getenv(name);
            }

            public static Map<String, String> getenv() {
                return BTraceRuntime.getenv();
            }

            public static void printEnv() {
                BTraceRuntime.printMap(Env.getenv());
            }

            public static long availableProcessors() {
                return Runtime.getRuntime().availableProcessors();
            }
        }
    }

    public static class Export {
        public static void serialize(Serializable obj, String fileName) {
            BTraceRuntime.serialize(obj, fileName);
        }

        public static String toXML(Object obj) {
            return BTraceRuntime.toXML(obj);
        }

        public static void writeXML(Object obj, String fileName) {
            BTraceRuntime.writeXML(obj, fileName);
        }

        public static void writeDOT(Object obj, String fileName) {
            BTraceRuntime.writeDOT(obj, fileName);
        }
    }

    public static class Reflective {
        public static Class<?> classOf(Object obj) {
            return obj.getClass();
        }

        public static Class<?> declaringClass(Field field) {
            return field.getDeclaringClass();
        }

        public static String name(Class<?> clazz) {
            return clazz.getName();
        }

        public static String name(Field field) {
            return field.getName();
        }

        public static Class<?> type(Field field) {
            return field.getType();
        }

        public static int accessFlags(Class<?> clazz) {
            return clazz.getModifiers();
        }

        public static int accessFlags(Field field) {
            return field.getModifiers();
        }

        public static ClassLoader contextClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }

        public static Class<?> classForName(String name) {
            ClassLoader callerLoader = BTraceRuntime.getCallerClassloader(2);
            return Reflective.classForName(name, callerLoader);
        }

        public static Class<?> classForName(String name, ClassLoader cl) {
            try {
                return Class.forName(name, false, cl);
            }
            catch (ClassNotFoundException exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static boolean isAssignableFrom(Class<?> a, Class<?> b) {
            return a.isAssignableFrom(b);
        }

        public static boolean isInstance(Class<?> clazz, Object obj) {
            return clazz.isInstance(obj);
        }

        public static Class<?> getSuperclass(Class<?> clazz) {
            return clazz.getSuperclass();
        }

        public static boolean isInterface(Class<?> clazz) {
            return clazz.isInterface();
        }

        public static boolean isArray(Class<?> clazz) {
            return clazz.isArray();
        }

        public static boolean isPrimitive(Class<?> clazz) {
            return clazz.isPrimitive();
        }

        public static Class<?> getComponentType(Class<?> clazz) {
            return clazz.getComponentType();
        }

        public static Field field(Class clazz, String name, boolean throwException) {
            return BTraceUtils.getField(clazz, name, throwException);
        }

        public static Field field(Class clazz, String name) {
            return Reflective.field(clazz, name, true);
        }

        public static Field field(String clazz, String name, boolean throwException) {
            ClassLoader callerLoader = BTraceRuntime.getCallerClassloader(2);
            return Reflective.field(Reflective.classForName(clazz, callerLoader), name, throwException);
        }

        public static Field field(String clazz, String name) {
            ClassLoader callerLoader = BTraceRuntime.getCallerClassloader(2);
            return Reflective.field(Reflective.classForName(clazz, callerLoader), name);
        }

        public static byte getByte(Field field) {
            BTraceUtils.checkStatic(field);
            try {
                return field.getByte(null);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static byte getByte(Field field, Object obj) {
            try {
                return field.getByte(obj);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static byte getByte(String name, Object instance) {
            Field f = BTraceUtils.getField(instance.getClass(), name, true);
            return Reflective.getByte(f, instance);
        }

        public static byte getByteStatic(String name, Class clazz) {
            Field f = BTraceUtils.getField(clazz, name, true);
            return Reflective.getByte(f, null);
        }

        public static short getShort(Field field) {
            BTraceUtils.checkStatic(field);
            try {
                return field.getShort(null);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static short getShort(Field field, Object obj) {
            try {
                return field.getShort(obj);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static short getShort(String name, Object instance) {
            Field f = BTraceUtils.getField(instance.getClass(), name, true);
            return Reflective.getShort(f, instance);
        }

        public static short getShortStatic(String name, Class clazz) {
            Field f = BTraceUtils.getField(clazz, name, true);
            return Reflective.getShort(f, null);
        }

        public static int getInt(Field field) {
            BTraceUtils.checkStatic(field);
            try {
                return field.getInt(null);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static int getInt(Field field, Object obj) {
            try {
                return field.getInt(obj);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static int getInt(String name, Object instance) {
            Field f = BTraceUtils.getField(instance.getClass(), name, true);
            return Reflective.getInt(f, instance);
        }

        public static int getIntStatic(String name, Class clazz) {
            Field f = BTraceUtils.getField(clazz, name, true);
            return Reflective.getInt(f, null);
        }

        public static long getLong(Field field) {
            BTraceUtils.checkStatic(field);
            try {
                return field.getLong(null);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static long getLong(Field field, Object obj) {
            try {
                return field.getLong(obj);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static long getLong(String name, Object instance) {
            Field f = BTraceUtils.getField(instance.getClass(), name, true);
            return Reflective.getLong(f, instance);
        }

        public static long getLongStatic(String name, Class clazz) {
            Field f = BTraceUtils.getField(clazz, name, true);
            return Reflective.getLong(f, null);
        }

        public static float getFloat(Field field) {
            BTraceUtils.checkStatic(field);
            try {
                return field.getFloat(null);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static float getFloat(Field field, Object obj) {
            try {
                return field.getFloat(obj);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static float getFloat(String name, Object instance) {
            Field f = BTraceUtils.getField(instance.getClass(), name, true);
            return Reflective.getFloat(f, instance);
        }

        public static float getFloatStatic(String name, Class clazz) {
            Field f = BTraceUtils.getField(clazz, name, true);
            return Reflective.getFloat(f, null);
        }

        public static double getDouble(Field field) {
            BTraceUtils.checkStatic(field);
            try {
                return field.getDouble(null);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static double getDouble(Field field, Object instance) {
            try {
                return field.getDouble(instance);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static double getDouble(String name, Object instance) {
            Field f = BTraceUtils.getField(instance.getClass(), name, true);
            return Reflective.getDouble(f, instance);
        }

        public static double getDouble(String name, Class clazz) {
            Field f = BTraceUtils.getField(clazz, name, true);
            return Reflective.getDouble(f, null);
        }

        public static boolean getBoolean(Field field) {
            BTraceUtils.checkStatic(field);
            try {
                return field.getBoolean(null);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static boolean getBoolean(Field field, Object obj) {
            try {
                return field.getBoolean(obj);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static boolean getBoolean(String name, Object instance) {
            Field f = BTraceUtils.getField(instance.getClass(), name, true);
            return Reflective.getBoolean(f, instance);
        }

        public static boolean getBooleanStatic(String name, Class clazz) {
            Field f = BTraceUtils.getField(clazz, name, true);
            return Reflective.getBoolean(f, null);
        }

        public static char getChar(Field field) {
            BTraceUtils.checkStatic(field);
            try {
                return field.getChar(null);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static char getChar(Field field, Object obj) {
            try {
                return field.getChar(obj);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static char getChar(String name, Object instance) {
            Field f = BTraceUtils.getField(instance.getClass(), name, true);
            return Reflective.getChar(f, instance);
        }

        public static char getCharStatic(String name, Class clazz) {
            Field f = BTraceUtils.getField(clazz, name, true);
            return Reflective.getChar(f, null);
        }

        public static Object get(Field field) {
            BTraceUtils.checkStatic(field);
            try {
                return field.get(null);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static Object get(Field field, Object obj) {
            try {
                return field.get(obj);
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
        }

        public static Object get(String name, Object instance) {
            Field f = BTraceUtils.getField(instance.getClass(), name, true);
            return Reflective.get(f, instance);
        }

        public static Object getStatic(String name, Class clazz) {
            Field f = BTraceUtils.getField(clazz, name, true);
            return Reflective.get(f, null);
        }

        public static void printFields(Object obj) {
            Reflective.printFields(obj, false);
        }

        public static void printFields(Object obj, boolean classNamePrefix) {
            StringBuilder buf = new StringBuilder();
            buf.append('{');
            BTraceUtils.addFieldValues(buf, obj, obj.getClass(), classNamePrefix);
            buf.append('}');
            BTraceUtils.println(buf.toString());
        }

        public static void printStaticFields(Class clazz) {
            Reflective.printStaticFields(clazz, false);
        }

        public static void printStaticFields(Class clazz, boolean classNamePrefix) {
            StringBuilder buf = new StringBuilder();
            buf.append('{');
            BTraceUtils.addStaticFieldValues(buf, clazz, classNamePrefix);
            buf.append('}');
            BTraceUtils.println(buf.toString());
        }
    }

    public static class References {
        public static WeakReference weakRef(Object obj) {
            return new WeakReference<Object>(obj);
        }

        public static SoftReference softRef(Object obj) {
            return new SoftReference<Object>(obj);
        }

        public static Object deref(Reference ref) {
            if (ref.getClass().getClassLoader() == null) {
                return ref.get();
            }
            throw new IllegalArgumentException();
        }
    }

    public static class Speculation {
        public static int speculation() {
            return BTraceRuntime.speculation();
        }

        public static void speculate(int id) {
            BTraceRuntime.speculate(id);
        }

        public static void commit(int id) {
            BTraceRuntime.commit(id);
        }

        public static void discard(int id) {
            BTraceRuntime.discard(id);
        }
    }

    public static class Profiling {
        public static Profiler newProfiler() {
            return BTraceRuntime.newProfiler();
        }

        public static Profiler newProfiler(int expectedBlockCnt) {
            return BTraceRuntime.newProfiler(expectedBlockCnt);
        }

        public static void recordEntry(Profiler profiler, String blockName) {
            BTraceRuntime.recordEntry(profiler, blockName);
        }

        public static void recordExit(Profiler profiler, String blockName, long duration) {
            BTraceRuntime.recordExit(profiler, blockName, duration);
        }

        public static Profiler.Snapshot snapshot(Profiler profiler) {
            return BTraceRuntime.snapshot(profiler);
        }

        public static Profiler.Snapshot snapshotAndReset(Profiler profiler) {
            return BTraceRuntime.snapshotAndReset(profiler);
        }

        public static void reset(Profiler profiler) {
            BTraceRuntime.resetProfiler(profiler);
        }

        public static void printSnapshot(String name, Profiler profiler) {
            BTraceRuntime.printSnapshot(name, profiler.snapshot());
        }

        public static void printSnapshot(String name, Profiler profiler, String format) {
            BTraceRuntime.printSnapshot(name, profiler.snapshot(), format);
        }
    }

    public static class Aggregations {
        public static Aggregation newAggregation(AggregationFunction type) {
            return BTraceRuntime.newAggregation(type);
        }

        public static AggregationKey newAggregationKey(Object element1) {
            return BTraceRuntime.newAggregationKey(element1);
        }

        public static AggregationKey newAggregationKey(Object element1, Object element2) {
            return BTraceRuntime.newAggregationKey(element1, element2);
        }

        public static AggregationKey newAggregationKey(Object element1, Object element2, Object element3) {
            return BTraceRuntime.newAggregationKey(element1, element2, element3);
        }

        public static AggregationKey newAggregationKey(Object element1, Object element2, Object element3, Object element4) {
            return BTraceRuntime.newAggregationKey(element1, element2, element3, element4);
        }

        public static void addToAggregation(Aggregation aggregation, long value) {
            BTraceRuntime.addToAggregation(aggregation, value);
        }

        public static void addToAggregation(Aggregation aggregation, AggregationKey key, long value) {
            BTraceRuntime.addToAggregation(aggregation, key, value);
        }

        public static void clearAggregation(Aggregation aggregation) {
            BTraceRuntime.clearAggregation(aggregation);
        }

        public static void truncateAggregation(Aggregation aggregation, int count) {
            BTraceRuntime.truncateAggregation(aggregation, count);
        }

        public static void printAggregation(String name, Aggregation aggregation) {
            BTraceRuntime.printAggregation(name, aggregation);
        }

        public static void printAggregation(String name, Aggregation aggregation, String format) {
            BTraceRuntime.printAggregation(name, aggregation, format);
        }

        public static void printAggregation(String name, String format, Collection<Aggregation> aggregationList) {
            Aggregation[] aggregationArray = new Aggregation[aggregationList.size()];
            int index = 0;
            Iterator<Aggregation> iterator = aggregationList.iterator();
            while (iterator.hasNext()) {
                Aggregation a;
                aggregationArray[index] = a = iterator.next();
                ++index;
            }
            BTraceRuntime.printAggregation(name, format, aggregationArray);
        }
    }

    public static class Atomic {
        public static AtomicInteger newAtomicInteger(int initialValue) {
            return BTraceRuntime.newAtomicInteger(initialValue);
        }

        public static int get(AtomicInteger ai) {
            return BTraceRuntime.get(ai);
        }

        public static void set(AtomicInteger ai, int newValue) {
            BTraceRuntime.set(ai, newValue);
        }

        public static void lazySet(AtomicInteger ai, int newValue) {
            BTraceRuntime.lazySet(ai, newValue);
        }

        public static boolean compareAndSet(AtomicInteger ai, int expect, int update) {
            return BTraceRuntime.compareAndSet(ai, expect, update);
        }

        public static boolean weakCompareAndSet(AtomicInteger ai, int expect, int update) {
            return BTraceRuntime.weakCompareAndSet(ai, expect, update);
        }

        public static int getAndIncrement(AtomicInteger ai) {
            return BTraceRuntime.getAndIncrement(ai);
        }

        public static int getAndDecrement(AtomicInteger ai) {
            return BTraceRuntime.getAndDecrement(ai);
        }

        public static int incrementAndGet(AtomicInteger ai) {
            return BTraceRuntime.incrementAndGet(ai);
        }

        public static int decrementAndGet(AtomicInteger ai) {
            return BTraceRuntime.decrementAndGet(ai);
        }

        public static int getAndAdd(AtomicInteger ai, int delta) {
            return BTraceRuntime.getAndAdd(ai, delta);
        }

        public static int addAndGet(AtomicInteger ai, int delta) {
            return BTraceRuntime.addAndGet(ai, delta);
        }

        public static int getAndSet(AtomicInteger ai, int newValue) {
            return BTraceRuntime.getAndSet(ai, newValue);
        }

        public static AtomicLong newAtomicLong(long initialValue) {
            return BTraceRuntime.newAtomicLong(initialValue);
        }

        public static long get(AtomicLong al) {
            return BTraceRuntime.get(al);
        }

        public static void set(AtomicLong al, long newValue) {
            BTraceRuntime.set(al, newValue);
        }

        public static void lazySet(AtomicLong al, long newValue) {
            BTraceRuntime.lazySet(al, newValue);
        }

        public static boolean compareAndSet(AtomicLong al, long expect, long update) {
            return BTraceRuntime.compareAndSet(al, expect, update);
        }

        public static boolean weakCompareAndSet(AtomicLong al, long expect, long update) {
            return BTraceRuntime.weakCompareAndSet(al, expect, update);
        }

        public static long getAndIncrement(AtomicLong al) {
            return BTraceRuntime.getAndIncrement(al);
        }

        public static long getAndDecrement(AtomicLong al) {
            return BTraceRuntime.getAndDecrement(al);
        }

        public static long incrementAndGet(AtomicLong al) {
            return BTraceRuntime.incrementAndGet(al);
        }

        public static long decrementAndGet(AtomicLong al) {
            return BTraceRuntime.decrementAndGet(al);
        }

        public static long getAndAdd(AtomicLong al, long delta) {
            return BTraceRuntime.getAndAdd(al, delta);
        }

        public static long addAndGet(AtomicLong al, long delta) {
            return BTraceRuntime.addAndGet(al, delta);
        }

        public static long getAndSet(AtomicLong al, long newValue) {
            return BTraceRuntime.getAndSet(al, newValue);
        }
    }

    public static class Collections {
        public static <K, V> Map<K, V> newHashMap() {
            return BTraceRuntime.newHashMap();
        }

        public static <K, V> Map<K, V> newWeakMap() {
            return BTraceRuntime.newWeakMap();
        }

        public static <V> Deque<V> newDeque() {
            return BTraceRuntime.newDeque();
        }

        public static <K, V> void putAll(Map<K, V> src, Map<K, V> dst) {
            BTraceRuntime.putAll(src, dst);
        }

        public static <K, V> void copy(Map<K, V> src, Map<K, V> dst) {
            BTraceRuntime.copy(src, dst);
        }

        public static <V> void copy(Collection<V> src, Collection<V> dst) {
        }

        public static <K, V> V get(Map<K, V> map, K key) {
            return BTraceRuntime.get(map, key);
        }

        public static <K, V> boolean containsKey(Map<K, V> map, K key) {
            return BTraceRuntime.containsKey(map, key);
        }

        public static <K, V> boolean containsValue(Map<K, V> map, V value) {
            return BTraceRuntime.containsValue(map, value);
        }

        public static <K, V> V put(Map<K, V> map, K key, V value) {
            return BTraceRuntime.put(map, key, value);
        }

        public static <K, V> V remove(Map<K, V> map, K key) {
            return BTraceRuntime.remove(map, key);
        }

        public static <K, V> void clear(Map<K, V> map) {
            BTraceRuntime.clear(map);
        }

        public static <K, V> int size(Map<K, V> map) {
            return BTraceRuntime.size(map);
        }

        public static <K, V> boolean isEmpty(Map<K, V> map) {
            return BTraceRuntime.isEmpty(map);
        }

        public static <E> int size(Collection<E> coll) {
            return BTraceRuntime.size(coll);
        }

        public static <E> boolean isEmpty(Collection<E> coll) {
            return BTraceRuntime.isEmpty(coll);
        }

        public static <E> boolean contains(Collection<E> coll, Object obj) {
            return BTraceRuntime.contains(coll, obj);
        }

        public static boolean contains(Object[] array, Object value) {
            for (Object each : array) {
                if (!BTraceUtils.compare(each, value)) continue;
                return true;
            }
            return false;
        }

        public static <E> Object[] toArray(Collection<E> collection) {
            return BTraceRuntime.toArray(collection);
        }

        public static <V> void push(Deque<V> queue, V value) {
            BTraceRuntime.push(queue, value);
        }

        public static <V> V poll(Deque<V> queue) {
            return BTraceRuntime.poll(queue);
        }

        public static <V> V peek(Deque<V> queue) {
            return BTraceRuntime.peek(queue);
        }

        public static <V> void addLast(Deque<V> queue, V value) {
            BTraceRuntime.addLast(queue, value);
        }

        public static <V> V peekFirst(Deque<V> queue) {
            return BTraceRuntime.peekFirst(queue);
        }

        public static <V> V peekLast(Deque<V> queue) {
            return BTraceRuntime.peekLast(queue);
        }

        public static <V> V removeLast(Deque<V> queue) {
            return BTraceRuntime.removeLast(queue);
        }

        public static <V> V removeFirst(Deque<V> queue) {
            return BTraceRuntime.removeFirst(queue);
        }
    }

    public static class Time {
        public static long millis() {
            return System.currentTimeMillis();
        }

        public static long nanos() {
            return System.nanoTime();
        }

        public static String timestamp(String format) {
            return new SimpleDateFormat(format).format(Calendar.getInstance().getTime());
        }

        public static String timestamp() {
            return new SimpleDateFormat().format(Calendar.getInstance().getTime());
        }
    }

    public static class Numbers {
        public static double random() {
            return Math.random();
        }

        public static strictfp double log(double a) {
            return Math.log(a);
        }

        public static strictfp double log10(double a) {
            return Math.log10(a);
        }

        public static strictfp double exp(double a) {
            return Math.exp(a);
        }

        public static boolean isNaN(double d) {
            return Double.isNaN(d);
        }

        public static boolean isNaN(float f) {
            return Float.isNaN(f);
        }

        public static boolean isInfinite(double d) {
            return Double.isInfinite(d);
        }

        public static boolean isInfinite(float f) {
            return Float.isInfinite(f);
        }

        public static boolean parseBoolean(String s2) {
            return Boolean.parseBoolean(s2);
        }

        public static byte parseByte(String s2) {
            return Byte.parseByte(s2);
        }

        public static short parseShort(String s2) {
            return Short.parseShort(s2);
        }

        public static int parseInt(String s2) {
            return Integer.parseInt(s2);
        }

        public static long parseLong(String s2) {
            return Long.parseLong(s2);
        }

        public static float parseFloat(String s2) {
            return Float.parseFloat(s2);
        }

        public static double parseDouble(String s2) {
            return Double.parseDouble(s2);
        }

        public static Boolean box(boolean b) {
            return b;
        }

        public static Character box(char c) {
            return Character.valueOf(c);
        }

        public static Byte box(byte b) {
            return b;
        }

        public static Short box(short s2) {
            return s2;
        }

        public static Integer box(int i) {
            return i;
        }

        public static Long box(long l) {
            return l;
        }

        public static Float box(float f) {
            return Float.valueOf(f);
        }

        public static Double box(double d) {
            return d;
        }

        public static boolean unbox(Boolean b) {
            return b;
        }

        public static char unbox(Character ch) {
            return ch.charValue();
        }

        public static byte unbox(Byte b) {
            return b;
        }

        public static short unbox(Short s2) {
            return s2;
        }

        public static int unbox(Integer i) {
            return i;
        }

        public static long unbox(Long l) {
            return l;
        }

        public static float unbox(Float f) {
            return f.floatValue();
        }

        public static double unbox(Double d) {
            return d;
        }
    }

    public static class Strings {
        public static boolean startsWith(String s2, String start) {
            return s2.startsWith(start);
        }

        public static boolean endsWith(String s2, String end) {
            return s2.endsWith(end);
        }

        public static String strcat(String str1, String str2) {
            return Strings.concat(str1, str2);
        }

        public static String concat(String str1, String str2) {
            return str1.concat(str2);
        }

        public static int compareTo(String str1, String str2) {
            return str1.compareTo(str2);
        }

        public static int strcmp(String str1, String str2) {
            return str1.compareTo(str2);
        }

        public static int compareToIgnoreCase(String str1, String str2) {
            return str1.compareToIgnoreCase(str2);
        }

        public static int stricmp(String str1, String str2) {
            return str1.compareToIgnoreCase(str2);
        }

        public static int strstr(String str1, String str2) {
            return str1.indexOf(str2);
        }

        public static int indexOf(String str1, String str2) {
            return str1.indexOf(str2);
        }

        public static int lastIndexOf(String str1, String str2) {
            return str1.lastIndexOf(str2);
        }

        public static String substr(String str, int start, int length) {
            return str.substring(start, length);
        }

        public static String substr(String str, int start) {
            return str.substring(start);
        }

        public static int length(String str) {
            return str.length();
        }

        public static int strlen(String str) {
            return str.length();
        }

        public static Pattern regexp(String regex) {
            return Pattern.compile(regex);
        }

        public static Pattern pattern(String regex) {
            return Strings.regexp(regex);
        }

        public static Pattern regexp(String regex, int flags) {
            return Pattern.compile(regex, flags);
        }

        public static Pattern pattern(String regex, int flags) {
            return Strings.regexp(regex, flags);
        }

        public static boolean matches(Pattern regex, String input) {
            return regex.matcher(input).matches();
        }

        public static boolean matches(String regex, String input) {
            return Pattern.matches(regex, input);
        }

        public static String str(boolean b) {
            return Boolean.toString(b);
        }

        public static String str(char c) {
            return Character.toString(c);
        }

        public static String str(int i) {
            return Integer.toString(i);
        }

        public static String toHexString(int i) {
            return Integer.toHexString(i);
        }

        public static String str(long l) {
            return Long.toString(l);
        }

        public static String str(Object obj) {
            if (obj == null) {
                return "null";
            }
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj.getClass().getClassLoader() == null) {
                try {
                    return obj.toString();
                }
                catch (NullPointerException e) {
                    return "null";
                }
            }
            return BTraceUtils.identityStr(obj);
        }

        public static String toHexString(long l) {
            return Long.toHexString(l);
        }

        public static String str(float f) {
            return Float.toString(f);
        }

        public static String str(double d) {
            return Double.toString(d);
        }

        public static Appendable newStringBuilder(boolean threadSafe) {
            return BTraceRuntime.newStringBuilder(threadSafe);
        }

        public static Appendable newStringBuilder() {
            return BTraceRuntime.newStringBuilder();
        }

        public static Appendable append(Appendable buffer, String strToAppend) {
            return BTraceRuntime.append(buffer, strToAppend);
        }

        public static int length(Appendable buffer) {
            return BTraceRuntime.length(buffer);
        }
    }

    public static class Threads {
        public static boolean isInteruppted() {
            return Thread.currentThread().isInterrupted();
        }

        public static void jstack() {
            Threads.jstack(1, -1);
        }

        public static void jstack(int numFrames) {
            Threads.jstack(1, numFrames);
        }

        private static void jstack(int strip, int numFrames) {
            if (numFrames == 0) {
                return;
            }
            StackTraceElement[] st = Thread.currentThread().getStackTrace();
            BTraceRuntime.stackTrace(st, strip + 2, numFrames);
        }

        public static void jstackAll() {
            Threads.jstackAll(1, -1);
        }

        public static void jstackAll(int numFrames) {
            Threads.jstackAll(1, numFrames);
        }

        private static void jstackAll(int strip, int numFrames) {
            BTraceRuntime.stackTraceAll(numFrames);
        }

        public static String jstackStr() {
            return Threads.jstackStr(1, -1);
        }

        public static String jstackStr(int numFrames) {
            if (numFrames == 0) {
                return "";
            }
            return Threads.jstackStr(1, numFrames);
        }

        private static String jstackStr(int strip, int numFrames) {
            if (numFrames == 0) {
                return "";
            }
            StackTraceElement[] st = Thread.currentThread().getStackTrace();
            return BTraceRuntime.stackTraceStr(st, strip + 2, numFrames);
        }

        public static String jstackAllStr() {
            return Threads.jstackAllStr(-1);
        }

        public static String jstackAllStr(int numFrames) {
            if (numFrames == 0) {
                return "";
            }
            return BTraceRuntime.stackTraceAllStr(numFrames);
        }

        public static void jstack(Throwable exception) {
            Threads.jstack(exception, -1);
        }

        public static void jstack(Throwable exception, int numFrames) {
            if (numFrames == 0) {
                return;
            }
            StackTraceElement[] st = exception.getStackTrace();
            BTraceUtils.println(exception.toString());
            BTraceRuntime.stackTrace("\t", st, 0, numFrames);
            for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
                BTraceUtils.print("Caused by: ");
                BTraceUtils.println(cause.toString());
                st = cause.getStackTrace();
                BTraceRuntime.stackTrace("\t", st, 0, numFrames);
            }
        }

        public static String jstackStr(Throwable exception) {
            return Threads.jstackStr(exception, -1);
        }

        public static String jstackStr(Throwable exception, int numFrames) {
            if (numFrames == 0) {
                return "";
            }
            StackTraceElement[] st = exception.getStackTrace();
            StringBuilder buf = new StringBuilder();
            buf.append(Strings.str(exception));
            buf.append(BTraceRuntime.stackTraceStr("\t", st, 0, numFrames));
            for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
                buf.append("Caused by:");
                st = cause.getStackTrace();
                buf.append(BTraceRuntime.stackTraceStr("\t", st, 0, numFrames));
            }
            return buf.toString();
        }

        public static Thread currentThread() {
            return Thread.currentThread();
        }

        public static long threadId(Thread thread) {
            return thread.getId();
        }

        public static Thread.State threadState(Thread thread) {
            return thread.getState();
        }

        public static boolean holdsLock(Object obj) {
            return Thread.holdsLock(obj);
        }

        public static void deadlocks() {
            Threads.deadlocks(true);
        }

        public static void deadlocks(boolean stackTrace) {
            BTraceRuntime.deadlocks(stackTrace);
        }

        public static String name(Thread thread) {
            return thread.getName();
        }
    }
}

