/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.client;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.openjdk.btrace.client.Client;
import org.openjdk.btrace.client.JpsUtils;
import org.openjdk.btrace.core.DebugSupport;
import org.openjdk.btrace.core.Messages;
import org.openjdk.btrace.core.comm.CommandListener;
import org.openjdk.btrace.core.comm.ExitCommand;
import org.openjdk.btrace.core.comm.PrintableCommand;
import org.openjdk.btrace.core.comm.StatusCommand;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;
import sun.misc.Signal;

public final class Main {
    private static final Logger log;
    public static final boolean TRACK_RETRANSFORM;
    public static final int BTRACE_DEFAULT_PORT = 2020;
    public static final String BTRACE_DEFAULT_HOST = "localhost";
    private static final Console con;
    private static final PrintWriter out;
    public static volatile boolean exiting;
    private static boolean DEBUG;
    private static boolean TRUSTED;
    private static boolean DUMP_CLASSES;
    private static String OUTPUT_FILE;
    private static String DUMP_DIR;
    private static String PROBE_DESC_PATH;

    private static PrintWriter getOutWriter(Console con) {
        return con != null ? con.writer() : new PrintWriter(System.out);
    }

    public static void main(String[] args) throws Exception {
        String pidArg;
        Integer pid;
        int port = 2020;
        String host = BTRACE_DEFAULT_HOST;
        String classPath = ".";
        String includePath = null;
        int count = 0;
        boolean hostDefined = false;
        boolean portDefined = false;
        boolean classpathDefined = false;
        boolean includePathDefined = false;
        String statsdDef = "";
        String resumeProbe = null;
        String probeCommand = null;
        String probeCommandArg = null;
        boolean listProbes = false;
        boolean unattended = false;
        block16: for (int i = 0; i < args.length; ++i) {
            String arg;
            switch (arg = args[i]) {
                case "-v": {
                    DEBUG = true;
                    DebugSupport.initLoggers(true, log);
                    continue block16;
                }
                case "--version": {
                    System.out.println(Messages.get("btrace.version"));
                    return;
                }
                case "-l": {
                    for (String vm : JpsUtils.listVms()) {
                        System.out.println(vm);
                    }
                    return;
                }
                case "-r": {
                    if (i >= args.length - 1 || !args[i + 1].equalsIgnoreCase("help")) continue block16;
                    System.out.println(Messages.get("remote.commands.help"));
                    return;
                }
            }
        }
        if (args.length < 2) {
            Main.usage();
        }
        while (true) {
            if (args[count].isEmpty()) {
                continue;
            }
            if (args[count].charAt(0) != '-') break;
            if (args.length <= count + 1) {
                Main.usage();
            }
            if (args[count].equals("-p") && !portDefined) {
                try {
                    port = Integer.parseInt(args[++count]);
                    if (log.isDebugEnabled()) {
                        log.debug("accepting port {}", (Object)port);
                    }
                }
                catch (NumberFormatException nfe) {
                    Main.usage();
                }
                portDefined = true;
            } else if (args[count].equals("-u")) {
                TRUSTED = true;
                log.debug("btrace trusted mode is set");
            } else if (args[count].equals("-o")) {
                OUTPUT_FILE = args[++count];
                if (log.isDebugEnabled()) {
                    log.debug("outputFile is {}", (Object)OUTPUT_FILE);
                }
            } else if (args[count].equals("-d")) {
                DUMP_CLASSES = true;
                DUMP_DIR = args[++count];
                if (log.isDebugEnabled()) {
                    log.debug("dumpDir is {}", (Object)DUMP_DIR);
                }
            } else if (args[count].equals("-pd")) {
                PROBE_DESC_PATH = args[++count];
                if (log.isDebugEnabled()) {
                    log.debug("probeDescDir is {}", (Object)PROBE_DESC_PATH);
                }
            } else if ((args[count].equals("-cp") || args[count].equals("-classpath")) && !classpathDefined) {
                classPath = args[++count];
                if (log.isDebugEnabled()) {
                    log.debug("accepting classpath {}", (Object)classPath);
                }
                classpathDefined = true;
            } else if (args[count].equals("-I") && !includePathDefined) {
                includePath = args[++count];
                if (log.isDebugEnabled()) {
                    log.debug("accepting include path {}", (Object)includePath);
                }
                includePathDefined = true;
            } else if (args[count].equals("-statsd")) {
                statsdDef = args[++count];
            } else if (!args[count].equals("-v")) {
                if (args[count].equals("-host") && !hostDefined) {
                    host = args[++count];
                    hostDefined = true;
                } else if (args[count].equals("-r")) {
                    if (log.isDebugEnabled()) {
                        log.debug("reconnecting to an already active probe {}", (Object)resumeProbe);
                    }
                    resumeProbe = args[++count];
                    if (count < args.length - 2 && !args[count + 1].startsWith("-") && (probeCommand = args[++count].toLowerCase()).equalsIgnoreCase("event") && count < args.length - 2) {
                        probeCommandArg = args[++count];
                    }
                    if (probeCommand != null && log.isDebugEnabled()) {
                        log.debug("executing probe command '{}'{}", (Object)probeCommand, (Object)(probeCommandArg != null ? "(" + probeCommandArg + ")" : ""));
                    }
                } else if (args[count].equals("-lp")) {
                    log.debug("listing active probes");
                    listProbes = true;
                } else if (args[count].equals("-x")) {
                    log.debug("submitting probe in unattended mode");
                    unattended = true;
                } else {
                    Main.usage();
                }
            }
            if (++count >= args.length) break;
        }
        if (!portDefined && log.isDebugEnabled()) {
            log.debug("assuming default port {}", (Object)port);
        }
        if (!classpathDefined && log.isDebugEnabled()) {
            log.debug("assuming default classpath '{}'", (Object)classPath);
        }
        if (args.length < count + 1) {
            Main.usage();
        }
        if ((pid = JpsUtils.findVmByName(pidArg = args[count])) == null) {
            Main.errorExit("Unable to find JVM with either PID or name: " + pidArg, 1);
        } else {
            log.info("Attaching BTrace to PID: {}", (Object)pid);
        }
        try {
            Client client = new Client(port, OUTPUT_FILE, PROBE_DESC_PATH, DEBUG, TRACK_RETRANSFORM, TRUSTED, DUMP_CLASSES, DUMP_DIR, statsdDef);
            if (resumeProbe != null) {
                Main.registerExitHook(client);
                if (con != null) {
                    Main.registerSignalHandler(client);
                }
                client.reconnect(host, resumeProbe, Main.createCommandListener(client), new String[]{probeCommand, probeCommandArg});
            } else if (listProbes) {
                Main.registerExitHook(client);
                client.attach(pid.toString(), null, classPath);
                client.connectAndListProbes(host, Main.createCommandListener(client));
                System.exit(0);
            } else {
                byte[] code;
                String fileName = args[count + 1];
                String[] btraceArgs = new String[args.length - count - 2];
                if (btraceArgs.length > 0) {
                    System.arraycopy(args, count + 2, btraceArgs, 0, btraceArgs.length);
                }
                if (!new File(fileName).exists()) {
                    Main.errorExit("File not found: " + fileName, 1);
                }
                if ((code = client.compile(fileName, classPath, includePath)) == null) {
                    Main.errorExit("BTrace compilation failed", 1);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Boot classpath: {}", (Object)classPath);
                }
                if (!hostDefined) {
                    client.attach(pid.toString(), null, classPath);
                }
                Main.registerExitHook(client);
                if (con != null) {
                    Main.registerSignalHandler(client);
                }
                log.debug("submitting the BTrace program");
                CommandListener listener = Main.createCommandListener(client);
                boolean isUnattended = unattended;
                client.submit(host, fileName, code, btraceArgs, cmd -> {
                    if (isUnattended && cmd.getType() == 6 && ((StatusCommand)cmd).getFlag() == 1) {
                        client.sendDisconnect();
                    } else {
                        listener.onCommand(cmd);
                    }
                });
            }
        }
        catch (IOException exp) {
            Main.errorExit(exp.getMessage(), 1);
        }
    }

    private static CommandListener createCommandListener(Client client) {
        return cmd -> {
            byte type = cmd.getType();
            if (cmd instanceof PrintableCommand) {
                ((PrintableCommand)((Object)cmd)).print(out);
                out.flush();
            } else if (type == 2) {
                exiting = true;
                out.flush();
                ExitCommand ecmd = (ExitCommand)cmd;
                System.exit(ecmd.getExitCode());
            }
            if (type == 15) {
                System.exit(0);
            }
        };
    }

    private static void registerExitHook(Client client) {
        log.debug("registering shutdown hook");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!exiting) {
                try {
                    if (!client.isDisconnected()) {
                        log.debug("sending exit command");
                        client.sendExit(0);
                    } else {
                        log.debug("sending disconnect command");
                        client.sendDisconnect();
                    }
                }
                catch (IOException ioexp) {
                    log.debug(ioexp.toString(), ioexp);
                }
            }
        }));
    }

    private static void registerSignalHandler(Client client) {
        log.debug("registering signal handler for SIGINT");
        Signal.handle(new Signal("INT"), sig -> {
            try {
                con.printf("Please enter your option:\n", new Object[0]);
                con.printf("\t1. exit\n\t2. send an event\n\t3. send a named event\n\t4. flush console output\n\t5. list probes\n\t6. detach client\n", new Object[0]);
                con.flush();
                String option = con.readLine();
                if (option == null) {
                    return;
                }
                switch (option = option.trim()) {
                    case "1": {
                        System.exit(0);
                    }
                    case "2": {
                        log.debug("sending event command");
                        client.sendEvent();
                        break;
                    }
                    case "3": {
                        con.printf("Please enter the event name: ", new Object[0]);
                        String name = con.readLine();
                        if (name != null) {
                            log.debug("sending event command");
                            client.sendEvent(name);
                        }
                        break;
                    }
                    case "4": {
                        out.flush();
                        break;
                    }
                    case "5": {
                        client.listProbes();
                        break;
                    }
                    case "6": {
                        client.disconnect();
                        break;
                    }
                    default: {
                        con.printf("invalid option!\n", new Object[0]);
                        break;
                    }
                }
            }
            catch (IOException ioexp) {
                log.debug(ioexp.toString(), ioexp);
            }
        });
    }

    private static void usage() {
        System.err.println(Messages.get("btrace.usage"));
        System.exit(1);
    }

    private static boolean isDebug() {
        return DEBUG;
    }

    private static void errorExit(String msg, int code) {
        exiting = true;
        System.err.println(msg);
        System.exit(code);
    }

    static {
        DebugSupport.initLoggers(Boolean.getBoolean("com.sun.btrace.debug"), null);
        log = LoggerFactory.getLogger(Main.class);
        if (Main.isDebug()) {
            log.debug("btrace debug mode is set");
        }
        if (TRACK_RETRANSFORM = Boolean.getBoolean("com.sun.btrace.trackRetransforms")) {
            log.debug("trackRetransforms flag is set");
        }
        TRUSTED = Boolean.getBoolean("com.sun.btrace.unsafe");
        if (TRUSTED |= Boolean.getBoolean("com.sun.btrace.trusted")) {
            log.debug("btrace trusted mode is set");
        }
        if (DUMP_CLASSES = Boolean.getBoolean("com.sun.btrace.dumpClasses")) {
            log.debug("dumpClasses flag is set");
        }
        DUMP_DIR = System.getProperty("com.sun.btrace.dumpDir", ".");
        if (DUMP_CLASSES && log.isDebugEnabled()) {
            log.debug("dumpDir is {}", (Object)DUMP_DIR);
        }
        PROBE_DESC_PATH = System.getProperty("com.sun.btrace.probeDescPath", ".");
        con = System.console();
        out = Main.getOutWriter(con);
    }
}

