/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.client;

import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openjdk.btrace.compiler.Compiler;
import org.openjdk.btrace.core.SharedSettings;
import org.openjdk.btrace.core.annotations.DTrace;
import org.openjdk.btrace.core.annotations.DTraceRef;
import org.openjdk.btrace.core.comm.Command;
import org.openjdk.btrace.core.comm.CommandListener;
import org.openjdk.btrace.core.comm.DisconnectCommand;
import org.openjdk.btrace.core.comm.EventCommand;
import org.openjdk.btrace.core.comm.ExitCommand;
import org.openjdk.btrace.core.comm.InstrumentCommand;
import org.openjdk.btrace.core.comm.ListProbesCommand;
import org.openjdk.btrace.core.comm.MessageCommand;
import org.openjdk.btrace.core.comm.ReconnectCommand;
import org.openjdk.btrace.core.comm.SetSettingsCommand;
import org.openjdk.btrace.core.comm.StatusCommand;
import org.openjdk.btrace.core.comm.WireIO;
import org.openjdk.btrace.libs.org.objectweb.asm.AnnotationVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassReader;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Type;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;

public class Client {
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    private static final String DTRACE_DESC;
    private static final String DTRACE_REF_DESC;
    private static boolean dtraceEnabled;
    private static Method submitFile;
    private static Method submitString;
    private final int port;
    private final String outputFile;
    private final boolean debug;
    private final boolean trackRetransforms;
    private final boolean trusted;
    private final boolean dumpClasses;
    private final String dumpDir;
    private final String probeDescPath;
    private final String statsdDef;
    private volatile Socket sock;
    private volatile ObjectInputStream ois;
    private volatile ObjectOutputStream oos;
    private boolean disconnected = false;

    public Client(int port) {
        this(port, null, ".", false, false, false, false, null, null);
    }

    public Client(int port, String probeDescPath) {
        this(port, null, probeDescPath, false, false, false, false, null, null);
    }

    public Client(int port, String outputFile, String probeDescPath, boolean debug, boolean trackRetransforms, boolean trusted, boolean dumpClasses, String dumpDir, String statsdDef) {
        this.port = port;
        this.outputFile = outputFile;
        this.probeDescPath = probeDescPath;
        this.debug = debug;
        this.trusted = trusted;
        this.dumpClasses = dumpClasses;
        this.dumpDir = dumpDir;
        this.trackRetransforms = trackRetransforms;
        this.statsdDef = statsdDef;
    }

    private static boolean isPortAvailable(int port) {
        Socket clSocket = null;
        try {
            clSocket = new Socket("127.0.0.1", port);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (clSocket != null) {
            try {
                clSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public byte[] compile(String fileName, String classPath) {
        return this.compile(fileName, classPath, new PrintWriter(System.err), null);
    }

    public byte[] compile(String fileName, String classPath, String includePath) {
        return this.compile(fileName, classPath, new PrintWriter(System.err), includePath);
    }

    public byte[] compile(String fileName, String classPath, PrintWriter err) {
        return this.compile(fileName, classPath, err, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] compile(String fileName, String classPath, PrintWriter err, String includePath) {
        byte[] code = null;
        File file = new File(fileName);
        if (fileName.endsWith(".java")) {
            Map<String, byte[]> classes;
            Compiler compiler = new Compiler(includePath);
            classPath = classPath + File.pathSeparator + System.getProperty("java.class.path");
            if (log.isDebugEnabled()) {
                log.debug("compiling {}", (Object)fileName);
            }
            if ((classes = compiler.compile(file, (Writer)err, ".", classPath)) == null) {
                log.error("btrace compilation for script {} failed!", (Object)fileName);
                return null;
            }
            int size = classes.size();
            if (size != 1) {
                log.error("no classes or more than one class in script {}", (Object)fileName);
                return null;
            }
            String name = classes.keySet().iterator().next();
            code = classes.get(name);
            if (!log.isDebugEnabled()) return code;
            log.debug("compiled {}", (Object)fileName);
            return code;
        }
        if (fileName.endsWith(".class")) {
            int codeLen = (int)file.length();
            code = new byte[codeLen];
            try {
                if (log.isDebugEnabled()) {
                    log.debug("reading {}", (Object)fileName);
                }
                try (FileInputStream fis = new FileInputStream(file);){
                    int off = 0;
                    int len = 0;
                    do {
                        if ((len = fis.read(code, off, codeLen - off)) <= -1) continue;
                        off += len;
                    } while (off < codeLen && len != -1);
                }
                if (!log.isDebugEnabled()) return code;
                log.debug("read {}", (Object)fileName);
                return code;
            }
            catch (IOException exp) {
                err.println(exp.getMessage());
                return null;
            }
        }
        err.println("BTrace script has to be a .java or a .class");
        return null;
    }

    public void attach(String pid, String sysCp, String bootCp) throws IOException {
        try {
            String agentPath = "/btrace-agent.jar";
            URL btracePkg = Client.class.getClassLoader().getResource("org/openjdk/btrace/client");
            if (btracePkg != null) {
                String tmp = btracePkg.toString();
                tmp = tmp.substring(0, tmp.indexOf(33));
                tmp = tmp.substring("jar:".length(), tmp.lastIndexOf(47));
                agentPath = tmp + agentPath;
                agentPath = new File(new URI(agentPath)).getAbsolutePath();
                this.attach(pid, agentPath, sysCp, bootCp);
            } else {
                log.warn("Unable to prepare BTrace agent");
            }
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception exp) {
            throw new IOException(exp.getMessage());
        }
    }

    public void attach(String pid, String agentPath, String sysCp, String bootCp) throws IOException {
        try {
            Properties serverVmProps;
            int serverPort;
            VirtualMachine vm = null;
            if (log.isDebugEnabled()) {
                log.debug("attaching to {}", (Object)pid);
            }
            vm = VirtualMachine.attach(pid);
            if (log.isDebugEnabled()) {
                log.debug("checking port availability: {}", (Object)this.port);
            }
            if ((serverPort = Integer.parseInt((serverVmProps = vm.getSystemProperties()).getProperty("btrace.port", "-1"))) != -1) {
                if (serverPort != this.port) {
                    throw new IOException("Can not attach to PID " + pid + " on port " + this.port + ". There is already a BTrace server active on port " + serverPort + "!");
                }
            } else if (!Client.isPortAvailable(this.port)) {
                throw new IOException("Port " + this.port + " unavailable.");
            }
            if (log.isDebugEnabled()) {
                log.debug("attached to {}", (Object)pid);
                log.debug("loading {}", (Object)agentPath);
            }
            String agentArgs = "port=" + this.port;
            if (this.statsdDef != null) {
                agentArgs = agentArgs + ",statsd=" + this.statsdDef;
            }
            if (this.debug) {
                agentArgs = agentArgs + ",debug=true";
            }
            if (this.trusted) {
                agentArgs = agentArgs + ",trusted=true";
            }
            if (this.dumpClasses) {
                agentArgs = agentArgs + ",dumpClasses=true";
                agentArgs = agentArgs + ",dumpDir=" + this.dumpDir;
            }
            if (this.trackRetransforms) {
                agentArgs = agentArgs + ",trackRetransforms=true";
            }
            if (bootCp != null) {
                agentArgs = agentArgs + ",bootClassPath=" + bootCp;
            }
            String toolsPath = this.getToolsJarPath(serverVmProps.getProperty("java.class.path"), serverVmProps.getProperty("java.home"));
            sysCp = sysCp == null ? toolsPath : sysCp + File.pathSeparator + toolsPath;
            agentArgs = agentArgs + ",systemClassPath=" + sysCp;
            String cmdQueueLimit = System.getProperty("org.openjdk.btrace.core.cmdQueueLimit", null);
            if (cmdQueueLimit != null) {
                agentArgs = agentArgs + ",=cmdQueueLimit" + cmdQueueLimit;
            }
            agentArgs = agentArgs + ",probeDescPath=" + this.probeDescPath;
            if (log.isDebugEnabled()) {
                log.debug("agent args: {}", (Object)agentArgs);
            }
            vm.loadAgent(agentPath, agentArgs);
            if (log.isDebugEnabled()) {
                log.debug("loaded {}", (Object)agentPath);
            }
        }
        catch (IOException | RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new IOException(exp.getMessage());
        }
    }

    void connectAndListProbes(String host, CommandListener listener) throws IOException {
        if (this.sock != null) {
            throw new IllegalStateException();
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("opening socket to {}", (Object)this.port);
            }
            long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(5L, TimeUnit.SECONDS);
            while (this.sock == null && System.nanoTime() <= timeout) {
                try {
                    this.sock = new Socket(host, this.port);
                }
                catch (ConnectException e) {
                    log.debug("server not yet available; retrying ...");
                    Thread.sleep(20L);
                }
            }
            if (this.sock == null) {
                log.debug("server not available. exiting.");
                System.exit(1);
            }
            this.oos = new ObjectOutputStream(this.sock.getOutputStream());
            WireIO.write(this.oos, new ListProbesCommand());
            this.ois = new ObjectInputStream(this.sock.getInputStream());
            log.debug("entering into command loop");
            this.commandLoop(cmd -> {
                if (cmd.getType() == 14) {
                    listener.onCommand(cmd);
                    System.exit(0);
                } else {
                    listener.onCommand(cmd);
                }
            });
        }
        catch (UnknownHostException uhe) {
            throw new IOException(uhe);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    void reconnect(String host, final String resumeProbe, final CommandListener listener, final String[] command) throws IOException {
        if (this.sock != null) {
            throw new IllegalStateException();
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("opening socket to {}", (Object)this.port);
            }
            long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(5L, TimeUnit.SECONDS);
            while (this.sock == null && System.nanoTime() <= timeout) {
                try {
                    this.sock = new Socket(host, this.port);
                }
                catch (ConnectException e) {
                    log.debug("server not yet available; retrying ...");
                    Thread.sleep(20L);
                }
            }
            if (this.sock == null) {
                log.debug("server not available. exiting.");
                System.exit(1);
            }
            this.oos = new ObjectOutputStream(this.sock.getOutputStream());
            this.ois = new ObjectInputStream(this.sock.getInputStream());
            log.debug("reconnecting client {}", (Object)resumeProbe);
            WireIO.write(this.oos, new ReconnectCommand(resumeProbe));
            log.debug("entering into command loop");
            this.commandLoop(new CommandListener(){
                boolean statusReported = false;

                @Override
                public void onCommand(Command cmd) throws IOException {
                    if (this.statusReported || cmd.getType() != 6) {
                        listener.onCommand(cmd);
                    } else {
                        StatusCommand statusCommand = (StatusCommand)cmd;
                        if (statusCommand.getFlag() == 8) {
                            if (statusCommand.isSuccess()) {
                                log.info("Reconnected to an active probe: {}", (Object)resumeProbe);
                                String probeCommand = command[0];
                                String probeCommandArg = command[1];
                                if (probeCommand != null) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("Executing remote command '{}'{}", (Object)probeCommand, (Object)(probeCommandArg != null ? "(" + probeCommandArg + ")" : ""));
                                    }
                                    switch (probeCommand) {
                                        case "exit": {
                                            Client.this.sendExit();
                                            break;
                                        }
                                        case "event": {
                                            if (probeCommandArg == null || probeCommandArg.equals("*")) {
                                                Client.this.sendEvent();
                                            } else {
                                                Client.this.sendEvent(probeCommandArg);
                                            }
                                            Client.this.sendDisconnect();
                                            break;
                                        }
                                        default: {
                                            log.warn("Unrecognized BTrace command {}", (Object)probeCommand);
                                        }
                                    }
                                }
                            } else {
                                log.warn("Unable to reconnect to an active probe: {}", (Object)resumeProbe);
                                System.exit(1);
                            }
                        } else {
                            listener.onCommand(cmd);
                        }
                        this.statusReported = true;
                    }
                }
            });
        }
        catch (UnknownHostException uhe) {
            throw new IOException(uhe);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void submit(String fileName, byte[] code, String[] args, CommandListener listener) throws IOException {
        this.submit("localhost", fileName, code, args, listener);
    }

    public void submit(String host, final String fileName, byte[] code, String[] args, final CommandListener listener) throws IOException {
        if (this.sock != null) {
            throw new IllegalStateException();
        }
        this.submitDTrace(fileName, code, args, listener);
        try {
            if (log.isDebugEnabled()) {
                log.debug("opening socket to {}", (Object)this.port);
            }
            long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(5L, TimeUnit.SECONDS);
            while (this.sock == null && System.nanoTime() <= timeout) {
                try {
                    this.sock = new Socket(host, this.port);
                }
                catch (ConnectException e) {
                    log.debug("server not yet available; retrying ...");
                    Thread.sleep(20L);
                }
            }
            if (this.sock == null) {
                log.debug("server not available. exiting.");
                System.exit(1);
            }
            this.oos = new ObjectOutputStream(this.sock.getOutputStream());
            log.debug("setting up client settings");
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("debug", this.debug);
            settings.put("dumpDir", this.dumpClasses ? this.dumpDir : "");
            settings.put("trackRetransforms", this.trackRetransforms);
            settings.put("trusted", this.trusted);
            settings.put("probeDescPath", this.probeDescPath);
            settings.put("scriptOutputFile", this.outputFile);
            WireIO.write(this.oos, new SetSettingsCommand(settings));
            this.ois = new ObjectInputStream(this.sock.getInputStream());
            if (log.isDebugEnabled()) {
                log.debug("sending instrument command: {}", (Object)Arrays.deepToString(args));
            }
            SharedSettings sSettings = new SharedSettings();
            sSettings.from(settings);
            WireIO.write(this.oos, new InstrumentCommand(code, args));
            log.debug("entering into command loop");
            this.commandLoop(new CommandListener(){
                boolean statusReported = false;

                @Override
                public void onCommand(Command cmd) throws IOException {
                    if (this.statusReported || cmd.getType() != 6) {
                        listener.onCommand(cmd);
                    } else {
                        StatusCommand statusCommand = (StatusCommand)cmd;
                        if (statusCommand.getFlag() == 1) {
                            if (statusCommand.isSuccess()) {
                                log.info("Successfully started BTrace probe: {}", (Object)fileName);
                            } else {
                                log.warn("Failed to start BTrace probe: {}", (Object)fileName);
                                System.exit(1);
                            }
                            this.statusReported = true;
                        } else {
                            listener.onCommand(cmd);
                        }
                    }
                }
            });
        }
        catch (UnknownHostException uhe) {
            throw new IOException(uhe);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void submit(byte[] code, String[] args, CommandListener listener) throws IOException {
        this.submit(null, code, args, listener);
    }

    public void sendExit() throws IOException {
        this.sendExit(0);
    }

    public void sendExit(int code) throws IOException {
        this.send(new ExitCommand(code));
    }

    public void sendDisconnect() throws IOException {
        this.send(new DisconnectCommand());
    }

    public void sendEvent() throws IOException {
        this.sendEvent("");
    }

    public void sendEvent(String name) throws IOException {
        this.send(new EventCommand(name));
    }

    public synchronized void close() throws IOException {
        if (this.ois != null) {
            this.ois.close();
        }
        if (this.oos != null) {
            this.oos.close();
        }
        if (this.sock != null) {
            this.sock.close();
        }
        this.reset();
    }

    boolean isDisconnected() {
        return this.disconnected;
    }

    void disconnect() throws IOException {
        this.disconnected = true;
        this.sendDisconnect();
    }

    void listProbes() throws IOException {
        this.send(new ListProbesCommand());
    }

    private void reset() {
        this.sock = null;
        this.ois = null;
        this.oos = null;
    }

    private String getToolsJarPath(String javaClassPath, String javaHome) {
        int homeIndex;
        String[] components;
        for (String c : components = javaClassPath.split(File.pathSeparator)) {
            if (c.endsWith("tools.jar")) {
                return new File(c).getAbsolutePath();
            }
            if (!c.endsWith("classes.jar")) continue;
            return new File(c).getAbsolutePath();
        }
        if (System.getProperty("os.name").startsWith("Mac") && (homeIndex = javaHome.indexOf("/Home")) > -1) {
            String java_mac_home = javaHome.substring(0, javaHome.indexOf("/Home"));
            return java_mac_home + "/Home/lib/tools.jar";
        }
        return javaHome + (javaHome.contains("/jre") ? "/.." : "") + "/lib/tools.jar";
    }

    private void send(Command cmd) throws IOException {
        if (this.oos == null) {
            throw new IllegalStateException();
        }
        this.oos.reset();
        WireIO.write(this.oos, cmd);
    }

    private void commandLoop(CommandListener listener) throws IOException {
        assert (this.ois != null) : "null input stream?";
        AtomicBoolean exited = new AtomicBoolean(false);
        while (true) {
            try {
                Command cmd;
                do {
                    cmd = WireIO.read(this.ois);
                    if (log.isDebugEnabled()) {
                        log.debug("received command {}", (Object)cmd);
                    }
                    listener.onCommand(cmd);
                } while (cmd.getType() != 2);
                log.debug("received EXIT cmd");
                return;
            }
            catch (IOException e) {
                if (exited.compareAndSet(false, true)) {
                    listener.onCommand(new ExitCommand(-1));
                }
                throw e;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                if (!exited.compareAndSet(false, true)) continue;
                listener.onCommand(new ExitCommand(-1));
                continue;
            }
            break;
        }
    }

    private void warn(CommandListener listener, String msg) {
        block2: {
            try {
                msg = "WARNING: " + msg + "\n";
                listener.onCommand(new MessageCommand(msg));
            }
            catch (IOException exp) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Failed to send warning messge", exp);
            }
        }
    }

    private void submitDTrace(String fileName, byte[] code, String[] args, CommandListener listener) {
        if (fileName == null || code == null) {
            return;
        }
        Object dtraceSrc = this.getDTraceSource(fileName, code);
        try {
            if (dtraceSrc instanceof String) {
                if (dtraceEnabled) {
                    submitString.invoke(null, dtraceSrc, args, listener);
                } else {
                    this.warn(listener, "@DTrace is supported only on Solaris 11+");
                }
            } else if (dtraceSrc instanceof File) {
                if (dtraceEnabled) {
                    submitFile.invoke(null, dtraceSrc, args, listener);
                } else {
                    this.warn(listener, "@DTraceRef is supported only on Solaris 11+");
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException iace) {
            iace.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite.getTargetException());
        }
    }

    private Object getDTraceSource(final String fileName, byte[] code) {
        if (Client.isPersistedProbe(code)) {
            return null;
        }
        ClassReader reader = new ClassReader(code);
        final Object[] result = new Object[1];
        reader.accept(new ClassVisitor(589824){

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean vis) {
                if (desc.equals(DTRACE_DESC)) {
                    return new AnnotationVisitor(589824){

                        @Override
                        public void visit(String name, Object value) {
                            if (name.equals("value")) {
                                result[0] = value;
                            }
                        }
                    };
                }
                if (desc.equals(DTRACE_REF_DESC)) {
                    return new AnnotationVisitor(589824){

                        @Override
                        public void visit(String name, Object value) {
                            if (name.equals("value")) {
                                String tmp = value.toString();
                                File file = new File(tmp);
                                if (file.isAbsolute()) {
                                    result[0] = file;
                                } else {
                                    int index = fileName.lastIndexOf(File.separatorChar);
                                    String dir = index == -1 ? "." : fileName.substring(0, index);
                                    result[0] = new File(dir, tmp);
                                }
                            }
                        }
                    };
                }
                return super.visitAnnotation(desc, vis);
            }
        }, 1);
        return result[0];
    }

    private static boolean isPersistedProbe(byte[] code) {
        return code[0] == -70 && code[1] == -50 && code[2] == -54 && code[3] == -54;
    }

    static {
        try {
            Class<?> dtraceConsumerClass = Class.forName("org.opensolaris.os.dtrace.Consumer");
            Class<?> dtraceClass = Class.forName("com.sun.btrace.dtrace.DTrace");
            dtraceEnabled = true;
            submitFile = dtraceClass.getMethod("submit", File.class, String[].class, CommandListener.class);
            submitString = dtraceClass.getMethod("submit", String.class, String[].class, CommandListener.class);
        }
        catch (Exception exp) {
            dtraceEnabled = false;
        }
        DTRACE_DESC = Type.getDescriptor(DTrace.class);
        DTRACE_REF_DESC = Type.getDescriptor(DTraceRef.class);
    }
}

