/*
 * Decompiled with CFR 0.152.
 */
package io.keploy.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utility {
    private static final Logger logger = LogManager.getLogger(Utility.class);
    private static final String CROSS = new String(Character.toChars(10060));
    private static final String WARN = "\u26a0\ufe0f";

    public static String getFileNameFromHeader(String header) {
        String fileName = "";
        String regex = ".*filename=(.*)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(header);
        if (matcher.matches()) {
            fileName = matcher.group(1);
            fileName = fileName.replaceAll("\"", "");
        }
        return fileName;
    }

    public static String lastFileNameFromDirectory(String path) {
        File dir = new File(path = path.trim());
        Object[] files = dir.listFiles();
        if (files == null) {
            logger.error(CROSS + " no directory found at location:" + path);
            return null;
        }
        if (files.length > 0) {
            Arrays.sort(files);
            Object lastFile = files[files.length - 1];
            String fileName = ((File)lastFile).getName();
            logger.debug("last file of directory {}: {}", (Object)path, (Object)fileName);
            return fileName;
        }
        return "";
    }

    public static String getFileNameFromPath(String filePath) {
        if (filePath.isEmpty()) {
            return "";
        }
        filePath = filePath.trim();
        String[] pathSplit = filePath.split("/");
        String fileName = pathSplit[pathSplit.length - 1];
        return fileName;
    }

    public static String getFileExtensionFromPath(String filePath) {
        String fileName = Utility.getFileNameFromPath(filePath);
        String[] split = fileName.split("\\.");
        String ext = split[split.length - 1];
        if (split.length == 1) {
            logger.error("no file found at location:" + fileName);
            return "";
        }
        return ext;
    }

    public static String resolveFileName(String folderPath) {
        folderPath = folderPath.trim();
        ArrayList<String> assets = new ArrayList<String>();
        File dir = new File(folderPath);
        File[] files = dir.listFiles();
        if (files == null) {
            logger.warn("\u26a0\ufe0f no directory found at location:{}", (Object)folderPath);
            logger.warn("\u26a0\ufe0f hence saving in the current user directory");
            return System.getProperty("user.dir") + "/asset-1";
        }
        if (files.length == 0) {
            return folderPath + "/asset-1";
        }
        for (File file : files) {
            boolean isPresent = file.getName().contains("asset-");
            if (!isPresent) continue;
            assets.add(file.getName());
        }
        Collections.sort(assets);
        String lastFileName = (String)assets.get(assets.size() - 1);
        if (lastFileName != null && !lastFileName.isEmpty()) {
            String ext = Utility.getFileExtensionFromPath(lastFileName);
            int idx = lastFileName.indexOf("." + ext);
            if (idx == -1) {
                logger.debug("no extension found in last file");
                return folderPath + "/asset-0";
            }
            boolean digit = Character.isDigit((lastFileName = lastFileName.substring(0, idx)).charAt(lastFileName.length() - 1));
            if (digit) {
                int lastFileCount = Character.getNumericValue(lastFileName.charAt(lastFileName.length() - 1)) + 1;
                return folderPath + "/asset-" + lastFileCount;
            }
            return folderPath + "/asset-1";
        }
        if (lastFileName != null) {
            return folderPath + "/asset-1";
        }
        return folderPath + "/asset-0";
    }

    public static void createFolder(String folderPath) {
        File folder = new File(folderPath);
        if (!folder.exists()) {
            boolean result = folder.mkdir();
            if (!result) {
                logger.debug("trying again to create a directory at path: {}", (Object)folderPath);
                result = folder.mkdirs();
            }
            if (result) {
                logger.debug("new folder created:");
            } else {
                String WARN = WARN;
                logger.warn(WARN + " failed to create assets directory, thus saving files in user directory");
                folderPath = System.getProperty("user.dir");
            }
        } else {
            logger.debug("directory already exists");
        }
    }
}

