/*
 * Decompiled with CFR 0.152.
 */
package io.keploy.ksql;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ProtocolStringList;
import io.keploy.grpc.stubs.Service;
import io.keploy.ksql.KConnection;
import io.keploy.ksql.KDriver;
import io.keploy.ksql.KResultSetMetaData;
import io.keploy.ksql.KStatement;
import io.keploy.regression.Mode;
import io.keploy.regression.context.Context;
import io.keploy.regression.context.Kcontext;
import io.keploy.utils.ProcessSQL;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KResultSet
implements ResultSet {
    ResultSet wrappedResultSet;
    static HashMap<String, String> meta = new HashMap();
    private List<Service.SqlCol> sqlColList;
    private Set<Service.SqlCol> colExists;
    private Map<String, String> TestRow = new HashMap<String, String>();
    public List<Map<String, String>> preTable = new ArrayList<Map<String, String>>();
    List<String> cols = new ArrayList<String>();
    List<String> tableRows = new ArrayList<String>();
    static final String msg1 = "Method";
    static final String msg2 = "not supported yet , If you see such warning Please create an issue on Keploy ";
    private Map<String, String> RowRecord = new HashMap<String, String>();
    private static final Logger logger = LogManager.getLogger(KResultSet.class);
    private static final String CROSS = new String(Character.toChars(10060));
    private Service.Table TableData = null;
    boolean select = false;
    boolean wasNull = true;
    private int index = 0;
    private String currentLabel = "";
    public static int commited = 0;

    public KResultSet(ResultSet rs) {
        if (Objects.equals(KDriver.DriverName, "org.h2.Driver")) {
            logger.debug("starting test connection for H2 ");
            KDriver.mode = KDriver.testMode;
        }
        this.sqlColList = new ArrayList<Service.SqlCol>();
        KResultSetMetaData.PrecisionDict = new HashMap();
        KResultSetMetaData.ScaleDict = new HashMap();
        this.colExists = new HashSet<Service.SqlCol>();
        this.preTable = new ArrayList<Map<String, String>>();
        this.RowRecord = new HashMap<String, String>();
        this.cols = new ArrayList<String>();
        this.tableRows = new ArrayList<String>();
        meta.clear();
        this.wrappedResultSet = rs;
    }

    public KResultSet(boolean rs) {
    }

    public KResultSet() {
        if (Objects.equals(KDriver.DriverName, "org.h2.Driver")) {
            logger.info("starting test connection for H2 ");
            KDriver.mode = KDriver.testMode;
        }
        this.sqlColList = new ArrayList<Service.SqlCol>();
        this.colExists = new HashSet<Service.SqlCol>();
        this.preTable = new ArrayList<Map<String, String>>();
        this.RowRecord = new HashMap<String, String>();
        this.cols = new ArrayList<String>();
        this.tableRows = new ArrayList<String>();
        Kcontext kctx = Context.getCtx();
        meta.clear();
        if (kctx != null) {
            this.wrappedResultSet = new KResultSet(true);
        }
    }

    private void addSqlColToList(String colName, String colType) {
        Service.SqlCol sqlCol = Service.SqlCol.newBuilder().setName(colName).setType(colType).build();
        boolean exist = this.colExists.contains(sqlCol);
        if (!exist) {
            this.sqlColList.add(sqlCol);
            this.colExists.add(sqlCol);
        }
    }

    private void addRows() {
        if (this.RowRecord.size() != 0) {
            this.preTable.add(this.RowRecord);
        }
        this.RowRecord = new HashMap<String, String>();
    }

    void extractTable(int cnt) {
        if (cnt == 0) {
            Kcontext kctx = Context.getCtx();
            if (kctx.getMock().size() <= 0) {
                logger.info(CROSS + " Cannot extract tables during test because mocks are unavailable ! \n");
            } else {
                List<Service.Mock> mock = kctx.getMock();
                if (mock.size() > 0 && mock.get(0).getKind().equals("SQL") && mock.get(0).getSpec().getMetadataMap().size() > 0) {
                    meta = ProcessSQL.convertMap(mock.get(0).getSpec().getMetadataMap());
                }
                Service.Table testTable = null;
                try {
                    testTable = ProcessSQL.ProcessDep(null, null, 0);
                }
                catch (InvalidProtocolBufferException var6) {
                    logger.info(CROSS + " Unable to extract tables during test \n" + var6);
                }
                this.TableData = testTable;
                if (this.TableData != null) {
                    this.GetPreAndScale();
                }
            }
        }
    }

    private boolean extractRows() {
        if (this.index == 0) {
            this.extractTable(this.index);
        }
        if (this.TableData == null) {
            return false;
        }
        ProtocolStringList rows = this.TableData.getRowsList();
        if (this.index == rows.size()) {
            return false;
        }
        String s2 = (String)rows.get(this.index);
        StringBuilder row = new StringBuilder(s2);
        for (int i = 0; i < row.length(); ++i) {
            if (row.charAt(i) != '`') continue;
            row.deleteCharAt(i);
        }
        String[] split = row.substring(1, row.length() - 1).split("\\|");
        this.TestRow.clear();
        for (int i = 0; i < split.length; ++i) {
            Service.SqlCol col = this.TableData.getCols(i);
            if (Objects.equals(split[i], "NA")) continue;
            this.TestRow.put(col.getName(), split[i]);
        }
        logger.debug("ROW-DATA:" + this.TestRow);
        return true;
    }

    @Override
    public boolean next() {
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                try {
                    return this.wrappedResultSet.next();
                }
                catch (SQLException e) {
                    logger.error(CROSS + " Unable to move sql cursor during next" + e);
                }
            }
            return false;
        }
        boolean hasNext = false;
        switch (KDriver.mode) {
            case MODE_TEST: {
                hasNext = this.extractRows();
                ++this.index;
                break;
            }
            case MODE_RECORD: {
                try {
                    hasNext = this.wrappedResultSet.next();
                }
                catch (SQLException e) {
                    logger.error(CROSS + " Unable to move sql cursor during next" + e);
                }
                this.addRows();
                if (hasNext) break;
                this.select = true;
                Service.Table.Builder tableBuilder = Service.Table.newBuilder();
                this.sqlColList = this.SetPreAndScale();
                logger.debug("sqlColList : " + this.sqlColList);
                tableBuilder.addAllCols(this.sqlColList);
                this.cols = ProcessSQL.toColumnList(this.sqlColList);
                logger.debug("cols : " + this.cols);
                this.tableRows = ProcessSQL.toRowList(this.preTable, this.cols);
                tableBuilder.addAllRows(this.tableRows);
                Service.Table table = tableBuilder.build();
                logger.debug("table : " + table);
                try {
                    meta.put("method", "next()");
                    meta.put("SQL-Query", KConnection.MyQuery);
                    ProcessSQL.ProcessDep(meta, table, commited);
                    commited = 0;
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                System.out.println("integrations: Not in a valid sdk mode");
            }
        }
        return hasNext;
    }

    @Override
    public void close() throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                this.wrappedResultSet.close();
            }
            return;
        }
        if (KDriver.mode == KDriver.testMode) {
            return;
        }
        if (!this.select) {
            this.addRows();
            Service.Table.Builder tableBuilder = Service.Table.newBuilder();
            this.sqlColList = this.SetPreAndScale();
            logger.debug("sqlColList : " + this.sqlColList);
            tableBuilder.addAllCols(this.sqlColList);
            this.cols = ProcessSQL.toColumnList(this.sqlColList);
            logger.debug("cols : " + this.cols);
            this.tableRows = ProcessSQL.toRowList(this.preTable, this.cols);
            tableBuilder.addAllRows(this.tableRows);
            Service.Table table = tableBuilder.build();
            logger.debug("table : " + table);
            try {
                meta.put("method", "close()");
                ProcessSQL.ProcessDep(meta, table, commited);
                commited = 0;
                meta.put("SQL-Query", KConnection.MyQuery);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }
        this.wrappedResultSet.close();
    }

    @Override
    public boolean wasNull() throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                return this.wrappedResultSet.wasNull();
            }
            return false;
        }
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            logger.debug("WasNull value is " + this.wasNull);
            return this.wasNull;
        }
        this.wasNull = this.wrappedResultSet.wasNull();
        if (this.wasNull && this.RowRecord.containsKey(this.currentLabel) && !this.RowRecord.get(this.currentLabel).equals("Null")) {
            this.RowRecord.put(this.currentLabel, "Null");
            this.currentLabel = "";
        }
        logger.debug("WasNull value is " + this.wasNull);
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        String gs;
        Kcontext kctx = Context.getCtx();
        String columnlabel = String.valueOf(columnIndex);
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            this.wasNull = false;
            String gs2 = this.TestRow.get(columnlabel);
            if (this.TestRow.get(columnlabel) == null || Objects.equals(gs2, "Null")) {
                this.wasNull = true;
                return null;
            }
            return gs2;
        }
        String res = null;
        this.currentLabel = columnlabel;
        res = gs = this.wrappedResultSet.getString(columnIndex);
        if (this.isNullValue(gs)) {
            res = "Null";
        }
        this.RowRecord.put(columnlabel, res);
        this.addSqlColToList(String.valueOf(columnIndex), "String");
        return gs;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            this.wasNull = false;
            if (this.TestRow.get(String.valueOf(columnIndex)) == null || Objects.equals(this.TestRow.get(String.valueOf(columnIndex)), "Null")) {
                this.wasNull = true;
                return false;
            }
            return Boolean.parseBoolean(this.TestRow.get(String.valueOf(columnIndex)));
        }
        Boolean gb = this.wrappedResultSet.getBoolean(columnIndex);
        this.RowRecord.put(String.valueOf(columnIndex), String.valueOf(gb));
        this.addSqlColToList(String.valueOf(columnIndex), gb.getClass().getSimpleName());
        return gb;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(String.valueOf(columnIndex)) == null || Objects.equals(this.TestRow.get(String.valueOf(columnIndex)), "Null")) {
                this.wasNull = true;
                return 0;
            }
            this.wasNull = false;
            return Byte.parseByte(this.TestRow.get(String.valueOf(columnIndex)));
        }
        Byte gb = this.wrappedResultSet.getByte(columnIndex);
        this.RowRecord.put(String.valueOf(columnIndex), String.valueOf(gb));
        this.addSqlColToList(String.valueOf(columnIndex), gb.getClass().getSimpleName());
        return gb;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Kcontext kctx = Context.getCtx();
        String columnLabel = String.valueOf(columnIndex);
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                return 0;
            }
            this.wasNull = false;
            return Short.parseShort(this.TestRow.get(columnLabel));
        }
        this.currentLabel = columnLabel;
        Short gs = this.wrappedResultSet.getShort(columnIndex);
        this.RowRecord.put(columnLabel, String.valueOf(gs));
        this.addSqlColToList(columnLabel, gs.getClass().getSimpleName());
        return gs;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Kcontext kctx = Context.getCtx();
        String columnLabel = String.valueOf(columnIndex);
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                return this.wrappedResultSet.getInt(columnIndex);
            }
            return 0;
        }
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                return 0;
            }
            this.wasNull = false;
            return Integer.parseInt(this.TestRow.get(String.valueOf(columnIndex)));
        }
        this.currentLabel = columnLabel;
        Integer gs = this.wrappedResultSet.getInt(columnIndex);
        this.RowRecord.put(String.valueOf(columnIndex), String.valueOf(gs));
        this.addSqlColToList(String.valueOf(columnIndex), gs.getClass().getSimpleName());
        return gs;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Kcontext kctx = Context.getCtx();
        String columnLabel = String.valueOf(columnIndex);
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                return this.wrappedResultSet.getLong(columnIndex);
            }
            return 0L;
        }
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                logger.debug("getLong wasNull for column " + columnLabel);
                this.wasNull = true;
                return 0L;
            }
            this.wasNull = false;
            logger.debug("getLong value is " + this.TestRow.get(columnLabel));
            return Long.parseLong(this.TestRow.get(columnLabel));
        }
        this.currentLabel = columnLabel;
        Long gs = this.wrappedResultSet.getLong(columnIndex);
        this.RowRecord.put(columnLabel, String.valueOf(gs));
        this.addSqlColToList(columnLabel, gs.getClass().getSimpleName());
        return gs;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Kcontext kctx = Context.getCtx();
        String columnLabel = String.valueOf(columnIndex);
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                return 0.0f;
            }
            this.wasNull = false;
            return Float.parseFloat(columnLabel);
        }
        Float gs = Float.valueOf(this.wrappedResultSet.getFloat(columnIndex));
        this.RowRecord.put(String.valueOf(columnIndex), String.valueOf(gs));
        this.addSqlColToList(String.valueOf(columnIndex), gs.getClass().getSimpleName());
        return gs.floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Kcontext kctx = Context.getCtx();
        String columnLabel = String.valueOf(columnIndex);
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                return 0.0;
            }
            this.wasNull = false;
            return Double.parseDouble(this.TestRow.get(String.valueOf(columnIndex)));
        }
        this.currentLabel = columnLabel;
        Double gs = this.wrappedResultSet.getDouble(columnIndex);
        this.RowRecord.put(String.valueOf(columnIndex), String.valueOf(gs));
        this.addSqlColToList(String.valueOf(columnIndex), gs.getClass().getSimpleName());
        return gs;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(String.valueOf(columnIndex)) == null || Objects.equals(this.TestRow.get(String.valueOf(columnIndex)), "Null")) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            return new BigDecimal(Double.parseDouble(this.TestRow.get(String.valueOf(columnIndex))));
        }
        BigDecimal gl = this.wrappedResultSet.getBigDecimal(String.valueOf(columnIndex));
        String res = String.valueOf(gl);
        if (this.isNullValue(gl)) {
            res = "Null";
        }
        this.RowRecord.put(String.valueOf(columnIndex), res);
        this.addSqlColToList(String.valueOf(columnIndex), "BigDecimal");
        return gl;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Kcontext kctx = Context.getCtx();
        String columnLabel = String.valueOf(columnIndex);
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            return this.TestRow.get(columnLabel).getBytes();
        }
        byte[] gs = this.wrappedResultSet.getBytes(columnIndex);
        this.RowRecord.put(columnLabel, String.valueOf(gs));
        this.addSqlColToList(columnLabel, gs.getClass().getSimpleName());
        return gs;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        String columnLabel = String.valueOf(columnIndex);
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                return this.wrappedResultSet.getDate(columnIndex);
            }
            return null;
        }
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            this.wasNull = false;
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(String.valueOf(columnIndex)), "Null")) {
                this.wasNull = true;
                return null;
            }
            String parseDateTime = this.ParseDateTime(this.TestRow.get(String.valueOf(columnIndex)));
            if (Objects.equals(parseDateTime, "") || parseDateTime == null) {
                this.wasNull = true;
                return null;
            }
            SimpleDateFormat formatter = new SimpleDateFormat(parseDateTime);
            try {
                Date x = new Date(formatter.parse(this.TestRow.get(String.valueOf(columnIndex))).getTime());
                return x;
            }
            catch (ParseException e) {
                logger.error(CROSS + "Failed to parse Date object from the stored mock due to \n" + e);
            }
        }
        this.currentLabel = columnLabel;
        Date gd = this.wrappedResultSet.getDate(columnIndex);
        String res = String.valueOf(gd);
        if (this.isNullValue(gd)) {
            res = "Null";
        }
        this.RowRecord.put(String.valueOf(columnIndex), res);
        this.addSqlColToList(String.valueOf(columnIndex), "Date");
        return gd;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        String columnLabel = String.valueOf(columnIndex);
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                return this.wrappedResultSet.getTime(columnIndex);
            }
            return null;
        }
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            this.wasNull = false;
            String parseDateTime = this.ParseDateTime(this.TestRow.get(String.valueOf(columnIndex)));
            if (this.TestRow.get(columnLabel) == null || Objects.equals(parseDateTime, "") || parseDateTime == null) {
                this.wasNull = true;
                return null;
            }
            SimpleDateFormat formatter = new SimpleDateFormat(parseDateTime);
            try {
                return new Time(formatter.parse(this.TestRow.get(String.valueOf(columnIndex))).getTime());
            }
            catch (ParseException e) {
                logger.error(CROSS + "Failed to parse Time object from the stored mock due to \n" + e);
            }
        }
        this.currentLabel = columnLabel;
        Time gt = this.wrappedResultSet.getTime(columnIndex);
        String res = String.valueOf(gt);
        if (this.isNullValue(gt)) {
            res = "Null";
        }
        this.RowRecord.put(String.valueOf(columnIndex), res);
        this.addSqlColToList(String.valueOf(columnIndex), "Time");
        return gt;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        String columnLabel = String.valueOf(columnIndex);
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                return this.wrappedResultSet.getTimestamp(columnIndex);
            }
            return null;
        }
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            this.wasNull = false;
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(String.valueOf(columnIndex)), "Null")) {
                this.wasNull = true;
                return null;
            }
            String parseDateTime = this.ParseDateTime(this.TestRow.get(String.valueOf(columnIndex)));
            if (Objects.equals(parseDateTime, "") || parseDateTime == null) {
                this.wasNull = true;
                return null;
            }
            SimpleDateFormat formatter = new SimpleDateFormat(parseDateTime);
            try {
                return new Timestamp(formatter.parse(this.TestRow.get(String.valueOf(columnIndex))).getTime());
            }
            catch (ParseException e) {
                logger.error(CROSS + "Failed to parse TimeStamp object from the stored mock due to \n" + e);
            }
        }
        this.currentLabel = columnLabel;
        Timestamp gts = this.wrappedResultSet.getTimestamp(columnIndex);
        String res = String.valueOf(gts);
        if (this.isNullValue(gts)) {
            res = "Null";
        }
        this.RowRecord.put(String.valueOf(columnIndex), res);
        this.addSqlColToList(String.valueOf(columnIndex), "Timestamp");
        return gts;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        logger.warn("{} InputStream getAsciiStream(int columnIndex) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getAsciiStream(columnIndex);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        logger.warn("{} InputStream getUnicodeStream(int columnIndex) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        logger.warn("{} InputStream getBinaryStream(int columnIndex) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getBinaryStream(columnIndex);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        String gs;
        Kcontext kctx = Context.getCtx();
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            this.wasNull = false;
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                return null;
            }
            return this.TestRow.get(columnLabel);
        }
        this.currentLabel = columnLabel;
        String res = gs = this.wrappedResultSet.getString(columnLabel);
        if (this.isNullValue(gs)) {
            res = "Null";
        }
        this.RowRecord.put(columnLabel, res);
        this.addSqlColToList(columnLabel, "String");
        return gs;
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                return false;
            }
            this.wasNull = false;
            return Boolean.parseBoolean(this.TestRow.get(columnLabel));
        }
        Boolean gb = this.wrappedResultSet.getBoolean(columnLabel);
        this.RowRecord.put(columnLabel, String.valueOf(gb));
        this.addSqlColToList(columnLabel, gb.getClass().getSimpleName());
        return gb;
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                return 0;
            }
            this.wasNull = false;
            return Byte.parseByte(this.TestRow.get(columnLabel));
        }
        Byte gb = this.wrappedResultSet.getByte(columnLabel);
        this.RowRecord.put(columnLabel, String.valueOf(gb));
        this.addSqlColToList(columnLabel, gb.getClass().getSimpleName());
        return gb;
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                return 0;
            }
            this.wasNull = false;
            return Short.parseShort(this.TestRow.get(columnLabel));
        }
        Short gs = this.wrappedResultSet.getShort(columnLabel);
        this.RowRecord.put(columnLabel, String.valueOf(gs));
        this.addSqlColToList(columnLabel, gs.getClass().getSimpleName());
        return gs;
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                return this.wrappedResultSet.getInt(columnLabel);
            }
            return 0;
        }
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                return 0;
            }
            this.wasNull = false;
            int x = Integer.parseInt(this.TestRow.get(columnLabel));
            return x;
        }
        this.currentLabel = columnLabel;
        Integer gs = this.wrappedResultSet.getInt(columnLabel);
        this.RowRecord.put(columnLabel, String.valueOf(gs));
        this.addSqlColToList(columnLabel, gs.getClass().getSimpleName());
        return gs;
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                return this.wrappedResultSet.getLong(columnLabel);
            }
            return 0L;
        }
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                logger.debug("getLong wasNull for {}", (Object)columnLabel);
                return 0L;
            }
            this.wasNull = false;
            long x = Long.parseLong(this.TestRow.get(columnLabel));
            logger.debug("getLong value is {} for column {}", (Object)x, (Object)columnLabel);
            return x;
        }
        this.currentLabel = columnLabel;
        Long gl = this.wrappedResultSet.getLong(columnLabel);
        this.RowRecord.put(columnLabel, String.valueOf(gl));
        this.addSqlColToList(columnLabel, gl.getClass().getSimpleName());
        return gl;
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                logger.debug("getFloat wasNull for {}", (Object)columnLabel);
                return 0.0f;
            }
            this.wasNull = false;
            logger.debug("getFloat value is {} for column {}", (Object)this.TestRow.get(columnLabel), (Object)columnLabel);
            return Float.parseFloat(this.TestRow.get(columnLabel));
        }
        this.currentLabel = columnLabel;
        Float gf = Float.valueOf(this.wrappedResultSet.getFloat(columnLabel));
        this.RowRecord.put(columnLabel, String.valueOf(gf));
        this.addSqlColToList(columnLabel, gf.getClass().getSimpleName());
        return gf.floatValue();
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                logger.debug("getDouble wasNull for {}", (Object)columnLabel);
                return 0.0;
            }
            this.wasNull = false;
            logger.debug("getDouble value is {} for column {}", (Object)this.TestRow.get(columnLabel), (Object)columnLabel);
            return Double.parseDouble(this.TestRow.get(columnLabel));
        }
        this.currentLabel = columnLabel;
        Double gd = this.wrappedResultSet.getDouble(columnLabel);
        this.RowRecord.put(columnLabel, String.valueOf(gd));
        this.addSqlColToList(columnLabel, gd.getClass().getSimpleName());
        return gd;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                logger.debug("getBigDecimal wasNull for {}", (Object)columnLabel);
                return null;
            }
            this.wasNull = false;
            logger.debug("getBigDecimal value is {} for column {}", (Object)this.TestRow.get(columnLabel), (Object)columnLabel);
            return new BigDecimal(Double.parseDouble(this.TestRow.get(columnLabel)));
        }
        this.currentLabel = columnLabel;
        BigDecimal gl = this.wrappedResultSet.getBigDecimal(columnLabel);
        String res = String.valueOf(gl);
        if (this.isNullValue(gl)) {
            res = "Null";
        }
        this.RowRecord.put(columnLabel, res);
        this.addSqlColToList(columnLabel, "BigDecimal");
        return gl;
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                logger.debug("getBytes wasNull for {}", (Object)columnLabel);
                return null;
            }
            this.wasNull = false;
            logger.debug("getBytes value is {} for column {}", (Object)this.TestRow.get(columnLabel), (Object)columnLabel);
            return this.TestRow.get(columnLabel).getBytes();
        }
        this.currentLabel = columnLabel;
        byte[] gb = this.wrappedResultSet.getBytes(columnLabel);
        if (this.isNullValue(gb)) {
            this.RowRecord.put(columnLabel, "Null");
        } else {
            this.RowRecord.put(columnLabel, new String(gb));
        }
        this.addSqlColToList(columnLabel, "byte[]");
        return gb;
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                return this.wrappedResultSet.getDate(columnLabel);
            }
            return null;
        }
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            this.wasNull = false;
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                logger.debug("getDate wasNull for {}", (Object)columnLabel);
                return null;
            }
            String parseDateTime = this.ParseDateTime(this.TestRow.get(String.valueOf(columnLabel)));
            if (Objects.equals(parseDateTime, "") || parseDateTime == null) {
                this.wasNull = true;
                logger.debug("getDate wasNull for {}", (Object)columnLabel);
                return null;
            }
            SimpleDateFormat formatter = new SimpleDateFormat(parseDateTime);
            try {
                Date x = new Date(formatter.parse(this.TestRow.get(columnLabel)).getTime());
                logger.debug("getDate value is {} for column {}", (Object)x, (Object)columnLabel);
                return x;
            }
            catch (ParseException e) {
                logger.error(CROSS + " Failed to parse Date object from the stored mock due to \n" + e);
            }
        }
        this.currentLabel = columnLabel;
        Date gd = this.wrappedResultSet.getDate(columnLabel);
        String res = String.valueOf(gd);
        if (this.isNullValue(gd)) {
            res = "Null";
        }
        this.RowRecord.put(columnLabel, res);
        this.addSqlColToList(columnLabel, "Date");
        return gd;
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                return this.wrappedResultSet.getTime(columnLabel);
            }
            return null;
        }
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                logger.debug("getTime wasNull for {}", (Object)columnLabel);
                this.wasNull = true;
                return null;
            }
            String parseDateTime = this.ParseDateTime(this.TestRow.get(String.valueOf(columnLabel)));
            if (Objects.equals(parseDateTime, "") || parseDateTime == null) {
                logger.debug("getTime wasNull for {}", (Object)columnLabel);
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            SimpleDateFormat formatter = new SimpleDateFormat(parseDateTime);
            try {
                logger.debug("getTime value is {} for column {}", (Object)formatter.parse(this.TestRow.get(columnLabel)), (Object)columnLabel);
                return new Time(formatter.parse(this.TestRow.get(columnLabel)).getTime());
            }
            catch (ParseException e) {
                logger.error(CROSS + " Failed to parse Time object from the stored mock due to \n" + e);
            }
        }
        this.currentLabel = columnLabel;
        Time gt = this.wrappedResultSet.getTime(columnLabel);
        String res = String.valueOf(gt);
        if (this.isNullValue(gt)) {
            res = "Null";
        }
        this.RowRecord.put(columnLabel, res);
        this.addSqlColToList(columnLabel, "Time");
        return gt;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                return this.wrappedResultSet.getTimestamp(columnLabel);
            }
            return null;
        }
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            this.wasNull = false;
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                logger.debug("getTimestamp wasNull for {}", (Object)columnLabel);
                this.wasNull = true;
                return null;
            }
            String parseDateTime = this.ParseDateTime(this.TestRow.get(String.valueOf(columnLabel)));
            if (Objects.equals(parseDateTime, "") || parseDateTime == null) {
                this.wasNull = true;
                logger.debug("getTimestamp wasNull for {}", (Object)columnLabel);
                return null;
            }
            SimpleDateFormat formatter = new SimpleDateFormat(parseDateTime);
            try {
                logger.debug("getTimestamp value is {} for column {}", (Object)formatter.parse(this.TestRow.get(columnLabel)), (Object)columnLabel);
                return new Timestamp(formatter.parse(this.TestRow.get(columnLabel)).getTime());
            }
            catch (ParseException e) {
                logger.error(CROSS + " Failed to parse TimeStamp object from the stored mock due to \n" + e);
            }
        }
        this.currentLabel = columnLabel;
        Timestamp gts = this.wrappedResultSet.getTimestamp(columnLabel);
        String res = String.valueOf(gts);
        if (this.isNullValue(gts)) {
            res = "Null";
        }
        this.RowRecord.put(columnLabel, res);
        this.addSqlColToList(columnLabel, "Timestamp");
        return gts;
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                return this.wrappedResultSet.getAsciiStream(columnLabel);
            }
            return null;
        }
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            this.wasNull = false;
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                return null;
            }
            return new ByteArrayInputStream(this.TestRow.get(columnLabel).getBytes());
        }
        this.currentLabel = columnLabel;
        InputStream gas = this.wrappedResultSet.getAsciiStream(columnLabel);
        String res = String.valueOf(gas);
        if (this.isNullValue(gas)) {
            res = "Null";
        }
        this.RowRecord.put(columnLabel, res);
        this.addSqlColToList(columnLabel, "InputStream");
        return gas;
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                return this.wrappedResultSet.getUnicodeStream(columnLabel);
            }
            return null;
        }
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            this.wasNull = false;
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                return null;
            }
            return new ByteArrayInputStream(this.TestRow.get(columnLabel).getBytes());
        }
        this.currentLabel = columnLabel;
        InputStream gus = this.wrappedResultSet.getUnicodeStream(columnLabel);
        String res = String.valueOf(gus);
        if (this.isNullValue(gus)) {
            res = "Null";
        }
        this.RowRecord.put(columnLabel, res);
        this.addSqlColToList(columnLabel, "InputStream");
        return gus;
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        logger.warn("{} InputStream getBinaryStream(String columnLabel) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getBinaryStream(columnLabel);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        logger.warn("{} SQLWarning getWarnings() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        logger.warn("{} void clearWarnings() throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        logger.warn("{} String getCursorName() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            return new KResultSetMetaData();
        }
        logger.debug("getMetaData for Query {}", (Object)KConnection.MyQuery);
        ResultSetMetaData getMetaData = this.wrappedResultSet.getMetaData();
        return new KResultSetMetaData(getMetaData);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        logger.warn("{} Object getObject(int columnIndex) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                return this.wrappedResultSet.getObject(columnLabel);
            }
            return null;
        }
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            this.wasNull = false;
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                return null;
            }
            return this.TestRow.get(columnLabel);
        }
        this.currentLabel = columnLabel;
        Object go = this.wrappedResultSet.getObject(columnLabel);
        String res = String.valueOf(go);
        if (this.isNullValue(go)) {
            res = "Null";
        }
        this.RowRecord.put(columnLabel, res);
        this.addSqlColToList(columnLabel, "Object");
        return go;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                return this.wrappedResultSet.findColumn(columnLabel);
            }
            return 0;
        }
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            this.wasNull = false;
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                return 0;
            }
            return Integer.parseInt(this.TestRow.get(columnLabel));
        }
        int fc = this.wrappedResultSet.findColumn(columnLabel);
        String res = String.valueOf(fc);
        if (this.isNullValue(fc)) {
            res = "Null";
        }
        this.RowRecord.put(columnLabel, res);
        this.addSqlColToList(columnLabel, "int");
        return fc;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Kcontext kctx = Context.getCtx();
        String columnLabel = String.valueOf(columnIndex);
        if (kctx == null) {
            if (KDriver.mode == KDriver.recordMode) {
                return this.wrappedResultSet.getCharacterStream(columnIndex);
            }
            return null;
        }
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            this.wasNull = false;
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                return null;
            }
            return new StringReader(this.TestRow.get(columnLabel));
        }
        this.currentLabel = columnLabel;
        Reader gcs = this.wrappedResultSet.getCharacterStream(columnIndex);
        String res = String.valueOf(gcs);
        if (this.isNullValue(gcs)) {
            res = "Null";
        }
        this.RowRecord.put(columnLabel, res);
        this.addSqlColToList(columnLabel, "Reader");
        return gcs;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        logger.warn("{} Reader getCharacterStream(String columnLabel) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getCharacterStream(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Kcontext kctx = Context.getCtx();
        String columnLabel = String.valueOf(columnIndex);
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(String.valueOf(columnIndex)) == null || Objects.equals(this.TestRow.get(String.valueOf(columnIndex)), "Null")) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            return new BigDecimal(Double.parseDouble(this.TestRow.get(String.valueOf(columnIndex))));
        }
        this.currentLabel = columnLabel;
        BigDecimal gs = this.wrappedResultSet.getBigDecimal(columnIndex);
        String res = String.valueOf(gs);
        if (this.isNullValue(gs)) {
            res = "Null";
        }
        this.RowRecord.put(String.valueOf(columnIndex), res);
        this.addSqlColToList(String.valueOf(columnIndex), "BigDecimal");
        return gs;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (KDriver.mode == Mode.ModeType.MODE_TEST) {
            if (this.TestRow.get(columnLabel) == null || Objects.equals(this.TestRow.get(columnLabel), "Null")) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            return new BigDecimal(Double.parseDouble(this.TestRow.get(columnLabel)));
        }
        this.currentLabel = columnLabel;
        BigDecimal gl = this.wrappedResultSet.getBigDecimal(columnLabel);
        String res = String.valueOf(gl);
        if (this.isNullValue(gl)) {
            res = "Null";
        }
        this.RowRecord.put(columnLabel, res);
        this.addSqlColToList(columnLabel, "BigDecimal");
        return gl;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        logger.warn("{} boolean isBeforeFirst() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        logger.warn("{} boolean isAfterLast() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        logger.warn("{} boolean isFirst() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        logger.warn("{} boolean isLast() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        logger.warn("{} void beforeFirst() throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        logger.warn("{} void afterLast() throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        logger.warn("{} boolean first() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.first();
    }

    @Override
    public boolean last() throws SQLException {
        logger.warn("{} boolean last() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.last();
    }

    @Override
    public int getRow() throws SQLException {
        logger.warn("{} int getRow() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getRow();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        logger.warn("{} boolean absolute(int row) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.absolute(row);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        logger.warn("{} boolean relative(int rows) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.relative(rows);
    }

    @Override
    public boolean previous() throws SQLException {
        logger.warn("{} boolean previous() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.previous();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        logger.warn("{} void setFetchDirection(int direction) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        logger.warn("{} int getFetchDirection() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        logger.warn("{} int getRow() throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        logger.warn("{} int getFetchSize() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        logger.warn("{} int getType() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        logger.warn("{} int getConcurrency() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        logger.warn("{} boolean rowUpdated() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        logger.warn("{} boolean rowInserted() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        logger.warn("{} boolean rowDeleted() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.rowDeleted();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        logger.warn("{} void updateNull(int columnIndex) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateNull(columnIndex);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        logger.warn("{} void updateBoolean(int columnIndex, boolean x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBoolean(columnIndex, x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        logger.warn("{} void updateByte(int columnIndex, byte x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateByte(columnIndex, x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        logger.warn("{} void updateShort(int columnIndex, short x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateShort(columnIndex, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        logger.warn("{} void updateInt(int columnIndex, int x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateInt(columnIndex, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        logger.warn("{} void updateLong(int columnIndex, long x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateLong(columnIndex, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        logger.warn("{} void updateFloat(int columnIndex, float x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateFloat(columnIndex, x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        logger.warn("{} void updateDouble(int columnIndex, double x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateDouble(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        logger.warn("{} void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBigDecimal(columnIndex, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        logger.warn("{} void updateString(int columnIndex, String x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateString(columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        logger.warn("{} void updateBytes(int columnIndex, byte[] x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBytes(columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        logger.warn("{} void updateDate(int columnIndex, Date x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateDate(columnIndex, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        logger.warn("{} void updateTime(int columnIndex, Time x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateTime(columnIndex, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        logger.warn("{} void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateTimestamp(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        logger.warn("{} void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        logger.warn("{} void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        logger.warn("{} void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        logger.warn("{} void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateObject(columnIndex, x, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        logger.warn("{} void updateObject(int columnIndex, Object x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateObject(columnIndex, x);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        logger.warn("{} void updateNull(String columnLabel) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateNull(columnLabel);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        logger.warn("{} void updateBoolean(String columnLabel, boolean x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBoolean(columnLabel, x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        logger.warn("{} void updateByte(String columnLabel, byte x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateByte(columnLabel, x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        logger.warn("{} void updateShort(String columnLabel, short x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateShort(columnLabel, x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        logger.warn("{} void updateInt(String columnLabel, int x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateInt(columnLabel, x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        logger.warn("{} void updateLong(String columnLabel, long x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateLong(columnLabel, x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        logger.warn("{} void updateFloat(String columnLabel, float x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateFloat(columnLabel, x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        logger.warn("{} void updateDouble(String columnLabel, double x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateDouble(columnLabel, x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        logger.warn("{} void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBigDecimal(columnLabel, x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        logger.warn("{} void updateString(String columnLabel, String x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateString(columnLabel, x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        logger.warn("{} void updateBytes(String columnLabel, byte[] x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBytes(columnLabel, x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        logger.warn("{} void updateDate(String columnLabel, Date x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateDate(columnLabel, x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        logger.warn("{} void updateTime(String columnLabel, Time x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateTime(columnLabel, x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        logger.warn("{} void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateTimestamp(columnLabel, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        logger.warn("{} void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        logger.warn("{} void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        logger.warn("{} void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        logger.warn("{} void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateObject(columnLabel, x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        logger.warn("{} void updateObject(String columnLabel, Object x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateObject(columnLabel, x);
    }

    @Override
    public void insertRow() throws SQLException {
        logger.warn("{} void insertRow() throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.insertRow();
    }

    @Override
    public void updateRow() throws SQLException {
        logger.warn("{} void updateRow() throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateRow();
    }

    @Override
    public void deleteRow() throws SQLException {
        logger.warn("{} void deleteRow() throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.deleteRow();
    }

    @Override
    public void refreshRow() throws SQLException {
        logger.warn("{} void refreshRow() throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.refreshRow();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        logger.warn("{} void cancelRowUpdates() throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.cancelRowUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        logger.warn("{} void moveToInsertRow() throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.moveToCurrentRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        logger.warn("{} void moveToCurrentRow() throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.moveToCurrentRow();
    }

    @Override
    public Statement getStatement() throws SQLException {
        Kcontext kctx = Context.getCtx();
        if (KDriver.mode == KDriver.testMode) {
            return new KStatement();
        }
        return new KStatement(this.wrappedResultSet.getStatement());
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        logger.warn("{} Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getObject(columnIndex, map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        logger.warn("{} Ref getRef(int columnIndex) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getRef(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        logger.warn("{} Blob getBlob(int columnIndex) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getBlob(columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        logger.warn("{} Clob getClob(int columnIndex) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getClob(columnIndex);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        logger.warn("{} Array getArray(int columnIndex) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getArray(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        logger.warn("{} Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getObject(columnLabel, map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        logger.warn("{} Ref getRef(String columnLabel) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getRef(columnLabel);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        logger.warn("{} Blob getBlob(String columnLabel) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getBlob(columnLabel);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        logger.warn("{} Clob getClob(String columnLabel) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getClob(columnLabel);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        logger.warn("{} Array getArray(String columnLabel) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getArray(columnLabel);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        logger.warn("{} Date getDate(int columnIndex, Calendar cal) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getDate(columnIndex, cal);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        logger.warn("{} Date getDate(String columnLabel, Calendar cal) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getDate(columnLabel, cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        logger.warn("{} Time getTime(int columnIndex, Calendar cal) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        logger.warn("{} Time getTime(String columnLabel, Calendar cal) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getTime(columnLabel, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        logger.warn("{} Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        logger.warn("{} Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getTimestamp(columnLabel, cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        logger.warn("{} URL getURL(int columnIndex) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getURL(columnIndex);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        logger.warn("{} URL getURL(String columnLabel) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getURL(columnLabel);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        logger.warn("{} void updateRef(int columnIndex, Ref x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateRef(columnIndex, x);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        logger.warn("{} void updateRef(String columnLabel, Ref x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateRef(columnLabel, x);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        logger.warn("{}void updateBlob(int columnIndex, Blob x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBlob(columnIndex, x);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        logger.warn("{} void updateBlob(String columnLabel, Blob x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBlob(columnLabel, x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        logger.warn("{} void updateClob(int columnIndex, Clob x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateClob(columnIndex, x);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        logger.warn("{} void updateClob(String columnLabel, Clob x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateClob(columnLabel, x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        logger.warn("{} void updateArray(int columnIndex, Array x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateArray(columnIndex, x);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        logger.warn("{} void updateArray(String columnLabel, Array x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateArray(columnLabel, x);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        logger.warn("{} RowId getRowId(int columnIndex) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getRowId(columnIndex);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        logger.warn("{} RowId getRowId(String columnLabel) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getRowId(columnLabel);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        logger.warn("{} void updateRowId(int columnIndex, RowId x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateRowId(columnIndex, x);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        logger.warn("{} void updateRowId(String columnLabel, RowId x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateRowId(columnLabel, x);
    }

    @Override
    public int getHoldability() throws SQLException {
        logger.warn("{} int getHoldability() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        logger.warn("{} boolean isClosed() throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.isClosed();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        logger.warn("{} void updateNString(int columnIndex, String nString) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateNString(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        logger.warn("{}  void updateNString(String columnLabel, String nString) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateNString(columnLabel, nString);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        logger.warn("{}  void updateNClob(int columnIndex, NClob nClob) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateNClob(columnIndex, nClob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        logger.warn("{} void updateNClob(String columnLabel, NClob nClob) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateNClob(columnLabel, nClob);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        logger.warn("{} NClob getNClob(int columnIndex) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getNClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        logger.warn("{}  NClob getNClob(String columnLabel) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getNClob(columnLabel);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        logger.warn("{} SQLXML getSQLXML(int columnIndex) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getSQLXML(columnIndex);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        logger.warn("{} SQLXML getSQLXML(String columnLabel) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getSQLXML(columnLabel);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        logger.warn("{} void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateSQLXML(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        logger.warn("{} void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateSQLXML(columnLabel, xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        logger.warn("{} String getNString(int columnIndex) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getNString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        logger.warn("{} String getNString(String columnLabel) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getNString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        logger.warn("{} Reader getNCharacterStream(int columnIndex) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getNCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        logger.warn("{} Reader getNCharacterStream(String columnLabel) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getNCharacterStream(columnLabel);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        logger.warn("{} void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateNCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        logger.warn("{} void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateNCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        logger.warn("{} void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        logger.warn("{} void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        logger.warn("{} void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        logger.warn("{} void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        logger.warn("{} void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        logger.warn("{} void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        logger.warn("{}  void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        logger.warn("{} void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBlob(columnLabel, inputStream, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        logger.warn("{} void updateClob(int columnIndex, Reader reader, long length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        logger.warn("{} void updateClob(String columnLabel, Reader reader, long length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        logger.warn("{} void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateNClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        logger.warn("{} void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateNClob(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        logger.warn("{} void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateNCharacterStream(columnIndex, x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        logger.warn("{} void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateNCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        logger.warn("{} void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateAsciiStream(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        logger.warn("{} void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBinaryStream(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        logger.warn("{} void updateCharacterStream(int columnIndex, Reader x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateCharacterStream(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        logger.warn("{} void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateAsciiStream(columnLabel, x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        logger.warn("{} void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBinaryStream(columnLabel, x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        logger.warn("{}  void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        logger.warn("{} void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBlob(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        logger.warn("{} void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateBlob(columnLabel, inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        logger.warn("{} void updateClob(int columnIndex, Reader reader) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateClob(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        logger.warn("{} void updateClob(String columnLabel, Reader reader) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateClob(columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        logger.warn("{} void updateNClob(int columnIndex, Reader reader) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateNClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        logger.warn("{} void updateNClob(String columnLabel, Reader reader) throws SQLException {}", (Object)msg1, (Object)msg2);
        this.wrappedResultSet.updateNClob(columnLabel, reader);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        logger.warn("{} <T> T getObject(int columnIndex, Class<T> type) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getObject(columnIndex, type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        logger.warn("{} <T> T getObject(String columnLabel, Class<T> type) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.getObject(columnLabel, type);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.warn("{} <T> T unwrap(Class<T> iface) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.warn("{} boolean isWrapperFor(Class<?> iface) throws SQLException {}", (Object)msg1, (Object)msg2);
        return this.wrappedResultSet.isWrapperFor(iface);
    }

    boolean isNullValue(Object obj) {
        return obj == null;
    }

    public void GetPreAndScale() {
        KResultSetMetaData.PrecisionDict = new HashMap();
        KResultSetMetaData.ScaleDict = new HashMap();
        if (this.TableData == null) {
            logger.debug("Returning as TableData not found !");
            return;
        }
        List<Service.SqlCol> columns = this.TableData.getColsList();
        if (columns.size() == 0) {
            return;
        }
        for (Service.SqlCol column : columns) {
            if (column == null) continue;
            KResultSetMetaData.PrecisionDict.put(column.getName(), String.valueOf(column.getPrecision()));
            KResultSetMetaData.ScaleDict.put(column.getName(), String.valueOf(column.getScale()));
        }
    }

    private List<Service.SqlCol> SetPreAndScale() {
        ArrayList<Service.SqlCol> sqlColList1 = new ArrayList<Service.SqlCol>();
        if (this.sqlColList == null) {
            logger.debug(CROSS + " Found empty sqlColList !!");
            return null;
        }
        for (Service.SqlCol col : this.sqlColList) {
            if (col == null) {
                logger.debug(CROSS + " Found null column in SQL column List !!");
                continue;
            }
            String colname = col.getName();
            String type = col.getType();
            long precision = 0L;
            long scale = 0L;
            if (KResultSetMetaData.PrecisionDict.size() > 0) {
                precision = Long.parseLong(KResultSetMetaData.PrecisionDict.get(colname));
            }
            if (KResultSetMetaData.ScaleDict.size() > 0) {
                scale = Long.parseLong(KResultSetMetaData.ScaleDict.get(colname));
            }
            Service.SqlCol sqlCol = Service.SqlCol.newBuilder().setName(colname).setType(type).setPrecision(precision).setScale(scale).build();
            sqlColList1.add(sqlCol);
        }
        KResultSetMetaData.PrecisionDict.clear();
        KResultSetMetaData.ScaleDict.clear();
        return sqlColList1;
    }

    String ParseDateTime(String formattedDate) {
        String[] patterns;
        if (formattedDate == null || formattedDate.equals("")) {
            logger.debug("Found empty formatted Date to Parse during test\n");
            return "";
        }
        for (String pattern : patterns = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss", "dd/MM/yyyy HH:mm:ss.SSS", "dd/MM/yyyy HH:mm:ss", "dd.MM.yyyy HH:mm:ss.SSS", "dd.MM.yyyy HH:mm:ss", "dd-MM-yyyy HH:mm:ss.SSS", "dd-MM-yyyy HH:mm:ss", "yyyy:MM:dd HH:mm:ss.SSS", "yyyy:MM:dd HH:mm:ss", "HH:mm:ss", "yyyy-MM-dd", "dd/MM/yyyy"}) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                java.util.Date date = sdf.parse(formattedDate);
                return pattern;
            }
            catch (ParseException e) {
                logger.debug(" ParseDateTime method cannot parse the formatted string provided... trying next!\n for date " + formattedDate);
            }
        }
        return "";
    }
}

