/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.util;

public final class JedisClusterHashTagUtil {
    private JedisClusterHashTagUtil() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static String getHashTag(String key) {
        return JedisClusterHashTagUtil.extractHashTag(key, true);
    }

    public static boolean isClusterCompliantMatchPattern(String matchPattern) {
        String tag = JedisClusterHashTagUtil.extractHashTag(matchPattern, false);
        return tag != null && !tag.isEmpty();
    }

    private static String extractHashTag(String key, boolean returnKeyOnAbsence) {
        int e;
        int s2 = key.indexOf("{");
        if (s2 > -1 && (e = key.indexOf("}", s2 + 1)) > -1 && e != s2 + 1) {
            return key.substring(s2 + 1, e);
        }
        return returnKeyOnAbsence ? key : null;
    }
}

