/*
 * Decompiled with CFR 0.152.
 */
package io.keploy.servlet;

import io.grpc.netty.shaded.io.netty.util.internal.InternalThreadLocalMap;
import io.keploy.grpc.stubs.Service;
import io.keploy.regression.KeployInstance;
import io.keploy.regression.Mode;
import io.keploy.regression.context.Context;
import io.keploy.regression.context.Kcontext;
import io.keploy.regression.keploy.AppConfig;
import io.keploy.regression.keploy.Config;
import io.keploy.regression.keploy.Filter;
import io.keploy.regression.keploy.Keploy;
import io.keploy.regression.keploy.ServerConfig;
import io.keploy.service.GrpcService;
import io.keploy.utils.GenericRequestWrapper;
import io.keploy.utils.GenericResponseWrapper;
import io.keploy.utils.HaltThread;
import io.keploy.utils.HttpStatusReasons;
import io.keploy.utils.MultipartContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeployMiddleware
implements javax.servlet.Filter {
    private static final Logger logger = LogManager.getLogger(KeployMiddleware.class);
    private static final String CROSS = new String(Character.toChars(10060));
    private static final String SET_PLAIN_TEXT = "\u001b[0;0m";
    private static final String SET_BOLD_TEXT = "\u001b[0;1m";

    public void init(FilterConfig filterConfig) {
        boolean isFilterNull;
        CountDownLatch countDownLatch = HaltThread.getInstance().getCountDownLatch();
        logger.debug("initializing keploy");
        KeployInstance ki = KeployInstance.getInstance();
        Keploy kp = ki.getKeploy();
        Config cfg = new Config();
        AppConfig appConfig = new AppConfig();
        if (System.getenv("APP_NAME") != null) {
            String app_name = System.getenv("APP_NAME").trim();
            appConfig.setName(app_name);
        }
        if (System.getenv("APP_PORT") != null) {
            String app_port = System.getenv("APP_PORT").trim();
            appConfig.setPort(app_port);
        }
        String kpath = System.getenv("KEPLOY_TEST_PATH");
        Path path = Paths.get("", new String[0]);
        if (kpath != null && kpath.length() > 0 && !Paths.get(kpath, new String[0]).isAbsolute()) {
            kpath = kpath.trim();
            Path effectivePath = path.resolve(kpath).toAbsolutePath();
            String absolutePath = effectivePath.normalize().toString();
            appConfig.setTestPath(absolutePath);
        } else if (kpath == null || kpath.length() == 0) {
            String currDir = System.getProperty("user.dir") + "/src/test/e2e/keploy-tests";
            appConfig.setTestPath(currDir);
        } else {
            appConfig.setTestPath(kpath);
        }
        logger.debug("test path: {}", (Object)appConfig.getTestPath());
        String mpath = System.getenv("KEPLOY_MOCK_PATH");
        if (mpath != null && mpath.length() > 0 && !Paths.get(mpath, new String[0]).isAbsolute()) {
            mpath = mpath.trim();
            Path effectivePath = path.resolve(mpath).toAbsolutePath();
            String absolutePath = effectivePath.normalize().toString();
            appConfig.setMockPath(absolutePath);
        } else if (mpath == null || mpath.length() == 0) {
            String currDir = System.getProperty("user.dir") + "/src/test/e2e/mocks";
            appConfig.setMockPath(currDir);
        } else {
            appConfig.setMockPath(mpath);
        }
        logger.debug("mock path: {}", (Object)appConfig.getMockPath());
        String apath = System.getenv("KEPLOY_ASSET_PATH");
        if (apath != null && apath.length() > 0 && !Paths.get(apath, new String[0]).isAbsolute()) {
            apath = apath.trim();
            Path effectivePath = path.resolve(apath).toAbsolutePath();
            String absolutePath = effectivePath.normalize().toString();
            appConfig.setAssetPath(absolutePath);
        } else if (mpath == null || mpath.length() == 0) {
            String currDir = System.getProperty("user.dir") + "/src/test/e2e/assets";
            appConfig.setAssetPath(currDir);
        } else {
            appConfig.setAssetPath(mpath);
        }
        logger.debug("asset path: {}", (Object)appConfig.getAssetPath());
        ServerConfig serverConfig = new ServerConfig();
        if (System.getenv("DENOISE") != null) {
            String denoise = System.getenv("DENOISE").trim();
            serverConfig.setDenoise(Boolean.parseBoolean(denoise));
        }
        if (System.getenv("KEPLOY_URL") != null) {
            String keploy_url = System.getenv("KEPLOY_URL").trim();
            serverConfig.setURL(keploy_url);
        }
        logger.info("fetching filter from env variables");
        String[] acceptUrlRegexList = System.getenv().get("ACCEPT_URL_REGEX_LIST") != null ? System.getenv().get("ACCEPT_URL_REGEX_LIST").split(",") : null;
        String[] acceptHeaderRegexList = System.getenv().get("ACCEPT_HEADER_REGEX_LIST") != null ? System.getenv().get("ACCEPT_HEADER_REGEX_LIST").split(",") : null;
        String[] rejectUrlRegexList = System.getenv().get("REJECT_URL_REGEX_LIST") != null ? System.getenv().get("REJECT_URL_REGEX_LIST").split(",") : null;
        String[] rejectHeaderRegexList = System.getenv().get("REJECT_HEADER_REGEX_LIST") != null ? System.getenv().get("REJECT_HEADER_REGEX_LIST").split(",") : null;
        boolean bl = isFilterNull = acceptHeaderRegexList == null && acceptUrlRegexList == null && rejectHeaderRegexList == null && rejectUrlRegexList == null;
        if (!isFilterNull) {
            Filter filter = new Filter(acceptUrlRegexList, acceptHeaderRegexList, rejectHeaderRegexList, rejectUrlRegexList);
            appConfig.setFilter(filter);
        }
        cfg.setApp(appConfig);
        cfg.setServer(serverConfig);
        kp.setCfg(cfg);
        new GrpcService();
        Mode.ModeType KEPLOY_MODE = Mode.getMode();
        if (KEPLOY_MODE != null && KEPLOY_MODE.equals((Object)Mode.ModeType.MODE_TEST)) {
            new Thread(() -> {
                try {
                    logger.debug("starting tests");
                    GrpcService.Test();
                }
                catch (Exception e) {
                    logger.error(CROSS + " failed to run tests", (Throwable)e);
                }
                countDownLatch.countDown();
                Context.cleanup();
                InternalThreadLocalMap.remove();
                try {
                    GrpcService.channel.shutdown();
                    GrpcService.channel.awaitTermination(1L, TimeUnit.MINUTES);
                    GrpcService.channel.shutdownNow();
                }
                catch (InterruptedException e) {
                    logger.error(CROSS + " failed to shut grpc connection properly... ", (Throwable)e);
                }
                try {
                    Thread.sleep(10000L);
                    System.exit(0);
                }
                catch (InterruptedException e) {
                    logger.error(CROSS + " failed to shut test run properly... ", (Throwable)e);
                }
            }).start();
        }
        String runTestBeforeRecord = System.getenv("RUN_TEST_BEFORE_RECORD");
        boolean runTests = false;
        if (runTestBeforeRecord != null) {
            runTests = Boolean.parseBoolean(runTestBeforeRecord);
        }
        if (KEPLOY_MODE != null && KEPLOY_MODE.equals((Object)Mode.ModeType.MODE_RECORD) && runTests) {
            new Thread(this::handleExistingTests).start();
        }
    }

    private static String bold(String str) {
        return SET_BOLD_TEXT + str + SET_PLAIN_TEXT;
    }

    private void handleExistingTests() {
        Thread.sleep(2000L);
        String WARN = "\ud83d\udea8";
        System.out.println("--------------------------------------------------------------------------------------------\n");
        String startTest = "\ud83d\udea8 Executing existing test cases to maintain the same state, kindly do not record any new test cases till these tests get completed.";
        System.out.println(KeployMiddleware.bold(startTest));
        System.out.println("\n--------------------------------------------------------------------------------------------");
        GrpcService.Test();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        KeployInstance ki = KeployInstance.getInstance();
        Keploy k = ki.getKeploy();
        logger.debug("inside middleware: incoming request");
        logger.debug("mode: {}", (Object)Mode.getMode());
        if (k == null || Mode.getMode() != null && Mode.getMode().equals((Object)Mode.ModeType.MODE_OFF)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Kcontext kctx = new Kcontext();
        kctx.setRequest(request);
        Context.setCtx(kctx);
        String keploy_test_id = request.getHeader("KEPLOY_TEST_ID");
        logger.debug("KEPLOY_TEST_ID: {}", (Object)keploy_test_id);
        if (keploy_test_id != null) {
            kctx.setTestId(keploy_test_id);
            kctx.setMode(Mode.ModeType.MODE_TEST);
            List<Service.Mock> mocks = k.getMocks().get(keploy_test_id);
            if (mocks != null) {
                kctx.getMock().addAll(mocks);
            }
        }
        GenericRequestWrapper requestWrapper = new GenericRequestWrapper(request);
        GenericResponseWrapper responseWrapper = new GenericResponseWrapper(response);
        HashMap<String, List<MultipartContent>> formData = new HashMap();
        if (request.getContentType() != null && request.getContentType().startsWith("multipart/form-data")) {
            formData = this.processMultipart(request);
        }
        filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        byte[] reqArr = requestWrapper.getData();
        byte[] resArr = responseWrapper.getData();
        String reqEncoding = request.getCharacterEncoding() == null ? "UTF-8" : request.getCharacterEncoding();
        String resEncoding = response.getCharacterEncoding() == null ? "ISO-8859-1" : response.getCharacterEncoding();
        String requestBody = this.getStringValue(reqArr, reqEncoding);
        String responseBody = this.getStringValue(resArr, resEncoding);
        String resContentType = response.getContentType();
        if (resContentType != null && this.isBinaryFile(resContentType)) {
            logger.debug("request contains binary file");
            responseBody = "";
        }
        logger.debug("request body inside middleware: {}", (Object)requestBody);
        logger.debug("response body inside middleware: {}", (Object)responseBody);
        String statusMsg = HttpStatusReasons.getStatusMsg(responseWrapper.getStatus());
        String protocolType = requestWrapper.getProtocol();
        int protoMajor = Character.getNumericValue(protocolType.charAt(protocolType.length() - 3));
        int protoMinor = Character.getNumericValue(protocolType.charAt(protocolType.length() - 1));
        Map<String, Service.StrArr> simResponseHeaderMap = this.getResponseHeaderMap(responseWrapper);
        Service.HttpResp simulateResponse = Service.HttpResp.newBuilder().setStatusCode(responseWrapper.getStatus()).setBody(responseBody).setStatusMessage(statusMsg).setProtoMajor(protoMajor).setProtoMinor(protoMinor).putAllHeader(simResponseHeaderMap).build();
        logger.debug("simulate response inside middleware: {}", (Object)simulateResponse);
        if (keploy_test_id != null) {
            k.getResp().put(keploy_test_id, simulateResponse);
            Context.cleanup();
            InternalThreadLocalMap.remove();
            logger.debug("response in keploy resp map: {}", (Object)k.getResp().get(keploy_test_id));
        } else {
            Mode.ModeType mode = Mode.getMode();
            if (mode != null && mode.equals((Object)Mode.ModeType.MODE_TEST)) {
                return;
            }
            Map<String, String> urlParams = this.setUrlParams(requestWrapper.getParameterMap());
            Service.HttpResp.Builder builder = Service.HttpResp.newBuilder();
            Map<String, Service.StrArr> headerMap = this.getResponseHeaderMap(responseWrapper);
            Service.HttpResp httpResp = builder.setStatusCode(responseWrapper.getStatus()).setBody(responseBody).setStatusMessage(statusMsg).setProtoMajor(protoMajor).setProtoMinor(protoMinor).putAllHeader(headerMap).build();
            try {
                GrpcService.CaptureTestCases(requestBody, urlParams, httpResp, protocolType, formData);
            }
            catch (Exception e) {
                logger.error(CROSS + " failed to capture testCases", (Throwable)e);
            }
        }
        responseWrapper.flushBuffer();
        Context.cleanup();
        InternalThreadLocalMap.remove();
        logger.debug("inside middleware: outgoing response");
    }

    private boolean isBinaryFile(String resContentType) {
        switch (resContentType) {
            case "application/octet-stream": 
            case "application/pdf": 
            case "image/jpeg": 
            case "image/jpg": 
            case "image/png": 
            case "image/gif": 
            case "text/plain": 
            case "text/html": {
                return true;
            }
        }
        return false;
    }

    private Map<String, List<MultipartContent>> processMultipart(HttpServletRequest request) throws IOException, ServletException {
        HashMap<String, List<MultipartContent>> data = new HashMap<String, List<MultipartContent>>();
        Collection parts = request.getParts();
        for (Part part : parts) {
            byte[] content;
            InputStream inputStream;
            String partName = part.getName();
            logger.debug("partName:{}", (Object)partName);
            if (part.getContentType() != null) {
                inputStream = part.getInputStream();
                content = IOUtils.toByteArray(inputStream);
                String fileName = part.getSubmittedFileName();
                MultipartContent multipartContent = new MultipartContent(fileName, content);
                data.computeIfAbsent(partName, x -> new ArrayList()).add(multipartContent);
                request.setAttribute("fileContent", (Object)content);
                continue;
            }
            inputStream = part.getInputStream();
            content = IOUtils.toByteArray(inputStream);
            MultipartContent multipartContent = new MultipartContent(null, content);
            data.computeIfAbsent(partName, x -> new ArrayList()).add(multipartContent);
            logger.debug("non-file body:{}", (Object)this.getStringValue(content, String.valueOf(StandardCharsets.UTF_8)));
        }
        return data;
    }

    private Map<String, Service.StrArr> getResponseHeaderMap(GenericResponseWrapper responseWrapper) {
        HashMap<String, Service.StrArr> map = new HashMap<String, Service.StrArr>();
        ArrayList headerNames = new ArrayList(responseWrapper.getHeaderNames());
        for (String name : headerNames) {
            if (name == null) continue;
            ArrayList values = new ArrayList(responseWrapper.getHeaders(name));
            Service.StrArr.Builder builder = Service.StrArr.newBuilder();
            for (String s2 : values) {
                builder.addValue(s2);
            }
            Service.StrArr value = builder.build();
            map.put(name, value);
        }
        return map;
    }

    private Map<String, String> setUrlParams(Map<String, String[]> param) {
        HashMap<String, String> urlParams = new HashMap<String, String>();
        for (String key : param.keySet()) {
            String value = param.get(key)[0];
            if (key == null || value == null) continue;
            urlParams.put(key, value);
        }
        return urlParams;
    }

    private String getStringValue(byte[] contentAsByteArray, String characterEncoding) {
        try {
            return new String(contentAsByteArray, 0, contentAsByteArray.length, characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void destroy() {
        InternalThreadLocalMap.destroy();
    }
}

