/*
 * Decompiled with CFR 0.152.
 */
package io.keploy.httpClients;

import com.google.protobuf.ByteString;
import io.keploy.grpc.stubs.Service;
import io.keploy.regression.KeployInstance;
import io.keploy.regression.Mock;
import io.keploy.regression.Mode;
import io.keploy.regression.context.Context;
import io.keploy.regression.context.Kcontext;
import io.keploy.regression.keploy.Keploy;
import io.keploy.service.GrpcService;
import io.keploy.service.mock.Config;
import io.keploy.service.mock.MockLib;
import io.keploy.utils.MagicBytes;
import io.keploy.utils.MultipartContent;
import io.keploy.utils.Utility;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApacheInterceptor {
    private static final Logger logger = LogManager.getLogger(ApacheInterceptor.class);
    private static final String CROSS = new String(Character.toChars(10060));
    private static final Keploy k = KeployInstance.getInstance().getKeploy();

    public static CloseableHttpResponse doProceed(@Origin Method method, @SuperCall Callable<CloseableHttpResponse> callable, @AllArguments Object[] args) {
        logger.debug("inside ApacheInterceptor for method: " + method);
        HttpUriRequest request = null;
        for (Object obj : args) {
            if (!(obj instanceof HttpUriRequest)) continue;
            request = (HttpUriRequest)obj;
        }
        if (request == null) {
            logger.error(CROSS + " failed to fetch request");
            return null;
        }
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            logger.debug("failed to get keploy context");
            try {
                return callable.call();
            }
            catch (Exception e) {
                logger.error(CROSS + " unable to execute request", (Throwable)e);
                return null;
            }
        }
        Mode.ModeType modeFromContext = kctx.getMode().getModeFromContext();
        if (modeFromContext.equals((Object)Mode.ModeType.MODE_OFF)) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                logger.error(CROSS + " unable to execute request", (Throwable)e);
                return null;
            }
        }
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("name", "apache");
        meta.put("type", "HTTP_CLIENT");
        meta.put("operation", request.getMethod());
        String url = "";
        try {
            url = request.getURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            logger.error(CROSS + " unable to set url for metadata", (Throwable)e);
        }
        meta.put("URL", url);
        meta.put("Header", Arrays.toString(request.getAllHeaders()));
        meta.put("ProtoMajor", String.valueOf(request.getProtocolVersion().getMajor()));
        meta.put("ProtoMinor", String.valueOf(request.getProtocolVersion().getMinor()));
        CloseableHttpResponse response = null;
        switch (modeFromContext) {
            case MODE_TEST: {
                if (kctx.getMock().size() > 0 && kctx.getMock().get(0).getKind().equals(Mock.Kind.HTTP_EXPORT.value)) {
                    List<Service.Mock> mocks = kctx.getMock();
                    if (mocks.size() > 0 && mocks.get(0).getSpec().getObjectsCount() > 0) {
                        logger.debug("test mode");
                        ByteString bin = mocks.get(0).getSpec().getObjectsList().get(0).getData();
                        Service.HttpResp httpResp = mocks.get(0).getSpec().getRes();
                        String respbody = httpResp.getBody();
                        long statusCode = httpResp.getStatusCode();
                        Map<String, Service.StrArr> headerMap = httpResp.getHeaderMap();
                        String statusMessage = httpResp.getStatusMessage();
                        long protoMajor = httpResp.getProtoMajor();
                        long protoMinor = httpResp.getProtoMinor();
                        String filePath = httpResp.getBinary();
                        String contentType = "";
                        if (headerMap.containsKey("Content-Type")) {
                            contentType = headerMap.get("Content-Type").getValue(0);
                        }
                        ContentType contentTypeEntity = ApacheInterceptor.getContentTypeEntity(contentType);
                        if (ApacheInterceptor.isBinaryFile(contentType)) {
                            byte[] fileData = ApacheInterceptor.getFileData(filePath);
                            response = new ApacheCustomHttpResponse(new ProtocolVersion("HTTP", (int)protoMajor, (int)protoMinor), (int)statusCode, statusMessage, fileData, contentTypeEntity);
                            ApacheInterceptor.setResponseHeaders((HttpResponse)response, headerMap);
                        } else {
                            response = new ApacheCustomHttpResponse(new ProtocolVersion("HTTP", (int)protoMajor, (int)protoMinor), (int)statusCode, statusMessage, respbody);
                            ApacheInterceptor.setResponseHeaders((HttpResponse)response, headerMap);
                        }
                        mocks.remove(0);
                    }
                    if (response == null) {
                        logger.error(CROSS + " unable to read response");
                        throw new RuntimeException("unable to read response");
                    }
                    return response;
                }
                logger.error(CROSS + " mocks not present");
                throw new RuntimeException("unable to read mocks from keploy context");
            }
            case MODE_RECORD: {
                logger.debug("record mode");
                String reqBody = "";
                try {
                    Header c_t = request.getFirstHeader("Content-Type");
                    String contentType = "";
                    if (c_t != null) {
                        contentType = c_t.getValue();
                    }
                    if (!ApacheInterceptor.isBinaryFile(contentType)) {
                        reqBody = ApacheInterceptor.getRequestBody(request);
                    }
                    meta.put("Body", reqBody);
                }
                catch (IOException e) {
                    logger.error(CROSS + " unable to read request body", (Throwable)e);
                }
                try {
                    response = callable.call();
                }
                catch (Exception e) {
                    logger.error(CROSS + " unable to execute request", (Throwable)e);
                    return null;
                }
                String binaryFilePath = "";
                String responseBody = "";
                Header type = response.getFirstHeader("Content-Type");
                String contentType = "";
                if (type != null) {
                    contentType = type.getValue();
                }
                if (ApacheInterceptor.isBinaryFile(contentType)) {
                    MultipartContent fileInfo = ApacheInterceptor.getFileInfo(response, url);
                    binaryFilePath = fileInfo.getFileName();
                    new Thread(() -> GrpcService.saveFile(fileInfo.getFileName(), fileInfo.getBody())).start();
                } else {
                    responseBody = ApacheInterceptor.getResponseBody((HttpResponse)response);
                }
                int statusCode = response.getStatusLine().getStatusCode();
                String statusMsg = response.getStatusLine().getReasonPhrase();
                long ProtoMajor = response.getProtocolVersion().getMajor();
                long ProtoMinor = response.getProtocolVersion().getMinor();
                Map<String, Service.StrArr> resHeaders = ApacheInterceptor.getHeadersMap(response.getAllHeaders());
                Service.HttpResp httpResp = Service.HttpResp.newBuilder().setBody(responseBody).setBinary(binaryFilePath).setStatusCode(statusCode).setStatusMessage(statusMsg).setProtoMajor(ProtoMajor).setProtoMinor(ProtoMinor).putAllHeader(resHeaders).build();
                Service.HttpReq httpReq = Service.HttpReq.newBuilder().setMethod(request.getMethod()).setBody(reqBody).setURL(url).setProtoMajor(ProtoMajor).setProtoMinor(ProtoMinor).putAllHeader(ApacheInterceptor.getHeadersMap(request.getAllHeaders())).putAllURLParams(ApacheInterceptor.getUrlParams(request)).build();
                ArrayList<Service.Mock.Object> lobj = new ArrayList<Service.Mock.Object>();
                Service.Mock.Object obj = Service.Mock.Object.newBuilder().setType("error").setData(ByteString.fromHex("")).build();
                lobj.add(obj);
                Service.Mock.SpecSchema specSchema = Service.Mock.SpecSchema.newBuilder().setReq(httpReq).setRes(httpResp).putAllMetadata(meta).addAllObjects(lobj).build();
                Service.Mock httpMock = Service.Mock.newBuilder().setVersion(Mock.Version.V1_BETA1.value).setKind(Mock.Kind.HTTP_EXPORT.value).setName(Config.Name).setSpec(specSchema).build();
                if (GrpcService.blockingStub != null && kctx.getFileExport().booleanValue() && !Config.MockId.containsKey(kctx.getTestId())) {
                    boolean recorded = MockLib.PutMock(Config.MockPath, httpMock);
                    String CAPTURE = "\ud83d\udfe0";
                    if (recorded) {
                        logger.info(CAPTURE + " Captured the mocked outputs for Http dependency call with meta: {}", (Object)meta);
                    }
                    return response;
                }
                kctx.getMock().add(httpMock);
                return response;
            }
        }
        logger.error(CROSS + " integrations: Not in a valid sdk mode");
        try {
            return callable.call();
        }
        catch (Exception e) {
            logger.error(CROSS + " unable to send request", (Throwable)e);
            return null;
        }
    }

    private static MultipartContent getFileInfo(CloseableHttpResponse response, String url) {
        String assetsDirectory = k.getCfg().getApp().getAssetPath();
        Utility.createFolder(assetsDirectory);
        String file = "";
        byte[] fileBody = ApacheInterceptor.getFileDataFromStream(response);
        if (response.getFirstHeader("Content-Disposition") != null) {
            String content_disposition = response.getFirstHeader("Content-Disposition").getValue();
            String fname = Utility.getFileNameFromHeader(content_disposition);
            if (!fname.isEmpty()) {
                file = assetsDirectory + "/" + fname;
                logger.debug("getting file name from Content-Disposition");
            }
        } else {
            logger.debug("content-disposition header not found");
        }
        if (file.isEmpty()) {
            String fileFromPath = Utility.getFileNameFromPath(url);
            String ext = Utility.getFileExtensionFromPath(url);
            if (!ext.isEmpty()) {
                file = assetsDirectory + "/" + fileFromPath;
                logger.debug("getting file name from url");
            } else {
                logger.debug("couldn't find name of file from url");
            }
        }
        if (file.isEmpty()) {
            MagicBytes.Header matches = MagicBytes.matches(fileBody);
            if (matches != null) {
                String fileExt = MagicBytes.getContentType(matches);
                if (fileExt.isEmpty()) {
                    logger.warn("add support for {} in MagicBytes ", (Object)matches.getName());
                } else {
                    logger.debug("getting file extension from magic numbers of the file");
                    String fName = Utility.resolveFileName(assetsDirectory);
                    file = fName + "." + fileExt;
                }
            } else {
                logger.debug("couldn't find extension of file its body");
            }
        }
        if (file.isEmpty()) {
            String fileExt = "data";
            String fName = Utility.resolveFileName(assetsDirectory);
            file = fName + "." + fileExt;
            logger.debug("could not get file extension hence saving file with .data extension");
        }
        logger.debug("returning fileName from getFileInfo():{}", (Object)file);
        return new MultipartContent(file, fileBody);
    }

    private static byte[] getFileData(String filePath) {
        byte[] fileBytes;
        File file = new File(filePath);
        Path path = file.toPath();
        try {
            fileBytes = Files.readAllBytes(path);
        }
        catch (IOException e) {
            logger.error(CROSS + " unable to read data from file");
            throw new RuntimeException(e);
        }
        return fileBytes;
    }

    private static byte[] getFileDataFromStream(CloseableHttpResponse response) {
        byte[] resBody = new byte[]{};
        String contentType = "";
        try {
            InputStream is = response.getEntity().getContent();
            resBody = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            is.close();
        }
        catch (IOException e) {
            logger.error(" unable to read file body from response", (Throwable)e);
            return resBody;
        }
        response.setEntity((HttpEntity)new ByteArrayEntity(resBody));
        return resBody;
    }

    private static Map<String, String> getUrlParams(HttpUriRequest request) {
        URIBuilder newBuilder = new URIBuilder(request.getURI());
        List params = newBuilder.getQueryParams();
        HashMap<String, String> map = new HashMap<String, String>();
        for (NameValuePair nvp : params) {
            map.put(nvp.getName(), nvp.getValue());
        }
        return map;
    }

    private static Map<String, Service.StrArr> getHeadersMap(Header[] allHeaders) {
        Object value;
        HashMap<String, List> headerMap = new HashMap<String, List>();
        for (Header header : allHeaders) {
            String key = header.getName();
            value = header.getValue();
            headerMap.computeIfAbsent(key, x -> new ArrayList()).add(value);
        }
        HashMap<String, Service.StrArr> map = new HashMap<String, Service.StrArr>();
        for (String name : headerMap.keySet()) {
            List values = (List)headerMap.get(name);
            Service.StrArr.Builder builder = Service.StrArr.newBuilder();
            for (String s2 : values) {
                builder.addValue(s2);
            }
            value = builder.build();
            map.put(name, (Service.StrArr)value);
        }
        return map;
    }

    private static HttpResponse getDummyResponse(String body, long statusCode, Map<String, Service.StrArr> headerMap, String msg, long protoMajor, long protoMinor) {
        ProtocolVersion protocol = new ProtocolVersion("HTTP", (int)protoMajor, (int)protoMinor);
        BasicHttpResponse response = new BasicHttpResponse(protocol, (int)statusCode, msg);
        response.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON));
        ApacheInterceptor.setResponseHeaders((HttpResponse)response, headerMap);
        return response;
    }

    private static String getResponseBody(HttpResponse response) {
        String resBody = "";
        try {
            if (response.getEntity() == null || response.getEntity().getContent() == null) {
                logger.debug("no response body found");
                return resBody;
            }
            resBody = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            logger.error(" unable to read response body", (Throwable)e);
            return resBody;
        }
        try {
            response.setEntity((HttpEntity)new StringEntity(resBody));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(" unable to read response body", (Throwable)e);
            return resBody;
        }
        return resBody;
    }

    private static void setResponseHeaders(HttpResponse httpResponse, Map<String, Service.StrArr> srcMap) {
        Object values;
        HashMap<String, ArrayList<String>> headerMap = new HashMap<String, ArrayList<String>>();
        for (String key : srcMap.keySet()) {
            values = srcMap.get(key);
            ArrayList<String> headerValues = new ArrayList<String>(((Service.StrArr)values).getValueList());
            headerMap.put(key, headerValues);
        }
        for (String key : headerMap.keySet()) {
            values = (List)headerMap.get(key);
            if (ApacheInterceptor.isCheckSumHeader(key)) continue;
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                httpResponse.addHeader(key, value);
            }
        }
    }

    private static boolean isCheckSumHeader(String checksum) {
        if (checksum.contains("ETag")) {
            return true;
        }
        if (checksum.contains("crc32")) {
            return true;
        }
        return checksum.contains("sha256");
    }

    private static void setBufferEntity(HttpUriRequest request) throws IOException {
        String METHOD;
        switch (METHOD = request.getMethod()) {
            case "POST": {
                HttpPost httpPost = (HttpPost)request;
                ((HttpPost)request).setEntity((HttpEntity)new BufferedHttpEntity(((HttpPost)request).getEntity()));
                break;
            }
            case "PUT": {
                HttpPut httpPut = (HttpPut)request;
                ((HttpPut)request).setEntity((HttpEntity)new BufferedHttpEntity(((HttpPut)request).getEntity()));
                break;
            }
            case "PATCH": {
                HttpPatch httpPatch = (HttpPatch)request;
                ((HttpPatch)request).setEntity((HttpEntity)new BufferedHttpEntity(((HttpPatch)request).getEntity()));
            }
        }
    }

    private static String getRequestBody(HttpUriRequest request) throws IOException {
        String METHOD = request.getMethod();
        String actualBody = "";
        switch (METHOD) {
            case "POST": {
                InputStream reqStream;
                HttpPost httpPost = (HttpPost)request;
                HttpEntity postEntity = httpPost.getEntity();
                if (postEntity == null || (reqStream = postEntity.getContent()) == null) break;
                actualBody = ApacheInterceptor.getActualRequestBody(reqStream);
                httpPost.setEntity((HttpEntity)new StringEntity(actualBody));
                break;
            }
            case "PUT": {
                InputStream reqStream;
                HttpPut httpPut = (HttpPut)request;
                HttpEntity putEntity = httpPut.getEntity();
                if (putEntity == null || (reqStream = putEntity.getContent()) == null) break;
                actualBody = ApacheInterceptor.getActualRequestBody(reqStream);
                httpPut.setEntity((HttpEntity)new StringEntity(actualBody));
                break;
            }
            case "PATCH": {
                InputStream reqStream;
                HttpPatch httpPatch = (HttpPatch)request;
                HttpEntity patchEntity = httpPatch.getEntity();
                if (patchEntity == null || (reqStream = patchEntity.getContent()) == null) break;
                actualBody = ApacheInterceptor.getActualRequestBody(reqStream);
                httpPatch.setEntity((HttpEntity)new StringEntity(actualBody));
                break;
            }
            default: {
                return "";
            }
        }
        return actualBody;
    }

    private static String getActualRequestBody(InputStream reqStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy(reqStream, (OutputStream)baos);
        byte[] reqArr = baos.toByteArray();
        return IOUtils.toString(reqArr, StandardCharsets.UTF_8.toString());
    }

    private static ContentType getContentTypeEntity(String contentType) {
        switch (contentType) {
            case "application/octet-stream": {
                return ContentType.APPLICATION_OCTET_STREAM;
            }
            case "application/x-www-form-urlencoded": {
                return ContentType.APPLICATION_FORM_URLENCODED;
            }
            case "application/json": {
                return ContentType.APPLICATION_JSON;
            }
            case "multipart/form-data": {
                return ContentType.MULTIPART_FORM_DATA;
            }
            case "image/gif": {
                return ContentType.IMAGE_GIF;
            }
            case "image/jpeg": 
            case "image/jpg": {
                return ContentType.IMAGE_JPEG;
            }
            case "image/png": {
                return ContentType.IMAGE_PNG;
            }
            case "text/html": {
                return ContentType.TEXT_HTML;
            }
            case "text/xml": {
                return ContentType.TEXT_XML;
            }
        }
        return ContentType.DEFAULT_TEXT;
    }

    private static boolean isBinaryFile(String resContentType) {
        switch (resContentType) {
            case "application/octet-stream": 
            case "application/pdf": 
            case "image/jpeg": 
            case "image/jpg": 
            case "image/png": 
            case "image/gif": 
            case "text/plain": 
            case "text/html": {
                return true;
            }
        }
        return false;
    }

    private static class ApacheCustomHttpResponse
    extends BasicHttpResponse
    implements CloseableHttpResponse {
        public ApacheCustomHttpResponse(ProtocolVersion ver, int code, String reason) {
            super(ver, code, reason);
        }

        public ApacheCustomHttpResponse(ProtocolVersion ver, int statusCode, String statusMsg, String body) {
            this(ver, statusCode, statusMsg);
            this.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON));
        }

        public ApacheCustomHttpResponse(ProtocolVersion ver, int statusCode, String statusMsg, byte[] body, ContentType contentType) {
            this(ver, statusCode, statusMsg);
            if (contentType.equals(ContentType.APPLICATION_OCTET_STREAM)) {
                this.setEntity((HttpEntity)new ByteArrayEntity(body));
            } else {
                this.setEntity((HttpEntity)new ByteArrayEntity(body, contentType));
            }
        }

        public void close() {
        }
    }
}

