/*
 * Decompiled with CFR 0.152.
 */
package io.keploy.httpClients;

import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import io.keploy.grpc.stubs.Service;
import io.keploy.regression.KeployInstance;
import io.keploy.regression.Mock;
import io.keploy.regression.Mode;
import io.keploy.regression.context.Context;
import io.keploy.regression.context.Kcontext;
import io.keploy.utils.HttpStatusReasons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OkHttpInterceptor_Kotlin
implements Interceptor {
    private static final Logger logger = LogManager.getLogger(OkHttpInterceptor_Kotlin.class);
    private static final String CROSS = new String(Character.toChars(10060));

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        logger.debug("inside OkHttpInterceptor");
        Request request = chain.request();
        Kcontext kctx = Context.getCtx();
        if (kctx == null) {
            logger.debug("simulate call");
            return chain.proceed(request);
        }
        Mode.ModeType modeFromContext = kctx.getMode().getModeFromContext();
        if (modeFromContext.equals((Object)Mode.ModeType.MODE_OFF)) {
            return chain.proceed(request);
        }
        String reqBody = this.getRequestBody(request);
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("name", "okhttp");
        meta.put("type", "HTTP_CLIENT");
        meta.put("operation", request.method());
        meta.put("URL", request.url().toString());
        meta.put("Header", request.headers().toString());
        meta.put("Body", reqBody);
        Response response = null;
        switch (modeFromContext) {
            case MODE_TEST: {
                if (kctx.getMock().size() > 0 && kctx.getMock().get(0).getKind().equals(Mock.Kind.HTTP_EXPORT.value)) {
                    List<Service.Mock> mocks = kctx.getMock();
                    if (mocks.size() > 0 && mocks.get(0).getSpec().getObjectsCount() > 0) {
                        logger.debug("test mode");
                        ByteString bin = mocks.get(0).getSpec().getObjectsList().get(0).getData();
                        Service.HttpResp httpResp = mocks.get(0).getSpec().getRes();
                        String body = httpResp.getBody();
                        long statusCode = httpResp.getStatusCode();
                        Map<String, Service.StrArr> headerMap = httpResp.getHeaderMap();
                        String statusMsg = httpResp.getStatusMessage();
                        MediaType mediaType = MediaType.parse("application/json; charset=utf-8");
                        ResponseBody resBody = ResponseBody.create(mediaType, body);
                        long protoMajor = httpResp.getProtoMajor();
                        long protoMinor = httpResp.getProtoMinor();
                        Protocol protocol = this.getProtocol(protoMinor, protoMajor);
                        Response.Builder resBuilder = new Response.Builder().body(resBody).code((int)statusCode).message(statusMsg).request(request).protocol(protocol);
                        response = this.setResponseHeaders(resBuilder, headerMap);
                        meta.put("ProtoMajor", String.valueOf(protoMajor));
                        meta.put("ProtoMinor", String.valueOf(protoMinor));
                        mocks.remove(0);
                    }
                    if (response == null) {
                        logger.error(CROSS + " unable to read response");
                        throw new RuntimeException("unable to read response");
                    }
                    return response;
                }
                logger.error(CROSS + " mocks not present in " + KeployInstance.getInstance().getKeploy().getCfg().getApp().getMockPath() + " directory.");
                throw new RuntimeException("unable to read mocks from keploy context");
            }
            case MODE_RECORD: {
                logger.debug("record mode");
                response = chain.proceed(request);
                String responseBody = this.getResponseBody(response);
                int statuscode = response.code();
                String statusMsg = HttpStatusReasons.getStatusMsg(statuscode);
                long[] protocol = this.getProtoVersion(response.protocol());
                long ProtoMinor = protocol[0];
                long ProtoMajor = protocol[1];
                Map<String, Service.StrArr> resHeaders = this.getHeadersMap(response.headers());
                Service.HttpResp httpResp = Service.HttpResp.newBuilder().setBody(responseBody).setStatusCode(statuscode).setStatusMessage(statusMsg).setProtoMajor(ProtoMajor).setProtoMinor(ProtoMinor).putAllHeader(resHeaders).build();
                Service.HttpReq httpReq = Service.HttpReq.newBuilder().setMethod(request.method()).setBody(reqBody).setURL(String.valueOf(request.url())).setProtoMajor(ProtoMajor).setProtoMinor(ProtoMinor).putAllHeader(this.getHeadersMap(request.headers())).putAllURLParams(this.getUrlParams(request)).build();
                meta.put("ProtoMajor", String.valueOf(ProtoMajor));
                meta.put("ProtoMinor", String.valueOf(ProtoMinor));
                Service.Mock.Object obj = Service.Mock.Object.newBuilder().setType("error").setData(ByteString.fromHex("")).build();
                ArrayList<Service.Mock.Object> lobj = new ArrayList<Service.Mock.Object>();
                lobj.add(obj);
                Service.Mock.SpecSchema specSchema = Service.Mock.SpecSchema.newBuilder().setReq(httpReq).setRes(httpResp).putAllMetadata(meta).addAllObjects(lobj).build();
                Service.Mock httpMock = Service.Mock.newBuilder().setVersion(Mock.Version.V1_BETA1.value).setKind(Mock.Kind.HTTP_EXPORT.value).setName("").setSpec(specSchema).build();
                kctx.getMock().add(httpMock);
                return response;
            }
        }
        logger.error(CROSS + " integrations: Not in a valid sdk mode");
        return chain.proceed(request);
    }

    private long[] getProtoVersion(Protocol protocol) {
        long[] proto = new long[2];
        String pname = protocol.name();
        if (pname.length() == 6) {
            proto[1] = Character.getNumericValue(pname.charAt(5));
        } else {
            proto[0] = Character.getNumericValue(pname.charAt(7));
            proto[1] = Character.getNumericValue(pname.charAt(5));
        }
        return proto;
    }

    private Protocol getProtocol(long protoMinor, long protoMajor) {
        if (protoMajor == 2L) {
            return Protocol.HTTP_2;
        }
        if (protoMajor == 1L && protoMinor == 1L) {
            return Protocol.HTTP_1_1;
        }
        return Protocol.HTTP_1_0;
    }

    private Map<String, String> getUrlParams(Request request) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : request.url().queryParameterNames()) {
            String value = request.url().queryParameterValues(key).get(0);
            map.put(key, value);
        }
        return map;
    }

    private Response setResponseHeaders(Response.Builder resB, Map<String, Service.StrArr> srcMap) {
        Object values;
        HashMap<String, ArrayList<String>> headerMap = new HashMap<String, ArrayList<String>>();
        for (String key : srcMap.keySet()) {
            values = srcMap.get(key);
            ProtocolStringList valueList = ((Service.StrArr)values).getValueList();
            ArrayList<String> headerValues = new ArrayList<String>(valueList);
            headerMap.put(key, headerValues);
        }
        for (String key : headerMap.keySet()) {
            values = (List)headerMap.get(key);
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                resB.addHeader(key, value);
            }
        }
        return resB.build();
    }

    private Map<String, Service.StrArr> getHeadersMap(Headers headers) {
        Map<String, List<String>> hmap = headers.toMultimap();
        HashMap<String, Service.StrArr> map = new HashMap<String, Service.StrArr>();
        for (String name : hmap.keySet()) {
            List<String> values = hmap.get(name);
            Service.StrArr.Builder builder = Service.StrArr.newBuilder();
            for (String s2 : values) {
                builder.addValue(s2);
            }
            Service.StrArr value = builder.build();
            map.put(name, value);
        }
        return map;
    }

    private String getRequestBody(Request request) {
        if (request.body() != null) {
            try {
                Request copy = request.newBuilder().build();
                Buffer buffer = new Buffer();
                Objects.requireNonNull(copy.body()).writeTo(buffer);
                return buffer.readUtf8();
            }
            catch (IOException e) {
                logger.error(CROSS + " unable to read request body", (Throwable)e);
            }
        }
        return "";
    }

    private String getResponseBody(Response response) throws IOException {
        BufferedSource source = Objects.requireNonNull(response.body()).source();
        source.request(Integer.MAX_VALUE);
        okio.ByteString snapshot = source.buffer().snapshot();
        return snapshot.utf8();
    }
}

