/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.library;

import com.thoughtworks.qdox.builder.Builder;
import com.thoughtworks.qdox.builder.ModelBuilderFactory;
import com.thoughtworks.qdox.builder.impl.ModelBuilder;
import com.thoughtworks.qdox.library.ClassLibrary;
import com.thoughtworks.qdox.library.JavaClassContext;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaModule;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.impl.DefaultDocletTagFactory;
import com.thoughtworks.qdox.model.impl.DefaultJavaPackage;
import com.thoughtworks.qdox.parser.structs.ClassDef;
import com.thoughtworks.qdox.writer.ModelWriterFactory;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public abstract class AbstractClassLibrary
implements ClassLibrary {
    private AbstractClassLibrary parentClassLibrary;
    private ModelBuilderFactory modelBuilderFactory;
    private ModelWriterFactory modelWriterFactory;
    private JavaClassContext context = new JavaClassContext();

    public AbstractClassLibrary() {
    }

    public AbstractClassLibrary(AbstractClassLibrary parent) {
        this.parentClassLibrary = parent;
    }

    @Override
    public Collection<JavaModule> getJavaModules() {
        Collection<JavaModule> modules = null;
        if (this.parentClassLibrary != null) {
            modules = this.parentClassLibrary.getJavaModules();
        }
        return modules;
    }

    @Override
    public final JavaClass getJavaClass(String name) {
        return this.getJavaClass(name, false);
    }

    @Override
    public final JavaClass getJavaClass(String name, boolean createStub) {
        JavaClass result = this.context.getClassByName(name);
        if (result == null && (result = this.resolveJavaClass(name)) != null) {
            this.context.add(result);
            this.context.add(result.getSource());
            JavaPackage contextPackage = this.context.getPackageByName(result.getPackageName());
            if (contextPackage == null) {
                DefaultJavaPackage newContextPackage = new DefaultJavaPackage(result.getPackageName());
                newContextPackage.setClassLibrary(this);
                this.context.add(newContextPackage);
                contextPackage = newContextPackage;
            }
            contextPackage.getClasses().addAll(result.getNestedClasses());
        }
        if (result == null && this.parentClassLibrary != null) {
            result = this.parentClassLibrary.getJavaClass(name);
        }
        if (result == null && createStub) {
            result = this.createStub(name);
        }
        return result;
    }

    private JavaClass createStub(String name) {
        Builder unknownBuilder = this.getModelBuilder();
        unknownBuilder.beginClass(new ClassDef(name));
        unknownBuilder.endClass();
        JavaSource unknownSource = unknownBuilder.getSource();
        return unknownSource.getClasses().get(0);
    }

    protected abstract JavaClass resolveJavaClass(String var1);

    @Override
    public Collection<JavaSource> getJavaSources() {
        return this.context.getSources();
    }

    protected final Collection<JavaSource> getJavaSources(ClassLibraryFilter filter) {
        LinkedList<JavaSource> result = new LinkedList<JavaSource>();
        if (filter.accept(this)) {
            result.addAll(this.context.getSources());
        }
        if (this.parentClassLibrary != null) {
            result.addAll(this.parentClassLibrary.getJavaSources(filter));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<JavaClass> getJavaClasses() {
        return this.context.getClasses();
    }

    protected final Collection<JavaClass> getJavaClasses(ClassLibraryFilter filter) {
        LinkedList<JavaClass> result = new LinkedList<JavaClass>();
        if (filter.accept(this)) {
            result.addAll(this.context.getClasses());
        }
        if (this.parentClassLibrary != null) {
            result.addAll(this.parentClassLibrary.getJavaClasses(filter));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<JavaPackage> getJavaPackages() {
        return this.context.getPackages();
    }

    @Override
    public final JavaPackage getJavaPackage(String name) {
        JavaPackage result = this.context.getPackageByName(name);
        if (result == null && (result = this.resolveJavaPackage(name)) != null) {
            this.context.add(result);
        }
        if (result == null && this.parentClassLibrary != null) {
            result = this.parentClassLibrary.getJavaPackage(name);
        }
        return result;
    }

    protected abstract JavaPackage resolveJavaPackage(String var1);

    protected final Collection<JavaPackage> getJavaPackages(ClassLibraryFilter filter) {
        LinkedList<JavaPackage> result = new LinkedList<JavaPackage>();
        if (filter.accept(this)) {
            result.addAll(this.context.getPackages());
        }
        if (this.parentClassLibrary != null) {
            result.addAll(this.parentClassLibrary.getJavaPackages(filter));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public boolean hasClassReference(String name) {
        boolean result;
        boolean bl = result = this.context.getClassByName(name) != null;
        if (!result) {
            result = this.containsClassReference(name);
        }
        if (!result && this.parentClassLibrary != null) {
            result = this.parentClassLibrary.hasClassReference(name);
        }
        return result;
    }

    protected abstract boolean containsClassReference(String var1);

    public final void setModelBuilderFactory(ModelBuilderFactory factory2) {
        this.modelBuilderFactory = factory2;
    }

    public final void setModelWriterFactory(ModelWriterFactory factory2) {
        this.modelWriterFactory = factory2;
    }

    protected final ModelWriterFactory getModelWriterFactory() {
        return this.modelWriterFactory;
    }

    protected final ModelBuilderFactory getModelBuilderFactory() {
        return this.modelBuilderFactory;
    }

    protected Builder getModelBuilder() {
        ModelBuilder result = this.modelBuilderFactory != null ? this.modelBuilderFactory.newInstance(this) : new ModelBuilder(this, new DefaultDocletTagFactory());
        result.setModelWriterFactory(this.modelWriterFactory);
        return result;
    }

    protected Builder getModelBuilder(URL url) {
        Builder result = this.getModelBuilder();
        result.setUrl(url);
        return result;
    }

    static interface ClassLibraryFilter {
        public boolean accept(AbstractClassLibrary var1);
    }
}

