/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.support;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.http.codec.multipart.FormFieldPart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebExchangeDataBinder
extends WebDataBinder {
    public WebExchangeDataBinder(@Nullable Object target) {
        super(target);
    }

    public WebExchangeDataBinder(@Nullable Object target, String objectName) {
        super(target, objectName);
    }

    public Mono<Void> bind(ServerWebExchange exchange2) {
        return this.getValuesToBind(exchange2).doOnNext(values2 -> this.doBind(new MutablePropertyValues((Map<?, ?>)values2))).then();
    }

    public Mono<Map<String, Object>> getValuesToBind(ServerWebExchange exchange2) {
        return WebExchangeDataBinder.extractValuesToBind(exchange2);
    }

    public static Mono<Map<String, Object>> extractValuesToBind(ServerWebExchange exchange2) {
        MultiValueMap<String, String> queryParams = exchange2.getRequest().getQueryParams();
        Mono<MultiValueMap<String, String>> formData = exchange2.getFormData();
        Mono<MultiValueMap<String, Part>> multipartData = exchange2.getMultipartData();
        return Mono.zip((Mono)Mono.just(queryParams), formData, multipartData).map(tuple -> {
            TreeMap result = new TreeMap();
            ((MultiValueMap)tuple.getT1()).forEach((key, values2) -> WebExchangeDataBinder.addBindValue(result, key, values2));
            ((MultiValueMap)tuple.getT2()).forEach((key, values2) -> WebExchangeDataBinder.addBindValue(result, key, values2));
            ((MultiValueMap)tuple.getT3()).forEach((key, values2) -> WebExchangeDataBinder.addBindValue(result, key, values2));
            return result;
        });
    }

    protected static void addBindValue(Map<String, Object> params, String key, List<?> values2) {
        if (!CollectionUtils.isEmpty(values2)) {
            params.put(key, (values2 = values2.stream().map(value -> value instanceof FormFieldPart ? ((FormFieldPart)value).value() : value).collect(Collectors.toList())).size() == 1 ? values2.get(0) : values2);
        }
    }
}

