/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public abstract class ResolvePathRequest<T> {
    private Path jdkHome;
    private T path;

    private ResolvePathRequest() {
    }

    public static ResolvePathRequest<File> ofFile(File file) {
        ResolvePathRequest<File> request = new ResolvePathRequest<File>(){

            @Override
            protected Path toPath(File f) {
                return f.toPath();
            }
        };
        request.path = file;
        return request;
    }

    public static ResolvePathRequest<Path> ofPath(Path path) {
        ResolvePathRequest<Path> request = new ResolvePathRequest<Path>(){

            @Override
            protected Path toPath(Path p) {
                return p;
            }
        };
        request.path = path;
        return request;
    }

    public static ResolvePathRequest<String> ofString(String string) {
        ResolvePathRequest<String> request = new ResolvePathRequest<String>(){

            @Override
            protected Path toPath(String s2) {
                return Paths.get(s2, new String[0]);
            }
        };
        request.path = string;
        return request;
    }

    protected abstract Path toPath(T var1);

    public T getPathElement() {
        return this.path;
    }

    public ResolvePathRequest<T> setJdkHome(T jdkHome) {
        this.jdkHome = this.toPath(jdkHome);
        return this;
    }

    public Path getJdkHome() {
        return this.jdkHome;
    }
}

