/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.util.scan.mapping;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;

public final class SuffixMapping
implements SourceMapping {
    private final String sourceSuffix;
    private final Set<String> targetSuffixes;

    public SuffixMapping(String sourceSuffix, String targetSuffix) {
        this.sourceSuffix = sourceSuffix;
        this.targetSuffixes = Collections.singleton(targetSuffix);
    }

    public SuffixMapping(String sourceSuffix, Set<String> targetSuffixes) {
        this.sourceSuffix = sourceSuffix;
        this.targetSuffixes = Collections.unmodifiableSet(targetSuffixes);
    }

    @Override
    public Set<File> getTargetFiles(File targetDir, String source2) {
        HashSet<File> targetFiles = new HashSet<File>();
        if (source2.endsWith(this.sourceSuffix)) {
            String base = source2.substring(0, source2.length() - this.sourceSuffix.length());
            for (String suffix : this.targetSuffixes) {
                targetFiles.add(new File(targetDir, base + suffix));
            }
        }
        return targetFiles;
    }
}

