/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.javac;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.javac.InProcessCompiler;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

@Component(role=Compiler.class, hint="javac ")
public class JavacCompiler
extends AbstractCompiler {
    private static final String[] WARNING_PREFIXES = new String[]{"warning: ", "\u8b66\u544a: ", "\u8b66\u544a\uff1a "};
    private static final String[] NOTE_PREFIXES = new String[]{"Note: ", "\u6ce8: ", "\u6ce8\u610f\uff1a "};
    private static final String[] MISC_PREFIXES = new String[]{"["};
    private static final Object LOCK = new Object();
    private static final String JAVAC_CLASSNAME = "com.sun.tools.javac.Main";
    private static volatile Class<?> JAVAC_CLASS;
    private final List<Class<?>> javaccClasses = new CopyOnWriteArrayList();
    @Requirement
    private InProcessCompiler inProcessCompiler;

    public JavacCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    @Override
    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        CompilerResult result;
        String[] sourceFiles;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = JavacCompiler.getSourceFiles(config)) == null || sourceFiles.length == 0) {
            return new CompilerResult();
        }
        if (this.getLogger() != null && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Compiling " + sourceFiles.length + " source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        }
        String[] args2 = JavacCompiler.buildCompilerArguments(config, sourceFiles);
        if (config.isFork()) {
            String executable = config.getExecutable();
            if (StringUtils.isEmpty(executable)) {
                try {
                    executable = JavacCompiler.getJavacExecutable();
                }
                catch (IOException e) {
                    if (this.getLogger() != null && this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("Unable to autodetect 'javac' path, using 'javac' from the environment.");
                    }
                    executable = "javac";
                }
            }
            result = this.compileOutOfProcess(config, executable, args2);
        } else {
            result = JavacCompiler.isJava16() && !config.isForceJavacCompilerUse() ? this.inProcessCompiler().compileInProcess(args2, config, sourceFiles) : this.compileInProcess(args2, config);
        }
        return result;
    }

    protected InProcessCompiler inProcessCompiler() {
        return this.inProcessCompiler;
    }

    protected static boolean isJava16() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("javax.tools.ToolProvider");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return JavacCompiler.buildCompilerArguments(config, JavacCompiler.getSourceFiles(config));
    }

    public static String[] buildCompilerArguments(CompilerConfiguration config, String[] sourceFiles) {
        List<String> sourceLocations;
        List<String> modulepathEntries;
        ArrayList<String> args2 = new ArrayList<String>();
        File destinationDir = new File(config.getOutputLocation());
        args2.add("-d");
        args2.add(destinationDir.getAbsolutePath());
        List<String> classpathEntries = config.getClasspathEntries();
        if (classpathEntries != null && !classpathEntries.isEmpty()) {
            args2.add("-classpath");
            args2.add(JavacCompiler.getPathString(classpathEntries));
        }
        if ((modulepathEntries = config.getModulepathEntries()) != null && !modulepathEntries.isEmpty()) {
            args2.add("--module-path");
            args2.add(JavacCompiler.getPathString(modulepathEntries));
        }
        if ((sourceLocations = config.getSourceLocations()) != null && !sourceLocations.isEmpty()) {
            args2.add("-sourcepath");
            args2.add(JavacCompiler.getPathString(sourceLocations));
        }
        if (!JavacCompiler.isJava16() || config.isForceJavacCompilerUse() || config.isFork()) {
            args2.addAll(Arrays.asList(sourceFiles));
        }
        if (!JavacCompiler.isPreJava16(config)) {
            if (config.getGeneratedSourcesDirectory() != null) {
                config.getGeneratedSourcesDirectory().mkdirs();
                args2.add("-s");
                args2.add(config.getGeneratedSourcesDirectory().getAbsolutePath());
            }
            if (config.getProc() != null) {
                args2.add("-proc:" + config.getProc());
            }
            if (config.getAnnotationProcessors() != null) {
                args2.add("-processor");
                String[] procs = config.getAnnotationProcessors();
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < procs.length; ++i) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(procs[i]);
                }
                args2.add(buffer.toString());
            }
            if (config.getProcessorPathEntries() != null && !config.getProcessorPathEntries().isEmpty()) {
                args2.add("-processorpath");
                args2.add(JavacCompiler.getPathString(config.getProcessorPathEntries()));
            }
            if (config.getProcessorModulePathEntries() != null && !config.getProcessorModulePathEntries().isEmpty()) {
                args2.add("--processor-module-path");
                args2.add(JavacCompiler.getPathString(config.getProcessorModulePathEntries()));
            }
        }
        if (config.isOptimize()) {
            args2.add("-O");
        }
        if (config.isDebug()) {
            if (StringUtils.isNotEmpty(config.getDebugLevel())) {
                args2.add("-g:" + config.getDebugLevel());
            } else {
                args2.add("-g");
            }
        }
        if (config.isVerbose()) {
            args2.add("-verbose");
        }
        if (!JavacCompiler.isPreJava18(config) && config.isParameters()) {
            args2.add("-parameters");
        }
        if (config.isEnablePreview()) {
            args2.add("--enable-preview");
        }
        if (config.isShowDeprecation()) {
            args2.add("-deprecation");
            config.setShowWarnings(true);
        }
        if (!config.isShowWarnings()) {
            args2.add("-nowarn");
        } else {
            String warnings = config.getWarnings();
            if (config.isShowLint()) {
                if (config.isShowWarnings() && StringUtils.isNotEmpty(warnings)) {
                    args2.add("-Xlint:" + warnings);
                } else {
                    args2.add("-Xlint");
                }
            }
        }
        if (config.isFailOnWarning()) {
            args2.add("-Werror");
        }
        if (!StringUtils.isEmpty(config.getReleaseVersion())) {
            args2.add("--release");
            args2.add(config.getReleaseVersion());
        } else {
            if (StringUtils.isEmpty(config.getTargetVersion())) {
                args2.add("-target");
                args2.add("1.1");
            } else {
                args2.add("-target");
                args2.add(config.getTargetVersion());
            }
            if (!JavacCompiler.suppressSource(config) && StringUtils.isEmpty(config.getSourceVersion())) {
                args2.add("-source");
                args2.add("1.3");
            } else if (!JavacCompiler.suppressSource(config)) {
                args2.add("-source");
                args2.add(config.getSourceVersion());
            }
        }
        if (!JavacCompiler.suppressEncoding(config) && !StringUtils.isEmpty(config.getSourceEncoding())) {
            args2.add("-encoding");
            args2.add(config.getSourceEncoding());
        }
        if (!StringUtils.isEmpty(config.getModuleVersion())) {
            args2.add("--module-version");
            args2.add(config.getModuleVersion());
        }
        for (Map.Entry<String, String> entry : config.getCustomCompilerArgumentsEntries()) {
            String key = entry.getKey();
            if (StringUtils.isEmpty(key) || key.startsWith("-J")) continue;
            args2.add(key);
            String value = entry.getValue();
            if (StringUtils.isEmpty(value)) continue;
            args2.add(value);
        }
        return args2.toArray(new String[0]);
    }

    private static boolean isPreJava14(CompilerConfiguration config) {
        String v = config.getCompilerVersion();
        if (v == null) {
            return false;
        }
        return v.startsWith("1.3") || v.startsWith("1.2") || v.startsWith("1.1") || v.startsWith("1.0");
    }

    private static boolean isPreJava16(CompilerConfiguration config) {
        String v = config.getReleaseVersion();
        if (v == null) {
            v = config.getCompilerVersion();
        }
        if (v == null) {
            v = config.getSourceVersion();
        }
        if (v == null) {
            return true;
        }
        return v.startsWith("5") || v.startsWith("1.5") || v.startsWith("1.4") || v.startsWith("1.3") || v.startsWith("1.2") || v.startsWith("1.1") || v.startsWith("1.0");
    }

    private static boolean isPreJava18(CompilerConfiguration config) {
        String v = config.getReleaseVersion();
        if (v == null) {
            v = config.getCompilerVersion();
        }
        if (v == null) {
            v = config.getSourceVersion();
        }
        if (v == null) {
            return true;
        }
        return v.startsWith("7") || v.startsWith("1.7") || v.startsWith("6") || v.startsWith("1.6") || v.startsWith("1.5") || v.startsWith("1.4") || v.startsWith("1.3") || v.startsWith("1.2") || v.startsWith("1.1") || v.startsWith("1.0");
    }

    private static boolean isPreJava9(CompilerConfiguration config) {
        String v = config.getReleaseVersion();
        if (v == null) {
            v = config.getCompilerVersion();
        }
        if (v == null) {
            v = config.getSourceVersion();
        }
        if (v == null) {
            return true;
        }
        return v.startsWith("8") || v.startsWith("1.8") || v.startsWith("7") || v.startsWith("1.7") || v.startsWith("1.6") || v.startsWith("1.5") || v.startsWith("1.4") || v.startsWith("1.3") || v.startsWith("1.2") || v.startsWith("1.1") || v.startsWith("1.0");
    }

    private static boolean suppressSource(CompilerConfiguration config) {
        return JavacCompiler.isPreJava14(config);
    }

    private static boolean suppressEncoding(CompilerConfiguration config) {
        return JavacCompiler.isPreJava14(config);
    }

    protected CompilerResult compileOutOfProcess(CompilerConfiguration config, String executable, String[] args2) throws CompilerException {
        List<CompilerMessage> messages;
        int returnCode;
        CommandLineUtils.StringStreamConsumer out;
        Commandline cli;
        block11: {
            cli = new Commandline();
            cli.setWorkingDirectory(config.getWorkingDirectory().getAbsolutePath());
            cli.setExecutable(executable);
            try {
                File argumentsFile = this.createFileWithArguments(args2, config.getBuildDirectory().getAbsolutePath());
                cli.addArguments(new String[]{"@" + argumentsFile.getCanonicalPath().replace(File.separatorChar, '/')});
                if (!StringUtils.isEmpty(config.getMaxmem())) {
                    cli.addArguments(new String[]{"-J-Xmx" + config.getMaxmem()});
                }
                if (!StringUtils.isEmpty(config.getMeminitial())) {
                    cli.addArguments(new String[]{"-J-Xms" + config.getMeminitial()});
                }
                for (String key : config.getCustomCompilerArgumentsAsMap().keySet()) {
                    if (!StringUtils.isNotEmpty(key) || !key.startsWith("-J")) continue;
                    cli.addArguments(new String[]{key});
                }
            }
            catch (IOException e) {
                throw new CompilerException("Error creating file with javac arguments", e);
            }
            out = new CommandLineUtils.StringStreamConsumer();
            if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                String debugFileName = StringUtils.isEmpty(config.getDebugFileName()) ? "javac" : config.getDebugFileName();
                File commandLineFile = new File(config.getBuildDirectory(), StringUtils.trim(debugFileName) + "." + (Os.isFamily("windows") ? "bat" : "sh"));
                try {
                    FileUtils.fileWrite(commandLineFile.getAbsolutePath(), cli.toString().replaceAll("'", ""));
                    if (!Os.isFamily("windows")) {
                        Runtime.getRuntime().exec(new String[]{"chmod", "a+x", commandLineFile.getAbsolutePath()});
                    }
                }
                catch (IOException e) {
                    if (this.getLogger() == null || !this.getLogger().isWarnEnabled()) break block11;
                    this.getLogger().warn("Unable to write '" + commandLineFile.getName() + "' debug script file", (Throwable)e);
                }
            }
        }
        try {
            returnCode = CommandLineUtils.executeCommandLine(cli, out, out);
            messages = JavacCompiler.parseModernStream(returnCode, new BufferedReader(new StringReader(out.getOutput())));
        }
        catch (IOException | CommandLineException e) {
            throw new CompilerException("Error while executing the external compiler.", e);
        }
        boolean success = returnCode == 0;
        return new CompilerResult(success, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompilerResult compileInProcess(String[] args2, CompilerConfiguration config) throws CompilerException {
        Class<?> javacClass = this.getJavacClass(config);
        Thread thread2 = Thread.currentThread();
        ClassLoader contextClassLoader = thread2.getContextClassLoader();
        thread2.setContextClassLoader(javacClass.getClassLoader());
        if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ttcl changed run compileInProcessWithProperClassloader");
        }
        try {
            CompilerResult compilerResult = this.compileInProcessWithProperClassloader(javacClass, args2);
            return compilerResult;
        }
        finally {
            this.releaseJavaccClass(javacClass, config);
            thread2.setContextClassLoader(contextClassLoader);
        }
    }

    protected CompilerResult compileInProcessWithProperClassloader(Class<?> javacClass, String[] args2) throws CompilerException {
        return JavacCompiler.compileInProcess0(javacClass, args2);
    }

    private static CompilerResult compileInProcess0(Class<?> javacClass, String[] args2) throws CompilerException {
        List<CompilerMessage> messages;
        Integer ok;
        StringWriter out = new StringWriter();
        try {
            Method compile = javacClass.getMethod("compile", String[].class, PrintWriter.class);
            ok = (Integer)compile.invoke(null, args2, new PrintWriter(out));
            messages = JavacCompiler.parseModernStream(ok, new BufferedReader(new StringReader(out.toString())));
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CompilerException("Error while executing the compiler.", e);
        }
        boolean success = ok == 0;
        return new CompilerResult(success, messages);
    }

    static List<CompilerMessage> parseModernStream(int exitCode, BufferedReader input) throws IOException {
        ArrayList<CompilerMessage> errors = new ArrayList<CompilerMessage>();
        StringBuilder buffer = new StringBuilder();
        boolean hasPointer = false;
        while (true) {
            String line;
            if ((line = input.readLine()) == null) {
                String bufferAsString = buffer.toString();
                if (buffer.length() > 0) {
                    if (bufferAsString.startsWith("javac:")) {
                        errors.add(new CompilerMessage(bufferAsString, CompilerMessage.Kind.ERROR));
                    } else if (bufferAsString.startsWith("Error occurred during initialization of boot layer")) {
                        errors.add(new CompilerMessage(bufferAsString, CompilerMessage.Kind.OTHER));
                    } else if (hasPointer) {
                        errors.add(JavacCompiler.parseModernError(exitCode, bufferAsString));
                    }
                }
                return errors;
            }
            if (line.startsWith("An exception has occurred in the compiler")) {
                buffer = new StringBuilder();
                while (line != null) {
                    buffer.append(line);
                    buffer.append(EOL);
                    line = input.readLine();
                }
                errors.add(new CompilerMessage(buffer.toString(), CompilerMessage.Kind.ERROR));
                return errors;
            }
            if (line.startsWith("An annotation processor threw an uncaught exception.")) {
                CompilerMessage annotationProcessingError = JavacCompiler.parseAnnotationProcessorStream(input);
                errors.add(annotationProcessingError);
            }
            if (!line.startsWith(" ") && hasPointer) {
                errors.add(JavacCompiler.parseModernError(exitCode, buffer.toString()));
                buffer = new StringBuilder();
                hasPointer = false;
            }
            if (buffer.length() == 0 && line.startsWith("error: ")) {
                errors.add(new CompilerMessage(line, CompilerMessage.Kind.ERROR));
            } else if (buffer.length() == 0 && line.startsWith("warning: ")) {
                errors.add(new CompilerMessage(line, CompilerMessage.Kind.WARNING));
            } else if (buffer.length() != 0 || !JavacCompiler.isNote(line)) {
                if (buffer.length() == 0 && JavacCompiler.isMisc(line)) {
                    errors.add(new CompilerMessage(line, CompilerMessage.Kind.OTHER));
                } else {
                    buffer.append(line);
                    buffer.append(EOL);
                }
            }
            if (!line.endsWith("^")) continue;
            hasPointer = true;
        }
    }

    private static CompilerMessage parseAnnotationProcessorStream(BufferedReader input) throws IOException {
        String line = input.readLine();
        StringBuilder buffer = new StringBuilder();
        while (line != null) {
            if (!line.startsWith("Consult the following stack trace for details.")) {
                buffer.append(line);
                buffer.append(EOL);
            }
            line = input.readLine();
        }
        return new CompilerMessage(buffer.toString(), CompilerMessage.Kind.ERROR);
    }

    private static boolean isMisc(String line) {
        return JavacCompiler.startsWithPrefix(line, MISC_PREFIXES);
    }

    private static boolean isNote(String line) {
        return JavacCompiler.startsWithPrefix(line, NOTE_PREFIXES);
    }

    private static boolean startsWithPrefix(String line, String[] prefixes) {
        for (String prefix : prefixes) {
            if (!line.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    static CompilerMessage parseModernError(int exitCode, String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        boolean isError = exitCode != 0;
        try {
            int endcolumn;
            boolean tokenIsAnInteger;
            StringBuilder file = null;
            String currentToken = null;
            do {
                if (currentToken != null) {
                    if (file == null) {
                        file = new StringBuilder(currentToken);
                    } else {
                        file.append(':').append(currentToken);
                    }
                }
                currentToken = tokens.nextToken();
                tokenIsAnInteger = true;
                try {
                    Integer.parseInt(currentToken);
                }
                catch (NumberFormatException e) {
                    tokenIsAnInteger = false;
                }
            } while (!tokenIsAnInteger);
            String lineIndicator = currentToken;
            int startOfFileName = file.toString().lastIndexOf(93);
            if (startOfFileName > -1) {
                file = new StringBuilder(file.substring(startOfFileName + 1 + EOL.length()));
            }
            int line = Integer.parseInt(lineIndicator);
            StringBuilder msgBuffer = new StringBuilder();
            String msg = tokens.nextToken(EOL).substring(2);
            String warnPrefix = JavacCompiler.getWarnPrefix(msg);
            if (warnPrefix != null) {
                isError = false;
                msg = msg.substring(warnPrefix.length());
            } else {
                isError = exitCode != 0;
            }
            msgBuffer.append(msg);
            msgBuffer.append(EOL);
            String context = tokens.nextToken(EOL);
            String pointer = null;
            do {
                String msgLine = tokens.nextToken(EOL);
                if (pointer != null) {
                    msgBuffer.append(msgLine);
                    msgBuffer.append(EOL);
                    continue;
                }
                if (msgLine.endsWith("^")) {
                    pointer = msgLine;
                    continue;
                }
                msgBuffer.append(context);
                msgBuffer.append(EOL);
                context = msgLine;
            } while (tokens.hasMoreTokens());
            msgBuffer.append(EOL);
            String message = msgBuffer.toString();
            int startcolumn = pointer.indexOf("^");
            int n = endcolumn = context == null ? startcolumn : context.indexOf(" ", startcolumn);
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new CompilerMessage(file.toString(), isError, line, startcolumn, line, endcolumn, message.trim());
        }
        catch (NoSuchElementException e) {
            return new CompilerMessage("no more tokens - could not parse error message: " + error, isError);
        }
        catch (Exception e) {
            return new CompilerMessage("could not parse error message: " + error, isError);
        }
    }

    private static String getWarnPrefix(String msg) {
        for (String warningPrefix : WARNING_PREFIXES) {
            if (!msg.startsWith(warningPrefix)) continue;
            return warningPrefix;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileWithArguments(String[] args2, String outputDirectory) throws IOException {
        try (PrintWriter writer = null;){
            File tempFile;
            if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                tempFile = File.createTempFile(JavacCompiler.class.getName(), "arguments", new File(outputDirectory));
            } else {
                tempFile = File.createTempFile(JavacCompiler.class.getName(), "arguments");
                tempFile.deleteOnExit();
            }
            writer = new PrintWriter(new FileWriter(tempFile));
            for (String arg : args2) {
                String argValue = arg.replace(File.separatorChar, '/');
                writer.write("\"" + argValue + "\"");
                writer.println();
            }
            writer.flush();
            File file = tempFile;
            return file;
        }
    }

    private static String getJavacExecutable() throws IOException {
        String javacCommand = "javac" + (Os.isFamily("windows") ? ".exe" : "");
        String javaHome = System.getProperty("java.home");
        File javacExe = Os.isName("AIX") ? new File(javaHome + File.separator + ".." + File.separator + "sh", javacCommand) : (Os.isName("Mac OS X") ? new File(javaHome + File.separator + "bin", javacCommand) : new File(javaHome + File.separator + ".." + File.separator + "bin", javacCommand));
        if (!javacExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty(javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).isDirectory()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            javacExe = new File(env.getProperty("JAVA_HOME") + File.separator + "bin", javacCommand);
        }
        if (!javacExe.isFile()) {
            throw new IOException("The javadoc executable '" + javacExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return javacExe.getAbsolutePath();
    }

    private void releaseJavaccClass(Class<?> javaccClass, CompilerConfiguration compilerConfiguration) {
        if (compilerConfiguration.getCompilerReuseStrategy() == CompilerConfiguration.CompilerReuseStrategy.ReuseCreated) {
            this.javaccClasses.add(javaccClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getJavacClass(CompilerConfiguration compilerConfiguration) throws CompilerException {
        Class<?> c = null;
        switch (compilerConfiguration.getCompilerReuseStrategy()) {
            case AlwaysNew: {
                return this.createJavacClass();
            }
            case ReuseCreated: {
                List<Class<?>> list = this.javaccClasses;
                synchronized (list) {
                    if (this.javaccClasses.size() > 0) {
                        c = this.javaccClasses.get(0);
                        this.javaccClasses.remove(c);
                        return c;
                    }
                }
                c = this.createJavacClass();
                return c;
            }
        }
        c = JAVAC_CLASS;
        if (c != null) {
            return c;
        }
        Object object = LOCK;
        synchronized (object) {
            if (c == null) {
                JAVAC_CLASS = c = this.createJavacClass();
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> createJavacClass() throws CompilerException {
        try {
            return JavacCompiler.class.getClassLoader().loadClass(JAVAC_CLASSNAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            File toolsJar = new File(System.getProperty("java.home"), "../lib/tools.jar");
            if (!toolsJar.exists()) {
                throw new CompilerException("tools.jar not found: " + toolsJar);
            }
            URL[] originalUrls = ((URLClassLoader)JavacCompiler.class.getClassLoader()).getURLs();
            URL[] urls2 = new URL[originalUrls.length + 1];
            urls2[0] = toolsJar.toURI().toURL();
            System.arraycopy(originalUrls, 0, urls2, 1, originalUrls.length);
            URLClassLoader javacClassLoader = new URLClassLoader(urls2);
            Thread thread2 = Thread.currentThread();
            ClassLoader contextClassLoader = thread2.getContextClassLoader();
            thread2.setContextClassLoader(javacClassLoader);
            try {
                Class<?> clazz = javacClassLoader.loadClass(JAVAC_CLASSNAME);
                thread2.setContextClassLoader(contextClassLoader);
                return clazz;
            }
            catch (Throwable throwable) {
                try {
                    thread2.setContextClassLoader(contextClassLoader);
                    throw throwable;
                }
                catch (MalformedURLException ex) {
                    throw new CompilerException("Could not convert the file reference to tools.jar to a URL, path to tools.jar: '" + toolsJar.getAbsolutePath() + "'.", ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new CompilerException("Unable to locate the Javac Compiler in:" + EOL + "  " + toolsJar + EOL + "Please ensure you are using JDK 1.4 or above and" + EOL + "not a JRE (the com.sun.tools.javac.Main class is required)." + EOL + "In most cases you can change the location of your Java" + EOL + "installation by setting the JAVA_HOME environment variable.", ex);
                }
            }
        }
    }
}

