/*
 * Decompiled with CFR 0.152.
 */
package io.keploy.servlet;

import io.keploy.grpc.stubs.Service;
import io.keploy.regression.KeployInstance;
import io.keploy.regression.context.Context;
import io.keploy.regression.context.Kcontext;
import io.keploy.regression.keploy.AppConfig;
import io.keploy.regression.keploy.Config;
import io.keploy.regression.keploy.Keploy;
import io.keploy.regression.keploy.ServerConfig;
import io.keploy.regression.mode;
import io.keploy.service.GrpcService;
import io.keploy.utils.HaltThread;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

@Component
public class middleware
extends HttpFilter {
    private static final Logger logger = LogManager.getLogger(middleware.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        HaltThread.getInstance();
        CountDownLatch countDownLatch = HaltThread.getCountDownLatch();
        logger.debug("initializing keploy");
        KeployInstance ki = KeployInstance.getInstance();
        Keploy kp = new Keploy();
        Config cfg = new Config();
        AppConfig appConfig = new AppConfig();
        if (System.getenv("APP_NAME") != null) {
            appConfig.setName(System.getenv("APP_NAME"));
        }
        if (System.getenv("APP_PORT") != null) {
            appConfig.setPort(System.getenv("APP_PORT"));
        }
        ServerConfig serverConfig = new ServerConfig();
        if (System.getenv("DENOISE") != null) {
            serverConfig.setDenoise(Boolean.valueOf(System.getenv("DENOISE")));
        }
        if (System.getenv("KEPLOY_URL") != null) {
            serverConfig.setURL(System.getenv("KEPLOY_URL"));
        }
        cfg.setApp(appConfig);
        cfg.setServer(serverConfig);
        kp.setCfg(cfg);
        KeployInstance.setKeploy(kp);
        GrpcService grpcService = new GrpcService();
        mode.ModeType KEPLOY_MODE = mode.getMode();
        new Thread(() -> {
            if (KEPLOY_MODE != null && KEPLOY_MODE.equals((Object)mode.ModeType.MODE_TEST)) {
                try {
                    logger.debug("calling test Method");
                    grpcService.Test();
                }
                catch (Exception e) {
                    logger.error("failed to run tests", (Throwable)e);
                }
                countDownLatch.countDown();
                try {
                    Thread.sleep(10000L);
                    System.exit(0);
                }
                catch (InterruptedException e) {
                    logger.error("Failed to shut test run properly... ", (Throwable)e);
                }
            }
        }).start();
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        KeployInstance ki = KeployInstance.getInstance();
        Keploy k = ki.getKeploy();
        logger.debug("inside middleware: incoming request");
        logger.debug("mode: {}", (Object)mode.getMode());
        if (k == null || mode.getMode() != null && mode.getMode().equals((Object)mode.ModeType.MODE_OFF)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Context.setCtx(new Kcontext(request, null, null, null));
        ContentCachingRequestWrapper requestWrapper = new ContentCachingRequestWrapper(request);
        ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper(response);
        filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        byte[] reqArr = requestWrapper.getContentAsByteArray();
        byte[] resArr = responseWrapper.getContentAsByteArray();
        String requestBody = this.getStringValue(reqArr, request.getCharacterEncoding());
        String responseBody = this.getStringValue(resArr, response.getCharacterEncoding());
        logger.debug("request body inside middleware: {}", (Object)requestBody);
        logger.debug("response body inside middleware: {}", (Object)responseBody);
        Map<String, Service.StrArr> simResponseHeaderMap = this.getResponseHeaderMap(responseWrapper);
        Service.HttpResp simulateResponse = Service.HttpResp.newBuilder().setStatusCode(responseWrapper.getStatus()).setBody(responseBody).putAllHeader(simResponseHeaderMap).build();
        logger.debug("simulate response inside middleware: {}", (Object)simulateResponse);
        String keploy_test_id = request.getHeader("KEPLOY_TEST_ID");
        logger.debug("KEPLOY_TEST_ID: {}", (Object)keploy_test_id);
        if (keploy_test_id != null) {
            k.getResp().put(keploy_test_id, simulateResponse);
            Context.cleanup();
            logger.debug("response in keploy resp map: {} ", (Object)k.getResp().get(keploy_test_id));
        } else {
            Map<String, String> urlParams = this.setUrlParams(requestWrapper.getParameterMap());
            Service.HttpResp.Builder builder = Service.HttpResp.newBuilder();
            Map<String, Service.StrArr> headerMap = this.getResponseHeaderMap(responseWrapper);
            Service.HttpResp httpResp = builder.setStatusCode(responseWrapper.getStatus()).setBody(responseBody).putAllHeader(headerMap).build();
            try {
                GrpcService.CaptureTestCases(ki, requestBody, urlParams, httpResp);
            }
            catch (Exception e) {
                logger.error("failed to capture testCases", (Throwable)e);
            }
        }
        responseWrapper.copyBodyToResponse();
        logger.debug("inside middleware: outgoing response");
    }

    public Map<String, Service.StrArr> getResponseHeaderMap(ContentCachingResponseWrapper contentCachingResponseWrapper) {
        HashMap<String, Service.StrArr> map = new HashMap<String, Service.StrArr>();
        ArrayList headerNames = new ArrayList(contentCachingResponseWrapper.getHeaderNames());
        for (String name : headerNames) {
            if (name == null) continue;
            ArrayList values2 = new ArrayList(contentCachingResponseWrapper.getHeaders(name));
            Service.StrArr.Builder builder = Service.StrArr.newBuilder();
            for (String s2 : values2) {
                builder.addValue(s2);
            }
            Service.StrArr value = builder.build();
            map.put(name, value);
        }
        return map;
    }

    public Map<String, String> setUrlParams(Map<String, String[]> param) {
        HashMap<String, String> urlParams = new HashMap<String, String>();
        for (String key : param.keySet()) {
            String value = param.get(key)[0];
            if (key == null || value == null) continue;
            urlParams.put(key, value);
        }
        return urlParams;
    }

    private String getStringValue(byte[] contentAsByteArray, String characterEncoding) {
        try {
            return new String(contentAsByteArray, 0, contentAsByteArray.length, characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void destroy() {
    }
}

