/*
 * Decompiled with CFR 0.152.
 */
package io.keploy.service;

import io.keploy.service.GrpcService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpPostMultipart {
    private static final Logger logger = LogManager.getLogger(HttpPostMultipart.class);
    private static final String CROSS = new String(Character.toChars(10060));
    private final String boundary = UUID.randomUUID().toString();
    private static final String LINE = "\r\n";
    private final HttpURLConnection httpConn;
    private final String charset;
    private final OutputStream outputStream;
    private final PrintWriter writer;

    public HttpPostMultipart(String charset, HttpURLConnection httpConn) throws IOException {
        this.charset = charset;
        this.httpConn = httpConn;
        this.httpConn.setUseCaches(false);
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.outputStream = this.httpConn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, charset), true);
    }

    public void addFormField(String name, String value) {
        this.writer.append("--" + this.boundary).append(LINE);
        this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE);
        this.writer.append("Content-Type: text/plain; charset=" + this.charset).append(LINE);
        this.writer.append(LINE);
        this.writer.append(value).append(LINE);
        this.writer.flush();
    }

    public void addFilePart(String fieldName, File uploadFile) throws IOException {
        String fileName = uploadFile.getName();
        this.writer.append("--" + this.boundary).append(LINE);
        this.writer.append("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"").append(LINE);
        this.writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(fileName)).append(LINE);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE);
        this.writer.append(LINE);
        this.writer.flush();
        FileInputStream inputStream = new FileInputStream(uploadFile);
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            this.outputStream.write(buffer, 0, bytesRead);
        }
        this.outputStream.flush();
        inputStream.close();
        this.writer.append(LINE);
        this.writer.flush();
    }

    public void finish() throws IOException {
        String responseBody = "";
        this.writer.flush();
        this.writer.append("--" + this.boundary + "--").append(LINE);
        this.writer.close();
        int status = this.httpConn.getResponseCode();
        logger.debug("status code got from simulate request: {}", (Object)status);
        Map<String, List<String>> responseHeaders = this.httpConn.getHeaderFields();
        logger.debug("response headers got from simulate request: {}", responseHeaders);
        if (!GrpcService.isSuccessfulResponse(this.httpConn)) {
            throw new IOException("Server returned non-OK status: " + status);
        }
        responseBody = GrpcService.getSimulateResponseBody(this.httpConn);
        logger.debug("response body got from multipart simulate request: {}", (Object)responseBody);
    }
}

