/*
 * Decompiled with CFR 0.152.
 */
package io.keploy.service;

import com.google.protobuf.ProtocolStringList;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.keploy.grpc.stubs.RegressionServiceGrpc;
import io.keploy.grpc.stubs.Service;
import io.keploy.regression.KeployInstance;
import io.keploy.regression.Mode;
import io.keploy.regression.context.Context;
import io.keploy.regression.context.Kcontext;
import io.keploy.regression.keploy.Keploy;
import io.keploy.utils.AssertKTests;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import me.tongfei.progressbar.ProgressBar;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GrpcService {
    private static final Logger logger = LogManager.getLogger(GrpcService.class);
    private static final String CROSS = new String(Character.toChars(10060));
    private static RegressionServiceGrpc.RegressionServiceBlockingStub blockingStub = null;
    private static Keploy k = null;
    public static ManagedChannel channel;
    public static OkHttpClient client;
    private static final String SET_PLAIN_TEXT = "\u001b[0;0m";
    private static final String SET_BOLD_TEXT = "\u001b[0;1m";

    public GrpcService() {
        k = KeployInstance.getInstance().getKeploy();
        channel = ManagedChannelBuilder.forTarget((String)this.getTarget()).usePlaintext().build();
        blockingStub = RegressionServiceGrpc.newBlockingStub((Channel)channel);
        client = new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.MINUTES).writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).followRedirects(false).build();
    }

    private String getTarget() {
        URL url;
        try {
            url = new URL(k.getCfg().getServer().getURL());
        }
        catch (MalformedURLException e) {
            logger.error(CROSS + " unable to make GrpcConnection", (Throwable)e);
            return "localhost:6789";
        }
        return url.getAuthority();
    }

    public static void CaptureTestCases(String reqBody, Map<String, String> params, Service.HttpResp httpResp, String protocolType) {
        logger.debug("inside CaptureTestCases");
        Kcontext kctx = Context.getCtx();
        HttpServletRequest ctxReq = kctx.getRequest();
        if (ctxReq == null) {
            logger.error(CROSS + " failed to get keploy context");
            return;
        }
        Service.TestCaseReq.Builder testCaseReqBuilder = Service.TestCaseReq.newBuilder();
        Service.HttpReq.Builder httpReqBuilder = Service.HttpReq.newBuilder();
        String url = ctxReq.getQueryString() == null ? ctxReq.getRequestURI() : ctxReq.getRequestURI() + "?" + ctxReq.getQueryString();
        httpReqBuilder.setMethod(ctxReq.getMethod()).setURL(url);
        httpReqBuilder.putAllURLParams(params);
        Map<String, Service.StrArr> headerMap = GrpcService.getRequestHeaderMap(ctxReq);
        httpReqBuilder.putAllHeader(headerMap);
        httpReqBuilder.setBody(reqBody);
        httpReqBuilder.setProtoMajor((long)Character.getNumericValue(protocolType.charAt(protocolType.length() - 3)));
        httpReqBuilder.setProtoMinor((long)Character.getNumericValue(protocolType.charAt(protocolType.length() - 1)));
        Service.HttpReq httpReq = httpReqBuilder.build();
        testCaseReqBuilder.setAppID(k.getCfg().getApp().getName());
        testCaseReqBuilder.setCaptured(Instant.now().getEpochSecond());
        testCaseReqBuilder.setURI(ctxReq.getRequestURI());
        testCaseReqBuilder.setHttpResp(httpResp);
        testCaseReqBuilder.setHttpReq(httpReq);
        testCaseReqBuilder.setTestCasePath(k.getCfg().getApp().getTestPath());
        testCaseReqBuilder.setMockPath(k.getCfg().getApp().getMockPath());
        testCaseReqBuilder.addAllMocks((Iterable)kctx.getMock());
        GrpcService.Capture(testCaseReqBuilder.build());
    }

    public static void Capture(Service.TestCaseReq testCaseReq) {
        new Thread(() -> {
            try {
                GrpcService.put(testCaseReq);
            }
            catch (Exception e) {
                logger.error(CROSS + " failed to send test case to backend", (Throwable)e);
            }
        }).start();
    }

    public static void put(Service.TestCaseReq testCaseReq) {
        Service.postTCResponse postTCResponse2;
        try {
            postTCResponse2 = blockingStub.postTC(testCaseReq);
        }
        catch (Exception e) {
            logger.error(CROSS + " failed to send testcase to backend, please ensure keploy server is up!", (Throwable)e);
            logger.error(CROSS + " please check keploy server logs if server is up");
            return;
        }
        Map tcsId = postTCResponse2.getTcsIdMap();
        String id = (String)tcsId.get("id");
        if (id == null) {
            return;
        }
        boolean noise = k.getCfg().getServer().getDenoise();
        if (noise) {
            GrpcService.denoise(id, testCaseReq);
        }
    }

    public static void denoise(String id, Service.TestCaseReq testCaseReq) {
        try {
            TimeUnit.SECONDS.sleep(3L);
        }
        catch (InterruptedException e) {
            logger.error(CROSS + " (denoise): unable to sleep", (Throwable)e);
        }
        Service.TestCase.Builder testCaseBuilder = Service.TestCase.newBuilder();
        testCaseBuilder.setId(id);
        testCaseBuilder.setCaptured(testCaseReq.getCaptured());
        testCaseBuilder.setURI(testCaseReq.getURI());
        testCaseBuilder.setHttpReq(testCaseReq.getHttpReq());
        testCaseBuilder.addAllMocks((Iterable)testCaseReq.getMocksList());
        Service.TestCase testCase = testCaseBuilder.build();
        Service.HttpResp resp2 = GrpcService.simulate(testCase);
        logger.debug("response got from simulate request: {}", (Object)resp2);
        Service.TestReq.Builder testReqBuilder = Service.TestReq.newBuilder();
        testReqBuilder.setID(id);
        testReqBuilder.setResp(resp2);
        testReqBuilder.setAppID(k.getCfg().getApp().getName());
        testReqBuilder.setTestCasePath(k.getCfg().getApp().getTestPath());
        testReqBuilder.setMockPath(k.getCfg().getApp().getMockPath());
        Service.TestReq bin2 = testReqBuilder.build();
        try {
            Service.deNoiseResponse deNoiseResponse2 = blockingStub.deNoise(bin2);
            logger.debug("denoise message received from server: {}", (Object)deNoiseResponse2.getMessage());
        }
        catch (Exception e) {
            logger.error(CROSS + " failed to send de-noise request to backend, please check keploy server logs", (Throwable)e);
        }
    }

    public static Service.HttpResp simulate(Service.TestCase testCase) {
        logger.debug("inside simulate");
        k.getMocks().put(testCase.getId(), new ArrayList(testCase.getMocksList()));
        k.getMocktime().put(testCase.getId(), testCase.getCaptured());
        k.getDeps().put(testCase.getId(), new ArrayList(testCase.getDepsList()));
        HashMap responseHeaders = new HashMap();
        Request request = GrpcService.getCustomRequest(testCase);
        logger.debug("simulate request: {}", (Object)request);
        try (Response response = client.newCall(request).execute();){
            String simResBody;
            try (ResponseBody responseBody = response.body();){
                if (!response.isSuccessful()) {
                    logger.debug("Unexpected response from server for simulate request: {}", (Object)response);
                }
                assert (responseBody != null);
                simResBody = responseBody.string();
            }
            logger.debug("response body got from simulate request: {}", (Object)simResBody);
            Map resHeadMap = response.headers().toMultimap();
            for (String key : resHeadMap.keySet()) {
                List vals = (List)resHeadMap.get(key);
                ArrayList values = new ArrayList(vals);
                responseHeaders.put(key, values);
            }
            long statusCode = response.code();
            logger.debug("status code got from simulate request: {}", (Object)statusCode);
            if (response.body() != null) {
                Objects.requireNonNull(response.body()).close();
            }
        }
        catch (IOException e) {
            logger.error(CROSS + " failed sending testcase request to app", (Throwable)e);
        }
        Service.HttpResp.Builder resp = GrpcService.GetResp(testCase.getId());
        k.getDeps().remove(testCase.getId());
        k.getMocks().remove(testCase.getId());
        k.getMocktime().remove(testCase.getId());
        return resp.build();
    }

    public static Service.HttpResp.Builder GetResp(String id) {
        logger.debug("inside GetResp");
        Service.HttpResp httpResp = (Service.HttpResp)k.getResp().get(id);
        if (httpResp == null) {
            logger.debug("response is not present in keploy resp map");
            return Service.HttpResp.newBuilder();
        }
        Service.HttpResp.Builder respBuilder = Service.HttpResp.newBuilder();
        try {
            respBuilder.setBody(httpResp.getBody()).setStatusCode(httpResp.getStatusCode()).setStatusMessage(httpResp.getStatusMessage()).setProtoMajor(httpResp.getProtoMajor()).setProtoMinor(httpResp.getProtoMinor()).putAllHeader(httpResp.getHeaderMap());
        }
        catch (Exception e) {
            logger.error(CROSS + " failed getting response for http request", (Throwable)e);
            return Service.HttpResp.newBuilder();
        }
        logger.debug("response from keploy resp map");
        return respBuilder;
    }

    public static void Test() {
        String id;
        String delay = "5";
        try {
            delay = System.getenv("DELAY");
            if (delay != null) {
                k.getCfg().getApp().setDelay(Duration.ofSeconds(Long.parseLong(delay)));
            }
            TimeUnit.SECONDS.sleep(k.getCfg().getApp().getDelay().getSeconds());
        }
        catch (InterruptedException e) {
            logger.error(CROSS + " (Test): unable to sleep", (Throwable)e);
        }
        logger.debug("entering test mode");
        logger.info("test starting in " + delay + " sec");
        List<Service.TestCase> tcs = GrpcService.fetch();
        String RED_CIRCLE = "\ud83d\udd34";
        if (Mode.getMode().equals((Object)Mode.ModeType.MODE_RECORD) && tcs == null) {
            logger.info("No existing tests found at {} directory", (Object)k.getCfg().getApp().getTestPath());
            System.out.println("--------------------------------------------------------------------------------------------\n");
            String endTest = "\ud83d\udd34 You can record your new test cases now.";
            System.out.println(GrpcService.bold(endTest));
            System.out.println("\n--------------------------------------------------------------------------------------------");
            return;
        }
        int total = tcs.size();
        try {
            id = GrpcService.start(String.valueOf(total));
        }
        catch (Exception e) {
            logger.error(CROSS + " failed to start test run", (Throwable)e);
            return;
        }
        logger.info("starting test execution id: {} total tests: {}", (Object)id, (Object)total);
        AtomicBoolean ok = new AtomicBoolean(true);
        AtomicInteger failedtestCount = new AtomicInteger(0);
        CountDownLatch wg = new CountDownLatch(tcs.size());
        String async_test = System.getenv("ASYNC_TESTING");
        int nThreads = Boolean.parseBoolean(async_test) ? 10 : 1;
        ExecutorService service = Executors.newFixedThreadPool(nThreads);
        String runTestBeforeRecord = System.getenv("RUN_TEST_BEFORE_RECORD");
        boolean runExistingTests = true;
        if (runTestBeforeRecord != null) {
            runExistingTests = Boolean.parseBoolean(runTestBeforeRecord);
        }
        if (Mode.getMode().equals((Object)Mode.ModeType.MODE_RECORD) && runExistingTests) {
            try (ProgressBar pb = new ProgressBar("KEPLOY-TESTS", (long)total);){
                GrpcService.runTests(service, pb, ok, wg, total, tcs, id, failedtestCount);
                pb.setExtraMessage("Tests Completed");
            }
        } else if (Mode.getMode().equals((Object)Mode.ModeType.MODE_TEST)) {
            GrpcService.runTests(service, null, ok, wg, total, tcs, id, failedtestCount);
        }
        try {
            wg.await();
        }
        catch (InterruptedException e) {
            logger.error(CROSS + " (Test): unable to wait for tests to get completed", (Throwable)e);
            AssertKTests.finalTestResult.set(false);
        }
        Boolean finalResult = ok.get();
        AssertKTests.finalTestResult.set(finalResult);
        GrpcService.end(id, finalResult);
        logger.info("test run completed with run id [{}]", (Object)id);
        logger.info("|| passed overall: {} ||", (Object)String.valueOf(finalResult).toUpperCase());
        if (Mode.getMode().equals((Object)Mode.ModeType.MODE_RECORD) && runExistingTests) {
            if (!finalResult.booleanValue()) {
                String test = failedtestCount.get() > 1 ? "tests" : "test";
                String WARN = "\u26a0\ufe0f";
                String inconsistentState = WARN + " " + GrpcService.bold(failedtestCount.get() + " " + test + " failed, Please make sure your database state is consistent.");
                System.out.println(inconsistentState);
            }
            System.out.println("--------------------------------------------------------------------------------------------\n");
            String endTest = "\ud83d\udd34 Tests have been completed, You can record your new test cases now.";
            System.out.println(GrpcService.bold(endTest));
            System.out.println("\n--------------------------------------------------------------------------------------------");
        }
    }

    private static void runTests(ExecutorService service, ProgressBar pb, AtomicBoolean ok, CountDownLatch wg, int total, List<Service.TestCase> tcs, String id, AtomicInteger failedtestCount) {
        for (int i = 0; i < tcs.size(); ++i) {
            Service.TestCase tc = tcs.get(i);
            logger.info("testing {} of {} testcase id: [{}]", (Object)(i + 1), (Object)total, (Object)tc.getId());
            service.submit(() -> {
                boolean pass = GrpcService.check(id, tc);
                if (!pass) {
                    failedtestCount.getAndIncrement();
                    ok.set(false);
                }
                logger.info("result : testcase id: [{}]  passed: {}", (Object)tc.getId(), (Object)pass);
                wg.countDown();
            });
            if (!Mode.getMode().equals((Object)Mode.ModeType.MODE_RECORD)) continue;
            pb.step();
        }
    }

    private static String bold(String str) {
        return SET_BOLD_TEXT + str + SET_PLAIN_TEXT;
    }

    public static String start(String total) {
        logger.debug("inside start function");
        Service.startRequest startRequest2 = Service.startRequest.newBuilder().setApp(k.getCfg().getApp().getName()).setTestCasePath(k.getCfg().getApp().getTestPath()).setMockPath(k.getCfg().getApp().getMockPath()).setTotal(total).build();
        Service.startResponse startResponse2 = null;
        try {
            startResponse2 = blockingStub.start(startRequest2);
        }
        catch (Exception e) {
            logger.error(CROSS + " failed to start test run, please check keploy server logs", (Throwable)e);
            AssertKTests.finalTestResult.set(false);
            System.exit(1);
        }
        return startResponse2 != null ? startResponse2.getId() : "";
    }

    public static void end(String id, boolean status) {
        logger.debug("inside end function");
        Service.endRequest endRequest2 = Service.endRequest.newBuilder().setId(id).setStatus(String.valueOf(status)).build();
        try {
            Service.endResponse endResponse2 = blockingStub.end(endRequest2);
            logger.debug("response after ending test run: {}", (Object)endResponse2);
        }
        catch (Exception e) {
            logger.error(CROSS + " failed to complete test runs, please check keploy server logs", (Throwable)e);
            AssertKTests.finalTestResult.set(false);
            System.exit(1);
        }
    }

    public static List<Service.TestCase> fetch() {
        logger.debug("inside fetch function");
        ArrayList<Service.TestCase> testCases = new ArrayList<Service.TestCase>();
        int i = 0;
        while (true) {
            int cnt;
            Service.getTCSRequest tcsRequest = Service.getTCSRequest.newBuilder().setApp(k.getCfg().getApp().getName()).setLimit("25").setOffset(String.valueOf(i)).setTestCasePath(k.getCfg().getApp().getTestPath()).setMockPath(k.getCfg().getApp().getMockPath()).build();
            Service.getTCSResponse tcs = null;
            try {
                tcs = blockingStub.getTCS(tcsRequest);
            }
            catch (Exception e) {
                if (e.getMessage().contains("no such file or directory")) {
                    if (Mode.getMode().equals((Object)Mode.ModeType.MODE_RECORD)) {
                        return null;
                    }
                    if (Mode.getMode().equals((Object)Mode.ModeType.MODE_TEST)) {
                        logger.info("No existing tests found at {} directory", (Object)k.getCfg().getApp().getTestPath());
                    }
                } else {
                    logger.error(CROSS + " failed to fetch testcases from keploy cloud, please ensure keploy server is up!", (Throwable)e);
                }
                AssertKTests.finalTestResult.set(false);
                System.exit(1);
            }
            if (tcs == null || (cnt = tcs.getTcsCount()) == 0) break;
            List tc = tcs.getTcsList();
            testCases.addAll(tc);
            boolean eof = tcs.getEof();
            if (eof) break;
            i += 25;
        }
        Collections.reverse(testCases);
        return testCases;
    }

    public static boolean check(String testrunId, Service.TestCase tc) {
        Service.testResponse testResponse2;
        Service.HttpResp resp;
        logger.debug("running test case with [{}] testrunId", (Object)testrunId);
        try {
            resp = GrpcService.simulate(tc);
            logger.debug("response got from simulate request: {}", (Object)resp);
        }
        catch (Exception e) {
            logger.error(CROSS + " failed to simulate request on local server", (Throwable)e);
            AssertKTests.finalTestResult.set(false);
            return false;
        }
        Service.TestReq testReq = Service.TestReq.newBuilder().setID(tc.getId()).setAppID(k.getCfg().getApp().getName()).setRunID(testrunId).setResp(resp).setTestCasePath(k.getCfg().getApp().getTestPath()).setMockPath(k.getCfg().getApp().getMockPath()).build();
        try {
            testResponse2 = blockingStub.test(testReq);
        }
        catch (Exception e) {
            logger.error(CROSS + " failed to send test request to backend, please check keploy server logs", (Throwable)e);
            return false;
        }
        if (testResponse2 == null) {
            return false;
        }
        Map res = testResponse2.getPassMap();
        logger.debug("(check): test result of testrunId [{}]: {}", (Object)testrunId, res.get("pass"));
        return res.getOrDefault("pass", false);
    }

    private static Request getCustomRequest(Service.TestCase testCase) {
        String url = testCase.getHttpReq().getURL();
        String host = k.getCfg().getApp().getHost();
        String port = k.getCfg().getApp().getPort();
        String method = testCase.getHttpReq().getMethod();
        String body = testCase.getHttpReq().getBody();
        String targetUrl = "http://" + host + ":" + port + url;
        String testId = testCase.getId();
        logger.debug("simulate request's url: {}", (Object)targetUrl);
        Map headerMap = testCase.getHttpReq().getHeaderMap();
        Request.Builder reqBuilder = GrpcService.setCustomRequestHeaderMap(headerMap);
        if (method.equals("GET") && !body.isEmpty()) {
            logger.warn("keploy doesn't support get request with body");
        }
        switch (method) {
            case "GET": {
                return reqBuilder.get().url(targetUrl).addHeader("KEPLOY_TEST_ID", testId).build();
            }
            case "DELETE": {
                return reqBuilder.delete().url(targetUrl).addHeader("KEPLOY_TEST_ID", testId).build();
            }
        }
        return reqBuilder.method(method, RequestBody.create((byte[])body.getBytes(StandardCharsets.UTF_8))).url(targetUrl).addHeader("KEPLOY_TEST_ID", testId).build();
    }

    private static Request.Builder setCustomRequestHeaderMap(Map<String, Service.StrArr> srcMap) {
        Object values;
        Request.Builder reqBuilder = new Request.Builder();
        HashMap headerMap = new HashMap();
        for (String key : srcMap.keySet()) {
            values = srcMap.get(key);
            ProtocolStringList valueList = values.getValueList();
            ArrayList headerValues = new ArrayList(valueList);
            headerMap.put(key, headerValues);
        }
        for (String key : headerMap.keySet()) {
            if (!GrpcService.isModifiable(key)) continue;
            values = (List)headerMap.get(key);
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                reqBuilder.addHeader(key, value);
            }
        }
        return reqBuilder;
    }

    private static boolean isModifiable(String key) {
        switch (key) {
            case "connection": {
                return false;
            }
            case "content-length": {
                return false;
            }
            case "date": {
                return false;
            }
            case "expect": {
                return false;
            }
            case "from": {
                return false;
            }
            case "host": {
                return false;
            }
            case "upgrade": {
                return false;
            }
            case "via": {
                return false;
            }
            case "warning": {
                return false;
            }
        }
        return true;
    }

    private static Map<String, Service.StrArr> getRequestHeaderMap(HttpServletRequest httpServletRequest) {
        HashMap<String, Service.StrArr> map = new HashMap<String, Service.StrArr>();
        ArrayList<String> headerNames = Collections.list(httpServletRequest.getHeaderNames());
        for (String name : headerNames) {
            ArrayList<String> values = Collections.list(httpServletRequest.getHeaders(name));
            Service.StrArr.Builder builder = Service.StrArr.newBuilder();
            for (String s : values) {
                builder.addValue(s);
            }
            Service.StrArr value = builder.build();
            map.put(name, value);
        }
        return map;
    }
}

