/*
 * Decompiled with CFR 0.152.
 */
package io.keploy.service;

import com.google.protobuf.ProtocolStringList;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import io.keploy.grpc.stubs.RegressionServiceGrpc;
import io.keploy.grpc.stubs.Service;
import io.keploy.regression.KeployInstance;
import io.keploy.regression.context.Context;
import io.keploy.regression.keploy.Keploy;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GrpcService {
    private static final Logger logger = LogManager.getLogger(GrpcService.class);
    private final RegressionServiceGrpc.RegressionServiceBlockingStub blockingStub;
    private final Keploy k;
    public static ManagedChannel channel;

    public GrpcService() {
        channel = ManagedChannelBuilder.forTarget((String)"localhost:8081").usePlaintext().build();
        this.blockingStub = RegressionServiceGrpc.newBlockingStub((Channel)channel);
        KeployInstance.getInstance();
        this.k = KeployInstance.getKeploy();
    }

    public void CaptureTestCases(KeployInstance ki, String reqBody, Map<String, String> params, Service.HttpResp httpResp) throws Exception {
        logger.debug("inside CaptureTestCases");
        HttpServletRequest ctxReq = Context.getCtx().getRequest();
        if (ctxReq == null) {
            logger.warn("failed to get keploy context");
            return;
        }
        Service.TestCaseReq.Builder testCaseReqBuilder = Service.TestCaseReq.newBuilder();
        Service.HttpReq.Builder httpReqBuilder = Service.HttpReq.newBuilder();
        String url = ctxReq.getQueryString() == null ? ctxReq.getRequestURI() : ctxReq.getRequestURI() + "?" + ctxReq.getQueryString();
        httpReqBuilder.setMethod(ctxReq.getMethod()).setURL(url);
        httpReqBuilder.putAllURLParams(params);
        Map<String, Service.StrArr> headerMap = this.getRequestHeaderMap(ctxReq);
        httpReqBuilder.putAllHeader(headerMap);
        httpReqBuilder.setBody(reqBody);
        httpReqBuilder.setProtoMajor(2L);
        httpReqBuilder.setProtoMinor(1L);
        Service.HttpReq httpReq = httpReqBuilder.build();
        testCaseReqBuilder.setAppID(this.k.getCfg().getApp().getName());
        testCaseReqBuilder.setCaptured(Instant.now().getEpochSecond());
        testCaseReqBuilder.setURI(ctxReq.getRequestURI());
        testCaseReqBuilder.setHttpResp(httpResp);
        testCaseReqBuilder.setHttpReq(httpReq);
        this.Capture(testCaseReqBuilder.build());
    }

    public void Capture(Service.TestCaseReq testCaseReq) throws Exception {
        this.put(testCaseReq);
    }

    public void put(Service.TestCaseReq testCaseReq) throws Exception {
        Service.postTCResponse postTCResponse2 = null;
        try {
            postTCResponse2 = this.blockingStub.postTC(testCaseReq);
        }
        catch (Exception e) {
            logger.error("failed to send test case to backend", (Throwable)e);
            throw new Exception();
        }
        Map tcsId = postTCResponse2.getTcsIdMap();
        String id = (String)tcsId.get("id");
        if (id == null) {
            return;
        }
        this.denoise(id, testCaseReq);
    }

    public void denoise(String id, Service.TestCaseReq testCaseReq) throws Exception {
        TimeUnit.SECONDS.sleep(3L);
        Service.TestCase.Builder testCaseBuilder = Service.TestCase.newBuilder();
        testCaseBuilder.setId(id);
        testCaseBuilder.setCaptured(testCaseReq.getCaptured());
        testCaseBuilder.setURI(testCaseReq.getURI());
        testCaseBuilder.setHttpReq(testCaseReq.getHttpReq());
        Service.TestCase testCase = testCaseBuilder.build();
        Service.HttpResp resp2 = this.simulate(testCase);
        Service.TestReq.Builder testReqBuilder = Service.TestReq.newBuilder();
        testReqBuilder.setID(id);
        testReqBuilder.setResp(resp2);
        testReqBuilder.setAppID(this.k.getCfg().getApp().getName());
        Service.TestReq bin2 = testReqBuilder.build();
        boolean noise = this.k.getCfg().getApp().getDenoise();
        if (noise) {
            try {
                Service.deNoiseResponse deNoiseResponse2 = this.blockingStub.deNoise(bin2);
                logger.debug("denoise message received from server {}", (Object)deNoiseResponse2.getMessage());
            }
            catch (Exception e) {
                logger.error("failed to send de-noise request to backend", (Throwable)e);
            }
        }
    }

    public Service.HttpResp simulate(Service.TestCase testCase) throws Exception {
        logger.debug("inside simulate");
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.MINUTES).writeTimeout(5L, TimeUnit.MINUTES).readTimeout(5L, TimeUnit.MINUTES).build();
        String simResBody = null;
        long statusCode = 0L;
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        Request request = this.getCustomRequest(testCase);
        logger.debug("simulate request: {}", (Object)request);
        try (Response response = client.newCall(request).execute();){
            try (ResponseBody responseBody = response.body();){
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected code " + response);
                }
                assert (responseBody != null);
                simResBody = responseBody.string();
            }
            Map resHeadMap = response.headers().toMultimap();
            for (String key : resHeadMap.keySet()) {
                List vals = (List)resHeadMap.get(key);
                ArrayList values = new ArrayList(vals);
                responseHeaders.put(key, values);
            }
            statusCode = response.code();
        }
        catch (IOException e) {
            logger.error("failed sending testcase request to app", (Throwable)e);
        }
        Service.HttpResp.Builder resp = this.GetResp(testCase.getId());
        if (!(resp.getStatusCode() >= 300L && resp.getStatusCode() < 400L || resp.getBody().equals(simResBody))) {
            resp.setBody(simResBody);
            resp.setStatusCode(statusCode);
            Map<String, Service.StrArr> resHeaders = this.getResponseHeaderMap(responseHeaders);
            logger.debug("response headers from GetResp: {}", resHeaders);
            try {
                resp.putAllHeader(resHeaders);
            }
            catch (Exception e) {
                logger.error("unable to put headers", (Throwable)e);
            }
        }
        return resp.build();
    }

    public Service.HttpResp.Builder GetResp(String id) throws Exception {
        logger.debug("inside GetResp");
        Service.HttpResp httpResp = (Service.HttpResp)this.k.getResp().get(id);
        if (httpResp == null) {
            logger.debug("response is not present in keploy resp map");
            return Service.HttpResp.newBuilder();
        }
        Service.HttpResp.Builder respBuilder = Service.HttpResp.newBuilder();
        try {
            respBuilder.setBody(httpResp.getBody()).setStatusCode(httpResp.getStatusCode()).putAllHeader(httpResp.getHeaderMap());
        }
        catch (Exception e) {
            logger.error("failed to get response", (Throwable)e);
            throw new Exception(e);
        }
        logger.debug("response from keploy resp map");
        return respBuilder;
    }

    public void Test() throws Exception {
        String id;
        TimeUnit.SECONDS.sleep(7L);
        logger.debug("entering test mode");
        logger.info("test starting in 5 sec");
        List<Service.TestCase> tcs = this.fetch();
        int total = tcs.size();
        try {
            id = this.start(String.valueOf(total));
        }
        catch (Exception e) {
            logger.info("failed to start test run ", (Throwable)e);
            return;
        }
        logger.info("starting test execution id: {} total tests: {}", (Object)id, (Object)total);
        boolean ok = true;
        for (int i = 0; i < tcs.size(); ++i) {
            Service.TestCase tc = tcs.get(i);
            logger.info("testing {} of {} testcase id: [{}]", (Object)(i + 1), (Object)total, (Object)tc.getId());
            logger.info("result : testcase id: [{}]  passed: {}", (Object)tc.getId(), (Object)(ok &= this.check(id, tc)));
        }
        String msg = this.end(id, ok);
        if (msg == null) {
            logger.error("failed to end test run");
            return;
        }
        logger.info("test run completed with run id [{}]", (Object)id);
        logger.info("|| passed overall: {} ||", (Object)String.valueOf(ok).toUpperCase());
    }

    public String start(String total) {
        Service.startRequest startRequest2 = Service.startRequest.newBuilder().setApp(this.k.getCfg().getApp().getName()).setTotal(total).build();
        Service.startResponse startResponse2 = this.blockingStub.start(startRequest2);
        return startResponse2.getId();
    }

    public String end(String id, boolean status) {
        Service.endRequest endRequest2 = Service.endRequest.newBuilder().setId(id).setStatus(String.valueOf(status)).build();
        Service.endResponse endResponse2 = this.blockingStub.end(endRequest2);
        return endResponse2.getMessage();
    }

    public List<Service.TestCase> fetch() {
        logger.info("inside fetch function");
        ArrayList<Service.TestCase> testCases = new ArrayList<Service.TestCase>();
        int i = 0;
        while (true) {
            try {
                Service.getTCSRequest tcsRequest = Service.getTCSRequest.newBuilder().setApp(this.k.getCfg().getApp().getName()).setLimit("25").setOffset(String.valueOf(i)).build();
                Service.getTCSResponse tcs = this.blockingStub.getTCS(tcsRequest);
                int cnt = tcs.getTcsCount();
                if (cnt == 0) break;
                List tc = tcs.getTcsList();
                testCases.addAll(tc);
            }
            catch (StatusRuntimeException e) {
                logger.warn("RPC failed: {}", (Object)e.getStatus());
                return null;
            }
            i += 25;
        }
        return testCases;
    }

    public boolean check(String testrunId, Service.TestCase tc) throws Exception {
        logger.debug("running test case with [{}] testrunId ", (Object)testrunId);
        Service.HttpResp resp = this.simulate(tc);
        Service.TestReq testReq = Service.TestReq.newBuilder().setID(tc.getId()).setAppID(this.k.getCfg().getApp().getName()).setRunID(testrunId).setResp(resp).build();
        Service.testResponse testResponse2 = this.blockingStub.test(testReq);
        Map res = testResponse2.getPassMap();
        logger.info("test result of testrunId [{}]: {} ", (Object)testrunId, res.get("pass"));
        return (Boolean)res.get("pass");
    }

    private Map<String, Service.StrArr> getResponseHeaderMap(Map<String, List<String>> srcMap) {
        HashMap<String, Service.StrArr> map = new HashMap<String, Service.StrArr>();
        for (String key : srcMap.keySet()) {
            if (key == null) continue;
            List<String> headerValues = srcMap.get(key);
            Service.StrArr.Builder builder = Service.StrArr.newBuilder();
            for (String hval : headerValues) {
                builder.addValue(hval);
            }
            Service.StrArr value = builder.build();
            key = this.convertFirstCapAfterEachDash(key);
            map.put(key, value);
        }
        return map;
    }

    private String convertFirstCapAfterEachDash(String str) {
        StringBuilder sb = new StringBuilder();
        String[] sarr = str.split("-");
        if (sarr.length == 1) {
            sb.append(Character.toUpperCase(sarr[0].charAt(0))).append(sarr[0].substring(1));
        } else {
            for (int i = 0; i < sarr.length - 1; ++i) {
                String val = sarr[i];
                sb.append(Character.toUpperCase(val.charAt(0))).append(val.substring(1)).append("-");
            }
            String lval = sarr[sarr.length - 1];
            sb.append(Character.toUpperCase(lval.charAt(0))).append(lval.substring(1));
        }
        return sb.toString();
    }

    private Request getCustomRequest(Service.TestCase testCase) {
        String url = testCase.getHttpReq().getURL();
        String host = this.k.getCfg().getApp().getHost();
        String port = this.k.getCfg().getApp().getPort();
        String method = testCase.getHttpReq().getMethod();
        String body = testCase.getHttpReq().getBody();
        String targetUrl = "http://" + host + ":" + port + url;
        logger.debug("simulate request's url: {}", (Object)targetUrl);
        Map headerMap = testCase.getHttpReq().getHeaderMap();
        Request.Builder reqBuilder = this.setCustomRequestHeaderMap(headerMap);
        switch (method) {
            case "GET": {
                return reqBuilder.get().url(targetUrl).addHeader("content-type", "application/json").addHeader("accept", "application/json").addHeader("KEPLOY_TEST_ID", testCase.getId()).build();
            }
            case "DELETE": {
                return reqBuilder.delete().url(targetUrl).addHeader("content-type", "application/json").addHeader("accept", "application/json").addHeader("KEPLOY_TEST_ID", testCase.getId()).build();
            }
        }
        return reqBuilder.method(method, RequestBody.create((byte[])body.getBytes(StandardCharsets.UTF_8))).url(targetUrl).addHeader("content-type", "application/json").addHeader("accept", "application/json").addHeader("KEPLOY_TEST_ID", testCase.getId()).build();
    }

    private Request.Builder setCustomRequestHeaderMap(Map<String, Service.StrArr> srcMap) {
        Object values;
        Request.Builder reqBuilder = new Request.Builder();
        HashMap headerMap = new HashMap();
        for (String key : srcMap.keySet()) {
            values = srcMap.get(key);
            ProtocolStringList valueList = values.getValueList();
            ArrayList headerValues = new ArrayList(valueList);
            headerMap.put(key, headerValues);
        }
        for (String key : headerMap.keySet()) {
            if (!this.isModifiable(key)) continue;
            values = (List)headerMap.get(key);
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                reqBuilder.addHeader(key, value);
            }
        }
        return reqBuilder;
    }

    private boolean isModifiable(String key) {
        switch (key) {
            case "connection": {
                return false;
            }
            case "content-length": {
                return false;
            }
            case "date": {
                return false;
            }
            case "expect": {
                return false;
            }
            case "from": {
                return false;
            }
            case "host": {
                return false;
            }
            case "upgrade": {
                return false;
            }
            case "via": {
                return false;
            }
            case "warning": {
                return false;
            }
        }
        return true;
    }

    private Map<String, Service.StrArr> getRequestHeaderMap(HttpServletRequest httpServletRequest) {
        HashMap<String, Service.StrArr> map = new HashMap<String, Service.StrArr>();
        ArrayList<String> headerNames = Collections.list(httpServletRequest.getHeaderNames());
        for (String name : headerNames) {
            ArrayList<String> values = Collections.list(httpServletRequest.getHeaders(name));
            Service.StrArr.Builder builder = Service.StrArr.newBuilder();
            for (String s : values) {
                builder.addValue(s);
            }
            Service.StrArr value = builder.build();
            map.put(name, value);
        }
        return map;
    }
}

