/*
 * Decompiled with CFR 0.152.
 */
package io.keploy.client;

import com.google.protobuf.ProtocolStringList;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import io.keploy.grpc.stubs.RegressionServiceGrpc;
import io.keploy.grpc.stubs.Service;
import io.keploy.regression.KeployInstance;
import io.keploy.regression.context.Context;
import io.keploy.regression.keploy.Keploy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GrpcClient {
    private static final Logger logger = LogManager.getLogger((String)"GrpcClient");
    private final RegressionServiceGrpc.RegressionServiceBlockingStub blockingStub;
    private final Keploy k;

    public GrpcClient() {
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)"localhost:8081").usePlaintext().build();
        this.blockingStub = RegressionServiceGrpc.newBlockingStub((Channel)channel);
        KeployInstance.getInstance();
        this.k = KeployInstance.getKeploy();
    }

    public void CaptureTestCases(KeployInstance ki, String reqBody, String resBody, Map<String, String> params, Service.HttpResp httpResp) throws Exception {
        HttpServletRequest ctxReq = Context.getCtx();
        if (ctxReq == null) {
            logger.warn("failed to get keploy context");
            return;
        }
        Service.TestCaseReq.Builder testCaseReqBuilder = Service.TestCaseReq.newBuilder();
        Service.HttpReq.Builder httpReqBuilder = Service.HttpReq.newBuilder();
        httpReqBuilder.setMethod(ctxReq.getMethod()).setURL(ctxReq.getRequestURL().toString());
        Map<String, String> urlParamsMap = params;
        httpReqBuilder.putAllURLParams(urlParamsMap);
        Map<String, Service.StrArr> headerMap = this.getRequestHeaderMap(ctxReq);
        httpReqBuilder.putAllHeader(headerMap);
        httpReqBuilder.setBody(reqBody);
        httpReqBuilder.setProtoMajor(2L);
        httpReqBuilder.setProtoMinor(1L);
        Service.HttpReq httpReq = httpReqBuilder.build();
        testCaseReqBuilder.setAppID(this.k.getCfg().getApp().getName());
        testCaseReqBuilder.setCaptured(Instant.now().getEpochSecond());
        testCaseReqBuilder.setURI(ctxReq.getRequestURI());
        testCaseReqBuilder.setHttpResp(httpResp);
        testCaseReqBuilder.setHttpReq(httpReq);
        this.Capture(testCaseReqBuilder.build());
    }

    public void Capture(Service.TestCaseReq testCaseReq) throws Exception {
        this.put(testCaseReq);
    }

    public void put(Service.TestCaseReq testCaseReq) throws Exception {
        Service.postTCResponse postTCResponse2 = null;
        try {
            postTCResponse2 = this.blockingStub.postTC(testCaseReq);
        }
        catch (Exception e) {
            logger.error("failed to send test case to backend", (Throwable)e);
            throw new Exception();
        }
        Map tcsId = postTCResponse2.getTcsIdMap();
        String id = (String)tcsId.get("id");
        if (id == null) {
            return;
        }
        this.denoise(id, testCaseReq);
    }

    public void denoise(String id, Service.TestCaseReq testCaseReq) throws Exception {
        TimeUnit.SECONDS.sleep(3L);
        Service.TestCase.Builder testCaseBuilder = Service.TestCase.newBuilder();
        testCaseBuilder.setId(id);
        testCaseBuilder.setCaptured(testCaseReq.getCaptured());
        testCaseBuilder.setURI(testCaseReq.getURI());
        testCaseBuilder.setHttpReq(testCaseReq.getHttpReq());
        Service.TestCase testCase = testCaseBuilder.build();
        Service.HttpResp resp2 = this.simulate(testCase);
        Service.TestReq.Builder testReqBuilder = Service.TestReq.newBuilder();
        testReqBuilder.setID(id);
        testReqBuilder.setResp(resp2);
        testReqBuilder.setAppID(this.k.getCfg().getApp().getName());
        Service.TestReq bin2 = testReqBuilder.build();
        try {
            Service.deNoiseResponse deNoiseResponse2 = this.blockingStub.deNoise(bin2);
            System.out.println(deNoiseResponse2.getMessage());
        }
        catch (Exception e) {
            logger.error("failed to send de-noise request to backend");
        }
    }

    public Service.HttpResp simulate(Service.TestCase testCase) throws Exception {
        int statusCode;
        String targetUrl = testCase.getHttpReq().getURL();
        String host = this.k.getCfg().getApp().getHost();
        String port = this.k.getCfg().getApp().getPort();
        String method = testCase.getHttpReq().getMethod();
        String body = testCase.getHttpReq().getBody();
        URL url = null;
        HttpURLConnection connection = null;
        StringBuilder response = new StringBuilder();
        try {
            url = new URL(targetUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestMethod(method);
            connection.setRequestProperty("content-type", "application/json");
            connection.setRequestProperty("accept", "application/json");
            connection.setRequestProperty("KEPLOY_TEST_ID", testCase.getId());
            this.setCustomRequestHeaderMap(connection, testCase.getHttpReq().getHeaderMap());
            if (!method.equals("GET") && !method.equals("DELETE")) {
                connection.setDoOutput(true);
                this.setCustomRequestBody(connection, body);
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));){
                String responseLine = null;
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine.trim());
                }
                System.out.println(response.toString());
            }
            statusCode = connection.getResponseCode();
        }
        catch (MalformedURLException e) {
            logger.info("failed sending testcase request to app");
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            logger.info("failed sending testcase request to app");
            throw new RuntimeException(e);
        }
        Map<String, List<String>> responseHeaders = connection.getHeaderFields();
        Service.HttpResp.Builder resp = this.GetResp(testCase.getId());
        if (!(resp.getStatusCode() >= 300L && resp.getStatusCode() < 400L || resp.getBody().equals(response.toString()))) {
            resp.setBody(response.toString());
            resp.setStatusCode((long)statusCode);
            connection.getHeaderFields();
            Map<String, Service.StrArr> resHeaders = this.getResponseHeaderMap(responseHeaders);
            resp.putAllHeader(resHeaders);
        }
        return resp.build();
    }

    public Service.HttpResp.Builder GetResp(String id) throws Exception {
        Service.HttpResp httpResp = (Service.HttpResp)this.k.getResp().get(id);
        if (httpResp == null) {
            return Service.HttpResp.newBuilder();
        }
        Service.HttpResp.Builder respBuilder = Service.HttpResp.newBuilder();
        try {
            respBuilder.setBody(httpResp.getBody()).setStatusCode(httpResp.getStatusCode()).putAllHeader(httpResp.getHeaderMap());
        }
        catch (Exception e) {
            logger.error("failed to get response ", (Object)e.getMessage());
            throw new Exception(e);
        }
        return respBuilder;
    }

    public void Test() throws Exception {
        String id;
        TimeUnit.SECONDS.sleep(10L);
        logger.debug("entering test mode");
        logger.info("test starting in 5 sec");
        List<Service.TestCase> tcs = this.fetch();
        int total = tcs.size();
        try {
            id = this.start(String.valueOf(total));
        }
        catch (Exception e) {
            logger.info("failed to start test run ", (Throwable)e);
            return;
        }
        logger.info("starting test execution id: " + id + " total tests: " + total);
        boolean ok = true;
        for (int i = 0; i < tcs.size(); ++i) {
            Service.TestCase tc = tcs.get(i);
            logger.info("testing " + (i + 1) + " of " + total + " testcase id : " + tc.getId());
            Service.TestCase tcCopy = tc;
            logger.info("result :  testcase id " + tcCopy.getId() + " passed ", (Object)(ok &= this.check(id, tcCopy)));
        }
        String msg = this.end(id, ok);
        if (msg == null) {
            logger.error("failed to end test run");
            return;
        }
        logger.info("test run completed :  with run id " + id + "\n || passed overall " + String.valueOf(ok).toUpperCase() + " ||");
    }

    public String start(String total) {
        Service.startRequest startRequest2 = Service.startRequest.newBuilder().setApp(this.k.getCfg().getApp().getName()).setTotal(total).build();
        Service.startResponse startResponse2 = this.blockingStub.start(startRequest2);
        return startResponse2.getId();
    }

    public String end(String id, boolean status) {
        Service.endRequest endRequest2 = Service.endRequest.newBuilder().setId(id).setStatus(String.valueOf(status)).build();
        Service.endResponse endResponse2 = this.blockingStub.end(endRequest2);
        return endResponse2.getMessage();
    }

    public List<Service.TestCase> fetch() {
        logger.info("inside fetch function");
        ArrayList<Service.TestCase> testCases = new ArrayList<Service.TestCase>();
        int i = 0;
        while (true) {
            try {
                Service.getTCSRequest tcsRequest = Service.getTCSRequest.newBuilder().setApp(this.k.getCfg().getApp().getName()).setLimit("25").setOffset(String.valueOf(i)).build();
                Service.getTCSResponse tcs = this.blockingStub.getTCS(tcsRequest);
                int cnt = tcs.getTcsCount();
                if (cnt == 0) break;
                List tc = tcs.getTcsList();
                testCases.addAll(tc);
            }
            catch (StatusRuntimeException e) {
                logger.warn("RPC failed: {0}", (Object)e.getStatus());
                return null;
            }
            i += 25;
        }
        return testCases;
    }

    public boolean check(String runId, Service.TestCase tc) throws Exception {
        Service.HttpResp resp = this.simulate(tc);
        Service.TestReq testReq = Service.TestReq.newBuilder().setID(tc.getId()).setAppID(this.k.getCfg().getApp().getName()).setRunID(runId).setResp(resp).build();
        Service.testResponse testResponse2 = this.blockingStub.test(testReq);
        Map res = testResponse2.getPassMap();
        System.out.println(res);
        return (Boolean)res.get("pass");
    }

    private Map<String, Service.StrArr> getResponseHeaderMap(Map<String, List<String>> srcMap) {
        HashMap<String, Service.StrArr> map = new HashMap<String, Service.StrArr>();
        for (String key : srcMap.keySet()) {
            List<String> headerValues = srcMap.get(key);
            Service.StrArr.Builder builder = Service.StrArr.newBuilder();
            for (int i = 0; i < headerValues.size(); ++i) {
                builder.addValue(headerValues.get(i));
            }
            Service.StrArr value = builder.build();
            map.put(key, value);
        }
        return map;
    }

    private void setCustomRequestHeaderMap(HttpURLConnection connection, Map<String, Service.StrArr> srcMap) {
        Object values;
        HashMap headerMap = new HashMap();
        for (String key : srcMap.keySet()) {
            values = srcMap.get(key);
            ProtocolStringList valueList = values.getValueList();
            ArrayList headerValues = new ArrayList(valueList);
            headerMap.put(key, headerValues);
        }
        for (String key : headerMap.keySet()) {
            if (!this.isModifiable(key)) continue;
            values = (List)headerMap.get(key);
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                connection.setRequestProperty(key, value);
            }
        }
    }

    private boolean isModifiable(String key) {
        switch (key) {
            case "connection": {
                return false;
            }
            case "content-length": {
                return false;
            }
            case "date": {
                return false;
            }
            case "expect": {
                return false;
            }
            case "from": {
                return false;
            }
            case "host": {
                return false;
            }
            case "upgrade": {
                return false;
            }
            case "via": {
                return false;
            }
            case "warning": {
                return false;
            }
        }
        return true;
    }

    private void setCustomRequestBody(HttpURLConnection connection, String body) {
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = body.getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Service.StrArr> getRequestHeaderMap(HttpServletRequest httpServletRequest) {
        HashMap<String, Service.StrArr> map = new HashMap<String, Service.StrArr>();
        ArrayList<String> headerNames = Collections.list(httpServletRequest.getHeaderNames());
        for (String name : headerNames) {
            ArrayList values = Collections.list(httpServletRequest.getHeaders(name));
            Service.StrArr.Builder builder = Service.StrArr.newBuilder();
            for (int i = 0; i < values.size(); ++i) {
                builder.addValue((String)values.get(i));
            }
            Service.StrArr value = builder.build();
            map.put(name, value);
        }
        return map;
    }
}

