/*
 * Decompiled with CFR 0.152.
 */
package io.keploy.service;

import com.google.protobuf.ProtocolStringList;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import io.keploy.grpc.stubs.RegressionServiceGrpc;
import io.keploy.grpc.stubs.Service;
import io.keploy.regression.KeployInstance;
import io.keploy.regression.context.Context;
import io.keploy.regression.keploy.Keploy;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GrpcService {
    private static final Logger logger = LogManager.getLogger(GrpcService.class);
    private static RegressionServiceGrpc.RegressionServiceBlockingStub blockingStub = null;
    private static Keploy k = null;
    public static ManagedChannel channel;
    private static OkHttpClient client;

    public GrpcService() {
        channel = ManagedChannelBuilder.forTarget((String)"localhost:8081").usePlaintext().build();
        blockingStub = RegressionServiceGrpc.newBlockingStub((Channel)channel);
        KeployInstance.getInstance();
        k = KeployInstance.getKeploy();
        client = new OkHttpClient.Builder().connectTimeout(6L, TimeUnit.MINUTES).writeTimeout(6L, TimeUnit.MINUTES).readTimeout(6L, TimeUnit.MINUTES).build();
    }

    public static void CaptureTestCases(KeployInstance ki, String reqBody, Map<String, String> params, Service.HttpResp httpResp) {
        logger.debug("inside CaptureTestCases");
        HttpServletRequest ctxReq = Context.getCtx().getRequest();
        if (ctxReq == null) {
            logger.warn("failed to get keploy context");
            return;
        }
        Service.TestCaseReq.Builder testCaseReqBuilder = Service.TestCaseReq.newBuilder();
        Service.HttpReq.Builder httpReqBuilder = Service.HttpReq.newBuilder();
        String url = ctxReq.getQueryString() == null ? ctxReq.getRequestURI() : ctxReq.getRequestURI() + "?" + ctxReq.getQueryString();
        httpReqBuilder.setMethod(ctxReq.getMethod()).setURL(url);
        httpReqBuilder.putAllURLParams(params);
        Map<String, Service.StrArr> headerMap = GrpcService.getRequestHeaderMap(ctxReq);
        httpReqBuilder.putAllHeader(headerMap);
        httpReqBuilder.setBody(reqBody);
        httpReqBuilder.setProtoMajor(2L);
        httpReqBuilder.setProtoMinor(1L);
        Service.HttpReq httpReq = httpReqBuilder.build();
        testCaseReqBuilder.setAppID(k.getCfg().getApp().getName());
        testCaseReqBuilder.setCaptured(Instant.now().getEpochSecond());
        testCaseReqBuilder.setURI(ctxReq.getRequestURI());
        testCaseReqBuilder.setHttpResp(httpResp);
        testCaseReqBuilder.setHttpReq(httpReq);
        GrpcService.Capture(testCaseReqBuilder.build());
    }

    public static void Capture(Service.TestCaseReq testCaseReq) {
        new Thread(() -> {
            try {
                GrpcService.put(testCaseReq);
            }
            catch (Exception e) {
                logger.error("failed to send test case to backend", (Throwable)e);
            }
        }).start();
    }

    public static void put(Service.TestCaseReq testCaseReq) {
        Service.postTCResponse postTCResponse2 = null;
        try {
            postTCResponse2 = blockingStub.postTC(testCaseReq);
        }
        catch (Exception e) {
            logger.error("failed to send test case to backend", (Throwable)e);
        }
        Map tcsId = postTCResponse2.getTcsIdMap();
        String id = (String)tcsId.get("id");
        if (id == null) {
            return;
        }
        boolean noise = k.getCfg().getServer().getDenoise();
        if (noise) {
            GrpcService.denoise(id, testCaseReq);
        }
        Context.cleanup();
    }

    public static void denoise(String id, Service.TestCaseReq testCaseReq) {
        try {
            TimeUnit.SECONDS.sleep(3L);
        }
        catch (InterruptedException e) {
            logger.error("(denoise): unable to sleep ", (Throwable)e);
        }
        Service.TestCase.Builder testCaseBuilder = Service.TestCase.newBuilder();
        testCaseBuilder.setId(id);
        testCaseBuilder.setCaptured(testCaseReq.getCaptured());
        testCaseBuilder.setURI(testCaseReq.getURI());
        testCaseBuilder.setHttpReq(testCaseReq.getHttpReq());
        Service.TestCase testCase = testCaseBuilder.build();
        Service.HttpResp resp2 = GrpcService.simulate(testCase);
        Service.TestReq.Builder testReqBuilder = Service.TestReq.newBuilder();
        testReqBuilder.setID(id);
        testReqBuilder.setResp(resp2);
        testReqBuilder.setAppID(k.getCfg().getApp().getName());
        Service.TestReq bin2 = testReqBuilder.build();
        try {
            Service.deNoiseResponse deNoiseResponse2 = blockingStub.deNoise(bin2);
            logger.debug("denoise message received from server {}", (Object)deNoiseResponse2.getMessage());
        }
        catch (Exception e) {
            logger.error("failed to send de-noise request to backend", (Throwable)e);
        }
    }

    public static Service.HttpResp simulate(Service.TestCase testCase) {
        logger.debug("inside simulate");
        String simResBody = null;
        long statusCode = 0L;
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        Request request = GrpcService.getCustomRequest(testCase);
        logger.debug("simulate request: {}", (Object)request);
        try (Response response = client.newCall(request).execute();){
            try (ResponseBody responseBody = response.body();){
                if (!response.isSuccessful()) {
                    logger.debug("Unexpected code {}", (Object)response);
                }
                assert (responseBody != null);
                simResBody = responseBody.string();
            }
            Map resHeadMap = response.headers().toMultimap();
            for (String key : resHeadMap.keySet()) {
                List vals = (List)resHeadMap.get(key);
                ArrayList values = new ArrayList(vals);
                responseHeaders.put(key, values);
            }
            statusCode = response.code();
            response.body().close();
        }
        catch (IOException e) {
            logger.error("failed sending testcase request to app", (Throwable)e);
        }
        Service.HttpResp.Builder resp = GrpcService.GetResp(testCase.getId());
        if (!(resp.getStatusCode() >= 300L && resp.getStatusCode() < 400L || resp.getBody().equals(simResBody))) {
            resp.setBody(simResBody);
            resp.setStatusCode(statusCode);
            Map<String, Service.StrArr> resHeaders = GrpcService.getResponseHeaderMap(responseHeaders);
            logger.debug("response headers from GetResp: {}", resHeaders);
            try {
                resp.putAllHeader(resHeaders);
            }
            catch (Exception e) {
                logger.error("unable to put headers", (Throwable)e);
            }
        }
        return resp.build();
    }

    public static Service.HttpResp.Builder GetResp(String id) {
        logger.debug("inside GetResp");
        Service.HttpResp httpResp = (Service.HttpResp)k.getResp().get(id);
        if (httpResp == null) {
            logger.debug("response is not present in keploy resp map");
            return Service.HttpResp.newBuilder();
        }
        Service.HttpResp.Builder respBuilder = Service.HttpResp.newBuilder();
        try {
            respBuilder.setBody(httpResp.getBody()).setStatusCode(httpResp.getStatusCode()).putAllHeader(httpResp.getHeaderMap());
        }
        catch (Exception e) {
            logger.error("failed to get response", (Throwable)e);
            return Service.HttpResp.newBuilder();
        }
        logger.debug("response from keploy resp map");
        return respBuilder;
    }

    public static void Test() {
        String id;
        try {
            TimeUnit.SECONDS.sleep(5L);
        }
        catch (InterruptedException e) {
            logger.error("(Test): unable to sleep ", (Throwable)e);
        }
        logger.debug("entering test mode");
        logger.info("test starting in 5 sec");
        List<Service.TestCase> tcs = GrpcService.fetch();
        int total = tcs.size();
        try {
            id = GrpcService.start(String.valueOf(total));
        }
        catch (Exception e) {
            logger.info("failed to start test run ", (Throwable)e);
            return;
        }
        logger.info("starting test execution id: {} total tests: {}", (Object)id, (Object)total);
        AtomicBoolean ok = new AtomicBoolean(true);
        CountDownLatch wg = new CountDownLatch(tcs.size());
        ExecutorService service = Executors.newFixedThreadPool(10);
        for (int i = 0; i < tcs.size(); ++i) {
            Service.TestCase tc = tcs.get(i);
            logger.info("testing {} of {} testcase id: [{}]", (Object)(i + 1), (Object)total, (Object)tc.getId());
            service.submit(() -> {
                boolean pass = GrpcService.check(id, tc);
                if (!pass) {
                    ok.set(false);
                }
                logger.info("result : testcase id: [{}]  passed: {}", (Object)tc.getId(), (Object)pass);
                wg.countDown();
            });
        }
        try {
            wg.await();
        }
        catch (InterruptedException e) {
            logger.error("(Test): unable to wait for tests to get completed", (Throwable)e);
        }
        String msg = GrpcService.end(id, ok.get());
        logger.debug("message from end {}", (Object)msg);
        logger.info("test run completed with run id [{}]", (Object)id);
        logger.info("|| passed overall: {} ||", (Object)String.valueOf(ok.get()).toUpperCase());
    }

    public static String start(String total) {
        logger.debug("inside start function");
        Service.startRequest startRequest2 = Service.startRequest.newBuilder().setApp(k.getCfg().getApp().getName()).setTotal(total).build();
        Service.startResponse startResponse2 = blockingStub.start(startRequest2);
        return startResponse2.getId();
    }

    public static String end(String id, boolean status) {
        logger.debug("inside end function");
        Service.endRequest endRequest2 = Service.endRequest.newBuilder().setId(id).setStatus(String.valueOf(status)).build();
        Service.endResponse endResponse2 = blockingStub.end(endRequest2);
        return endResponse2.getMessage();
    }

    public static List<Service.TestCase> fetch() {
        logger.info("inside fetch function");
        ArrayList<Service.TestCase> testCases = new ArrayList<Service.TestCase>();
        int i = 0;
        while (true) {
            try {
                Service.getTCSRequest tcsRequest = Service.getTCSRequest.newBuilder().setApp(k.getCfg().getApp().getName()).setLimit("25").setOffset(String.valueOf(i)).build();
                Service.getTCSResponse tcs = blockingStub.getTCS(tcsRequest);
                int cnt = tcs.getTcsCount();
                if (cnt == 0) break;
                List tc = tcs.getTcsList();
                testCases.addAll(tc);
            }
            catch (StatusRuntimeException e) {
                logger.warn("RPC failed: {}", (Object)e.getStatus());
                return null;
            }
            i += 25;
        }
        Collections.reverse(testCases);
        return testCases;
    }

    public static boolean check(String testrunId, Service.TestCase tc) {
        logger.debug("running test case with [{}] testrunId ", (Object)testrunId);
        Service.HttpResp resp = null;
        try {
            resp = GrpcService.simulate(tc);
        }
        catch (Exception e) {
            logger.error("failed to simulate request on local server", (Throwable)e);
            return false;
        }
        Service.TestReq testReq = Service.TestReq.newBuilder().setID(tc.getId()).setAppID(k.getCfg().getApp().getName()).setRunID(testrunId).setResp(resp).build();
        Service.testResponse testResponse2 = null;
        try {
            testResponse2 = blockingStub.test(testReq);
        }
        catch (Exception e) {
            logger.error("failed to send test request to backend", (Throwable)e);
            return false;
        }
        Map res = testResponse2.getPassMap();
        logger.debug("(check): test result of testrunId [{}]: {} ", (Object)testrunId, res.get("pass"));
        return res.getOrDefault("pass", false);
    }

    private static Map<String, Service.StrArr> getResponseHeaderMap(Map<String, List<String>> srcMap) {
        HashMap<String, Service.StrArr> map = new HashMap<String, Service.StrArr>();
        for (String key : srcMap.keySet()) {
            if (key == null) continue;
            List<String> headerValues = srcMap.get(key);
            Service.StrArr.Builder builder = Service.StrArr.newBuilder();
            for (String hval : headerValues) {
                builder.addValue(hval);
            }
            Service.StrArr value = builder.build();
            key = GrpcService.convertFirstCapAfterEachDash(key);
            map.put(key, value);
        }
        return map;
    }

    private static String convertFirstCapAfterEachDash(String str) {
        StringBuilder sb = new StringBuilder();
        String[] sarr = str.split("-");
        if (sarr.length == 1) {
            sb.append(Character.toUpperCase(sarr[0].charAt(0))).append(sarr[0].substring(1));
        } else {
            for (int i = 0; i < sarr.length - 1; ++i) {
                String val = sarr[i];
                sb.append(Character.toUpperCase(val.charAt(0))).append(val.substring(1)).append("-");
            }
            String lval = sarr[sarr.length - 1];
            sb.append(Character.toUpperCase(lval.charAt(0))).append(lval.substring(1));
        }
        return sb.toString();
    }

    private static Request getCustomRequest(Service.TestCase testCase) {
        String url = testCase.getHttpReq().getURL();
        String host = k.getCfg().getApp().getHost();
        String port = k.getCfg().getApp().getPort();
        String method = testCase.getHttpReq().getMethod();
        String body = testCase.getHttpReq().getBody();
        String targetUrl = "http://" + host + ":" + port + url;
        logger.debug("simulate request's url: {}", (Object)targetUrl);
        Map headerMap = testCase.getHttpReq().getHeaderMap();
        Request.Builder reqBuilder = GrpcService.setCustomRequestHeaderMap(headerMap);
        switch (method) {
            case "GET": {
                return reqBuilder.get().url(targetUrl).addHeader("content-type", "application/json").addHeader("accept", "application/json").addHeader("KEPLOY_TEST_ID", testCase.getId()).build();
            }
            case "DELETE": {
                return reqBuilder.delete().url(targetUrl).addHeader("content-type", "application/json").addHeader("accept", "application/json").addHeader("KEPLOY_TEST_ID", testCase.getId()).build();
            }
        }
        return reqBuilder.method(method, RequestBody.create((byte[])body.getBytes(StandardCharsets.UTF_8))).url(targetUrl).addHeader("content-type", "application/json").addHeader("accept", "application/json").addHeader("KEPLOY_TEST_ID", testCase.getId()).build();
    }

    private static Request.Builder setCustomRequestHeaderMap(Map<String, Service.StrArr> srcMap) {
        Object values;
        Request.Builder reqBuilder = new Request.Builder();
        HashMap headerMap = new HashMap();
        for (String key : srcMap.keySet()) {
            values = srcMap.get(key);
            ProtocolStringList valueList = values.getValueList();
            ArrayList headerValues = new ArrayList(valueList);
            headerMap.put(key, headerValues);
        }
        for (String key : headerMap.keySet()) {
            if (!GrpcService.isModifiable(key)) continue;
            values = (List)headerMap.get(key);
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                reqBuilder.addHeader(key, value);
            }
        }
        return reqBuilder;
    }

    private static boolean isModifiable(String key) {
        switch (key) {
            case "connection": {
                return false;
            }
            case "content-length": {
                return false;
            }
            case "date": {
                return false;
            }
            case "expect": {
                return false;
            }
            case "from": {
                return false;
            }
            case "host": {
                return false;
            }
            case "upgrade": {
                return false;
            }
            case "via": {
                return false;
            }
            case "warning": {
                return false;
            }
        }
        return true;
    }

    private static Map<String, Service.StrArr> getRequestHeaderMap(HttpServletRequest httpServletRequest) {
        HashMap<String, Service.StrArr> map = new HashMap<String, Service.StrArr>();
        ArrayList<String> headerNames = Collections.list(httpServletRequest.getHeaderNames());
        for (String name : headerNames) {
            ArrayList<String> values = Collections.list(httpServletRequest.getHeaders(name));
            Service.StrArr.Builder builder = Service.StrArr.newBuilder();
            for (String s : values) {
                builder.addValue(s);
            }
            Service.StrArr value = builder.build();
            map.put(name, value);
        }
        return map;
    }
}

