/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.keta.server.leader;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kcache.keta.server.leader.KetaIdentity;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

class KetaProtocol {
    KetaProtocol() {
    }

    public static ByteBuffer serializeMetadata(KetaIdentity identity) {
        return identity.toJsonBytes();
    }

    public static KetaIdentity deserializeMetadata(ByteBuffer buffer) {
        return KetaIdentity.fromJson(buffer);
    }

    public static ByteBuffer serializeAssignment(Assignment assignment) {
        return assignment.toJsonBytes();
    }

    public static Assignment deserializeAssignment(ByteBuffer buffer) {
        return Assignment.fromJson(buffer);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Assignment {
        public static final int CURRENT_VERSION = 1;
        public static final short NO_ERROR = 0;
        public static final short DUPLICATE_URLS = 1;
        private final int version;
        private final short error;
        private final String leader;
        private final KetaIdentity leaderIdentity;
        private final List<KetaIdentity> members;

        public Assignment(@JsonProperty(value="error") short error, @JsonProperty(value="leader") String leader, @JsonProperty(value="leader_identity") KetaIdentity leaderIdentity, @JsonProperty(value="members") List<KetaIdentity> members) {
            this.version = 1;
            this.error = error;
            this.leader = leader;
            this.leaderIdentity = leaderIdentity;
            this.members = members;
        }

        public static Assignment fromJson(ByteBuffer json) {
            try {
                byte[] jsonBytes = new byte[json.remaining()];
                json.get(jsonBytes);
                return (Assignment)new ObjectMapper().readValue(jsonBytes, Assignment.class);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error deserializing identity information", e);
            }
        }

        @JsonProperty(value="version")
        public int version() {
            return this.version;
        }

        @JsonProperty(value="error")
        public short error() {
            return this.error;
        }

        @JsonProperty(value="leader")
        public String leader() {
            return this.leader;
        }

        @JsonProperty(value="leader_identity")
        public KetaIdentity leaderIdentity() {
            return this.leaderIdentity;
        }

        @JsonProperty(value="members")
        public List<KetaIdentity> members() {
            return this.members;
        }

        public boolean failed() {
            return this.error != 0;
        }

        public ByteBuffer toJsonBytes() {
            try {
                return ByteBuffer.wrap(new ObjectMapper().writeValueAsBytes((Object)this));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error serializing identity information", e);
            }
        }

        public String toString() {
            return "Assignment{version=" + this.version + ", error=" + this.error + ", leader='" + this.leader + '\'' + ", leaderIdentity=" + this.leaderIdentity + ", members=" + this.members + '}';
        }
    }
}

