/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.keta.server.grpc.utils;

import io.etcd.jetcd.api.ResponseHeader;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.kcache.keta.auth.exceptions.AuthNotEnabledException;
import io.kcache.keta.auth.exceptions.AuthenticationException;
import io.kcache.keta.auth.exceptions.InvalidAuthMgmtException;
import io.kcache.keta.auth.exceptions.InvalidAuthTokenException;
import io.kcache.keta.auth.exceptions.PermissionDeniedException;
import io.kcache.keta.auth.exceptions.RoleAlreadyExistsException;
import io.kcache.keta.auth.exceptions.RoleIsEmptyException;
import io.kcache.keta.auth.exceptions.RoleNotFoundException;
import io.kcache.keta.auth.exceptions.RootRoleNotFoundException;
import io.kcache.keta.auth.exceptions.RootUserNotFoundException;
import io.kcache.keta.auth.exceptions.UserAlreadyExistsException;
import io.kcache.keta.auth.exceptions.UserIsEmptyException;
import io.kcache.keta.auth.exceptions.UserNotFoundException;
import io.kcache.keta.lease.exceptions.LeaseExistsException;
import io.kcache.keta.lease.exceptions.LeaseNotFoundException;
import io.kcache.keta.server.grpc.errors.KetaErrorType;
import io.kcache.keta.server.grpc.errors.KetaException;
import io.kcache.keta.version.exceptions.KeyNotFoundException;

public class GrpcUtils {
    public static ResponseHeader toResponseHeader(int memberId) {
        return ResponseHeader.newBuilder().setMemberId(memberId).build();
    }

    public static ResponseHeader toResponseHeader(int memberId, long revision) {
        return ResponseHeader.newBuilder().setMemberId(memberId).setRevision(revision).build();
    }

    public static StatusRuntimeException toStatusException(Exception ex) {
        if (ex instanceof AuthenticationException) {
            return KetaErrorType.AuthFailed.toException();
        }
        if (ex instanceof AuthNotEnabledException) {
            return KetaErrorType.AuthNotEnabled.toException();
        }
        if (ex instanceof InvalidAuthMgmtException) {
            return KetaErrorType.InvalidAuthMgmt.toException();
        }
        if (ex instanceof InvalidAuthTokenException) {
            return KetaErrorType.InvalidAuthToken.toException();
        }
        if (ex instanceof PermissionDeniedException) {
            return KetaErrorType.PermissionDenied.toException();
        }
        if (ex instanceof RoleAlreadyExistsException) {
            return KetaErrorType.RoleAlreadyExist.toException();
        }
        if (ex instanceof RoleIsEmptyException) {
            return KetaErrorType.RoleEmpty.toException();
        }
        if (ex instanceof RoleNotFoundException) {
            return KetaErrorType.RoleNotFound.toException();
        }
        if (ex instanceof RootRoleNotFoundException) {
            return KetaErrorType.RootRoleNotExist.toException();
        }
        if (ex instanceof RootUserNotFoundException) {
            return KetaErrorType.RootUserNotExist.toException();
        }
        if (ex instanceof UserAlreadyExistsException) {
            return KetaErrorType.UserAlreadyExist.toException();
        }
        if (ex instanceof UserIsEmptyException) {
            return KetaErrorType.UserEmpty.toException();
        }
        if (ex instanceof UserNotFoundException) {
            return KetaErrorType.UserNotFound.toException();
        }
        if (ex instanceof KeyNotFoundException) {
            return KetaErrorType.KeyNotFound.toException();
        }
        if (ex instanceof LeaseExistsException) {
            return KetaErrorType.LeaseExist.toException();
        }
        if (ex instanceof LeaseNotFoundException) {
            return KetaErrorType.LeaseNotFound.toException();
        }
        if (ex instanceof KetaException) {
            return ((KetaException)ex).getType().toException();
        }
        return Status.UNKNOWN.withDescription(ex.getMessage()).asRuntimeException();
    }
}

