/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.keta.server.grpc.errors;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;

public enum KetaErrorType {
    EmptyKey(Status.Code.INVALID_ARGUMENT, "ketaserver: key is not provided"),
    KeyNotFound(Status.Code.INVALID_ARGUMENT, "ketaserver: key not found"),
    ValueProvided(Status.Code.INVALID_ARGUMENT, "ketaserver: value is provided"),
    LeaseProvided(Status.Code.INVALID_ARGUMENT, "ketaserver: lease is provided"),
    TooManyOps(Status.Code.INVALID_ARGUMENT, "ketaserver: too many operations in txn request"),
    DuplicateKey(Status.Code.INVALID_ARGUMENT, "ketaserver: duplicate key given in txn request"),
    Compacted(Status.Code.OUT_OF_RANGE, "ketaserver: mvcc: required revision has been compacted"),
    FutureRev(Status.Code.OUT_OF_RANGE, "ketaserver: mvcc: required revision is a future revision"),
    NoSpace(Status.Code.RESOURCE_EXHAUSTED, "ketaserver: mvcc: database space exceeded"),
    LeaseNotFound(Status.Code.NOT_FOUND, "ketaserver: requested lease not found"),
    LeaseExist(Status.Code.FAILED_PRECONDITION, "ketaserver: lease already exists"),
    LeaseTTLTooLarge(Status.Code.OUT_OF_RANGE, "ketaserver: too large lease TTL"),
    MemberExist(Status.Code.FAILED_PRECONDITION, "ketaserver: member ID already exist"),
    PeerURLExist(Status.Code.FAILED_PRECONDITION, "ketaserver: Peer URLs already exists"),
    MemberNotEnoughStarted(Status.Code.FAILED_PRECONDITION, "ketaserver: re-configuration failed due to not enough started members"),
    MemberBadURLs(Status.Code.INVALID_ARGUMENT, "ketaserver: given member URLs are invalid"),
    MemberNotFound(Status.Code.NOT_FOUND, "ketaserver: member not found"),
    MemberNotLearner(Status.Code.FAILED_PRECONDITION, "ketaserver: can only promote a learner member"),
    LearnerNotReady(Status.Code.FAILED_PRECONDITION, "ketaserver: can only promote a learner member which is in sync with leader"),
    TooManyLearners(Status.Code.FAILED_PRECONDITION, "ketaserver: too many learner members in cluster"),
    RequestTooLarge(Status.Code.INVALID_ARGUMENT, "ketaserver: request is too large"),
    RequestTooManyRequests(Status.Code.RESOURCE_EXHAUSTED, "ketaserver: too many requests"),
    RootUserNotExist(Status.Code.FAILED_PRECONDITION, "ketaserver: root user does not exist"),
    RootRoleNotExist(Status.Code.FAILED_PRECONDITION, "ketaserver: root user does not have root role"),
    UserAlreadyExist(Status.Code.FAILED_PRECONDITION, "ketaserver: user name already exists"),
    UserEmpty(Status.Code.INVALID_ARGUMENT, "ketaserver: user name is empty"),
    UserNotFound(Status.Code.FAILED_PRECONDITION, "ketaserver: user name not found"),
    RoleAlreadyExist(Status.Code.FAILED_PRECONDITION, "ketaserver: role name already exists"),
    RoleNotFound(Status.Code.FAILED_PRECONDITION, "ketaserver: role name not found"),
    RoleEmpty(Status.Code.INVALID_ARGUMENT, "ketaserver: role name is empty"),
    AuthFailed(Status.Code.INVALID_ARGUMENT, "ketaserver: authentication failed, invalid user ID or password"),
    PermissionDenied(Status.Code.PERMISSION_DENIED, "ketaserver: permission denied"),
    RoleNotGranted(Status.Code.FAILED_PRECONDITION, "ketaserver: role is not granted to the user"),
    PermissionNotGranted(Status.Code.FAILED_PRECONDITION, "ketaserver: permission is not granted to the role"),
    AuthNotEnabled(Status.Code.FAILED_PRECONDITION, "ketaserver: authentication is not enabled"),
    InvalidAuthToken(Status.Code.UNAUTHENTICATED, "ketaserver: invalid auth token"),
    InvalidAuthMgmt(Status.Code.INVALID_ARGUMENT, "ketaserver: invalid auth management"),
    NoLeader(Status.Code.UNAVAILABLE, "ketaserver: no leader"),
    NotLeader(Status.Code.FAILED_PRECONDITION, "ketaserver: not leader"),
    LeaderChanged(Status.Code.UNAVAILABLE, "ketaserver: leader changed"),
    NotCapable(Status.Code.UNAVAILABLE, "ketaserver: not capable"),
    Stopped(Status.Code.UNAVAILABLE, "ketaserver: server stopped"),
    Timeout(Status.Code.UNAVAILABLE, "ketaserver: request timed out"),
    TimeoutDueToLeaderFail(Status.Code.UNAVAILABLE, "ketaserver: request timed out, possibly due to previous leader failure"),
    TimeoutDueToConnectionLost(Status.Code.UNAVAILABLE, "ketaserver: request timed out, possibly due to connection lost"),
    Unhealthy(Status.Code.UNAVAILABLE, "ketaserver: unhealthy cluster"),
    Corrupt(Status.Code.DATA_LOSS, "ketaserver: corrupt cluster"),
    ErrGPRCNotSupportedForLearner(Status.Code.UNAVAILABLE, "ketaserver: rpc not supported for learner"),
    BadLeaderTransferee(Status.Code.FAILED_PRECONDITION, "ketaserver: bad leader transferee"),
    ClusterVersionUnavailable(Status.Code.UNAVAILABLE, "ketaserver: cluster version not found during downgrade"),
    WrongDowngradeVersionFormat(Status.Code.INVALID_ARGUMENT, "ketaserver: wrong downgrade target version format"),
    InvalidDowngradeTargetVersion(Status.Code.INVALID_ARGUMENT, "ketaserver: invalid downgrade target version"),
    DowngradeInProcess(Status.Code.FAILED_PRECONDITION, "ketaserver: cluster has a downgrade job in progress"),
    NoInflightDowngrade(Status.Code.FAILED_PRECONDITION, "ketaserver: no inflight downgrade job"),
    Starting(Status.Code.UNAVAILABLE, "ketaserver: server starting");

    private final Status.Code code;
    private final String description;

    private KetaErrorType(Status.Code code, String description) {
        this.code = code;
        this.description = description;
    }

    public Status.Code getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public Status toStatus() {
        return this.code.toStatus().withDescription(this.description);
    }

    public StatusRuntimeException toException() {
        return this.toStatus().asRuntimeException();
    }
}

