/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.keta.server.grpc;

import com.google.protobuf.ByteString;
import io.etcd.jetcd.api.LeaseGrantRequest;
import io.etcd.jetcd.api.LeaseGrantResponse;
import io.etcd.jetcd.api.LeaseGrpc;
import io.etcd.jetcd.api.LeaseKeepAliveRequest;
import io.etcd.jetcd.api.LeaseKeepAliveResponse;
import io.etcd.jetcd.api.LeaseLeasesRequest;
import io.etcd.jetcd.api.LeaseLeasesResponse;
import io.etcd.jetcd.api.LeaseRevokeRequest;
import io.etcd.jetcd.api.LeaseRevokeResponse;
import io.etcd.jetcd.api.LeaseStatus;
import io.etcd.jetcd.api.LeaseTimeToLiveRequest;
import io.etcd.jetcd.api.LeaseTimeToLiveResponse;
import io.grpc.stub.StreamObserver;
import io.kcache.keta.KetaEngine;
import io.kcache.keta.auth.KetaAuthManager;
import io.kcache.keta.lease.KetaLeaseManager;
import io.kcache.keta.lease.LeaseKeys;
import io.kcache.keta.pb.Lease;
import io.kcache.keta.server.grpc.errors.KetaErrorType;
import io.kcache.keta.server.grpc.utils.AuthServerInterceptor;
import io.kcache.keta.server.grpc.utils.GrpcUtils;
import io.kcache.keta.server.leader.KetaLeaderElector;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaseService
extends LeaseGrpc.LeaseImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(LeaseService.class);
    private final KetaLeaderElector elector;

    public LeaseService(KetaLeaderElector elector) {
        this.elector = elector;
    }

    @Override
    public void leaseGrant(LeaseGrantRequest request, StreamObserver<LeaseGrantResponse> responseObserver) {
        if (!KetaEngine.getInstance().isLeader()) {
            responseObserver.onError((Throwable)KetaErrorType.LeaderChanged.toException());
            return;
        }
        long id = request.getID();
        LOG.info("Lease grant request: {}", (Object)id);
        Lease lease = Lease.newBuilder().setID(id).setTTL(request.getTTL()).setExpiry(System.currentTimeMillis() + request.getTTL() * 1000L).build();
        KetaLeaseManager leaseMgr = KetaEngine.getInstance().getLeaseManager();
        try {
            LeaseKeys lk = leaseMgr.grant(lease);
            responseObserver.onNext((Object)LeaseGrantResponse.newBuilder().setHeader(GrpcUtils.toResponseHeader(this.elector.getMemberId())).setID(lk.getLease().getID()).setTTL(lk.getLease().getTTL()).build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)GrpcUtils.toStatusException(e));
        }
    }

    @Override
    public void leaseRevoke(LeaseRevokeRequest request, StreamObserver<LeaseRevokeResponse> responseObserver) {
        if (!KetaEngine.getInstance().isLeader()) {
            responseObserver.onError((Throwable)KetaErrorType.LeaderChanged.toException());
            return;
        }
        long id = request.getID();
        this.checkLeasePuts(id);
        LOG.info("Lease revoke request: {}", (Object)id);
        if (id == 0L) {
            responseObserver.onError((Throwable)KetaErrorType.LeaseNotFound.toException());
            return;
        }
        KetaLeaseManager leaseMgr = KetaEngine.getInstance().getLeaseManager();
        try {
            leaseMgr.revoke(id);
            responseObserver.onNext((Object)LeaseRevokeResponse.newBuilder().setHeader(GrpcUtils.toResponseHeader(this.elector.getMemberId())).build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)GrpcUtils.toStatusException(e));
        }
    }

    private void checkLeasePuts(long lease) {
        if (lease == 0L) {
            return;
        }
        KetaLeaseManager leaseMgr = KetaEngine.getInstance().getLeaseManager();
        LeaseKeys lk = leaseMgr.get(lease);
        KetaAuthManager authMgr = KetaEngine.getInstance().getAuthManager();
        if (lk != null) {
            for (ByteString key : lk.getKeys()) {
                authMgr.checkPutPermitted((String)AuthServerInterceptor.USER_CTX_KEY.get(), key);
            }
        }
    }

    @Override
    public StreamObserver<LeaseKeepAliveRequest> leaseKeepAlive(final StreamObserver<LeaseKeepAliveResponse> responseObserver) {
        return new StreamObserver<LeaseKeepAliveRequest>(){

            public void onNext(LeaseKeepAliveRequest value) {
                if (!KetaEngine.getInstance().isLeader()) {
                    responseObserver.onError((Throwable)KetaErrorType.LeaderChanged.toException());
                    return;
                }
                long id = value.getID();
                LOG.info("Lease keep alive request: {}", (Object)id);
                KetaLeaseManager leaseMgr = KetaEngine.getInstance().getLeaseManager();
                try {
                    LeaseKeys lease = leaseMgr.renew(id);
                    responseObserver.onNext((Object)LeaseKeepAliveResponse.newBuilder().setHeader(GrpcUtils.toResponseHeader(LeaseService.this.elector.getMemberId())).setID(id).setTTL(lease.getTTL()).build());
                }
                catch (Exception e) {
                    responseObserver.onError((Throwable)GrpcUtils.toStatusException(e));
                }
            }

            public void onError(Throwable t) {
                LOG.error(t.getMessage());
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
    }

    @Override
    public void leaseTimeToLive(LeaseTimeToLiveRequest request, StreamObserver<LeaseTimeToLiveResponse> responseObserver) {
        if (!KetaEngine.getInstance().isLeader()) {
            responseObserver.onError((Throwable)KetaErrorType.LeaderChanged.toException());
            return;
        }
        long id = request.getID();
        LOG.info("Lease time to live request: {}", (Object)id);
        KetaLeaseManager leaseMgr = KetaEngine.getInstance().getLeaseManager();
        try {
            LeaseKeys lease = leaseMgr.get(id);
            LeaseTimeToLiveResponse.Builder builder = LeaseTimeToLiveResponse.newBuilder().setHeader(GrpcUtils.toResponseHeader(this.elector.getMemberId())).setID(id).setTTL((lease.getExpiry() - System.currentTimeMillis()) / 1000L).setGrantedTTL(lease.getTTL());
            if (request.getKeys()) {
                builder.addAllKeys(lease.getKeys());
            }
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)GrpcUtils.toStatusException(e));
        }
    }

    @Override
    public void leaseLeases(LeaseLeasesRequest request, StreamObserver<LeaseLeasesResponse> responseObserver) {
        if (!KetaEngine.getInstance().isLeader()) {
            responseObserver.onError((Throwable)KetaErrorType.LeaderChanged.toException());
            return;
        }
        LOG.info("Lease leases request");
        KetaLeaseManager leaseMgr = KetaEngine.getInstance().getLeaseManager();
        try {
            List leases = leaseMgr.leaseIds().stream().map(l -> LeaseStatus.newBuilder().setID((long)l).build()).collect(Collectors.toList());
            responseObserver.onNext((Object)LeaseLeasesResponse.newBuilder().addAllLeases(leases).build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)GrpcUtils.toStatusException(e));
        }
    }
}

