/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.keta.server;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.common.exception.EtcdException;
import io.etcd.jetcd.watch.WatchResponse;
import io.kcache.keta.server.utils.RemoteClusterTestHarness;
import io.kcache.keta.server.utils.TestUtils;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class WatchErrorTest
extends RemoteClusterTestHarness {
    private Client client;

    @BeforeAll
    public void deployVerticle(Vertx vertx, VertxTestContext testContext) throws Exception {
        vertx.deployVerticle((Verticle)this.createKeta(), testContext.completing());
        this.client = Client.builder().endpoints(new String[]{this.endpoints}).build();
    }

    @Override
    @BeforeEach
    public void setUp(Vertx vertx) throws Exception {
        super.setUp(vertx);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Disabled(value="This test hangs on Linux builds")
    @Test
    public void testWatchOnError() throws Exception {
        ByteSequence key = TestUtils.randomByteSequence();
        ArrayList events = new ArrayList();
        CountDownLatch latch = new CountDownLatch(1);
        Consumer<WatchResponse> onNext = r -> {};
        Consumer<Throwable> onError = t -> {
            events.add(t);
            latch.countDown();
        };
        try (Watch.Watcher watcher = this.client.getWatchClient().watch(key, onNext, onError);){
            this.tearDown();
            latch.await();
        }
        Assertions.assertThat(events).isNotEmpty();
        Assertions.assertThat(events).allMatch(EtcdException.class::isInstance);
    }
}

