/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.keta.server;

import com.google.common.base.Charsets;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Txn;
import io.etcd.jetcd.kv.DeleteResponse;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.kv.PutResponse;
import io.etcd.jetcd.op.Cmp;
import io.etcd.jetcd.op.CmpTarget;
import io.etcd.jetcd.op.Op;
import io.etcd.jetcd.options.DeleteOption;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import io.kcache.keta.server.utils.RemoteClusterTestHarness;
import io.kcache.keta.server.utils.TestUtils;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class KVTest
extends RemoteClusterTestHarness {
    private KV kvClient;
    private static final ByteSequence SAMPLE_KEY = TestUtils.bytesOf("sample_key");
    private static final ByteSequence SAMPLE_VALUE = TestUtils.bytesOf("sample_value");
    private static final ByteSequence SAMPLE_KEY_2 = TestUtils.bytesOf("sample_key2");
    private static final ByteSequence SAMPLE_VALUE_2 = TestUtils.bytesOf("sample_value2");
    private static final ByteSequence SAMPLE_KEY_3 = TestUtils.bytesOf("sample_key3");

    @BeforeAll
    public void deployVerticle(Vertx vertx, VertxTestContext testContext) throws Exception {
        vertx.deployVerticle((Verticle)this.createKeta(), testContext.completing());
        this.kvClient = Client.builder().endpoints(new String[]{this.endpoints}).build().getKVClient();
    }

    @Override
    @BeforeEach
    public void setUp(Vertx vertx) throws Exception {
        super.setUp(vertx);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testByteSequence() {
        ByteSequence prefix = TestUtils.bytesOf("/test-service/");
        ByteSequence subPrefix = TestUtils.bytesOf("uuids/");
        String keyString = TestUtils.randomString();
        ByteSequence key = TestUtils.bytesOf(keyString);
        ByteSequence prefixedKey = prefix.concat(subPrefix).concat(key);
        Assertions.assertThat((boolean)prefixedKey.startsWith(prefix)).isTrue();
        Assertions.assertThat((String)prefixedKey.substring(prefix.size() + subPrefix.size()).toString(Charsets.UTF_8)).isEqualTo(keyString);
        Assertions.assertThat((Object)prefixedKey.substring(prefix.size(), prefix.size() + subPrefix.size())).isEqualTo((Object)subPrefix);
    }

    @Test
    public void testPut() throws Exception {
        CompletableFuture feature = this.kvClient.put(SAMPLE_KEY, SAMPLE_VALUE);
        PutResponse response = (PutResponse)feature.get();
        Assertions.assertThat((Object)response.getHeader()).isNotNull();
        Assertions.assertThat((!response.hasPrevKv() ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testPutWithNotExistLease() throws ExecutionException, InterruptedException {
        PutOption option = PutOption.newBuilder().withLeaseId(99999L).build();
        CompletableFuture future = this.kvClient.put(SAMPLE_KEY, SAMPLE_VALUE, option);
        AssertionsForClassTypes.assertThatExceptionOfType(ExecutionException.class).isThrownBy(future::get).withMessageEndingWith("ketaserver: requested lease not found");
    }

    @Test
    public void testGet() throws Exception {
        CompletableFuture feature = this.kvClient.put(SAMPLE_KEY_2, SAMPLE_VALUE_2);
        feature.get();
        CompletableFuture getFeature = this.kvClient.get(SAMPLE_KEY_2);
        GetResponse response = (GetResponse)getFeature.get();
        Assertions.assertThat((List)response.getKvs()).hasSize(1);
        Assertions.assertThat((String)((KeyValue)response.getKvs().get(0)).getValue().toString(Charsets.UTF_8)).isEqualTo(SAMPLE_VALUE_2.toString(Charsets.UTF_8));
        Assertions.assertThat((!response.isMore() ? 1 : 0) != 0).isTrue();
    }

    @Test
    @Disabled
    public void testGetWithRev() throws Exception {
        CompletableFuture feature = this.kvClient.put(SAMPLE_KEY_3, SAMPLE_VALUE);
        PutResponse putResp = (PutResponse)feature.get();
        this.kvClient.put(SAMPLE_KEY_3, SAMPLE_VALUE_2).get();
        GetOption option = GetOption.newBuilder().withRevision(putResp.getHeader().getRevision()).build();
        CompletableFuture getFeature = this.kvClient.get(SAMPLE_KEY_3, option);
        GetResponse response = (GetResponse)getFeature.get();
        Assertions.assertThat((List)response.getKvs()).hasSize(1);
        Assertions.assertThat((String)((KeyValue)response.getKvs().get(0)).getValue().toString(Charsets.UTF_8)).isEqualTo(SAMPLE_VALUE.toString(Charsets.UTF_8));
    }

    @Test
    public void testGetSortedPrefix() throws Exception {
        String prefix = TestUtils.randomString();
        int numPrefix = 3;
        this.putKeysWithPrefix(prefix, numPrefix);
        GetOption option = GetOption.newBuilder().withSortField(GetOption.SortTarget.KEY).withSortOrder(GetOption.SortOrder.DESCEND).withPrefix(TestUtils.bytesOf(prefix)).build();
        CompletableFuture getFeature = this.kvClient.get(TestUtils.bytesOf(prefix), option);
        GetResponse response = (GetResponse)getFeature.get();
        Assertions.assertThat((List)response.getKvs()).hasSize(numPrefix);
        for (int i = 0; i < numPrefix; ++i) {
            Assertions.assertThat((String)((KeyValue)response.getKvs().get(i)).getKey().toString(Charsets.UTF_8)).isEqualTo(prefix + (numPrefix - i - 1));
            Assertions.assertThat((String)((KeyValue)response.getKvs().get(i)).getValue().toString(Charsets.UTF_8)).isEqualTo(String.valueOf(numPrefix - i - 1));
        }
    }

    @Test
    public void testDelete() throws Exception {
        this.testPut();
        ByteSequence keyToDelete = SAMPLE_KEY;
        CompletableFuture getFeature = this.kvClient.get(keyToDelete);
        GetResponse resp = (GetResponse)getFeature.get();
        CompletableFuture deleteFuture = this.kvClient.delete(keyToDelete);
        DeleteResponse delResp = (DeleteResponse)deleteFuture.get();
        Assertions.assertThat((long)delResp.getDeleted()).isEqualTo((long)resp.getKvs().size());
    }

    @Test
    public void testGetAndDeleteWithPrefix() throws Exception {
        String prefix = TestUtils.randomString();
        ByteSequence key = TestUtils.bytesOf(prefix);
        int numPrefixes = 10;
        this.putKeysWithPrefix(prefix, numPrefixes);
        CompletableFuture getFuture = this.kvClient.get(key, GetOption.newBuilder().withPrefix(key).build());
        GetResponse getResp = (GetResponse)getFuture.get();
        Assertions.assertThat((long)getResp.getCount()).isEqualTo((long)numPrefixes);
        DeleteOption deleteOpt = DeleteOption.newBuilder().withPrefix(key).build();
        CompletableFuture delFuture = this.kvClient.delete(key, deleteOpt);
        DeleteResponse delResp = (DeleteResponse)delFuture.get();
        Assertions.assertThat((long)delResp.getDeleted()).isEqualTo((long)numPrefixes);
    }

    private void putKeysWithPrefix(String prefix, int numPrefixes) throws ExecutionException, InterruptedException {
        for (int i = 0; i < numPrefixes; ++i) {
            ByteSequence key = TestUtils.bytesOf(prefix + i);
            ByteSequence value = TestUtils.bytesOf("" + i);
            this.kvClient.put(key, value).get();
        }
    }

    @Test
    public void testTxn() throws Exception {
        ByteSequence sampleKey = TestUtils.bytesOf("txn_key");
        ByteSequence sampleValue = TestUtils.bytesOf("xyz");
        ByteSequence cmpValue = TestUtils.bytesOf("abc");
        ByteSequence putValue = TestUtils.bytesOf("XYZ");
        ByteSequence putValueNew = TestUtils.bytesOf("ABC");
        this.kvClient.put(sampleKey, sampleValue).get();
        Txn txn = this.kvClient.txn();
        Cmp cmp = new Cmp(sampleKey, Cmp.Op.GREATER, (CmpTarget)CmpTarget.value((ByteSequence)cmpValue));
        CompletableFuture txnResp = txn.If(new Cmp[]{cmp}).Then(new Op[]{Op.put((ByteSequence)sampleKey, (ByteSequence)putValue, (PutOption)PutOption.DEFAULT)}).Else(new Op[]{Op.put((ByteSequence)sampleKey, (ByteSequence)putValueNew, (PutOption)PutOption.DEFAULT)}).commit();
        txnResp.get();
        GetResponse getResp = (GetResponse)this.kvClient.get(sampleKey).get();
        Assertions.assertThat((List)getResp.getKvs()).hasSize(1);
        Assertions.assertThat((String)((KeyValue)getResp.getKvs().get(0)).getValue().toString(Charsets.UTF_8)).isEqualTo(putValue.toString(Charsets.UTF_8));
    }

    @Test
    public void testTxnForCmpOpNotEqual() throws Exception {
        ByteSequence sampleKey = TestUtils.bytesOf("txn_key");
        ByteSequence sampleValue = TestUtils.bytesOf("xyz");
        ByteSequence cmpValue = TestUtils.bytesOf("abc");
        ByteSequence putValue = TestUtils.bytesOf("XYZ");
        ByteSequence putValueNew = TestUtils.bytesOf("ABC");
        this.kvClient.put(sampleKey, sampleValue).get();
        Txn txn = this.kvClient.txn();
        Cmp cmp = new Cmp(sampleKey, Cmp.Op.NOT_EQUAL, (CmpTarget)CmpTarget.value((ByteSequence)cmpValue));
        CompletableFuture txnResp = txn.If(new Cmp[]{cmp}).Then(new Op[]{Op.put((ByteSequence)sampleKey, (ByteSequence)putValue, (PutOption)PutOption.DEFAULT)}).Else(new Op[]{Op.put((ByteSequence)sampleKey, (ByteSequence)putValueNew, (PutOption)PutOption.DEFAULT)}).commit();
        txnResp.get();
        GetResponse getResp = (GetResponse)this.kvClient.get(sampleKey).get();
        Assertions.assertThat((List)getResp.getKvs()).hasSize(1);
        Assertions.assertThat((String)((KeyValue)getResp.getKvs().get(0)).getValue().toString(Charsets.UTF_8)).isEqualTo(putValue.toString(Charsets.UTF_8));
    }

    @Test
    public void testNestedTxn() throws Exception {
        ByteSequence foo = TestUtils.bytesOf("txn_foo");
        ByteSequence bar = TestUtils.bytesOf("txn_bar");
        ByteSequence barz = TestUtils.bytesOf("txn_barz");
        ByteSequence abc = TestUtils.bytesOf("txn_abc");
        ByteSequence oneTwoThree = TestUtils.bytesOf("txn_123");
        Txn txn = this.kvClient.txn();
        Cmp cmp = new Cmp(foo, Cmp.Op.EQUAL, (CmpTarget)CmpTarget.version((long)0L));
        CompletableFuture txnResp = txn.If(new Cmp[]{cmp}).Then(new Op[]{Op.put((ByteSequence)foo, (ByteSequence)bar, (PutOption)PutOption.DEFAULT), Op.txn(null, (Op[])new Op[]{Op.put((ByteSequence)abc, (ByteSequence)oneTwoThree, (PutOption)PutOption.DEFAULT)}, null)}).Else(new Op[]{Op.put((ByteSequence)foo, (ByteSequence)barz, (PutOption)PutOption.DEFAULT)}).commit();
        txnResp.get();
        GetResponse getResp = (GetResponse)this.kvClient.get(foo).get();
        Assertions.assertThat((List)getResp.getKvs()).hasSize(1);
        Assertions.assertThat((String)((KeyValue)getResp.getKvs().get(0)).getValue().toString(Charsets.UTF_8)).isEqualTo(bar.toString(Charsets.UTF_8));
        GetResponse getResp2 = (GetResponse)this.kvClient.get(abc).get();
        Assertions.assertThat((List)getResp2.getKvs()).hasSize(1);
        Assertions.assertThat((String)((KeyValue)getResp2.getKvs().get(0)).getValue().toString(Charsets.UTF_8)).isEqualTo(oneTwoThree.toString(Charsets.UTF_8));
    }
}

