package io.etcd.jetcd.api.lock;

import static io.etcd.jetcd.api.lock.LockGrpc.getServiceDescriptor;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@javax.annotation.Generated(
value = "by VertxGrpc generator",
comments = "Source: lock.proto")
public final class VertxLockGrpc {
    private VertxLockGrpc() {}

    public static LockVertxStub newVertxStub(io.grpc.Channel channel) {
        return new LockVertxStub(channel);
    }

    /**
     * <pre>
     *  The lock service exposes client-side locking facilities as a gRPC interface.
     * </pre>
     */
    public static final class LockVertxStub extends io.grpc.stub.AbstractStub<LockVertxStub> {
        private final io.vertx.core.impl.ContextInternal ctx;
        private LockGrpc.LockStub delegateStub;

        private LockVertxStub(io.grpc.Channel channel) {
            super(channel);
            delegateStub = LockGrpc.newStub(channel);
            this.ctx = (io.vertx.core.impl.ContextInternal) io.vertx.core.Vertx.currentContext();
        }

        private LockVertxStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = LockGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (io.vertx.core.impl.ContextInternal) io.vertx.core.Vertx.currentContext();
        }

        @Override
        protected LockVertxStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new LockVertxStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Lock acquires a distributed shared lock on a given named lock.
         *  On success, it will return a unique key that exists so long as the
         *  lock is held by the caller. This key can be used in conjunction with
         *  transactions to safely ensure updates to etcd only occur while holding
         *  lock ownership. The lock is held until Unlock is called on the key or the
         *  lease associate with the owner expires.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.lock.LockResponse> lock(io.etcd.jetcd.api.lock.LockRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::lock);
        }

        /**
         * <pre>
         *  Unlock takes a key returned by Lock and releases the hold on lock. The
         *  next Lock caller waiting for the lock will then be woken up and given
         *  ownership of the lock.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.lock.UnlockResponse> unlock(io.etcd.jetcd.api.lock.UnlockRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::unlock);
        }

    }

    /**
     * <pre>
     *  The lock service exposes client-side locking facilities as a gRPC interface.
     * </pre>
     */
    public static abstract class LockVertxImplBase implements io.grpc.BindableService {
        private String compression;

        /**
         * Set whether the server will try to use a compressed response.
         *
         * @param compression the compression, e.g {@code gzip}
         */
        public LockVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        /**
         * <pre>
         *  Lock acquires a distributed shared lock on a given named lock.
         *  On success, it will return a unique key that exists so long as the
         *  lock is held by the caller. This key can be used in conjunction with
         *  transactions to safely ensure updates to etcd only occur while holding
         *  lock ownership. The lock is held until Unlock is called on the key or the
         *  lease associate with the owner expires.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.lock.LockResponse> lock(io.etcd.jetcd.api.lock.LockRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Unlock takes a key returned by Lock and releases the hold on lock. The
         *  next Lock caller waiting for the lock will then be woken up and given
         *  ownership of the lock.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.lock.UnlockResponse> unlock(io.etcd.jetcd.api.lock.UnlockRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            io.etcd.jetcd.api.lock.LockGrpc.getLockMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.lock.LockRequest,
                                            io.etcd.jetcd.api.lock.LockResponse>(
                                            this, METHODID_LOCK, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.lock.LockGrpc.getUnlockMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.lock.UnlockRequest,
                                            io.etcd.jetcd.api.lock.UnlockResponse>(
                                            this, METHODID_UNLOCK, compression)))
                    .build();
        }
    }

    private static final int METHODID_LOCK = 0;
    private static final int METHODID_UNLOCK = 1;

    private static final class MethodHandlers<Req, Resp> implements
            io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final LockVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(LockVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_LOCK:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.lock.LockRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.lock.LockResponse>) responseObserver,
                            compression,
                            serviceImpl::lock);
                    break;
                case METHODID_UNLOCK:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.lock.UnlockRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.lock.UnlockResponse>) responseObserver,
                            compression,
                            serviceImpl::unlock);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public io.grpc.stub.StreamObserver<Req> invoke(io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
