package io.etcd.jetcd.api;

import static io.etcd.jetcd.api.WatchGrpc.getServiceDescriptor;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@javax.annotation.Generated(
value = "by VertxGrpc generator",
comments = "Source: rpc.proto")
public final class VertxWatchGrpc {
    private VertxWatchGrpc() {}

    public static WatchVertxStub newVertxStub(io.grpc.Channel channel) {
        return new WatchVertxStub(channel);
    }

    
    public static final class WatchVertxStub extends io.grpc.stub.AbstractStub<WatchVertxStub> {
        private final io.vertx.core.impl.ContextInternal ctx;
        private WatchGrpc.WatchStub delegateStub;

        private WatchVertxStub(io.grpc.Channel channel) {
            super(channel);
            delegateStub = WatchGrpc.newStub(channel);
            this.ctx = (io.vertx.core.impl.ContextInternal) io.vertx.core.Vertx.currentContext();
        }

        private WatchVertxStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = WatchGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (io.vertx.core.impl.ContextInternal) io.vertx.core.Vertx.currentContext();
        }

        @Override
        protected WatchVertxStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new WatchVertxStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public io.vertx.core.streams.ReadStream<io.etcd.jetcd.api.WatchResponse> watch(io.vertx.core.Handler<io.vertx.core.streams.WriteStream<io.etcd.jetcd.api.WatchRequest>> hdlr) {
            return io.vertx.grpc.stub.ClientCalls.manyToMany(ctx, hdlr, delegateStub::watch);
        }
    }

    
    public static abstract class WatchVertxImplBase implements io.grpc.BindableService {
        private String compression;

        /**
         * Set whether the server will try to use a compressed response.
         *
         * @param compression the compression, e.g {@code gzip}
         */
        public WatchVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public void watch(io.vertx.core.streams.ReadStream<io.etcd.jetcd.api.WatchRequest> request, io.vertx.core.streams.WriteStream<io.etcd.jetcd.api.WatchResponse> response) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            io.etcd.jetcd.api.WatchGrpc.getWatchMethod(),
                            asyncBidiStreamingCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.WatchRequest,
                                            io.etcd.jetcd.api.WatchResponse>(
                                            this, METHODID_WATCH, compression)))
                    .build();
        }
    }

    private static final int METHODID_WATCH = 0;

    private static final class MethodHandlers<Req, Resp> implements
            io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final WatchVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(WatchVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public io.grpc.stub.StreamObserver<Req> invoke(io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_WATCH:
                    return (io.grpc.stub.StreamObserver<Req>) io.vertx.grpc.stub.ServerCalls.manyToMany(
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.WatchResponse>) responseObserver,
                            compression,
                            serviceImpl::watch);
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
