package io.etcd.jetcd.api;

import static io.etcd.jetcd.api.LeaseGrpc.getServiceDescriptor;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@javax.annotation.Generated(
value = "by VertxGrpc generator",
comments = "Source: rpc.proto")
public final class VertxLeaseGrpc {
    private VertxLeaseGrpc() {}

    public static LeaseVertxStub newVertxStub(io.grpc.Channel channel) {
        return new LeaseVertxStub(channel);
    }

    
    public static final class LeaseVertxStub extends io.grpc.stub.AbstractStub<LeaseVertxStub> {
        private final io.vertx.core.impl.ContextInternal ctx;
        private LeaseGrpc.LeaseStub delegateStub;

        private LeaseVertxStub(io.grpc.Channel channel) {
            super(channel);
            delegateStub = LeaseGrpc.newStub(channel);
            this.ctx = (io.vertx.core.impl.ContextInternal) io.vertx.core.Vertx.currentContext();
        }

        private LeaseVertxStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = LeaseGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (io.vertx.core.impl.ContextInternal) io.vertx.core.Vertx.currentContext();
        }

        @Override
        protected LeaseVertxStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new LeaseVertxStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.LeaseGrantResponse> leaseGrant(io.etcd.jetcd.api.LeaseGrantRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::leaseGrant);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.LeaseRevokeResponse> leaseRevoke(io.etcd.jetcd.api.LeaseRevokeRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::leaseRevoke);
        }

        
        public io.vertx.core.Future<io.etcd.jetcd.api.LeaseTimeToLiveResponse> leaseTimeToLive(io.etcd.jetcd.api.LeaseTimeToLiveRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::leaseTimeToLive);
        }

        /**
         * <pre>
         *  Compact compacts the event history in the etcd key-value store. The key-value
         *  store should be periodically compacted or the event history will continue to grow
         *  indefinitely.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.LeaseLeasesResponse> leaseLeases(io.etcd.jetcd.api.LeaseLeasesRequest request) {
            return io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::leaseLeases);
        }

        
        public io.vertx.core.streams.ReadStream<io.etcd.jetcd.api.LeaseKeepAliveResponse> leaseKeepAlive(io.vertx.core.Handler<io.vertx.core.streams.WriteStream<io.etcd.jetcd.api.LeaseKeepAliveRequest>> hdlr) {
            return io.vertx.grpc.stub.ClientCalls.manyToMany(ctx, hdlr, delegateStub::leaseKeepAlive);
        }
    }

    
    public static abstract class LeaseVertxImplBase implements io.grpc.BindableService {
        private String compression;

        /**
         * Set whether the server will try to use a compressed response.
         *
         * @param compression the compression, e.g {@code gzip}
         */
        public LeaseVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.LeaseGrantResponse> leaseGrant(io.etcd.jetcd.api.LeaseGrantRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.LeaseRevokeResponse> leaseRevoke(io.etcd.jetcd.api.LeaseRevokeRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        
        public io.vertx.core.Future<io.etcd.jetcd.api.LeaseTimeToLiveResponse> leaseTimeToLive(io.etcd.jetcd.api.LeaseTimeToLiveRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Compact compacts the event history in the etcd key-value store. The key-value
         *  store should be periodically compacted or the event history will continue to grow
         *  indefinitely.
         * </pre>
         */
        public io.vertx.core.Future<io.etcd.jetcd.api.LeaseLeasesResponse> leaseLeases(io.etcd.jetcd.api.LeaseLeasesRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        
        public void leaseKeepAlive(io.vertx.core.streams.ReadStream<io.etcd.jetcd.api.LeaseKeepAliveRequest> request, io.vertx.core.streams.WriteStream<io.etcd.jetcd.api.LeaseKeepAliveResponse> response) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            io.etcd.jetcd.api.LeaseGrpc.getLeaseGrantMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.LeaseGrantRequest,
                                            io.etcd.jetcd.api.LeaseGrantResponse>(
                                            this, METHODID_LEASE_GRANT, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.LeaseGrpc.getLeaseRevokeMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.LeaseRevokeRequest,
                                            io.etcd.jetcd.api.LeaseRevokeResponse>(
                                            this, METHODID_LEASE_REVOKE, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.LeaseGrpc.getLeaseKeepAliveMethod(),
                            asyncBidiStreamingCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.LeaseKeepAliveRequest,
                                            io.etcd.jetcd.api.LeaseKeepAliveResponse>(
                                            this, METHODID_LEASE_KEEP_ALIVE, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.LeaseGrpc.getLeaseTimeToLiveMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.LeaseTimeToLiveRequest,
                                            io.etcd.jetcd.api.LeaseTimeToLiveResponse>(
                                            this, METHODID_LEASE_TIME_TO_LIVE, compression)))
                    .addMethod(
                            io.etcd.jetcd.api.LeaseGrpc.getLeaseLeasesMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.etcd.jetcd.api.LeaseLeasesRequest,
                                            io.etcd.jetcd.api.LeaseLeasesResponse>(
                                            this, METHODID_LEASE_LEASES, compression)))
                    .build();
        }
    }

    private static final int METHODID_LEASE_GRANT = 0;
    private static final int METHODID_LEASE_REVOKE = 1;
    private static final int METHODID_LEASE_KEEP_ALIVE = 2;
    private static final int METHODID_LEASE_TIME_TO_LIVE = 3;
    private static final int METHODID_LEASE_LEASES = 4;

    private static final class MethodHandlers<Req, Resp> implements
            io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final LeaseVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(LeaseVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_LEASE_GRANT:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.LeaseGrantRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.LeaseGrantResponse>) responseObserver,
                            compression,
                            serviceImpl::leaseGrant);
                    break;
                case METHODID_LEASE_REVOKE:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.LeaseRevokeRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.LeaseRevokeResponse>) responseObserver,
                            compression,
                            serviceImpl::leaseRevoke);
                    break;
                case METHODID_LEASE_TIME_TO_LIVE:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.LeaseTimeToLiveRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.LeaseTimeToLiveResponse>) responseObserver,
                            compression,
                            serviceImpl::leaseTimeToLive);
                    break;
                case METHODID_LEASE_LEASES:
                    io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (io.etcd.jetcd.api.LeaseLeasesRequest) request,
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.LeaseLeasesResponse>) responseObserver,
                            compression,
                            serviceImpl::leaseLeases);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public io.grpc.stub.StreamObserver<Req> invoke(io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_LEASE_KEEP_ALIVE:
                    return (io.grpc.stub.StreamObserver<Req>) io.vertx.grpc.stub.ServerCalls.manyToMany(
                            (io.grpc.stub.StreamObserver<io.etcd.jetcd.api.LeaseKeepAliveResponse>) responseObserver,
                            compression,
                            serviceImpl::leaseKeepAlive);
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
