/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.keta.server.grpc;

import io.etcd.jetcd.api.ClusterGrpc;
import io.etcd.jetcd.api.Member;
import io.etcd.jetcd.api.MemberAddRequest;
import io.etcd.jetcd.api.MemberAddResponse;
import io.etcd.jetcd.api.MemberListRequest;
import io.etcd.jetcd.api.MemberListResponse;
import io.etcd.jetcd.api.MemberRemoveRequest;
import io.etcd.jetcd.api.MemberRemoveResponse;
import io.etcd.jetcd.api.MemberUpdateRequest;
import io.etcd.jetcd.api.MemberUpdateResponse;
import io.grpc.stub.StreamObserver;
import io.kcache.keta.server.grpc.errors.KetaErrorType;
import io.kcache.keta.server.grpc.utils.GrpcUtils;
import io.kcache.keta.server.leader.KetaIdentity;
import io.kcache.keta.server.leader.KetaLeaderElector;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterService
extends ClusterGrpc.ClusterImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterService.class);
    private final KetaLeaderElector elector;

    public ClusterService(KetaLeaderElector elector) {
        this.elector = elector;
    }

    @Override
    public void memberAdd(MemberAddRequest request, StreamObserver<MemberAddResponse> responseObserver) {
        super.memberAdd(request, responseObserver);
    }

    @Override
    public void memberRemove(MemberRemoveRequest request, StreamObserver<MemberRemoveResponse> responseObserver) {
        super.memberRemove(request, responseObserver);
    }

    @Override
    public void memberUpdate(MemberUpdateRequest request, StreamObserver<MemberUpdateResponse> responseObserver) {
        super.memberUpdate(request, responseObserver);
    }

    @Override
    public void memberList(MemberListRequest request, StreamObserver<MemberListResponse> responseObserver) {
        MemberListResponse.Builder responseBuilder = MemberListResponse.newBuilder();
        responseBuilder.setHeader(GrpcUtils.toResponseHeader(this.elector.getMemberId()));
        Collection<KetaIdentity> members = this.elector.getMembers();
        if (members.isEmpty()) {
            responseObserver.onError((Throwable)KetaErrorType.NoLeader.toException());
            return;
        }
        for (KetaIdentity member : members) {
            responseBuilder.addMembers(Member.newBuilder().setID(this.elector.getMemberId()).setName(member.getHost()).build());
        }
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }
}

