/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.api.lock;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import io.etcd.jetcd.api.lock.JetcdProto;
import io.etcd.jetcd.api.lock.LockRequest;
import io.etcd.jetcd.api.lock.LockResponse;
import io.etcd.jetcd.api.lock.UnlockRequest;
import io.etcd.jetcd.api.lock.UnlockResponse;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import io.grpc.protobuf.ProtoMethodDescriptorSupplier;
import io.grpc.protobuf.ProtoServiceDescriptorSupplier;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;

public final class LockGrpc {
    public static final String SERVICE_NAME = "v3lockpb.Lock";
    private static volatile MethodDescriptor<LockRequest, LockResponse> getLockMethod;
    private static volatile MethodDescriptor<UnlockRequest, UnlockResponse> getUnlockMethod;
    private static final int METHODID_LOCK = 0;
    private static final int METHODID_UNLOCK = 1;
    private static volatile ServiceDescriptor serviceDescriptor;

    private LockGrpc() {
    }

    private static <T> StreamObserver<T> toObserver(final Handler<AsyncResult<T>> handler) {
        return new StreamObserver<T>(){
            private volatile boolean resolved = false;

            public void onNext(T value) {
                if (!this.resolved) {
                    this.resolved = true;
                    handler.handle((Object)Future.succeededFuture(value));
                }
            }

            public void onError(Throwable t) {
                if (!this.resolved) {
                    this.resolved = true;
                    handler.handle((Object)Future.failedFuture((Throwable)t));
                }
            }

            public void onCompleted() {
                if (!this.resolved) {
                    this.resolved = true;
                    handler.handle((Object)Future.succeededFuture());
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodDescriptor<LockRequest, LockResponse> getLockMethod() {
        MethodDescriptor getLockMethod = LockGrpc.getLockMethod;
        if (getLockMethod != null) return getLockMethod;
        Class<LockGrpc> clazz = LockGrpc.class;
        synchronized (LockGrpc.class) {
            getLockMethod = LockGrpc.getLockMethod;
            if (getLockMethod != null) return getLockMethod;
            LockGrpc.getLockMethod = getLockMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)SERVICE_NAME, (String)"Lock")).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)LockRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)LockResponse.getDefaultInstance())).setSchemaDescriptor((Object)new LockMethodDescriptorSupplier("Lock")).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getLockMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodDescriptor<UnlockRequest, UnlockResponse> getUnlockMethod() {
        MethodDescriptor getUnlockMethod = LockGrpc.getUnlockMethod;
        if (getUnlockMethod != null) return getUnlockMethod;
        Class<LockGrpc> clazz = LockGrpc.class;
        synchronized (LockGrpc.class) {
            getUnlockMethod = LockGrpc.getUnlockMethod;
            if (getUnlockMethod != null) return getUnlockMethod;
            LockGrpc.getUnlockMethod = getUnlockMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)SERVICE_NAME, (String)"Unlock")).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)UnlockRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)UnlockResponse.getDefaultInstance())).setSchemaDescriptor((Object)new LockMethodDescriptorSupplier("Unlock")).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getUnlockMethod;
        }
    }

    public static LockStub newStub(Channel channel) {
        return new LockStub(channel);
    }

    public static LockBlockingStub newBlockingStub(Channel channel) {
        return new LockBlockingStub(channel);
    }

    public static LockFutureStub newFutureStub(Channel channel) {
        return new LockFutureStub(channel);
    }

    public static LockVertxStub newVertxStub(Channel channel) {
        return new LockVertxStub(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceDescriptor getServiceDescriptor() {
        ServiceDescriptor result = serviceDescriptor;
        if (result != null) return result;
        Class<LockGrpc> clazz = LockGrpc.class;
        synchronized (LockGrpc.class) {
            result = serviceDescriptor;
            if (result != null) return result;
            serviceDescriptor = result = ServiceDescriptor.newBuilder((String)SERVICE_NAME).setSchemaDescriptor((Object)new LockFileDescriptorSupplier()).addMethod(LockGrpc.getLockMethod()).addMethod(LockGrpc.getUnlockMethod()).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private static final class LockMethodDescriptorSupplier
    extends LockBaseDescriptorSupplier
    implements ProtoMethodDescriptorSupplier {
        private final String methodName;

        LockMethodDescriptorSupplier(String methodName) {
            this.methodName = methodName;
        }

        public Descriptors.MethodDescriptor getMethodDescriptor() {
            return this.getServiceDescriptor().findMethodByName(this.methodName);
        }
    }

    private static final class LockFileDescriptorSupplier
    extends LockBaseDescriptorSupplier {
        LockFileDescriptorSupplier() {
        }
    }

    private static abstract class LockBaseDescriptorSupplier
    implements ProtoFileDescriptorSupplier,
    ProtoServiceDescriptorSupplier {
        LockBaseDescriptorSupplier() {
        }

        public Descriptors.FileDescriptor getFileDescriptor() {
            return JetcdProto.getDescriptor();
        }

        public Descriptors.ServiceDescriptor getServiceDescriptor() {
            return this.getFileDescriptor().findServiceByName("Lock");
        }
    }

    private static final class VertxMethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final LockVertxImplBase serviceImpl;
        private final int methodId;

        VertxMethodHandlers(LockVertxImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.lock((LockRequest)request, (Promise<LockResponse>)((Promise)Promise.promise().future().setHandler(ar -> {
                        if (ar.succeeded()) {
                            responseObserver.onNext(ar.result());
                            responseObserver.onCompleted();
                        } else {
                            responseObserver.onError(ar.cause());
                        }
                    })));
                    break;
                }
                case 1: {
                    this.serviceImpl.unlock((UnlockRequest)request, (Promise<UnlockResponse>)((Promise)Promise.promise().future().setHandler(ar -> {
                        if (ar.succeeded()) {
                            responseObserver.onNext(ar.result());
                            responseObserver.onCompleted();
                        } else {
                            responseObserver.onError(ar.cause());
                        }
                    })));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final LockImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(LockImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.lock((LockRequest)request, responseObserver);
                    break;
                }
                case 1: {
                    this.serviceImpl.unlock((UnlockRequest)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static final class LockVertxStub
    extends AbstractStub<LockVertxStub> {
        public LockVertxStub(Channel channel) {
            super(channel);
        }

        public LockVertxStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected LockVertxStub build(Channel channel, CallOptions callOptions) {
            return new LockVertxStub(channel, callOptions);
        }

        public void lock(LockRequest request, Handler<AsyncResult<LockResponse>> response) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(LockGrpc.getLockMethod(), this.getCallOptions()), (Object)request, (StreamObserver)LockGrpc.toObserver(response));
        }

        public void unlock(UnlockRequest request, Handler<AsyncResult<UnlockResponse>> response) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(LockGrpc.getUnlockMethod(), this.getCallOptions()), (Object)request, (StreamObserver)LockGrpc.toObserver(response));
        }
    }

    public static abstract class LockVertxImplBase
    implements BindableService {
        public void lock(LockRequest request, Promise<LockResponse> response) {
            ServerCalls.asyncUnimplementedUnaryCall(LockGrpc.getLockMethod(), (StreamObserver)LockGrpc.toObserver(response));
        }

        public void unlock(UnlockRequest request, Promise<UnlockResponse> response) {
            ServerCalls.asyncUnimplementedUnaryCall(LockGrpc.getUnlockMethod(), (StreamObserver)LockGrpc.toObserver(response));
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)LockGrpc.getServiceDescriptor()).addMethod(LockGrpc.getLockMethod(), ServerCalls.asyncUnaryCall(new VertxMethodHandlers(this, 0))).addMethod(LockGrpc.getUnlockMethod(), ServerCalls.asyncUnaryCall(new VertxMethodHandlers(this, 1))).build();
        }
    }

    public static final class LockFutureStub
    extends AbstractStub<LockFutureStub> {
        public LockFutureStub(Channel channel) {
            super(channel);
        }

        public LockFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected LockFutureStub build(Channel channel, CallOptions callOptions) {
            return new LockFutureStub(channel, callOptions);
        }

        public ListenableFuture<LockResponse> lock(LockRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(LockGrpc.getLockMethod(), this.getCallOptions()), (Object)request);
        }

        public ListenableFuture<UnlockResponse> unlock(UnlockRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(LockGrpc.getUnlockMethod(), this.getCallOptions()), (Object)request);
        }
    }

    public static final class LockBlockingStub
    extends AbstractStub<LockBlockingStub> {
        public LockBlockingStub(Channel channel) {
            super(channel);
        }

        public LockBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected LockBlockingStub build(Channel channel, CallOptions callOptions) {
            return new LockBlockingStub(channel, callOptions);
        }

        public LockResponse lock(LockRequest request) {
            return (LockResponse)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), LockGrpc.getLockMethod(), (CallOptions)this.getCallOptions(), (Object)request);
        }

        public UnlockResponse unlock(UnlockRequest request) {
            return (UnlockResponse)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), LockGrpc.getUnlockMethod(), (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static final class LockStub
    extends AbstractStub<LockStub> {
        public LockStub(Channel channel) {
            super(channel);
        }

        public LockStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected LockStub build(Channel channel, CallOptions callOptions) {
            return new LockStub(channel, callOptions);
        }

        public void lock(LockRequest request, StreamObserver<LockResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(LockGrpc.getLockMethod(), this.getCallOptions()), (Object)request, responseObserver);
        }

        public void unlock(UnlockRequest request, StreamObserver<UnlockResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(LockGrpc.getUnlockMethod(), this.getCallOptions()), (Object)request, responseObserver);
        }
    }

    public static abstract class LockImplBase
    implements BindableService {
        public void lock(LockRequest request, StreamObserver<LockResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(LockGrpc.getLockMethod(), responseObserver);
        }

        public void unlock(UnlockRequest request, StreamObserver<UnlockResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(LockGrpc.getUnlockMethod(), responseObserver);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)LockGrpc.getServiceDescriptor()).addMethod(LockGrpc.getLockMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(LockGrpc.getUnlockMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1))).build();
        }
    }
}

