/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.api;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import io.etcd.jetcd.api.JetcdProto;
import io.etcd.jetcd.api.MemberAddRequest;
import io.etcd.jetcd.api.MemberAddResponse;
import io.etcd.jetcd.api.MemberListRequest;
import io.etcd.jetcd.api.MemberListResponse;
import io.etcd.jetcd.api.MemberRemoveRequest;
import io.etcd.jetcd.api.MemberRemoveResponse;
import io.etcd.jetcd.api.MemberUpdateRequest;
import io.etcd.jetcd.api.MemberUpdateResponse;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import io.grpc.protobuf.ProtoMethodDescriptorSupplier;
import io.grpc.protobuf.ProtoServiceDescriptorSupplier;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;

public final class ClusterGrpc {
    public static final String SERVICE_NAME = "etcdserverpb.Cluster";
    private static volatile MethodDescriptor<MemberAddRequest, MemberAddResponse> getMemberAddMethod;
    private static volatile MethodDescriptor<MemberRemoveRequest, MemberRemoveResponse> getMemberRemoveMethod;
    private static volatile MethodDescriptor<MemberUpdateRequest, MemberUpdateResponse> getMemberUpdateMethod;
    private static volatile MethodDescriptor<MemberListRequest, MemberListResponse> getMemberListMethod;
    private static final int METHODID_MEMBER_ADD = 0;
    private static final int METHODID_MEMBER_REMOVE = 1;
    private static final int METHODID_MEMBER_UPDATE = 2;
    private static final int METHODID_MEMBER_LIST = 3;
    private static volatile ServiceDescriptor serviceDescriptor;

    private ClusterGrpc() {
    }

    private static <T> StreamObserver<T> toObserver(final Handler<AsyncResult<T>> handler) {
        return new StreamObserver<T>(){
            private volatile boolean resolved = false;

            public void onNext(T value) {
                if (!this.resolved) {
                    this.resolved = true;
                    handler.handle((Object)Future.succeededFuture(value));
                }
            }

            public void onError(Throwable t) {
                if (!this.resolved) {
                    this.resolved = true;
                    handler.handle((Object)Future.failedFuture((Throwable)t));
                }
            }

            public void onCompleted() {
                if (!this.resolved) {
                    this.resolved = true;
                    handler.handle((Object)Future.succeededFuture());
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodDescriptor<MemberAddRequest, MemberAddResponse> getMemberAddMethod() {
        MethodDescriptor getMemberAddMethod = ClusterGrpc.getMemberAddMethod;
        if (getMemberAddMethod != null) return getMemberAddMethod;
        Class<ClusterGrpc> clazz = ClusterGrpc.class;
        synchronized (ClusterGrpc.class) {
            getMemberAddMethod = ClusterGrpc.getMemberAddMethod;
            if (getMemberAddMethod != null) return getMemberAddMethod;
            ClusterGrpc.getMemberAddMethod = getMemberAddMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)SERVICE_NAME, (String)"MemberAdd")).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)MemberAddRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MemberAddResponse.getDefaultInstance())).setSchemaDescriptor((Object)new ClusterMethodDescriptorSupplier("MemberAdd")).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getMemberAddMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodDescriptor<MemberRemoveRequest, MemberRemoveResponse> getMemberRemoveMethod() {
        MethodDescriptor getMemberRemoveMethod = ClusterGrpc.getMemberRemoveMethod;
        if (getMemberRemoveMethod != null) return getMemberRemoveMethod;
        Class<ClusterGrpc> clazz = ClusterGrpc.class;
        synchronized (ClusterGrpc.class) {
            getMemberRemoveMethod = ClusterGrpc.getMemberRemoveMethod;
            if (getMemberRemoveMethod != null) return getMemberRemoveMethod;
            ClusterGrpc.getMemberRemoveMethod = getMemberRemoveMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)SERVICE_NAME, (String)"MemberRemove")).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)MemberRemoveRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MemberRemoveResponse.getDefaultInstance())).setSchemaDescriptor((Object)new ClusterMethodDescriptorSupplier("MemberRemove")).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getMemberRemoveMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodDescriptor<MemberUpdateRequest, MemberUpdateResponse> getMemberUpdateMethod() {
        MethodDescriptor getMemberUpdateMethod = ClusterGrpc.getMemberUpdateMethod;
        if (getMemberUpdateMethod != null) return getMemberUpdateMethod;
        Class<ClusterGrpc> clazz = ClusterGrpc.class;
        synchronized (ClusterGrpc.class) {
            getMemberUpdateMethod = ClusterGrpc.getMemberUpdateMethod;
            if (getMemberUpdateMethod != null) return getMemberUpdateMethod;
            ClusterGrpc.getMemberUpdateMethod = getMemberUpdateMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)SERVICE_NAME, (String)"MemberUpdate")).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)MemberUpdateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MemberUpdateResponse.getDefaultInstance())).setSchemaDescriptor((Object)new ClusterMethodDescriptorSupplier("MemberUpdate")).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getMemberUpdateMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodDescriptor<MemberListRequest, MemberListResponse> getMemberListMethod() {
        MethodDescriptor getMemberListMethod = ClusterGrpc.getMemberListMethod;
        if (getMemberListMethod != null) return getMemberListMethod;
        Class<ClusterGrpc> clazz = ClusterGrpc.class;
        synchronized (ClusterGrpc.class) {
            getMemberListMethod = ClusterGrpc.getMemberListMethod;
            if (getMemberListMethod != null) return getMemberListMethod;
            ClusterGrpc.getMemberListMethod = getMemberListMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)SERVICE_NAME, (String)"MemberList")).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)MemberListRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MemberListResponse.getDefaultInstance())).setSchemaDescriptor((Object)new ClusterMethodDescriptorSupplier("MemberList")).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getMemberListMethod;
        }
    }

    public static ClusterStub newStub(Channel channel) {
        return new ClusterStub(channel);
    }

    public static ClusterBlockingStub newBlockingStub(Channel channel) {
        return new ClusterBlockingStub(channel);
    }

    public static ClusterFutureStub newFutureStub(Channel channel) {
        return new ClusterFutureStub(channel);
    }

    public static ClusterVertxStub newVertxStub(Channel channel) {
        return new ClusterVertxStub(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceDescriptor getServiceDescriptor() {
        ServiceDescriptor result = serviceDescriptor;
        if (result != null) return result;
        Class<ClusterGrpc> clazz = ClusterGrpc.class;
        synchronized (ClusterGrpc.class) {
            result = serviceDescriptor;
            if (result != null) return result;
            serviceDescriptor = result = ServiceDescriptor.newBuilder((String)SERVICE_NAME).setSchemaDescriptor((Object)new ClusterFileDescriptorSupplier()).addMethod(ClusterGrpc.getMemberAddMethod()).addMethod(ClusterGrpc.getMemberRemoveMethod()).addMethod(ClusterGrpc.getMemberUpdateMethod()).addMethod(ClusterGrpc.getMemberListMethod()).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private static final class ClusterMethodDescriptorSupplier
    extends ClusterBaseDescriptorSupplier
    implements ProtoMethodDescriptorSupplier {
        private final String methodName;

        ClusterMethodDescriptorSupplier(String methodName) {
            this.methodName = methodName;
        }

        public Descriptors.MethodDescriptor getMethodDescriptor() {
            return this.getServiceDescriptor().findMethodByName(this.methodName);
        }
    }

    private static final class ClusterFileDescriptorSupplier
    extends ClusterBaseDescriptorSupplier {
        ClusterFileDescriptorSupplier() {
        }
    }

    private static abstract class ClusterBaseDescriptorSupplier
    implements ProtoFileDescriptorSupplier,
    ProtoServiceDescriptorSupplier {
        ClusterBaseDescriptorSupplier() {
        }

        public Descriptors.FileDescriptor getFileDescriptor() {
            return JetcdProto.getDescriptor();
        }

        public Descriptors.ServiceDescriptor getServiceDescriptor() {
            return this.getFileDescriptor().findServiceByName("Cluster");
        }
    }

    private static final class VertxMethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final ClusterVertxImplBase serviceImpl;
        private final int methodId;

        VertxMethodHandlers(ClusterVertxImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.memberAdd((MemberAddRequest)request, (Promise<MemberAddResponse>)((Promise)Promise.promise().future().setHandler(ar -> {
                        if (ar.succeeded()) {
                            responseObserver.onNext(ar.result());
                            responseObserver.onCompleted();
                        } else {
                            responseObserver.onError(ar.cause());
                        }
                    })));
                    break;
                }
                case 1: {
                    this.serviceImpl.memberRemove((MemberRemoveRequest)request, (Promise<MemberRemoveResponse>)((Promise)Promise.promise().future().setHandler(ar -> {
                        if (ar.succeeded()) {
                            responseObserver.onNext(ar.result());
                            responseObserver.onCompleted();
                        } else {
                            responseObserver.onError(ar.cause());
                        }
                    })));
                    break;
                }
                case 2: {
                    this.serviceImpl.memberUpdate((MemberUpdateRequest)request, (Promise<MemberUpdateResponse>)((Promise)Promise.promise().future().setHandler(ar -> {
                        if (ar.succeeded()) {
                            responseObserver.onNext(ar.result());
                            responseObserver.onCompleted();
                        } else {
                            responseObserver.onError(ar.cause());
                        }
                    })));
                    break;
                }
                case 3: {
                    this.serviceImpl.memberList((MemberListRequest)request, (Promise<MemberListResponse>)((Promise)Promise.promise().future().setHandler(ar -> {
                        if (ar.succeeded()) {
                            responseObserver.onNext(ar.result());
                            responseObserver.onCompleted();
                        } else {
                            responseObserver.onError(ar.cause());
                        }
                    })));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final ClusterImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(ClusterImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.memberAdd((MemberAddRequest)request, responseObserver);
                    break;
                }
                case 1: {
                    this.serviceImpl.memberRemove((MemberRemoveRequest)request, responseObserver);
                    break;
                }
                case 2: {
                    this.serviceImpl.memberUpdate((MemberUpdateRequest)request, responseObserver);
                    break;
                }
                case 3: {
                    this.serviceImpl.memberList((MemberListRequest)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static final class ClusterVertxStub
    extends AbstractStub<ClusterVertxStub> {
        public ClusterVertxStub(Channel channel) {
            super(channel);
        }

        public ClusterVertxStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected ClusterVertxStub build(Channel channel, CallOptions callOptions) {
            return new ClusterVertxStub(channel, callOptions);
        }

        public void memberAdd(MemberAddRequest request, Handler<AsyncResult<MemberAddResponse>> response) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(ClusterGrpc.getMemberAddMethod(), this.getCallOptions()), (Object)request, (StreamObserver)ClusterGrpc.toObserver(response));
        }

        public void memberRemove(MemberRemoveRequest request, Handler<AsyncResult<MemberRemoveResponse>> response) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(ClusterGrpc.getMemberRemoveMethod(), this.getCallOptions()), (Object)request, (StreamObserver)ClusterGrpc.toObserver(response));
        }

        public void memberUpdate(MemberUpdateRequest request, Handler<AsyncResult<MemberUpdateResponse>> response) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(ClusterGrpc.getMemberUpdateMethod(), this.getCallOptions()), (Object)request, (StreamObserver)ClusterGrpc.toObserver(response));
        }

        public void memberList(MemberListRequest request, Handler<AsyncResult<MemberListResponse>> response) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(ClusterGrpc.getMemberListMethod(), this.getCallOptions()), (Object)request, (StreamObserver)ClusterGrpc.toObserver(response));
        }
    }

    public static abstract class ClusterVertxImplBase
    implements BindableService {
        public void memberAdd(MemberAddRequest request, Promise<MemberAddResponse> response) {
            ServerCalls.asyncUnimplementedUnaryCall(ClusterGrpc.getMemberAddMethod(), (StreamObserver)ClusterGrpc.toObserver(response));
        }

        public void memberRemove(MemberRemoveRequest request, Promise<MemberRemoveResponse> response) {
            ServerCalls.asyncUnimplementedUnaryCall(ClusterGrpc.getMemberRemoveMethod(), (StreamObserver)ClusterGrpc.toObserver(response));
        }

        public void memberUpdate(MemberUpdateRequest request, Promise<MemberUpdateResponse> response) {
            ServerCalls.asyncUnimplementedUnaryCall(ClusterGrpc.getMemberUpdateMethod(), (StreamObserver)ClusterGrpc.toObserver(response));
        }

        public void memberList(MemberListRequest request, Promise<MemberListResponse> response) {
            ServerCalls.asyncUnimplementedUnaryCall(ClusterGrpc.getMemberListMethod(), (StreamObserver)ClusterGrpc.toObserver(response));
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)ClusterGrpc.getServiceDescriptor()).addMethod(ClusterGrpc.getMemberAddMethod(), ServerCalls.asyncUnaryCall(new VertxMethodHandlers(this, 0))).addMethod(ClusterGrpc.getMemberRemoveMethod(), ServerCalls.asyncUnaryCall(new VertxMethodHandlers(this, 1))).addMethod(ClusterGrpc.getMemberUpdateMethod(), ServerCalls.asyncUnaryCall(new VertxMethodHandlers(this, 2))).addMethod(ClusterGrpc.getMemberListMethod(), ServerCalls.asyncUnaryCall(new VertxMethodHandlers(this, 3))).build();
        }
    }

    public static final class ClusterFutureStub
    extends AbstractStub<ClusterFutureStub> {
        public ClusterFutureStub(Channel channel) {
            super(channel);
        }

        public ClusterFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected ClusterFutureStub build(Channel channel, CallOptions callOptions) {
            return new ClusterFutureStub(channel, callOptions);
        }

        public ListenableFuture<MemberAddResponse> memberAdd(MemberAddRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(ClusterGrpc.getMemberAddMethod(), this.getCallOptions()), (Object)request);
        }

        public ListenableFuture<MemberRemoveResponse> memberRemove(MemberRemoveRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(ClusterGrpc.getMemberRemoveMethod(), this.getCallOptions()), (Object)request);
        }

        public ListenableFuture<MemberUpdateResponse> memberUpdate(MemberUpdateRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(ClusterGrpc.getMemberUpdateMethod(), this.getCallOptions()), (Object)request);
        }

        public ListenableFuture<MemberListResponse> memberList(MemberListRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(ClusterGrpc.getMemberListMethod(), this.getCallOptions()), (Object)request);
        }
    }

    public static final class ClusterBlockingStub
    extends AbstractStub<ClusterBlockingStub> {
        public ClusterBlockingStub(Channel channel) {
            super(channel);
        }

        public ClusterBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected ClusterBlockingStub build(Channel channel, CallOptions callOptions) {
            return new ClusterBlockingStub(channel, callOptions);
        }

        public MemberAddResponse memberAdd(MemberAddRequest request) {
            return (MemberAddResponse)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), ClusterGrpc.getMemberAddMethod(), (CallOptions)this.getCallOptions(), (Object)request);
        }

        public MemberRemoveResponse memberRemove(MemberRemoveRequest request) {
            return (MemberRemoveResponse)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), ClusterGrpc.getMemberRemoveMethod(), (CallOptions)this.getCallOptions(), (Object)request);
        }

        public MemberUpdateResponse memberUpdate(MemberUpdateRequest request) {
            return (MemberUpdateResponse)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), ClusterGrpc.getMemberUpdateMethod(), (CallOptions)this.getCallOptions(), (Object)request);
        }

        public MemberListResponse memberList(MemberListRequest request) {
            return (MemberListResponse)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), ClusterGrpc.getMemberListMethod(), (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static final class ClusterStub
    extends AbstractStub<ClusterStub> {
        public ClusterStub(Channel channel) {
            super(channel);
        }

        public ClusterStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected ClusterStub build(Channel channel, CallOptions callOptions) {
            return new ClusterStub(channel, callOptions);
        }

        public void memberAdd(MemberAddRequest request, StreamObserver<MemberAddResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(ClusterGrpc.getMemberAddMethod(), this.getCallOptions()), (Object)request, responseObserver);
        }

        public void memberRemove(MemberRemoveRequest request, StreamObserver<MemberRemoveResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(ClusterGrpc.getMemberRemoveMethod(), this.getCallOptions()), (Object)request, responseObserver);
        }

        public void memberUpdate(MemberUpdateRequest request, StreamObserver<MemberUpdateResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(ClusterGrpc.getMemberUpdateMethod(), this.getCallOptions()), (Object)request, responseObserver);
        }

        public void memberList(MemberListRequest request, StreamObserver<MemberListResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(ClusterGrpc.getMemberListMethod(), this.getCallOptions()), (Object)request, responseObserver);
        }
    }

    public static abstract class ClusterImplBase
    implements BindableService {
        public void memberAdd(MemberAddRequest request, StreamObserver<MemberAddResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(ClusterGrpc.getMemberAddMethod(), responseObserver);
        }

        public void memberRemove(MemberRemoveRequest request, StreamObserver<MemberRemoveResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(ClusterGrpc.getMemberRemoveMethod(), responseObserver);
        }

        public void memberUpdate(MemberUpdateRequest request, StreamObserver<MemberUpdateResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(ClusterGrpc.getMemberUpdateMethod(), responseObserver);
        }

        public void memberList(MemberListRequest request, StreamObserver<MemberListResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(ClusterGrpc.getMemberListMethod(), responseObserver);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)ClusterGrpc.getServiceDescriptor()).addMethod(ClusterGrpc.getMemberAddMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(ClusterGrpc.getMemberRemoveMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1))).addMethod(ClusterGrpc.getMemberUpdateMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2))).addMethod(ClusterGrpc.getMemberListMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3))).build();
        }
    }
}

