/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.keta.server.utils;

import com.google.common.base.Charsets;
import com.google.protobuf.ByteString;
import io.etcd.jetcd.ByteSequence;
import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class TestUtils {
    public static ByteSequence bytesOf(String string) {
        return ByteSequence.from((String)string, (Charset)StandardCharsets.UTF_8);
    }

    public static ByteString byteStringOf(String string) {
        return ByteString.copyFrom((byte[])string.getBytes(StandardCharsets.UTF_8));
    }

    public static String randomString() {
        return UUID.randomUUID().toString();
    }

    public static ByteSequence randomByteSequence() {
        return ByteSequence.from((String)TestUtils.randomString(), (Charset)Charsets.UTF_8);
    }

    public static int findNextAvailablePort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void waitForCondition(TestCondition testCondition, long maxWaitMs, String conditionDetails) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        boolean testConditionMet = false;
        while (!(testConditionMet = testCondition.conditionMet()) && System.currentTimeMillis() - startTime < maxWaitMs) {
            Thread.sleep(Math.min(maxWaitMs, 500L));
        }
        if (!testConditionMet) {
            conditionDetails = conditionDetails != null ? conditionDetails : "";
            throw new AssertionError((Object)("Condition not met within timeout " + maxWaitMs + ". " + conditionDetails));
        }
    }

    public static interface TestCondition {
        public boolean conditionMet();
    }
}

